/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.table.DefaultTableModel;

public class MergeNodesTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 6346267999771986379L;
    private String[] columnNames = new String[4];
    private ArrayList<InternalData463> dataMatrix;
    private int dataSize;
    public boolean changes = false;

    public MergeNodesTableModel() {
        this.columnNames[0] = "ID";
        this.columnNames[1] = "Name";
        this.columnNames[2] = "preNodes";
        this.columnNames[3] = "postNodes";
        this.dataMatrix = new ArrayList();
    }

    public void clearModel() {
        this.dataMatrix.clear();
        this.dataSize = 0;
    }

    public void addNew(int ID, String name, int preNodes, int postNodes) {
        InternalData463 row = new InternalData463();
        row.ID = ID;
        row.name = name;
        row.preNodes = preNodes;
        row.postNodes = postNodes;
        this.dataMatrix.add(row);
        ++this.dataSize;
    }

    @Override
    public void removeRow(int index) {
        this.dataMatrix.remove(index);
        --this.dataSize;
    }

    public void removeRow(String row) {
        for (InternalData463 dataRow : this.dataMatrix) {
            if (!dataRow.name.equals(row)) continue;
            this.dataMatrix.remove(dataRow);
            --this.dataSize;
            return;
        }
    }

    public ArrayList<String> getMergeVector() {
        ArrayList<String> result = new ArrayList<String>();
        for (InternalData463 dataRow : this.dataMatrix) {
            result.add(dataRow.name);
        }
        return result;
    }

    public int elementIndex(String txt) {
        int counter = -1;
        for (InternalData463 row : this.dataMatrix) {
            ++counter;
            if (!row.name.equals(txt)) continue;
            return counter;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            int clickCount = 1;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).ID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).preNodes;
            case 3 -> this.dataMatrix.get((int)rowIndex).postNodes;
            default -> null;
        };
    }

    public class InternalData463 {
        public int ID;
        public String name;
        public int preNodes;
        public int postNodes;
    }
}

