/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables;

import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class InvariantsViewerTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -6625961285405380868L;
    private String[] columnNames;
    private ArrayList<ArrayList<String>> dataMatrix;
    private int dataSize;
    boolean mctMode;
    public boolean changes = false;

    public InvariantsViewerTableModel(boolean mctMode) {
        this.mctMode = mctMode;
        if (mctMode) {
            this.columnNames = new String[2];
            this.columnNames[0] = "ID";
            this.columnNames[1] = "Element";
        } else {
            this.columnNames = new String[5];
            this.columnNames[0] = "ID";
            this.columnNames[1] = "Transition name";
            this.columnNames[2] = "Support";
            this.columnNames[3] = "Fire%";
            this.columnNames[4] = "stdDev";
        }
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(ArrayList<String> dataRow) {
        this.dataMatrix.add(dataRow);
        ++this.dataSize;
    }

    public void clear() {
        this.dataMatrix.clear();
        this.dataSize = 0;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.mctMode) {
            if (columnIndex > 1) {
                return null;
            }
            return this.dataMatrix.get(rowIndex).get(columnIndex);
        }
        if (columnIndex < 3) {
            return this.dataMatrix.get(rowIndex).get(columnIndex);
        }
        try {
            String returnValue = this.dataMatrix.get(rowIndex).get(columnIndex);
            String strVal = returnValue.toString();
            return Double.parseDouble(strVal);
        }
        catch (Exception e) {
            return this.dataMatrix.get(rowIndex).get(columnIndex);
        }
    }
}

