/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets.dialogs;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.subnets.dialogs.BaseDialog;
import holmes.petrinet.subnets.dialogs.ComboBoxItem;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OnSubnetAction
extends BaseDialog {
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JComboBox<ComboBoxItem<Integer>> comboBox;
    private JButton button;

    public OnSubnetAction(GraphPanel graphPanel, String title, int width, int height) {
        super(title, width, height);
        this.initComponents(graphPanel);
    }

    private void initComponents(GraphPanel graphPanel) {
        JPanel panel = new JPanel(null);
        this.getDialog().add(panel);
        JLabel subnetsLabel = new JLabel(lang.getText("OSA_entry001"));
        panel.add(subnetsLabel);
        subnetsLabel.setBounds(50, 50, 90, 30);
        this.comboBox = new JComboBox();
        panel.add(this.comboBox);
        this.comboBox.setBounds(145, 50, 200, 30);
        graphPanel.getNodes().stream().filter(node -> node instanceof MetaNode && ((MetaNode)node).getMySheetID() == graphPanel.getSheetId()).map(MetaNode.class::cast).map(metaNode -> {
            String subnetName = metaNode.getName();
            String label = String.format(" [%d] %s", metaNode.getRepresentedSheetID(), subnetName);
            return new ComboBoxItem<Integer>(metaNode.getRepresentedSheetID(), label);
        }).forEach(this.comboBox::addItem);
        this.button = new JButton(lang.getText("OSA_entry002"));
        panel.add(this.button);
        this.button.setBounds(130, 150, 120, 30);
    }

    public void setAction(ActionListener action) {
        this.button.addActionListener(action);
    }

    public ComboBoxItem<Integer> getComboBoxValue() {
        return (ComboBoxItem)this.comboBox.getSelectedItem();
    }
}

