/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets.dialogs;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.subnets.dialogs.BaseDialog;
import holmes.petrinet.subnets.dialogs.ComboBoxItem;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OnNodeAction
extends BaseDialog {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JComboBox<ComboBoxItem<Place>> placeComboBox;
    private JComboBox<ComboBoxItem<Transition>> transitionComboBox;
    private JButton button;
    private JCheckBox checkBox;

    public OnNodeAction(GraphPanel graphPanel, String title, int width, int height) {
        super(title, width, height);
        this.initComponents(graphPanel);
    }

    private void initComponents(GraphPanel graphPanel) {
        JPanel panel = new JPanel(null);
        this.getDialog().add(panel);
        JLabel placeLabel = new JLabel(lang.getText("ONA_entry001"));
        panel.add(placeLabel);
        placeLabel.setBounds(25, 50, 90, 25);
        this.placeComboBox = new JComboBox();
        panel.add(this.placeComboBox);
        this.placeComboBox.setBounds(100, 50, 400, 25);
        graphPanel.getNodes().stream().filter(node -> node.getNodeLocations().stream().anyMatch(location -> location.getSheetID() != graphPanel.getSheetId())).filter(Place.class::isInstance).map(Place.class::cast).map(place -> {
            List<String> subnets = place.getElementLocations().stream().map(ElementLocation::getSheetID).filter(i -> i != 0).map(Object::toString).sorted().distinct().toList();
            String subnetsLabel = subnets.isEmpty() ? "" : String.format(" (%s)", String.join((CharSequence)",", subnets));
            String label = String.format("[%d]%s: %s", place.getID(), subnetsLabel, place.getName());
            return new ComboBoxItem<Place>((Place)place, label);
        }).forEach(this.placeComboBox::addItem);
        JLabel transitionLabel = new JLabel(lang.getText("ONA_entry002"));
        panel.add(transitionLabel);
        transitionLabel.setBounds(25, 80, 90, 25);
        this.transitionComboBox = new JComboBox();
        panel.add(this.transitionComboBox);
        this.transitionComboBox.setBounds(100, 80, 400, 25);
        graphPanel.getNodes().stream().filter(node -> node.getNodeLocations().stream().anyMatch(location -> location.getSheetID() != graphPanel.getSheetId())).filter(Transition.class::isInstance).map(Transition.class::cast).map(transition -> {
            List<String> subnets = transition.getElementLocations().stream().map(ElementLocation::getSheetID).filter(i -> i != 0).map(Object::toString).sorted().distinct().toList();
            String subnetsLabel = subnets.isEmpty() ? "" : String.format(" (%s)", String.join((CharSequence)",", subnets));
            String label = String.format("[%d]%s: %s", transition.getID(), subnetsLabel, transition.getName());
            return new ComboBoxItem<Transition>((Transition)transition, label);
        }).forEach(this.transitionComboBox::addItem);
        this.placeComboBox.setSelectedIndex(-1);
        this.transitionComboBox.setSelectedIndex(-1);
        JLabel typeLabel = new JLabel("");
        panel.add(typeLabel);
        typeLabel.setBounds(25, 130, 500, 25);
        JLabel idLabel = new JLabel("");
        panel.add(idLabel);
        idLabel.setBounds(25, 150, 500, 25);
        JLabel subnetsLabel = new JLabel("");
        panel.add(subnetsLabel);
        subnetsLabel.setBounds(25, 170, 500, 25);
        this.placeComboBox.addItemListener(e -> {
            this.button.setEnabled(true);
            if (e.getStateChange() != 2) {
                typeLabel.setText(lang.getText("ONA_entry003"));
                ComboBoxItem item = (ComboBoxItem)e.getItem();
                int gID = ((Place)item.getValue()).getID();
                int arrID = overlord.getWorkspace().getProject().getPlaces().indexOf(item.getValue());
                idLabel.setText(String.format("gID:  %d, ID:  %d", gID, arrID));
                List<String> subnets = ((Place)item.getValue()).getElementLocations().stream().map(ElementLocation::getSheetID).map(integer -> OnNodeAction.overlord.subnetsHQ.getMetanode((int)integer).map(PetriNetElement::getName).orElse("Subnet0")).sorted().distinct().toList();
                subnetsLabel.setText(String.format(lang.getText("ONA_entry004"), String.join((CharSequence)", ", subnets)));
                if (this.transitionComboBox.getSelectedIndex() != -1) {
                    this.transitionComboBox.setSelectedIndex(-1);
                }
            }
        });
        this.transitionComboBox.addItemListener(e -> {
            this.button.setEnabled(true);
            if (e.getStateChange() != 2) {
                typeLabel.setText(lang.getText("ONA_entry005"));
                ComboBoxItem item = (ComboBoxItem)e.getItem();
                int gID = ((Transition)item.getValue()).getID();
                int arrID = overlord.getWorkspace().getProject().getTransitions().indexOf(item.getValue());
                idLabel.setText(String.format("gID:  %d, ID:  %d", gID, arrID));
                List<String> subnets = ((Transition)item.getValue()).getElementLocations().stream().map(ElementLocation::getSheetID).map(integer -> OnNodeAction.overlord.subnetsHQ.getMetanode((int)integer).map(PetriNetElement::getName).orElse("Subnet0")).sorted().distinct().toList();
                subnetsLabel.setText(String.format(lang.getText("ONA_entry006"), String.join((CharSequence)", ", subnets)));
                if (this.placeComboBox.getSelectedIndex() != -1) {
                    this.placeComboBox.setSelectedIndex(-1);
                }
            }
        });
        this.checkBox = new JCheckBox(lang.getText("ONA_entry007"));
        panel.add(this.checkBox);
        this.checkBox.setBounds(20, 205, 250, 25);
        this.button = new JButton(lang.getText("ONA_entry008"));
        panel.add(this.button);
        this.button.setEnabled(false);
        this.button.setBounds(190, 245, 150, 30);
    }

    public void setAction(ActionListener action) {
        this.button.addActionListener(action);
    }

    public ComboBoxItem<Place> getPlaceComboBoxValue() {
        return (ComboBoxItem)this.placeComboBox.getSelectedItem();
    }

    public ComboBoxItem<Transition> getTransitionComboBoxValue() {
        return (ComboBoxItem)this.transitionComboBox.getSelectedItem();
    }

    public boolean getCheckboxValue() {
        return this.checkBox.isSelected();
    }
}

