/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets.dialogs;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.utilities.Tools;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;

public abstract class BaseDialog {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JDialog dialog;

    protected BaseDialog(String title, int width, int height) {
        this.initDialog(title, width, height);
    }

    private void initDialog(String title, int width, int height) {
        this.dialog = new JDialog((Frame)overlord.getFrame(), title);
        this.dialog.setSize(width, height);
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setResizable(false);
        try {
            this.dialog.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00416exception") + ex.getMessage(), "error", true);
        }
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                overlord.getFrame().setEnabled(true);
            }
        });
    }

    public void open() {
        JFrame frame = overlord.getFrame();
        frame.setEnabled(false);
        this.dialog.setVisible(true);
    }

    public JDialog getDialog() {
        return this.dialog;
    }
}

