/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets;

import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import java.util.ArrayList;
import java.util.Iterator;

public final class SubnetsTools {
    private SubnetsTools() {
    }

    public static int isInterface(ElementLocation element, ArrayList<MetaNode> metanodes) {
        Node node = element.getParentNode();
        int subSheet = element.getSheetID();
        int metaSheet = -1;
        for (MetaNode meta : metanodes) {
            if (meta.getRepresentedSheetID() != subSheet) continue;
            metaSheet = meta.getElementLocations().get(0).getSheetID();
            break;
        }
        if (metaSheet == -1) {
            return 0;
        }
        int counter = 0;
        for (ElementLocation el : node.getElementLocations()) {
            if (el.getSheetID() != metaSheet) continue;
            ++counter;
        }
        return counter;
    }

    public static int countInMetaArcs(Node node, MetaNode meta) {
        int counter = 0;
        for (Arc arc : meta.getElementLocations().get(0).accessMetaInArcs()) {
            if (!arc.getStartNode().equals(node)) continue;
            ++counter;
        }
        return counter;
    }

    public static int countOutMetaArcs(Node node, MetaNode meta) {
        int counter = 0;
        for (Arc arc : meta.getElementLocations().get(0).accessMetaOutArcs()) {
            if (!arc.getEndNode().equals(node)) continue;
            ++counter;
        }
        return counter;
    }

    public static int countInterfaceInArcs(Node node, int subnetID, boolean countMeta) {
        int counter = 0;
        for (ElementLocation el : node.getElementLocations()) {
            if (el.getSheetID() != subnetID) continue;
            counter += el.getOutArcs().size();
            if (!countMeta) continue;
            counter += el.accessMetaOutArcs().size();
        }
        return counter;
    }

    public static int countInterfaceOutArcs(Node node, int sheet, boolean countMeta) {
        int counter = 0;
        for (ElementLocation el : node.getElementLocations()) {
            if (el.getSheetID() != sheet) continue;
            counter += el.getInArcs().size();
            if (!countMeta) continue;
            counter += el.accessMetaOutArcs().size();
        }
        return counter;
    }

    public static ElementLocation getNexusEL(Node node, MetaNode metanode) {
        int val;
        int index;
        ElementLocation el;
        int metaSheet = metanode.getElementLocations().get(0).getSheetID();
        ElementLocation metaEL = metanode.getElementLocations().get(0);
        ArrayList<Integer> elCounter = new ArrayList<Integer>();
        for (int i = 0; i < node.getElementLocations().size(); ++i) {
            elCounter.add(0);
        }
        ElementLocation anyOne = null;
        ArrayList<ElementLocation> checkList = new ArrayList<ElementLocation>();
        for (Arc arc : metaEL.accessMetaInArcs()) {
            if (!arc.getStartNode().equals(node)) continue;
            el = null;
            el = arc.getStartLocation();
            if (el.getSheetID() != metaSheet || checkList.contains(el)) continue;
            checkList.add(el);
            anyOne = el;
            index = node.getElementLocations().indexOf(el);
            val = (Integer)elCounter.get(index);
            elCounter.set(index, val += el.accessMetaOutArcs().size());
        }
        checkList.clear();
        for (Arc arc : metaEL.accessMetaOutArcs()) {
            if (!arc.getEndNode().equals(node)) continue;
            el = null;
            el = arc.getEndLocation();
            if (el.getSheetID() != metaSheet || checkList.contains(el)) continue;
            checkList.add(el);
            anyOne = el;
            index = node.getElementLocations().indexOf(el);
            val = (Integer)elCounter.get(index);
            elCounter.set(index, val += el.accessMetaInArcs().size());
        }
        int found = 0;
        int maxValue = 0;
        boolean check = false;
        Iterator iterator = elCounter.iterator();
        while (iterator.hasNext()) {
            val = (Integer)iterator.next();
            if (val <= maxValue) continue;
            found = elCounter.indexOf(val);
            maxValue = val;
            check = true;
        }
        if (check) {
            return node.getElementLocations().get(found);
        }
        return anyOne;
    }

    public static ArrayList<Integer> getSubnets(Node node) {
        ArrayList<Integer> subnets = new ArrayList<Integer>();
        for (ElementLocation el : node.getElementLocations()) {
            if (subnets.contains(el.getSheetID())) continue;
            subnets.add(el.getSheetID());
        }
        return subnets;
    }

    public static ArrayList<MetaNode> getMetanodesInSubnet(ArrayList<MetaNode> metanodes, int subnet) {
        ArrayList<MetaNode> result = new ArrayList<MetaNode>();
        for (MetaNode meta : metanodes) {
            if (meta.getMySheetID() != subnet) continue;
            result.add(meta);
        }
        return result;
    }

    public static ArrayList<Integer> getMetanodesRepNetsInSubnet(ArrayList<MetaNode> metanodes, int subnet) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (MetaNode meta : metanodes) {
            if (meta.getMySheetID() != subnet) continue;
            result.add(meta.getRepresentedSheetID());
        }
        return result;
    }

    public static MetaNode getMetaForSubnet(ArrayList<MetaNode> metanodes, int subID) {
        for (MetaNode meta : metanodes) {
            if (meta.getRepresentedSheetID() != subID) continue;
            return meta;
        }
        return null;
    }

    public static ArrayList<Integer> createVector(int size, int startVal) {
        ArrayList<Integer> vector = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            vector.add(startVal);
        }
        return vector;
    }
}

