/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.subnets.SubnetsTools;
import holmes.windows.HolmesNotepad;
import java.util.ArrayList;

public class SubnetsSnoopyCompatibility {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    PetriNet pn = overlord.getWorkspace().getProject();

    public ArrayList<ArrayList<Integer>> macroCheck() {
        int i;
        ArrayList<ArrayList<Integer>> results = new ArrayList<ArrayList<Integer>>();
        boolean problems = false;
        ArrayList<MetaNode> metanodes = this.pn.getMetaNodes();
        int size = metanodes.size();
        ArrayList<Integer> problemMultiEL = new ArrayList<Integer>();
        ArrayList<Integer> problemWrongType = new ArrayList<Integer>();
        for (i = 0; i < size; ++i) {
            problemMultiEL.add(0);
            problemWrongType.add(0);
        }
        for (i = 0; i < size; ++i) {
            MetaNode meta = metanodes.get(i);
            if (meta.getElementLocations().size() > 1) {
                problems = true;
                problemMultiEL.set(i, 1);
            }
            if (meta.getMetaType() != MetaNode.MetaType.UNKNOWN && meta.getMetaType() != MetaNode.MetaType.SUBNET) continue;
            problems = true;
            problemWrongType.set(i, 1);
        }
        if (problems) {
            results.add(problemMultiEL);
            results.add(problemWrongType);
            return results;
        }
        return null;
    }

    public boolean checkAndFix(boolean showResults) {
        boolean fixedAll = true;
        ArrayList<Node> nodes = this.pn.getNodes();
        ArrayList<MetaNode> metanodes = this.pn.getMetaNodes();
        ArrayList<Arc> arcs = this.pn.getArcs();
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        for (Node node : nodes) {
            try {
                ArrayList<Integer> subnets;
                if (!node.isPortal() && !(node instanceof MetaNode) || (subnets = SubnetsTools.getSubnets(node)).size() == 1) continue;
                ArrayList<Integer> requiredINmArcs = new ArrayList<Integer>();
                ArrayList<Integer> requiredOUTmArcs = new ArrayList<Integer>();
                int maxID = overlord.getWorkspace().getMaximumSubnetID();
                for (int i = 0; i < maxID + 1; ++i) {
                    requiredINmArcs.add(0);
                    requiredOUTmArcs.add(0);
                }
                this.countINandOUTmArcs(node, subnets, requiredINmArcs, requiredOUTmArcs, metanodes);
                for (int subnetID : subnets) {
                    int indexStart;
                    ArrayList<Integer> pathway = this.getPathway(node, subnetID, metanodes, subnets);
                    int pathNetID = pathway.get(0);
                    int inInterfaces = SubnetsTools.countInterfaceInArcs(node, pathNetID, false);
                    int outInterfaces = SubnetsTools.countInterfaceOutArcs(node, pathNetID, false);
                    if (inInterfaces == 0 && outInterfaces == 0) continue;
                    for (int sub = indexStart = pathway.indexOf(pathNetID); sub < pathway.size() - 1; ++sub) {
                        int subID = pathway.get(sub);
                        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, subID);
                        int repNetID = meta.getRepresentedSheetID();
                        int valIN = requiredINmArcs.get(repNetID);
                        requiredINmArcs.set(repNetID, valIN -= inInterfaces);
                        int valOUT = requiredOUTmArcs.get(repNetID);
                        requiredOUTmArcs.set(repNetID, valOUT -= outInterfaces);
                    }
                }
                boolean inFix = false;
                boolean outFix = false;
                int totalINadded = 0;
                int totalOUTadded = 0;
                if (overlord.getSettingsManager().getValue("editorSubnetCompressMode").equals("1")) {
                    for (net = 0; net < requiredINmArcs.size(); ++net) {
                        howMany = requiredINmArcs.get(net);
                        if (howMany >= 0) continue;
                        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, net);
                        ElementLocation pattern = this.getAnyELfromSubnet(node, meta.getFirstELoc().getSheetID());
                        SubnetsSnoopyCompatibility.overlord.subnetsHQ.addAllMissingInMetaArcsCompression(meta.getFirstELoc(), pattern, -howMany, arcs);
                        inFix = true;
                        totalINadded += -howMany;
                    }
                    for (net = 0; net < requiredOUTmArcs.size(); ++net) {
                        howMany = requiredOUTmArcs.get(net);
                        if (howMany >= 0) continue;
                        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, net);
                        ElementLocation pattern = this.getAnyELfromSubnet(node, meta.getFirstELoc().getSheetID());
                        SubnetsSnoopyCompatibility.overlord.subnetsHQ.addAllMissingOutMetaArcs(meta.getFirstELoc(), pattern, -howMany, arcs);
                        outFix = true;
                        totalOUTadded += -howMany;
                    }
                } else {
                    for (net = 0; net < requiredINmArcs.size(); ++net) {
                        howMany = requiredINmArcs.get(net);
                        if (howMany >= 0) continue;
                        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, net);
                        ElementLocation pattern = this.getAnyELfromSubnet(node, meta.getFirstELoc().getSheetID());
                        SubnetsSnoopyCompatibility.overlord.subnetsHQ.addAllMissingInMetaArcs(meta.getFirstELoc(), pattern, -howMany, arcs);
                        inFix = true;
                        totalINadded += -howMany;
                    }
                    for (net = 0; net < requiredOUTmArcs.size(); ++net) {
                        howMany = requiredOUTmArcs.get(net);
                        if (howMany >= 0) continue;
                        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, net);
                        ElementLocation pattern = this.getAnyELfromSubnet(node, meta.getFirstELoc().getSheetID());
                        SubnetsSnoopyCompatibility.overlord.subnetsHQ.addAllMissingOutMetaArcsCompression(meta.getFirstELoc(), pattern, -howMany, arcs);
                        outFix = true;
                        totalOUTadded += -howMany;
                    }
                }
                if (!inFix && !outFix) continue;
                notePad.addTextLineNL(lang.getText("SSC_entry001") + " " + node.getName(), "text");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("SSC_entry002"), totalINadded, totalOUTadded);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " SSC_entry002", "error", true);
                }
                notePad.addTextLineNL(strB, "text");
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00420exception") + " " + node.getName() + "\n" + e.getMessage(), "error", true);
                fixedAll = false;
            }
        }
        if (showResults) {
            notePad.setVisible(true);
        } else {
            notePad.dispose();
        }
        return fixedAll;
    }

    private ElementLocation getAnyELfromSubnet(Node node, int subnet) {
        for (ElementLocation el : node.getElementLocations()) {
            if (el.getSheetID() != subnet) continue;
            return el;
        }
        return null;
    }

    private ArrayList<Integer> getPathway(Node node, int subnetID, ArrayList<MetaNode> metanodes, ArrayList<Integer> subnets) {
        ArrayList<Integer> pathway = new ArrayList<Integer>();
        boolean proceed = true;
        int thisSubnet = subnetID;
        pathway.add(thisSubnet);
        while (proceed) {
            MetaNode metaRep = SubnetsTools.getMetaForSubnet(metanodes, thisSubnet);
            if (metaRep == null) {
                return pathway;
            }
            int lowerSubnet = metaRep.getFirstELoc().getSheetID();
            if (subnets.contains(lowerSubnet)) {
                pathway.add(lowerSubnet);
                thisSubnet = lowerSubnet;
                continue;
            }
            return pathway;
        }
        return pathway;
    }

    private void countINandOUTmArcs(Node node, ArrayList<Integer> subnets, ArrayList<Integer> requiredINmArcs, ArrayList<Integer> requiredOUTmArcs, ArrayList<MetaNode> metanodes) {
        for (int netID : subnets) {
            int totalInMetaArcs = 0;
            int totalOutMetaArcs = 0;
            MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, netID);
            if (meta == null) continue;
            ElementLocation metaEL = meta.getFirstELoc();
            int repNet = meta.getRepresentedSheetID();
            for (Arc arc : metaEL.accessMetaInArcs()) {
                if (!arc.getStartNode().equals(node)) continue;
                ++totalInMetaArcs;
            }
            for (Arc arc : metaEL.accessMetaOutArcs()) {
                if (!arc.getEndNode().equals(node)) continue;
                ++totalOutMetaArcs;
            }
            requiredINmArcs.set(repNet, totalInMetaArcs);
            requiredOUTmArcs.set(repNet, totalOutMetaArcs);
        }
    }

    private ArrayList<Integer> getDeepestSubnet(Node node, ArrayList<MetaNode> metanodes, ArrayList<Integer> subnets) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        ArrayList<Integer> subTested = new ArrayList<Integer>();
        for (ElementLocation el : node.getElementLocations()) {
            int subnet = el.getSheetID();
            if (subTested.contains(subnets)) continue;
            subTested.add(subnet);
            ArrayList<Integer> includedSubnets = SubnetsTools.getMetanodesRepNetsInSubnet(metanodes, subnet);
            ArrayList<Integer> subTest = new ArrayList<Integer>(subnets);
            subTest.retainAll(includedSubnets);
            if (subTest.size() != 0 || result.contains(el.getSheetID())) continue;
            result.add(el.getSheetID());
        }
        return result;
    }

    class FixPackage {
        public Node node = null;
        public boolean inMeta = false;
        public MetaNode metanode = null;

        FixPackage() {
        }
    }
}

