/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;

public class SubnetsGraphics {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public void addRequiredSheets() {
        Workspace workspace = overlord.getWorkspace();
        int sheetsNumber = workspace.getSheets().size();
        ArrayList<Node> nodes = workspace.getProject().getNodes();
        int subNets = 0;
        for (Node node : nodes) {
            for (ElementLocation el : node.getElementLocations()) {
                if (el.getSheetID() <= subNets) continue;
                subNets = el.getSheetID();
            }
        }
        ++subNets;
        int metaNodesNumber = 0;
        ArrayList<MetaNode> metanodes = workspace.getProject().getMetaNodes();
        for (MetaNode metanode : metanodes) {
            if (metanode.getRepresentedSheetID() <= metaNodesNumber) continue;
            metaNodesNumber = metanode.getRepresentedSheetID();
        }
        if (++metaNodesNumber > subNets) {
            subNets = metaNodesNumber;
        }
        for (int s = sheetsNumber; s < subNets; ++s) {
            overlord.getWorkspace().newTab(false, new Point(0, 0), 1, MetaNode.MetaType.SUBNET);
        }
    }

    public void collapseSubnets() {
        int i;
        int shNumber;
        Workspace workspace = overlord.getWorkspace();
        ArrayList<Node> nodes = workspace.getProject().getNodes();
        ArrayList<Integer> subnetsVector = new ArrayList<Integer>();
        subnetsVector.add(0);
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                int shId = el.getSheetID();
                if (shId > subnetsVector.size() - 1) {
                    int diff = shId - (subnetsVector.size() - 1);
                    SubnetsGraphics.updateVector(subnetsVector, diff, 0);
                }
                int oldVal = subnetsVector.get(shId) + 1;
                subnetsVector.set(shId, oldVal);
            }
        }
        int sheetsNumber = workspace.getSheets().size();
        if (sheetsNumber > (shNumber = subnetsVector.size())) {
            SubnetsGraphics.updateVector(subnetsVector, sheetsNumber - shNumber, 0);
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int emptyNetToRemove = 0;
        for (int i2 = 0; i2 < subnetsVector.size(); ++i2) {
            indices.add(i2);
            if (subnetsVector.get(i2) != 0) continue;
            ++emptyNetToRemove;
        }
        int originalSize = subnetsVector.size();
        block3: for (i = 0; i < subnetsVector.size(); ++i) {
            if (subnetsVector.get(i) > 0) continue;
            for (int j = i + 1; j < subnetsVector.size(); ++j) {
                if (subnetsVector.get(j) == 0) continue;
                subnetsVector.set(i, subnetsVector.get(j));
                subnetsVector.set(j, 0);
                indices.set(i, (Integer)indices.get(j));
                indices.set(j, -1);
                continue block3;
            }
        }
        for (i = 0; i < emptyNetToRemove; ++i) {
            int lastPos = subnetsVector.size() - 1;
            subnetsVector.remove(lastPos);
            indices.remove(lastPos);
        }
        for (Node n : nodes) {
            int oldRepresentedSheet;
            int val;
            int val2;
            int sheetID;
            for (ElementLocation el : n.getElementLocations()) {
                sheetID = el.getSheetID();
                val2 = (Integer)indices.get(indices.indexOf(sheetID));
                if (val2 == indices.indexOf(sheetID) || val2 == -1) continue;
                el.setSheetID(indices.indexOf(sheetID));
            }
            for (ElementLocation el : n.getTextsLocations(GUIManager.locationMoveType.NAME)) {
                sheetID = el.getSheetID();
                val2 = (Integer)indices.get(indices.indexOf(sheetID));
                if (val2 == indices.indexOf(sheetID) || val2 == -1) continue;
                el.setSheetID(indices.indexOf(sheetID));
            }
            if (!(n instanceof MetaNode) || (val = indices.indexOf(oldRepresentedSheet = ((MetaNode)n).getRepresentedSheetID())) == -1) continue;
            ((MetaNode)n).setRepresentedSheetID(val);
        }
        int leaveAlone = originalSize - emptyNetToRemove;
        workspace.getProject().repaintAllGraphPanels();
    }

    public void realignElements() {
        int sheetID;
        Workspace workspace = overlord.getWorkspace();
        ArrayList<Node> nodes = workspace.getProject().getNodes();
        ArrayList<Integer> vectorW = new ArrayList<Integer>();
        ArrayList<Integer> vectorH = new ArrayList<Integer>();
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                sheetID = el.getSheetID();
                if (sheetID > vectorW.size() - 1) {
                    SubnetsGraphics.updateVector(vectorW, sheetID - vectorW.size() + 1, 99999);
                    SubnetsGraphics.updateVector(vectorH, sheetID - vectorH.size() + 1, 99999);
                }
                if (el.getPosition().x < (Integer)vectorW.get(sheetID)) {
                    vectorW.set(sheetID, el.getPosition().x);
                }
                if (el.getPosition().y >= (Integer)vectorH.get(sheetID)) continue;
                vectorH.set(sheetID, el.getPosition().y);
            }
        }
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                sheetID = el.getSheetID();
                Point oldPoint = el.getPosition();
                int newWidth = oldPoint.x - (Integer)vectorW.get(sheetID) + 100;
                int newHeight = oldPoint.y - vectorH.get(sheetID) + 100;
                el.getPosition().setLocation(newWidth, newHeight);
            }
        }
        workspace.getProject().repaintAllGraphPanels();
    }

    public void resizePanels() {
        Workspace workspace = overlord.getWorkspace();
        int sheetsNumber = workspace.getSheets().size();
        ArrayList<Node> nodes = workspace.getProject().getNodes();
        ArrayList<Dimension> hidden = new ArrayList<Dimension>();
        hidden.add(new Dimension(1650, 1200));
        for (int net = 1; net < sheetsNumber; ++net) {
            hidden.add(new Dimension(1650, 1200));
        }
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                int subNet = el.getSheetID();
                if (((Dimension)hidden.get(subNet)).getWidth() < (double)el.getPosition().x) {
                    ((Dimension)hidden.get(subNet)).setSize((double)el.getPosition().x, ((Dimension)hidden.get(subNet)).getHeight());
                }
                if (!(((Dimension)hidden.get(subNet)).getHeight() < (double)el.getPosition().y)) continue;
                ((Dimension)hidden.get(subNet)).setSize(((Dimension)hidden.get(subNet)).getWidth(), (double)el.getPosition().y);
            }
        }
        try {
            for (int net = 0; net < sheetsNumber; ++net) {
                GraphPanel graphPanel = workspace.getSheets().get(net).getGraphPanel();
                int width = ((Dimension)hidden.get((int)net)).width;
                int height = ((Dimension)hidden.get((int)net)).height;
                graphPanel.setSize(new Dimension(width + 200, height + 100));
                graphPanel.setOriginSize(new Dimension(width + 200, height + 100));
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00419exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public static void updateVector(ArrayList<Integer> vector, int howMany, int initValue) {
        for (int i = 0; i < howMany; ++i) {
            vector.add(initValue);
        }
    }
}

