/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.subnets.SubnetsGraphics;
import holmes.petrinet.subnets.SubnetsSnoopyCompatibility;
import holmes.petrinet.subnets.SubnetsTools;
import holmes.windows.HolmesNotepad;
import holmes.workspace.Workspace;
import holmes.workspace.WorkspaceSheet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class SubnetsControl {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addArcToMetanode(ElementLocation startPTLocation, ElementLocation endMetanodeLocation, Arc semiArc) {
        Workspace workspace = overlord.getWorkspace();
        ArrayList<Arc> arcs = workspace.getProject().getArcs();
        MetaNode metanode = (MetaNode)endMetanodeLocation.getParentNode();
        int subnetID = metanode.getRepresentedSheetID();
        Node startNode = startPTLocation.getParentNode();
        int howManyExists = 0;
        ElementLocation oneOfMany = null;
        for (ElementLocation el : startNode.getElementLocations()) {
            if (el.getSheetID() != subnetID) continue;
            ++howManyExists;
            oneOfMany = el;
        }
        boolean askStupidQuestions = !overlord.getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1");
        boolean hasMetaArc = this.checkIfInMetaArcExists(startPTLocation, metanode);
        boolean addIdAlready = false;
        if (!hasMetaArc) {
            addIdAlready = true;
        } else if (howManyExists > 0 && askStupidQuestions) {
            Object[] options = new Object[]{lang.getText("SC_entry001a"), lang.getText("SC_entry001b")};
            String strB = "err.";
            try {
                strB = String.format(lang.getText("SC_entry002"), subnetID, howManyExists, startNode.getName());
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " SC_entry002", "error", true);
            }
            int n = JOptionPane.showOptionDialog(null, strB, lang.getText("SC_entry002t"), 0, 3, null, options, options[0]);
            if (n != 0) return false;
            addIdAlready = true;
        } else {
            addIdAlready = true;
        }
        if (!addIdAlready) return false;
        ElementLocation newPortal = null;
        newPortal = oneOfMany == null ? new ElementLocation(subnetID, new Point(50, 50), startNode) : new ElementLocation(subnetID, new Point(oneOfMany.getPosition().x + 15, oneOfMany.getPosition().y + 15), startNode);
        ElementLocation newNameEL = new ElementLocation(subnetID, new Point(0, 0), startNode);
        startNode.getElementLocations().add(newPortal);
        startNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
        startNode.setPortal(true);
        Arc arc = new Arc(IdGenerator.getNextId(), semiArc.getStartLocation(), endMetanodeLocation, Arc.TypeOfArc.META_ARC);
        arcs.add(arc);
        int index = workspace.getIndexOfId(subnetID);
        workspace.getSheets().get(index).getGraphPanel().repaint();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addArcFromMetanode(ElementLocation endPTNode, ElementLocation startMetanode, Arc semiArc) {
        Workspace workspace = overlord.getWorkspace();
        ArrayList<Arc> arcs = workspace.getProject().getArcs();
        MetaNode metanode = (MetaNode)startMetanode.getParentNode();
        int subnetID = metanode.getRepresentedSheetID();
        Node endNode = endPTNode.getParentNode();
        int howManyExists = 0;
        ElementLocation oneOfMany = null;
        for (ElementLocation el : endNode.getElementLocations()) {
            if (el.getSheetID() != subnetID) continue;
            ++howManyExists;
            oneOfMany = el;
        }
        boolean hasMetaArc = this.checkIfOutMetaExists(endPTNode, metanode);
        boolean addIdAlready = false;
        if (!hasMetaArc) {
            addIdAlready = true;
        } else if (howManyExists > 0) {
            Object[] options = new Object[]{lang.getText("SC_entry003a"), lang.getText("SC_entry003b")};
            String strB = "err.";
            try {
                strB = String.format(lang.getText("SC_entry004"), subnetID, howManyExists, endNode.getName());
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " SC_entry004", "error", true);
            }
            int n = JOptionPane.showOptionDialog(null, strB, lang.getText("SC_entry004t"), 0, 3, null, options, options[0]);
            if (n != 0) return false;
            addIdAlready = true;
        } else {
            addIdAlready = true;
        }
        if (!addIdAlready) return false;
        ElementLocation newPortal = null;
        newPortal = oneOfMany == null ? new ElementLocation(subnetID, new Point(50, 50), endNode) : new ElementLocation(subnetID, new Point(oneOfMany.getPosition().x + 15, oneOfMany.getPosition().y + 15), endNode);
        ElementLocation newNameEL = new ElementLocation(subnetID, new Point(0, 0), endNode);
        endNode.getElementLocations().add(newPortal);
        endNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
        endNode.setPortal(true);
        Arc arc = new Arc(IdGenerator.getNextId(), startMetanode, endPTNode, Arc.TypeOfArc.META_ARC);
        arcs.add(arc);
        int index = workspace.getIndexOfId(subnetID);
        workspace.getSheets().get(index).getGraphPanel().repaint();
        return true;
    }

    public void addMetaArc(Arc arc) {
        Random gen = new Random();
        ArrayList<MetaNode> metanodes = overlord.getWorkspace().getProject().getMetaNodes();
        ElementLocation startEL = arc.getStartLocation();
        ElementLocation endEL = arc.getEndLocation();
        ElementLocation ourPatient = null;
        boolean isInterfIN = false;
        if (SubnetsTools.isInterface(startEL, metanodes) > 0) {
            ourPatient = startEL;
            isInterfIN = true;
        } else if (SubnetsTools.isInterface(endEL, metanodes) > 0) {
            ourPatient = endEL;
        } else {
            return;
        }
        int subSheetID = ourPatient.getSheetID();
        Node metanode = null;
        for (MetaNode meta : metanodes) {
            if (meta.getRepresentedSheetID() != subSheetID) continue;
            metanode = meta;
            break;
        }
        if (metanode == null) {
            overlord.log("Error: no metanode found.", "error", true);
        }
        ElementLocation metaEL = metanode.getElementLocations().get(0);
        int sheetID = metaEL.getSheetID();
        Point point = metaEL.getPosition();
        Node parent = ourPatient.getParentNode();
        int metaArcs = 0;
        int interfArc = 0;
        if (isInterfIN) {
            metaArcs = SubnetsTools.countInMetaArcs(parent, (MetaNode)metanode);
            interfArc = SubnetsTools.countInterfaceInArcs(parent, ourPatient.getSheetID(), true);
        } else {
            metaArcs = SubnetsTools.countOutMetaArcs(parent, (MetaNode)metanode);
            interfArc = SubnetsTools.countInterfaceOutArcs(parent, ourPatient.getSheetID(), true);
        }
        if (interfArc <= metaArcs) {
            return;
        }
        boolean uncompressed = overlord.getSettingsManager().getValue("editorSubnetCompressMode").equals("1");
        if (uncompressed) {
            ElementLocation nexus = SubnetsTools.getNexusEL(parent, (MetaNode)metanode);
            if (nexus == null) {
                uncompressed = false;
            } else {
                Arc newArc = null;
                newArc = isInterfIN ? new Arc(IdGenerator.getNextId(), nexus, metaEL, Arc.TypeOfArc.META_ARC) : new Arc(IdGenerator.getNextId(), metaEL, nexus, Arc.TypeOfArc.META_ARC);
                overlord.getWorkspace().getProject().getArcs().add(newArc);
            }
        }
        if (!uncompressed) {
            int newX = gen.nextInt(160) - 80;
            int newY = gen.nextInt(100) + 15;
            if (!isInterfIN) {
                newY *= -1;
            }
            ElementLocation newEL = new ElementLocation(sheetID, new Point(point.x + newX, point.y - newY), parent);
            ElementLocation newNameEL = new ElementLocation(sheetID, new Point(0, 0), parent);
            parent.getElementLocations().add(newEL);
            parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
            parent.setPortal(true);
            Arc newArc = null;
            newArc = isInterfIN ? new Arc(IdGenerator.getNextId(), newEL, metaEL, Arc.TypeOfArc.META_ARC) : new Arc(IdGenerator.getNextId(), metaEL, newEL, Arc.TypeOfArc.META_ARC);
            overlord.getWorkspace().getProject().getArcs().add(newArc);
        }
    }

    private boolean checkIfInMetaArcExists(ElementLocation startLocation, MetaNode metanode) {
        Node parent = startLocation.getParentNode();
        for (ElementLocation el : parent.getElementLocations()) {
            for (Arc arc : el.accessMetaOutArcs()) {
                if (!arc.getEndLocation().getParentNode().equals(metanode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIfOutMetaExists(ElementLocation endLocation, MetaNode metanode) {
        Node parent = endLocation.getParentNode();
        for (ElementLocation el : parent.getElementLocations()) {
            for (Arc arc : el.accessMetaInArcs()) {
                if (!arc.getStartLocation().getParentNode().equals(metanode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean changeSubnetType(MetaNode metanode, MetaNode.MetaType desiredType) {
        if (overlord.getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1")) {
            if (desiredType == MetaNode.MetaType.SUBNET) {
                JOptionPane.showMessageDialog(null, lang.getText("SC_entry005"), lang.getText("SC_entry005t"), 1);
                return false;
            }
        } else if (desiredType == MetaNode.MetaType.SUBNET) {
            metanode.setMetaType(desiredType);
            return true;
        }
        int sheetID = metanode.getRepresentedSheetID();
        if (desiredType == MetaNode.MetaType.SUBNETPLACE) {
            ArrayList<ElementLocation> elements = this.getSubnetElementLocations(sheetID);
            for (ElementLocation el : elements) {
                if (!el.getParentNode().isPortal() || el.getParentNode() instanceof Transition || !(el.getParentNode() instanceof Place)) continue;
                for (ElementLocation internalEL : el.getParentNode().getElementLocations()) {
                    if (internalEL.getSheetID() == sheetID) continue;
                    JOptionPane.showMessageDialog(null, lang.getText("SC_entry006"), lang.getText("SC_entry006t"), 1);
                    return false;
                }
            }
        } else if (desiredType == MetaNode.MetaType.SUBNETTRANS) {
            ArrayList<ElementLocation> elements = this.getSubnetElementLocations(sheetID);
            for (ElementLocation el : elements) {
                if (!el.getParentNode().isPortal() || el.getParentNode() instanceof Place || !(el.getParentNode() instanceof Transition)) continue;
                for (ElementLocation internalEL : el.getParentNode().getElementLocations()) {
                    if (internalEL.getSheetID() == sheetID) continue;
                    JOptionPane.showMessageDialog(null, lang.getText("SC_entry007"), lang.getText("SC_entry007t"), 1);
                    return false;
                }
            }
        }
        metanode.setMetaType(desiredType);
        return true;
    }

    public ArrayList<ElementLocation> getSubnetElementLocations(int sheetID) {
        ArrayList<ElementLocation> result = new ArrayList<ElementLocation>();
        ArrayList<Node> nodes = overlord.getWorkspace().getProject().getNodes();
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                if (el.getSheetID() != sheetID) continue;
                result.add(el);
            }
        }
        return result;
    }

    public Optional<MetaNode> getMetanode(int subnetID) {
        return overlord.getWorkspace().getProject().getNodes().stream().filter(node -> node instanceof MetaNode && ((MetaNode)node).getRepresentedSheetID() == subnetID).map(MetaNode.class::cast).findAny();
    }

    public GraphPanel getGraphPanel(int sheetID) {
        return overlord.getWorkspace().getSheetById(sheetID).getGraphPanel();
    }

    public ArrayList<Integer> getSubnetsVector() {
        int shNumber;
        ArrayList<Integer> result = new ArrayList<Integer>();
        ArrayList<Node> nodes = overlord.getWorkspace().getProject().getNodes();
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                int shNumber2;
                int sheetID = el.getSheetID();
                if (sheetID > (shNumber2 = result.size()) - 1) {
                    SubnetsGraphics.updateVector(result, sheetID - shNumber2 + 1, 0);
                }
                int value = result.get(sheetID) + 1;
                result.set(sheetID, value);
            }
        }
        int sheetsNumber = overlord.getWorkspace().getSheets().size();
        if (sheetsNumber > (shNumber = result.size())) {
            SubnetsGraphics.updateVector(result, sheetsNumber - shNumber, 0);
        }
        return result;
    }

    public void removeMetaNode(int sheetID) {
        PetriNet pn = overlord.getWorkspace().getProject();
        ArrayList<MetaNode> metanodes = pn.getMetaNodes();
        ArrayList<Arc> arcs = pn.getArcs();
        ArrayList<Node> nodes = pn.getNodes();
        boolean removed = false;
        boolean found = false;
        if (metanodes.isEmpty()) {
            return;
        }
        for (MetaNode node : metanodes) {
            if (node.getRepresentedSheetID() != sheetID) continue;
            found = true;
            if (!node.getInputArcs().isEmpty() || !node.getOutputArcs().isEmpty()) {
                overlord.log(lang.getText("LOGentry00417critErr"), "error", true);
                for (ElementLocation el : node.getElementLocations()) {
                    Arc arc;
                    Arc a;
                    Iterator<Arc> i = el.getInArcs().iterator();
                    while (i.hasNext()) {
                        a = i.next();
                        arcs.remove(a);
                        a.unlinkElementLocations();
                        if (a.getPairedArc() != null) {
                            arc = a.getPairedArc();
                            arc.unlinkElementLocations();
                            arcs.remove(arc);
                        }
                        i.remove();
                    }
                    i = el.getOutArcs().iterator();
                    while (i.hasNext()) {
                        a = i.next();
                        arcs.remove(a);
                        a.unlinkElementLocations();
                        if (a.getPairedArc() != null) {
                            arc = a.getPairedArc();
                            arc.unlinkElementLocations();
                            arcs.remove(arc);
                        }
                        i.remove();
                    }
                }
            }
            for (ElementLocation el : node.getElementLocations()) {
                for (Arc arc : el.accessMetaInArcs()) {
                    ElementLocation startEL = arc.getStartLocation();
                    startEL.accessMetaOutArcs().remove(arc);
                    arcs.remove(arc);
                }
                for (Arc arc : el.accessMetaOutArcs()) {
                    ElementLocation endEL = arc.getEndLocation();
                    endEL.accessMetaInArcs().remove(arc);
                    arcs.remove(arc);
                }
            }
            nodes.remove(node);
            removed = true;
            break;
        }
        if (!found) {
            strB = "err.";
            try {
                strB = String.format(lang.getText("SC_entry008"), sheetID);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " SC_entry008", "error", true);
            }
            overlord.log(strB, "warning", true);
        } else if (!removed) {
            strB = "err.";
            try {
                strB = String.format(lang.getText("SC_entry009"), sheetID);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " SC_entry009", "error", true);
            }
            overlord.log(strB, "error", true);
        }
    }

    public void validateMetaArcs(ArrayList<Integer> sheetModified, boolean forceFix, boolean doNotRemove) {
        boolean compressMetaArcs = overlord.getSettingsManager().getValue("editorSubnetCompressMode").equals("1");
        ArrayList<MetaNode> metanodes = overlord.getWorkspace().getProject().getMetaNodes();
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        for (int sheetID : sheetModified) {
            if (sheetID == 0 && !forceFix) continue;
            ArrayList<ElementLocation> subnetElements = this.getSubnetElementLocations(sheetID);
            MetaNode metanodeRepresSubnet = null;
            for (MetaNode meta : metanodes) {
                if (meta.getRepresentedSheetID() != sheetID) continue;
                metanodeRepresSubnet = meta;
                break;
            }
            if (metanodeRepresSubnet == null) {
                overlord.log(lang.getText("LOGentry00418critErr") + " " + sheetID, "error", true);
                break;
            }
            ArrayList<Node> alreadyChecked = new ArrayList<Node>();
            for (ElementLocation el : subnetElements) {
                Node parent;
                ElementLocation lonely;
                Object cand;
                Node nodeToFix = el.getParentNode();
                if (!nodeToFix.isPortal() || el.getParentNode() instanceof MetaNode || alreadyChecked.contains(nodeToFix)) continue;
                alreadyChecked.add(nodeToFix);
                int inInterfaceLinks = 0;
                int outInterfaceLinks = 0;
                for (ElementLocation element : nodeToFix.getElementLocations()) {
                    if (element.getSheetID() != sheetID) continue;
                    outInterfaceLinks += element.getInArcs().size();
                    inInterfaceLinks += element.getOutArcs().size();
                    outInterfaceLinks += element.accessMetaInArcs().size();
                    inInterfaceLinks += element.accessMetaOutArcs().size();
                }
                ElementLocation metaEL = metanodeRepresSubnet.getElementLocations().get(0);
                int metaSheet = metaEL.getSheetID();
                ArrayList<Arc> inMetaArcs = new ArrayList<Arc>();
                ArrayList<Arc> outMetaArcs = new ArrayList<Arc>();
                for (Arc arc : metaEL.accessMetaInArcs()) {
                    if (!arc.getStartNode().equals(nodeToFix)) continue;
                    inMetaArcs.add(arc);
                }
                for (Arc arc : metaEL.accessMetaOutArcs()) {
                    if (!arc.getEndNode().equals(nodeToFix)) continue;
                    outMetaArcs.add(arc);
                }
                if (inInterfaceLinks > inMetaArcs.size()) {
                    ElementLocation pattern = null;
                    for (ElementLocation cand2 : nodeToFix.getElementLocations()) {
                        if (cand2.getSheetID() != metaSheet) continue;
                        pattern = cand2;
                        break;
                    }
                    if (pattern != null) {
                        if (compressMetaArcs) {
                            this.addAllMissingInMetaArcsCompression(metaEL, pattern, inInterfaceLinks - inMetaArcs.size(), arcs);
                        } else {
                            this.addAllMissingInMetaArcs(metaEL, pattern, inInterfaceLinks - inMetaArcs.size(), arcs);
                        }
                    }
                } else if (inInterfaceLinks < inMetaArcs.size() && !doNotRemove) {
                    int toRemove = inMetaArcs.size() - inInterfaceLinks;
                    ArrayList<Arc> arrayList = new ArrayList<Arc>();
                    for (int r = inMetaArcs.size() - 1; r >= inInterfaceLinks; --r) {
                        cand = ((Arc)inMetaArcs.get(r)).getStartLocation();
                        if (((ElementLocation)cand).accessMetaOutArcs().size() == 1 && ((ElementLocation)cand).accessMetaInArcs().isEmpty() & ((ElementLocation)cand).getInArcs().isEmpty() && ((ElementLocation)cand).getOutArcs().isEmpty()) {
                            arrayList.add((Arc)inMetaArcs.get(r));
                        }
                        if (arrayList.size() == toRemove) break;
                    }
                    int elNumber = 0;
                    for (Arc arc : outMetaArcs) {
                        if (!arc.getEndNode().equals(nodeToFix)) continue;
                        ++elNumber;
                    }
                    for (Arc arc : arrayList) {
                        arc.unlinkElementLocations();
                        arcs.remove(arc);
                        --toRemove;
                        if (elNumber <= 1) continue;
                        lonely = arc.getStartLocation();
                        parent = lonely.getParentNode();
                        parent.getElementLocations().remove(lonely);
                        --elNumber;
                    }
                    arrayList.clear();
                    for (int r = inMetaArcs.size() - 1; r >= 0; --r) {
                        if (toRemove > 0) {
                            arrayList.add((Arc)inMetaArcs.get(r));
                        }
                        --toRemove;
                    }
                    for (Arc arc : arrayList) {
                        arc.unlinkElementLocations();
                        arcs.remove(arc);
                    }
                }
                if (outInterfaceLinks > outMetaArcs.size()) {
                    ElementLocation pattern = null;
                    for (ElementLocation cand2 : nodeToFix.getElementLocations()) {
                        if (cand2.getSheetID() != metaSheet) continue;
                        pattern = cand2;
                        break;
                    }
                    if (pattern == null) continue;
                    if (compressMetaArcs) {
                        this.addAllMissingOutMetaArcsCompression(metaEL, pattern, outInterfaceLinks - outMetaArcs.size(), arcs);
                        continue;
                    }
                    this.addAllMissingOutMetaArcs(metaEL, pattern, outInterfaceLinks - outMetaArcs.size(), arcs);
                    continue;
                }
                if (outInterfaceLinks >= outMetaArcs.size() || doNotRemove) continue;
                int toRemove = outMetaArcs.size() - outInterfaceLinks;
                ArrayList<Arc> arrayList = new ArrayList<Arc>();
                for (int r = outMetaArcs.size() - 1; r >= outInterfaceLinks; --r) {
                    cand = ((Arc)outMetaArcs.get(r)).getEndLocation();
                    if (((ElementLocation)cand).accessMetaInArcs().size() == 1 && ((ElementLocation)cand).accessMetaOutArcs().isEmpty() & ((ElementLocation)cand).getInArcs().isEmpty() && ((ElementLocation)cand).getOutArcs().isEmpty()) {
                        arrayList.add((Arc)outMetaArcs.get(r));
                    }
                    if (arrayList.size() == toRemove) break;
                }
                int elNumber = 0;
                for (Arc arc : outMetaArcs) {
                    if (!arc.getEndNode().equals(nodeToFix)) continue;
                    ++elNumber;
                }
                for (Arc arc : arrayList) {
                    arc.unlinkElementLocations();
                    arcs.remove(arc);
                    --toRemove;
                    if (elNumber <= 1) continue;
                    lonely = arc.getEndLocation();
                    parent = lonely.getParentNode();
                    parent.getElementLocations().remove(lonely);
                    --elNumber;
                }
                arrayList.clear();
                for (int r = outMetaArcs.size() - 1; r >= 0; --r) {
                    if (toRemove > 0) {
                        arrayList.add((Arc)outMetaArcs.get(r));
                    }
                    --toRemove;
                }
                for (Arc arc : arrayList) {
                    arc.unlinkElementLocations();
                    arcs.remove(arc);
                }
            }
        }
    }

    public void addAllMissingInMetaArcs(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Random gen = new Random();
        Node parent = pattern.getParentNode();
        int sheetID = pattern.getSheetID();
        Point refMetaPoint = metanodeEL.getPosition();
        for (int i = 0; i < howMany; ++i) {
            ElementLocation nameEL = new ElementLocation(sheetID, new Point(0, 0), parent);
            int newX = gen.nextInt(160) - 80;
            int newY = gen.nextInt(100) + 15;
            Point point = new Point(refMetaPoint.x + newX, refMetaPoint.y - newY);
            ElementLocation newPortalEL = new ElementLocation(sheetID, point, parent);
            parent.setPortal(true);
            parent.getElementLocations().add(newPortalEL);
            parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(nameEL);
            Arc arc = new Arc(IdGenerator.getNextId(), newPortalEL, metanodeEL, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void addAllMissingInMetaArcsCompression(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Node nodeTP = pattern.getParentNode();
        ElementLocation nexus = null;
        int currentMax = 0;
        ArrayList<Arc> inMetaArcsFromNodeTP = new ArrayList<Arc>();
        int howManyElements = 0;
        for (Arc arc : metanodeEL.accessMetaInArcs()) {
            if (!arc.getStartNode().equals(nodeTP)) continue;
            ++howManyElements;
            inMetaArcsFromNodeTP.add(arc);
            int outArcs = arc.getStartLocation().accessMetaOutArcs().size();
            if (outArcs <= currentMax) continue;
            currentMax = outArcs;
            nexus = arc.getStartLocation();
        }
        Point p1 = metanodeEL.getPosition();
        double distance = 9.9999999E7;
        if (nexus == null) {
            for (ElementLocation anyone : nodeTP.getElementLocations()) {
                if (anyone.getSheetID() != metanodeEL.getSheetID()) continue;
                if (nexus == null) {
                    nexus = anyone;
                    continue;
                }
                Point p2 = nexus.getPosition();
                double currDist = Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
                if (!(currDist < distance)) continue;
                distance = currDist;
                nexus = anyone;
            }
        }
        for (Arc arc : inMetaArcsFromNodeTP) {
            ElementLocation other = arc.getStartLocation();
            if (other.equals(nexus)) continue;
            for (Arc arcSwitch : other.accessMetaOutArcs()) {
                arcSwitch.modifyStartLocation(nexus);
                nexus.accessMetaOutArcs().add(arcSwitch);
            }
            other.accessMetaOutArcs().clear();
            if (howManyElements <= 1 || !other.accessMetaInArcs().isEmpty() || !other.getInArcs().isEmpty() || !other.getOutArcs().isEmpty()) continue;
            nodeTP.getElementLocations().remove(other);
            --howManyElements;
        }
        for (int i = 0; i < howMany; ++i) {
            Arc arc;
            arc = new Arc(IdGenerator.getNextId(), nexus, metanodeEL, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void addAllMissingOutMetaArcs(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Random gen = new Random();
        Node parent = pattern.getParentNode();
        int sheetID = pattern.getSheetID();
        Point refMetaPoint = metanodeEL.getPosition();
        for (int i = 0; i < howMany; ++i) {
            ElementLocation nameEL = new ElementLocation(sheetID, new Point(0, 0), parent);
            int newX = gen.nextInt(160) - 80;
            int newY = gen.nextInt(100) + 15;
            Point point = new Point(refMetaPoint.x + newX, refMetaPoint.y + newY);
            ElementLocation newPortalEL = new ElementLocation(sheetID, point, parent);
            parent.setPortal(true);
            parent.getElementLocations().add(newPortalEL);
            parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(nameEL);
            Arc arc = new Arc(IdGenerator.getNextId(), metanodeEL, newPortalEL, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void addAllMissingOutMetaArcsCompression(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Node nodeTP = pattern.getParentNode();
        ElementLocation nexus = null;
        int currentMax = 0;
        ArrayList<Arc> outMetaArcsToNodeTP = new ArrayList<Arc>();
        int howManyElements = 0;
        for (Arc arc : metanodeEL.accessMetaOutArcs()) {
            if (!arc.getEndNode().equals(nodeTP)) continue;
            ++howManyElements;
            outMetaArcsToNodeTP.add(arc);
            int inArcs = arc.getEndLocation().accessMetaInArcs().size();
            if (inArcs <= currentMax) continue;
            currentMax = inArcs;
            nexus = arc.getEndLocation();
        }
        Point p1 = metanodeEL.getPosition();
        double distance = 9.9999999E7;
        if (nexus == null) {
            for (ElementLocation anyone : nodeTP.getElementLocations()) {
                if (anyone.getSheetID() != metanodeEL.getSheetID()) continue;
                if (nexus == null) {
                    nexus = anyone;
                    continue;
                }
                Point p2 = nexus.getPosition();
                double currDist = Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
                if (!(currDist < distance)) continue;
                distance = currDist;
                nexus = anyone;
            }
        }
        for (Arc arc : outMetaArcsToNodeTP) {
            ElementLocation other = arc.getEndLocation();
            if (other.equals(nexus)) continue;
            for (Arc arcSwitch : other.accessMetaInArcs()) {
                arcSwitch.modifyEndLocation(nexus);
                nexus.accessMetaInArcs().add(arcSwitch);
            }
            other.accessMetaInArcs().clear();
            if (howManyElements <= 1 || !other.accessMetaOutArcs().isEmpty() || !other.getInArcs().isEmpty() || !other.getOutArcs().isEmpty()) continue;
            nodeTP.getElementLocations().remove(other);
            --howManyElements;
        }
        for (int i = 0; i < howMany; ++i) {
            Arc arc;
            arc = new Arc(IdGenerator.getNextId(), metanodeEL, nexus, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void clearAllMetaArcs(Node node, int subnet) {
        ArrayList<MetaNode> metanodes = overlord.getWorkspace().getProject().getMetaNodes();
        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, subnet);
        meta.removeAllInConnectionsWith(node);
        meta.removeAllOutConnectionsWith(node);
    }

    public boolean checkSnoopyCompatibility() {
        String strB;
        int i;
        boolean status = false;
        SubnetsSnoopyCompatibility sc = new SubnetsSnoopyCompatibility();
        ArrayList<ArrayList<Integer>> results = sc.macroCheck();
        if (results == null) {
            return true;
        }
        status = sc.checkAndFix(true);
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        ArrayList<Integer> problemMultiEL = results.get(0);
        ArrayList<Integer> problemWrongType = results.get(1);
        ArrayList<MetaNode> metanodes = overlord.getWorkspace().getProject().getMetaNodes();
        int size = problemWrongType.size();
        notePad.addTextLineNL(lang.getText("SC_entry010"), "text");
        for (i = 0; i < size; ++i) {
            if (problemMultiEL.get(i) == 0) continue;
            strB = "err.";
            try {
                strB = String.format(lang.getText("SC_entry011"), metanodes.get(i).getName(), metanodes.get(i).getRepresentedSheetID());
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " SC_entry011", "error", true);
            }
            notePad.addTextLineNL(strB, "text");
        }
        notePad.addTextLineNL(" ------ ", "text");
        notePad.addTextLineNL(lang.getText("SC_entry012"), "text");
        for (i = 0; i < size; ++i) {
            if (problemWrongType.get(i) == 0) continue;
            strB = "err.";
            try {
                strB = String.format(lang.getText("SC_entry013"), new Object[]{metanodes.get(i).getName(), metanodes.get(i).getRepresentedSheetID(), metanodes.get(i).getMetaType()});
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " SC_entry013", "error", true);
            }
            notePad.addTextLineNL(strB, "text");
        }
        notePad.addTextLineNL(" ------ ", "text");
        notePad.setVisible(true);
        return status;
    }

    public boolean checkIfExpendable(ElementLocation el) {
        MetaNode meta2;
        Node parent = el.getParentNode();
        if (!el.accessMetaInArcs().isEmpty()) {
            ArrayList<MetaNode> metanodesInSubnet = new ArrayList<MetaNode>();
            for (Arc arc : el.accessMetaInArcs()) {
                MetaNode meta2 = (MetaNode)arc.getStartNode();
                if (metanodesInSubnet.contains(meta2)) continue;
                metanodesInSubnet.add(meta2);
            }
            int size = metanodesInSubnet.size();
            block1: for (int m = 0; m < size; ++m) {
                meta2 = (MetaNode)metanodesInSubnet.get(m);
                for (ElementLocation elementLocation : meta2.getElementLocations()) {
                    boolean found = false;
                    for (Arc arc : elementLocation.accessMetaOutArcs()) {
                        if (!arc.getEndNode().equals(parent) || arc.getEndLocation().equals(el)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    metanodesInSubnet.remove(meta2);
                    --m;
                    --size;
                    continue block1;
                }
            }
            if (!metanodesInSubnet.isEmpty()) {
                for (MetaNode meta2 : metanodesInSubnet) {
                    int repID = meta2.getRepresentedSheetID();
                    for (ElementLocation element : parent.getElementLocations()) {
                        if (element.getSheetID() != repID) continue;
                        return false;
                    }
                }
            }
        }
        if (!el.accessMetaOutArcs().isEmpty()) {
            ArrayList<MetaNode> metanodesOutSubnet = new ArrayList<MetaNode>();
            for (Arc arc : el.accessMetaOutArcs()) {
                meta2 = (MetaNode)arc.getEndNode();
                if (metanodesOutSubnet.contains(meta2)) continue;
                metanodesOutSubnet.add(meta2);
            }
            int size = metanodesOutSubnet.size();
            block7: for (int m = 0; m < size; ++m) {
                meta2 = (MetaNode)metanodesOutSubnet.get(m);
                for (ElementLocation elementLocation : meta2.getElementLocations()) {
                    boolean found = false;
                    for (Arc arc : elementLocation.accessMetaInArcs()) {
                        if (!arc.getStartNode().equals(parent) || arc.getStartLocation().equals(el)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    metanodesOutSubnet.remove(meta2);
                    --m;
                    --size;
                    continue block7;
                }
            }
            if (!metanodesOutSubnet.isEmpty()) {
                for (MetaNode meta2 : metanodesOutSubnet) {
                    int repID = meta2.getRepresentedSheetID();
                    for (ElementLocation element : parent.getElementLocations()) {
                        if (element.getSheetID() != repID) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void moveSelectedElementsToSubnet(GraphPanel graphPanel, int subnetSheetId, boolean createMetaArcs) {
        ArrayList<ElementLocation> elements = graphPanel.getSelectionManager().getSelectedElementLocations();
        this.changeNodesSheetID(elements, subnetSheetId);
        this.clearMetaArcs(elements);
        this.createPortalsAndMetaArcs(elements, this.getMetanode(subnetSheetId).orElseThrow(), createMetaArcs);
        graphPanel.getSelectionManager().deselectAllElements();
    }

    private void changeNodesSheetID(List<ElementLocation> elements, int subnetSheetId) {
        for (ElementLocation element : elements) {
            element.setSheetID(subnetSheetId);
            Node parent = element.getParentNode();
            int index = parent.getElementLocations().indexOf(element);
            ElementLocation textLocation = parent.getTextsLocations(GUIManager.locationMoveType.NAME).get(index);
            textLocation.setSheetID(subnetSheetId);
        }
    }

    public void copySelectedElementsToSubnet(GraphPanel graphPanel, int subnetSheetId) {
        ArrayList<ElementLocation> elements = graphPanel.getSelectionManager().getSelectedElementLocations();
        for (ElementLocation location : elements) {
            this.cloneNodeIntoPortal(location, subnetSheetId);
        }
    }

    public void clearMetaArcs(List<ElementLocation> elements) {
        for (ElementLocation element : elements) {
            for (Arc arc : element.accessMetaInArcs()) {
                arc.getStartLocation().accessMetaOutArcs().remove(arc);
                overlord.getWorkspace().getProject().getArcs().remove(arc);
            }
            element.accessMetaInArcs().clear();
            for (Arc arc : element.accessMetaOutArcs()) {
                arc.getEndLocation().accessMetaInArcs().remove(arc);
                overlord.getWorkspace().getProject().getArcs().remove(arc);
            }
            element.accessMetaOutArcs().clear();
        }
    }

    private void createPortalsAndMetaArcs(List<ElementLocation> elements, MetaNode subnetNode, boolean createMetaArcs) {
        int currentSheetId = subnetNode.getMySheetID();
        int subnetSheetId = subnetNode.getRepresentedSheetID();
        ElementLocation subnetElementLocation = subnetNode.getFirstELoc();
        HashMap<ElementLocation, ElementLocation> locationToPortal = new HashMap<ElementLocation, ElementLocation>();
        HashSet<ElementLocation> elementToMetanode = new HashSet<ElementLocation>();
        HashSet<ElementLocation> elementFromMetanode = new HashSet<ElementLocation>();
        for (ElementLocation element : elements) {
            ElementLocation portal;
            Arc newArc;
            int sheetID;
            for (Arc arc : element.getInArcs()) {
                sheetID = arc.getStartLocation().getSheetID();
                if (sheetID != currentSheetId) continue;
                if (createMetaArcs && !elementToMetanode.contains(arc.getStartLocation())) {
                    newArc = new Arc(IdGenerator.getNextId(), arc.getStartLocation(), subnetElementLocation, Arc.TypeOfArc.META_ARC);
                    overlord.getWorkspace().getProject().addArc(newArc);
                    elementToMetanode.add(arc.getStartLocation());
                }
                if (locationToPortal.containsKey(arc.getStartLocation())) {
                    portal = (ElementLocation)locationToPortal.get(arc.getStartLocation());
                } else {
                    portal = this.cloneNodeIntoPortal(arc.getStartLocation(), subnetSheetId);
                    locationToPortal.put(arc.getStartLocation(), portal);
                }
                arc.getStartLocation().getOutArcs().remove(arc);
                portal.getOutArcs().add(arc);
                arc.modifyStartLocation(portal);
            }
            for (Arc arc : element.getOutArcs()) {
                sheetID = arc.getEndLocation().getSheetID();
                if (sheetID != currentSheetId) continue;
                if (createMetaArcs && !elementFromMetanode.contains(arc.getEndLocation())) {
                    newArc = new Arc(IdGenerator.getNextId(), subnetElementLocation, arc.getEndLocation(), Arc.TypeOfArc.META_ARC);
                    overlord.getWorkspace().getProject().addArc(newArc);
                    elementFromMetanode.add(arc.getEndLocation());
                }
                if (locationToPortal.containsKey(arc.getEndLocation())) {
                    portal = (ElementLocation)locationToPortal.get(arc.getEndLocation());
                } else {
                    portal = this.cloneNodeIntoPortal(arc.getEndLocation(), subnetSheetId);
                    locationToPortal.put(arc.getEndLocation(), portal);
                }
                arc.getEndLocation().getInArcs().remove(arc);
                portal.getInArcs().add(arc);
                arc.modifyEndLocation(portal);
            }
        }
    }

    public ElementLocation cloneNodeIntoPortal(ElementLocation element, int subnetSheetId) {
        Node parent = element.getParentNode();
        ElementLocation newGraphicsEL = new ElementLocation(subnetSheetId, new Point(element.getPosition().x, element.getPosition().y), parent);
        ElementLocation newNameEL = new ElementLocation(subnetSheetId, new Point(0, 0), parent);
        parent.getElementLocations().add(newGraphicsEL);
        parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
        parent.setPortal(true);
        return newGraphicsEL;
    }

    public void realignElements(List<ElementLocation> elementsToAlign, List<ElementLocation> otherElements) {
        int bottom = otherElements.stream().map(location -> location.getPosition().y).max(Comparator.naturalOrder()).orElse(0);
        int offsetX = elementsToAlign.stream().map(location -> location.getPosition().x).min(Comparator.naturalOrder()).orElseThrow();
        int offsetY = elementsToAlign.stream().map(location -> location.getPosition().y).min(Comparator.naturalOrder()).orElseThrow();
        int margin = 50;
        for (ElementLocation location2 : elementsToAlign) {
            Point position = location2.getPosition();
            position.setLocation(position.x - offsetX + 50, position.y - offsetY + bottom + 50);
        }
    }

    public void deleteSubnet(MetaNode metaNode) {
        WorkspaceSheet subnetSheet = overlord.getWorkspace().getSheetById(metaNode.getRepresentedSheetID());
        for (ElementLocation location : this.getSubnetElementLocations(metaNode.getRepresentedSheetID())) {
            if (location.getParentNode() instanceof MetaNode) {
                this.deleteSubnet((MetaNode)location.getParentNode());
                continue;
            }
            subnetSheet.getGraphPanel().getSelectionManager().deleteElementLocation(location);
        }
        this.removeMetaNode(metaNode.getRepresentedSheetID());
        overlord.getWorkspace().deleteSheetFromArrays(subnetSheet);
        overlord.getWorkspace().repaintAllGraphPanels();
    }

    public void unwrapSubnet(GraphPanel graphPanel) {
        MetaNode metaNode = graphPanel.getSelectionManager().getSelectedMetanode();
        WorkspaceSheet subnetSheet = overlord.getWorkspace().getSheetById(metaNode.getRepresentedSheetID());
        List<ElementLocation> subnetElements = List.copyOf(this.getSubnetElementLocations(metaNode.getRepresentedSheetID()));
        List<ElementLocation> parentNetElements = this.getSubnetElementLocations(metaNode.getMySheetID()).stream().filter(location -> location.getParentNode() != metaNode).toList();
        this.changeNodesSheetID(subnetElements, metaNode.getMySheetID());
        this.realignElements(subnetElements, parentNetElements);
        graphPanel.adjustOriginSize();
        this.removeMetaNode(metaNode.getRepresentedSheetID());
        overlord.getWorkspace().deleteSheetFromArrays(subnetSheet);
        overlord.getWorkspace().repaintAllGraphPanels();
    }

    public void createSubnetFromSelectedElements(GraphPanel graphPanel) {
        int newSheetId = overlord.getWorkspace().newTab(true, graphPanel.getSelectionManager().getMeanSelectionPoint(), graphPanel.getSheetId(), MetaNode.MetaType.SUBNET);
        this.moveSelectedElementsToSubnet(graphPanel, newSheetId, true);
        this.realignElements(this.getSubnetElementLocations(newSheetId), List.of());
        this.getGraphPanel(newSheetId).adjustOriginSize();
        overlord.getWorkspace().repaintAllGraphPanels();
        overlord.markNetChange();
    }

    public void mergePortals(ElementLocation clickedELoc, List<ElementLocation> selectedELoc) {
        GraphPanel graphPanel = this.getGraphPanel(clickedELoc.getSheetID());
        selectedELoc.remove(clickedELoc);
        ArrayList<Arc> inArcs = new ArrayList<Arc>();
        ArrayList<Arc> inMetaArcs = new ArrayList<Arc>();
        ArrayList<Arc> outArcs = new ArrayList<Arc>();
        ArrayList<Arc> outMetaArcs = new ArrayList<Arc>();
        for (ElementLocation location : selectedELoc) {
            inArcs.addAll(location.getInArcs());
            location.getInArcs().clear();
            outArcs.addAll(location.getOutArcs());
            location.getOutArcs().clear();
            inMetaArcs.addAll(location.accessMetaInArcs());
            location.accessMetaInArcs().clear();
            outMetaArcs.addAll(location.accessMetaOutArcs());
            location.accessMetaOutArcs().clear();
        }
        for (Arc arc : inArcs) {
            arc.modifyEndLocation(clickedELoc);
        }
        for (Arc arc : outArcs) {
            arc.modifyStartLocation(clickedELoc);
        }
        for (Arc arc : inMetaArcs) {
            arc.modifyEndLocation(clickedELoc);
        }
        for (Arc arc : outMetaArcs) {
            arc.modifyStartLocation(clickedELoc);
        }
        clickedELoc.getInArcs().addAll(inArcs);
        clickedELoc.getOutArcs().addAll(outArcs);
        clickedELoc.accessMetaInArcs().addAll(inMetaArcs);
        clickedELoc.accessMetaOutArcs().addAll(outMetaArcs);
        graphPanel.getSelectionManager().deselectElementLocation(clickedELoc);
        graphPanel.getSelectionManager().deleteAllSelectedElements();
        graphPanel.getSelectionManager().selectElementLocation(clickedELoc);
        overlord.markNetChange();
    }

    public ElementLocation cloneLocationNearMetanode(ElementLocation element, int subnetID) {
        Random gen = new Random();
        int angle = gen.nextInt(360);
        int radius = gen.nextInt(40) + 60;
        MetaNode metanode = this.getMetanode(subnetID).orElseThrow();
        Point p = metanode.getFirstELoc().getPosition();
        int x = Math.toIntExact(Math.round((double)radius * Math.cos(Math.toRadians(angle)) + (double)p.x));
        int y = Math.toIntExact(Math.round((double)radius * Math.sin(Math.toRadians(angle)) + (double)p.y));
        ElementLocation newLocation = SubnetsControl.overlord.subnetsHQ.cloneNodeIntoPortal(element, metanode.getMySheetID());
        newLocation.setPosition(new Point(x, y));
        return newLocation;
    }

    public void fixMetaArcsNumber(MetaNode metaNode) {
        Set nodes = this.getSubnetElementLocations(metaNode.getMySheetID()).stream().map(ElementLocation::getParentNode).collect(Collectors.toSet());
        Set subnetNodes = this.getSubnetElementLocations(metaNode.getRepresentedSheetID()).stream().map(ElementLocation::getParentNode).collect(Collectors.toSet());
        nodes.retainAll(subnetNodes);
        for (Node node : nodes) {
            Arc newArc;
            AtomicBoolean hasInArcs = new AtomicBoolean(false);
            AtomicBoolean hasOutArcs = new AtomicBoolean(false);
            node.getNodeLocations(metaNode.getRepresentedSheetID()).forEach(location -> {
                if (!location.getInArcs().isEmpty()) {
                    hasInArcs.set(true);
                }
                if (!location.getOutArcs().isEmpty()) {
                    hasOutArcs.set(true);
                }
            });
            boolean alreadyConnected = node.getNodeLocations(metaNode.getMySheetID()).stream().anyMatch(location -> {
                boolean inArcExists = location.accessMetaInArcs().stream().anyMatch(arc -> arc.getStartLocation().equals(metaNode.getFirstELoc()));
                boolean outArcExists = location.accessMetaOutArcs().stream().anyMatch(arc -> arc.getEndLocation().equals(metaNode.getFirstELoc()));
                return inArcExists || outArcExists;
            });
            if (alreadyConnected || !hasInArcs.get() && !hasOutArcs.get()) continue;
            ElementLocation newLocation = this.cloneLocationNearMetanode(node.getLastLocation(), metaNode.getRepresentedSheetID());
            if (hasInArcs.get()) {
                newArc = new Arc(IdGenerator.getNextId(), metaNode.getFirstELoc(), newLocation, Arc.TypeOfArc.META_ARC);
                overlord.getWorkspace().getProject().addArc(newArc);
            }
            if (!hasOutArcs.get()) continue;
            newArc = new Arc(IdGenerator.getNextId(), newLocation, metaNode.getFirstELoc(), Arc.TypeOfArc.META_ARC);
            overlord.getWorkspace().getProject().addArc(newArc);
        }
    }
}

