/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.subnets.dialogs.ComboBoxItem;
import holmes.petrinet.subnets.dialogs.OnNodeAction;
import holmes.petrinet.subnets.dialogs.OnSubnetAction;
import java.util.List;
import java.util.Optional;

public class SubnetsActions {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    private SubnetsActions() {
    }

    public static void openTransferElementsToSubnet(GraphPanel graphPanel, boolean createMetaArcs) {
        String title = createMetaArcs ? lang.getText("SA_entry001") : lang.getText("SA_entry002");
        OnSubnetAction onSubnetActionDialog = new OnSubnetAction(graphPanel, title, 400, 240);
        onSubnetActionDialog.setAction(e -> {
            ComboBoxItem<Integer> selectedItem = onSubnetActionDialog.getComboBoxValue();
            overlord.getWorkspace().repaintAllGraphPanels();
            overlord.getFrame().setEnabled(true);
            onSubnetActionDialog.getDialog().dispose();
            Optional.ofNullable(selectedItem).ifPresent(item -> {
                overlord.markNetChange();
                List<ElementLocation> oldSubnetElements = List.copyOf(SubnetsActions.overlord.subnetsHQ.getSubnetElementLocations((Integer)item.getValue()));
                SubnetsActions.overlord.subnetsHQ.moveSelectedElementsToSubnet(graphPanel, (Integer)item.getValue(), createMetaArcs);
                List<ElementLocation> newSubnetElements = SubnetsActions.overlord.subnetsHQ.getSubnetElementLocations((Integer)item.getValue()).stream().filter(location -> !oldSubnetElements.contains(location)).toList();
                SubnetsActions.overlord.subnetsHQ.realignElements(newSubnetElements, oldSubnetElements);
                SubnetsActions.overlord.subnetsHQ.getGraphPanel((Integer)item.getValue()).adjustOriginSize();
            });
        });
        onSubnetActionDialog.open();
    }

    public static void openCopyElementsToSubnet(GraphPanel graphPanel) {
        OnSubnetAction onSubnetActionDialog = new OnSubnetAction(graphPanel, lang.getText("SA_entry003"), 400, 240);
        onSubnetActionDialog.setAction(e -> {
            ComboBoxItem<Integer> selectedItem = onSubnetActionDialog.getComboBoxValue();
            overlord.getWorkspace().repaintAllGraphPanels();
            overlord.getFrame().setEnabled(true);
            onSubnetActionDialog.getDialog().dispose();
            Optional.ofNullable(selectedItem).ifPresent(item -> {
                overlord.markNetChange();
                List<ElementLocation> oldSubnetElements = List.copyOf(SubnetsActions.overlord.subnetsHQ.getSubnetElementLocations((Integer)item.getValue()));
                SubnetsActions.overlord.subnetsHQ.copySelectedElementsToSubnet(graphPanel, (Integer)item.getValue());
                List<ElementLocation> newSubnetElements = SubnetsActions.overlord.subnetsHQ.getSubnetElementLocations((Integer)item.getValue()).stream().filter(location -> !oldSubnetElements.contains(location)).toList();
                SubnetsActions.overlord.subnetsHQ.realignElements(newSubnetElements, oldSubnetElements);
                SubnetsActions.overlord.subnetsHQ.getGraphPanel((Integer)item.getValue()).adjustOriginSize();
            });
        });
        onSubnetActionDialog.open();
    }

    public static void addExistingElement(GraphPanel graphPanel) {
        OnNodeAction onNodeActionDialog = new OnNodeAction(graphPanel, lang.getText("SA_entry004"), 540, 340);
        onNodeActionDialog.setAction(e -> {
            ComboBoxItem<Place> selectedPlace = onNodeActionDialog.getPlaceComboBoxValue();
            ComboBoxItem<Transition> selectedTransition = onNodeActionDialog.getTransitionComboBoxValue();
            Node selectedNode = null;
            if (selectedPlace != null) {
                selectedNode = selectedPlace.getValue();
            } else if (selectedTransition != null) {
                selectedNode = selectedTransition.getValue();
            }
            boolean addMetaArcs = onNodeActionDialog.getCheckboxValue();
            Optional.ofNullable(selectedNode).ifPresent(node -> {
                overlord.markNetChange();
                ElementLocation newLocation = SubnetsActions.overlord.subnetsHQ.cloneNodeIntoPortal(node.getLastLocation(), graphPanel.getSheetId());
                newLocation.setPosition(graphPanel.getMousePt());
                if (addMetaArcs) {
                    ElementLocation nearMetanode = SubnetsActions.overlord.subnetsHQ.cloneLocationNearMetanode(newLocation, graphPanel.getSheetId());
                    Arc newArc = new Arc(IdGenerator.getNextId(), nearMetanode, SubnetsActions.overlord.subnetsHQ.getMetanode(graphPanel.getSheetId()).orElseThrow().getFirstELoc(), Arc.TypeOfArc.META_ARC);
                    overlord.getWorkspace().getProject().addArc(newArc);
                }
            });
            overlord.getWorkspace().repaintAllGraphPanels();
            overlord.getFrame().setEnabled(true);
            onNodeActionDialog.getDialog().dispose();
        });
        onNodeActionDialog.open();
    }
}

