/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators.xtpn;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.functions.FunctionsTools;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.xtpn.SimulatorEngineXTPN;
import holmes.windows.HolmesNotepad;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class GraphicalSimulatorXTPN {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private SimulatorGlobals.SimNetType netSimTypeXTPN;
    private SimulatorModeXTPN simulatorStatusXTPN = SimulatorModeXTPN.STOPPED;
    private SimulatorModeXTPN previousSimStatusXTPN = SimulatorModeXTPN.STOPPED;
    private PetriNet petriNet;
    private SimulatorGlobals sg;
    private int delay = 30;
    private boolean simulationActive = false;
    private Timer timer;
    private ArrayList<TransitionXTPN> consumingTokensTransitionsXTPN;
    private ArrayList<TransitionXTPN> consumingTokensTransitionsClassical;
    private ArrayList<TransitionXTPN> producingTokensTransitionsAll;
    ArrayList<ArrayList<TransitionXTPN>> transitionsAfterSubtracting;
    private long stepCounter = 0L;
    private double simTotalTime = 0.0;
    ArrayList<ArrayList<SimulatorEngineXTPN.NextXTPNstep>> nextXTPNsteps;
    SimulatorEngineXTPN.NextXTPNstep infoNode;
    private SimulatorEngineXTPN engineXTPN;

    public GraphicalSimulatorXTPN(SimulatorGlobals.SimNetType type, PetriNet net) {
        this.netSimTypeXTPN = type;
        this.petriNet = net;
        this.consumingTokensTransitionsXTPN = new ArrayList();
        this.consumingTokensTransitionsClassical = new ArrayList();
        this.producingTokensTransitionsAll = new ArrayList();
        this.engineXTPN = new SimulatorEngineXTPN();
        this.nextXTPNsteps = new ArrayList();
    }

    public boolean isSimulationActive() {
        return this.simulationActive;
    }

    public void setSimulationActive(boolean simulationActive) {
        this.simulationActive = simulationActive;
        overlord.getWorkspace().getProject().setSimulationActive(simulationActive);
    }

    public void resetSimulator() {
        this.setSimulatorStatus(SimulatorModeXTPN.STOPPED);
        this.setSimulationActive(false);
        this.previousSimStatusXTPN = SimulatorModeXTPN.STOPPED;
        this.stepCounter = 0L;
        this.simTotalTime = 0.0;
        this.nextXTPNsteps.clear();
        this.engineXTPN.setEngine(SimulatorGlobals.SimNetType.XTPN, this.convertTransitionsToXTPN(this.petriNet.getTransitions()), this.convertPlacesToXTPN(this.petriNet.getPlaces()));
    }

    public void startSimulation(SimulatorModeXTPN simulatorMode) {
        this.sg = GraphicalSimulatorXTPN.overlord.simSettings;
        boolean readArcPreserveTime = overlord.getSettingsManager().getValue("simXTPNreadArcTokens").equals("1");
        this.sg.setXTPNreadArcPreserveTokensLifetime(readArcPreserveTime);
        boolean readArcDontTakeTokens = overlord.getSettingsManager().getValue("simXTPNreadArcDoNotTakeTokens").equals("1");
        this.sg.setXTPNreadArcDontTakeTokens(readArcDontTakeTokens);
        ArrayList<Place> places = this.petriNet.getPlaces();
        HolmesNotepad notepad = new HolmesNotepad(640, 480);
        boolean status = FunctionsTools.validateFunctionNet(notepad, places);
        if (status) {
            notepad.setVisible(true);
        } else {
            notepad.dispose();
        }
        this.stepCounter = 0L;
        this.simTotalTime = 0.0;
        this.engineXTPN.setEngine(SimulatorGlobals.SimNetType.XTPN, this.convertTransitionsToXTPN(this.petriNet.getTransitions()), this.convertPlacesToXTPN(places));
        this.engineXTPN.setGraphicalSimulation(true);
        ArrayList<Arc> arcs = this.petriNet.getArcs();
        for (Arc arc : arcs) {
            arc.arcXTPNbox.setXTPNactStatus(false);
            arc.arcXTPNbox.setXTPNprodStatus(false);
        }
        this.previousSimStatusXTPN = this.getsimulatorStatusXTPN();
        this.setSimulatorStatus(simulatorMode);
        this.setSimulationActive(true);
        SimulationPerformer taskPerformer = new SimulationPerformer();
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationDisruptButtonsXTPN();
        switch (this.getsimulatorStatusXTPN()) {
            case XTPNLOOP: {
                taskPerformer = new StepLoopPerformerXTPN(true);
                break;
            }
            case SINGLE_STEP: {
                taskPerformer = new StepLoopPerformerXTPN(false);
                break;
            }
            case PAUSED: {
                break;
            }
            case STOPPED: {
                break;
            }
        }
        this.setTimer(new Timer(this.getDelay(), taskPerformer));
        this.getTimer().start();
    }

    public SimulatorGlobals.SimNetType getSimNetType() {
        return this.netSimTypeXTPN;
    }

    public void stop() {
        ((SimulationPerformer)this.getTimer().getActionListeners()[0]).scheduleStop();
    }

    public void pause() {
        if (this.getsimulatorStatusXTPN() != SimulatorModeXTPN.PAUSED && this.getsimulatorStatusXTPN() != SimulatorModeXTPN.STOPPED) {
            this.pauseSimulation();
        } else if (this.getsimulatorStatusXTPN() == SimulatorModeXTPN.PAUSED) {
            this.unpauseSimulation();
        } else if (this.getsimulatorStatusXTPN() == SimulatorModeXTPN.STOPPED) {
            JOptionPane.showMessageDialog(null, lang.getText("GSXTPN_entry001"), lang.getText("GSXTPN_entry001t"), 0);
        }
    }

    private void stopSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationInitiateButtonsXTPN();
        this.timer.stop();
        this.previousSimStatusXTPN = this.simulatorStatusXTPN;
        this.setSimulatorStatus(SimulatorModeXTPN.STOPPED);
        this.stepCounter = 0L;
        this.simTotalTime = 0.0;
        GraphicalSimulatorXTPN.overlord.io.updateTimeStep(true, this.stepCounter, this.simTotalTime, 0.0);
        GraphicalSimulatorXTPN.overlord.simSettings.currentStep = this.stepCounter;
        GraphicalSimulatorXTPN.overlord.simSettings.currentTime = this.simTotalTime;
        ArrayList<Arc> arcs = this.petriNet.getArcs();
        for (Arc arc : arcs) {
            arc.arcXTPNbox.setXTPNactStatus(false);
            arc.arcXTPNbox.setXTPNprodStatus(false);
        }
    }

    private void pauseSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlyUnpauseButtonXTPN();
        this.timer.stop();
        this.previousSimStatusXTPN = this.simulatorStatusXTPN;
        this.setSimulatorStatus(SimulatorModeXTPN.PAUSED);
    }

    private void unpauseSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationDisruptButtonsXTPN();
        if (this.previousSimStatusXTPN != SimulatorModeXTPN.STOPPED) {
            this.timer.start();
            this.setSimulatorStatus(this.previousSimStatusXTPN);
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    private void setTimer(Timer timer) {
        this.timer = timer;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        if (this.timer != null) {
            this.timer.setDelay(delay);
        }
        this.delay = delay;
    }

    public SimulatorModeXTPN getsimulatorStatusXTPN() {
        return this.simulatorStatusXTPN;
    }

    private void setSimulatorStatus(SimulatorModeXTPN mode) {
        this.simulatorStatusXTPN = mode;
    }

    public long getStepsCounterXTPN() {
        return this.stepCounter;
    }

    public double getTimeCounterXTPN() {
        return this.simTotalTime;
    }

    private ArrayList<TransitionXTPN> convertTransitionsToXTPN(ArrayList<Transition> transitionsVector) {
        ArrayList<TransitionXTPN> transitions = new ArrayList<TransitionXTPN>();
        for (Transition trans : transitionsVector) {
            if (!(trans instanceof TransitionXTPN)) {
                transitions.clear();
                overlord.log(lang.getText("LOGentry00397"), "error", true);
                return transitions;
            }
            transitions.add((TransitionXTPN)trans);
        }
        return transitions;
    }

    private ArrayList<PlaceXTPN> convertPlacesToXTPN(ArrayList<Place> placesVector) {
        ArrayList<PlaceXTPN> places = new ArrayList<PlaceXTPN>();
        for (Place place : placesVector) {
            if (!(place instanceof PlaceXTPN)) {
                places.clear();
                overlord.log(lang.getText("LOGentry00398"), "error", true);
                return places;
            }
            places.add((PlaceXTPN)place);
        }
        return places;
    }

    public static enum SimulatorModeXTPN {
        XTPNLOOP,
        SINGLE_STEP,
        STOPPED,
        PAUSED;

    }

    private class SimulationPerformer
    implements ActionListener {
        protected int repaintSteps;
        protected boolean newStateChangeStarts;
        protected boolean subtractPhase;
        protected boolean addPhase;
        protected boolean scheduledStop;

        private SimulationPerformer() {
            this.repaintSteps = GraphicalSimulatorXTPN.overlord.simSettings.getTransitionGraphicDelay();
            this.newStateChangeStarts = true;
            this.subtractPhase = false;
            this.addPhase = false;
            this.scheduledStop = false;
        }

        protected void initiateTokensMoveGraphics() {
            GraphicalSimulatorXTPN.this.petriNet.incrementGraphicalSimulationStep();
        }

        public void scheduleStop() {
            this.scheduledStop = true;
        }

        public void executeScheduledStop() {
            GraphicalSimulatorXTPN.this.stopSimulation();
            this.scheduledStop = false;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            GraphicalSimulatorXTPN.this.petriNet.incrementGraphicalSimulationStep();
        }
    }

    private class StepLoopPerformerXTPN
    extends SimulationPerformer {
        private boolean loop;

        public StepLoopPerformerXTPN() {
            this.loop = false;
        }

        public StepLoopPerformerXTPN(boolean looping) {
            this.loop = looping;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int DEFAULT_COUNTER = GraphicalSimulatorXTPN.overlord.simSettings.getTransitionGraphicDelay();
            if (this.newStateChangeStarts) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                    GraphicalSimulatorXTPN.this.setSimulationActive(false);
                    return;
                }
                ArrayList<SimulatorEngineXTPN.NextXTPNstep> classicalInputTransitions = GraphicalSimulatorXTPN.this.engineXTPN.revalidateNetState();
                GraphicalSimulatorXTPN.this.nextXTPNsteps = GraphicalSimulatorXTPN.this.engineXTPN.computeNextState();
                GraphicalSimulatorXTPN.this.nextXTPNsteps.set(4, classicalInputTransitions);
                GraphicalSimulatorXTPN.this.nextXTPNsteps.get((int)6).get((int)0).changeType += classicalInputTransitions.size();
                GraphicalSimulatorXTPN.this.infoNode = GraphicalSimulatorXTPN.this.nextXTPNsteps.get(6).get(0);
                if (GraphicalSimulatorXTPN.this.infoNode.changeType == 0) {
                    GraphicalSimulatorXTPN.this.setSimulationActive(false);
                    GraphicalSimulatorXTPN.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, lang.getText("GSXTPN_entry002"), lang.getText("GSXTPN_entry002t"), 1);
                    return;
                }
                GraphicalSimulatorXTPN.this.engineXTPN.updateNetTime(GraphicalSimulatorXTPN.this.infoNode.timeToChange);
                ++GraphicalSimulatorXTPN.this.stepCounter;
                GraphicalSimulatorXTPN.this.simTotalTime += GraphicalSimulatorXTPN.this.infoNode.timeToChange;
                GraphicalSimulatorXTPN.overlord.io.updateTimeStep(true, GraphicalSimulatorXTPN.this.stepCounter, GraphicalSimulatorXTPN.this.simTotalTime, GraphicalSimulatorXTPN.this.infoNode.timeToChange);
                GraphicalSimulatorXTPN.overlord.simSettings.currentStep = GraphicalSimulatorXTPN.this.stepCounter;
                GraphicalSimulatorXTPN.overlord.simSettings.currentTime = GraphicalSimulatorXTPN.this.simTotalTime;
                GraphicalSimulatorXTPN.this.consumingTokensTransitionsXTPN = GraphicalSimulatorXTPN.this.engineXTPN.returnConsumingTransXTPNVector(GraphicalSimulatorXTPN.this.nextXTPNsteps);
                GraphicalSimulatorXTPN.this.consumingTokensTransitionsClassical = GraphicalSimulatorXTPN.this.engineXTPN.returnConsumingTransClassicalVector(GraphicalSimulatorXTPN.this.nextXTPNsteps);
                GraphicalSimulatorXTPN.this.producingTokensTransitionsAll = GraphicalSimulatorXTPN.this.engineXTPN.returnProducingTransVector(GraphicalSimulatorXTPN.this.nextXTPNsteps);
                this.newStateChangeStarts = false;
                this.repaintSteps = 0;
                if (!GraphicalSimulatorXTPN.this.consumingTokensTransitionsXTPN.isEmpty() || !GraphicalSimulatorXTPN.this.consumingTokensTransitionsClassical.isEmpty()) {
                    this.subtractPhase = true;
                } else if (!GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.isEmpty()) {
                    this.addPhase = true;
                } else {
                    this.endThisSimulationStep();
                }
                GraphicalSimulatorXTPN.this.petriNet.repaintAllGraphPanels();
            }
            if (this.subtractPhase) {
                if (this.repaintSteps == 0) {
                    GraphicalSimulatorXTPN.this.transitionsAfterSubtracting = this.prepareSubtractPhaseGraphics();
                }
                if (this.repaintSteps < DEFAULT_COUNTER) {
                    ++this.repaintSteps;
                    this.initiateTokensMoveGraphics();
                } else {
                    GraphicalSimulatorXTPN.this.engineXTPN.endSubtractPhase(GraphicalSimulatorXTPN.this.transitionsAfterSubtracting);
                    this.subtractPhase = false;
                    this.repaintSteps = 0;
                    if (!GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.isEmpty()) {
                        this.addPhase = true;
                    } else {
                        this.endThisSimulationStep();
                    }
                }
            }
            if (this.addPhase) {
                if (this.repaintSteps == 0) {
                    this.prepareProductionPhaseGraphics();
                }
                if (this.repaintSteps < DEFAULT_COUNTER) {
                    ++this.repaintSteps;
                    this.initiateTokensMoveGraphics();
                } else {
                    GraphicalSimulatorXTPN.this.engineXTPN.endProductionPhase(GraphicalSimulatorXTPN.this.producingTokensTransitionsAll);
                    this.addPhase = false;
                    this.repaintSteps = 0;
                    this.endThisSimulationStep();
                }
            }
        }

        private void endThisSimulationStep() {
            this.newStateChangeStarts = true;
            if (!this.loop) {
                this.scheduleStop();
            }
            this.clearDataMatrix();
        }

        private void clearDataMatrix() {
            GraphicalSimulatorXTPN.this.consumingTokensTransitionsXTPN.clear();
            GraphicalSimulatorXTPN.this.consumingTokensTransitionsClassical.clear();
            GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.clear();
            GraphicalSimulatorXTPN.this.nextXTPNsteps.clear();
        }

        public ArrayList<ArrayList<TransitionXTPN>> prepareSubtractPhaseGraphics() {
            ArrayList<Arc> arcs;
            ArrayList<ArrayList<TransitionXTPN>> launchedTransitions = new ArrayList<ArrayList<TransitionXTPN>>();
            ArrayList<TransitionXTPN> launchedXTPN = new ArrayList<TransitionXTPN>();
            ArrayList<TransitionXTPN> launchedClassical = new ArrayList<TransitionXTPN>();
            for (TransitionXTPN transition : GraphicalSimulatorXTPN.this.consumingTokensTransitionsXTPN) {
                if (transition.isActiveTransitionXTPN(GraphicalSimulatorXTPN.this.sg.getCalculationsAccuracy())) {
                    transition.setLaunching(true);
                    arcs = transition.getInputArcs();
                    for (Arc arc : arcs) {
                        arc.setSimulationForwardDirection(true);
                        arc.setTransportingTokens(true);
                        PlaceXTPN place = (PlaceXTPN)arc.getStartNode();
                        if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                            arc.setTransportingTokens(false);
                            continue;
                        }
                        if (arc.getArcType() == Arc.TypeOfArc.READARC && GraphicalSimulatorXTPN.this.sg.isXTPNreadArcDontTakeTokens()) continue;
                        int weight = arc.getWeight();
                        if (transition.fpnExtension.isFunctional()) {
                            weight = FunctionsTools.getFunctionalArcWeight(transition, arc, place);
                        }
                        ArrayList<Double> removedTokens = place.removeTokensForProduction_XTPN(weight, 0, GraphicalSimulatorXTPN.this.engineXTPN.getGenerator());
                        if (arc.getArcType() != Arc.TypeOfArc.READARC) continue;
                        transition.readArcReturnVector.add(new TransitionXTPN.TokensBack(place, weight, removedTokens));
                    }
                    launchedXTPN.add(transition);
                    continue;
                }
                transition.deactivateTransitionXTPN(true);
                transition.setActivationStatusXTPN(false);
                transition.setProductionStatus_xTPN(false);
                for (Arc arc : transition.getOutputArcs()) {
                    arc.arcXTPNbox.setXTPNprodStatus(false);
                }
                GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.remove(transition);
            }
            boolean mustFireSOMETHING = false;
            int activatedXTPN = GraphicalSimulatorXTPN.this.consumingTokensTransitionsXTPN.size();
            int producedXTPN = GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.size() - 1;
            double time = GraphicalSimulatorXTPN.this.infoNode.timeToChange;
            if (activatedXTPN == 0 && producedXTPN == 0 && time == 0.0) {
                mustFireSOMETHING = true;
            }
            int fireClassSoFar = 0;
            Iterator<TransitionXTPN> iteratorTrans = GraphicalSimulatorXTPN.this.consumingTokensTransitionsClassical.iterator();
            while (iteratorTrans.hasNext()) {
                TransitionXTPN transition = iteratorTrans.next();
                if (!(mustFireSOMETHING && fireClassSoFar == 0 || GraphicalSimulatorXTPN.this.engineXTPN.getGenerator().nextInt(100) >= 50 || transition.isImmediateXTPN())) {
                    transition.deactivateTransitionXTPN(true);
                    GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.remove(transition);
                    iteratorTrans.remove();
                    continue;
                }
                if (transition.isActiveTransitionXTPN(GraphicalSimulatorXTPN.this.sg.getCalculationsAccuracy())) {
                    ++fireClassSoFar;
                    transition.setLaunching(true);
                    arcs = transition.getInputArcs();
                    for (Arc arc : arcs) {
                        arc.setSimulationForwardDirection(true);
                        arc.setTransportingTokens(true);
                        PlaceXTPN place = (PlaceXTPN)arc.getStartNode();
                        if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                            arc.setTransportingTokens(false);
                            continue;
                        }
                        int weight = arc.getWeight();
                        if (transition.fpnExtension.isFunctional()) {
                            weight = FunctionsTools.getFunctionalArcWeight(transition, arc, place);
                        }
                        place.removeTokensForProduction_XTPN(weight, 0, GraphicalSimulatorXTPN.this.engineXTPN.getGenerator());
                    }
                    launchedClassical.add(transition);
                    continue;
                }
                transition.deactivateTransitionXTPN(true);
                GraphicalSimulatorXTPN.this.producingTokensTransitionsAll.remove(transition);
            }
            launchedTransitions.add(launchedXTPN);
            launchedTransitions.add(launchedClassical);
            return launchedTransitions;
        }

        public void prepareProductionPhaseGraphics() {
            for (TransitionXTPN tran : GraphicalSimulatorXTPN.this.producingTokensTransitionsAll) {
                tran.setLaunching(true);
                ArrayList<Arc> arcs = tran.getOutputArcs();
                for (Arc arc : arcs) {
                    if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) continue;
                    arc.setSimulationForwardDirection(true);
                    arc.setTransportingTokens(true);
                    arc.arcXTPNbox.setXTPNprodStatus(true);
                }
            }
        }
    }
}

