/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.petrinet.simulators.IRandomGenerator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class StandardRandom
implements IRandomGenerator {
    private Random generator;

    public StandardRandom() {
        this.generator = new Random();
    }

    public StandardRandom(long seed) {
        this.generator = new Random(seed);
    }

    @Override
    public long nextLong() {
        return this.generator.nextLong();
    }

    @Override
    public long nextLong(long max) {
        long val;
        long bits;
        while ((bits = this.generator.nextLong() << 1 >>> 1) - (val = bits % max) + (max - 1L) < 0L) {
        }
        return val;
    }

    private int getRandomInt(int min, int max) {
        if (min == 0 && max == 0) {
            return 0;
        }
        if (min == max) {
            return min;
        }
        return this.generator.nextInt(max - min + 1) + min;
    }

    @Override
    public long nextLong(long min, long max) {
        return this.nextLong(max - min) + min;
    }

    @Override
    public int nextInt(int max) {
        return this.generator.nextInt(max);
    }

    @Override
    public double nextDouble() {
        return this.generator.nextDouble();
    }

    @Override
    public double nextDouble(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }
}

