/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class SimulatorGlobals {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private int ARC_STEP_DELAY = 25;
    private int TRANS_FIRING_DELAY = 25;
    private boolean maxMode = false;
    private boolean singleMode = false;
    private SimNetType refNetType = SimNetType.BASIC;
    private boolean emptySteps = false;
    private int simSteps = 1000;
    private int simReps = 100;
    public long currentStep = 0L;
    public double currentTime = 0.0;
    private int simulatorType = 0;
    private int generatorType = 0;
    private int SPNimmediateMode = 2;
    private boolean SPNdetRemove = true;
    private boolean ssaMassActionKineticsEnabled = true;
    public boolean quickSimToken = false;
    private double calculationsAccuracy = 1.0E-9;
    private long simSteps_XTPN = 30000L;
    private double simMaxTime_XTPN = 5000.0;
    private int simRepetitions_XTPN = 10;
    private boolean simulateTime = false;
    private boolean recordSomeSteps = false;
    private int recordedSteps = 10;
    private boolean recordStatictis = false;
    private boolean readArcXTPNactive = false;
    private boolean readArcXTPNdontTakeTokens = false;

    public void setMaxMode(boolean value) {
        this.maxMode = value;
    }

    public boolean isMaxMode() {
        return this.maxMode;
    }

    public void setEmptySteps(boolean value) {
        this.emptySteps = value;
    }

    public boolean isEmptySteps() {
        return this.emptySteps;
    }

    public void setSingleMode(boolean value) {
        this.singleMode = value;
        if (this.singleMode && overlord.getSettingsManager().getValue("simSingleMode").equals("1")) {
            this.setMaxMode(true);
        }
    }

    public boolean isSingleMode() {
        return this.singleMode;
    }

    public SimNetType getNetType() {
        return this.refNetType;
    }

    public int setNetType(int typeID) {
        int res = this.checkSimulatorNetType(typeID);
        switch (res) {
            case 0: {
                this.refNetType = SimNetType.BASIC;
                break;
            }
            case 1: {
                this.refNetType = SimNetType.TIME;
                break;
            }
            case 2: {
                this.refNetType = SimNetType.HYBRID;
            }
        }
        return res;
    }

    public int setNetType(SimNetType netType, boolean isXTPN) {
        if (isXTPN) {
            this.refNetType = netType;
            return -1;
        }
        int typeID = 0;
        if (netType == SimNetType.TIME) {
            typeID = 1;
        } else if (netType == SimNetType.HYBRID) {
            typeID = 2;
        }
        int res = this.checkSimulatorNetType(typeID);
        switch (res) {
            case 0: {
                this.refNetType = SimNetType.BASIC;
                break;
            }
            case 1: {
                this.refNetType = SimNetType.TIME;
                break;
            }
            case 2: {
                this.refNetType = SimNetType.HYBRID;
            }
        }
        return res;
    }

    public int checkSimulatorNetType(int type) {
        if (type == 0) {
            return 0;
        }
        if (type == 1) {
            ArrayList<Node> nodes = overlord.getWorkspace().getProject().getNodes();
            for (Node n : nodes) {
                if (n instanceof Place || !(n instanceof Transition) || ((Transition)n).getTransType() == Transition.TransitionType.TPN) continue;
                JOptionPane.showMessageDialog(null, lang.getText("SG_entry001"), lang.getText("SG_entry001t"), 0);
                SimulatorGlobals.overlord.getSimulatorBox().getCurrentDockWindow().simMode.setSelectedIndex(2);
                return 2;
            }
            return 1;
        }
        if (type == 2) {
            return 2;
        }
        if (type == 3) {
            return 3;
        }
        return 1;
    }

    public void setSimSteps(int value) {
        this.simSteps = value;
    }

    public int getSimSteps() {
        return this.simSteps;
    }

    public void setRepetitions(int value) {
        this.simReps = value;
    }

    public int getRepetitions() {
        return this.simReps;
    }

    public void setSimulatorType(int type) {
        this.simulatorType = type;
    }

    public int getSimulatorType() {
        return this.simulatorType;
    }

    public void setGeneratorType(int type) {
        this.generatorType = type;
    }

    public int getGeneratorType() {
        return this.generatorType;
    }

    public void setArcGraphicDelay(int value) {
        this.ARC_STEP_DELAY = value;
    }

    public int getArcGraphicDelay() {
        return this.ARC_STEP_DELAY;
    }

    public void setTransitionGraphicDelay(int value) {
        this.TRANS_FIRING_DELAY = value;
    }

    public int getTransitionGraphicDelay() {
        return this.TRANS_FIRING_DELAY;
    }

    public void reset() {
        this.ARC_STEP_DELAY = 25;
        this.TRANS_FIRING_DELAY = 25;
        this.maxMode = false;
        this.singleMode = false;
        this.refNetType = SimNetType.BASIC;
        this.emptySteps = false;
        this.simSteps = 1000;
        this.simReps = 100;
        this.currentStep = 0L;
        this.currentTime = 0.0;
    }

    public int getSPNimmediateMode() {
        return this.SPNimmediateMode;
    }

    public void setSPNimmediateMode(int type) {
        if (type < 0 || type > 2) {
            type = 2;
        }
        this.SPNimmediateMode = type;
    }

    public boolean isSPNdetRemoveMode() {
        return this.SPNdetRemove;
    }

    public void setSPNdetRemoveMode(boolean mode) {
        this.SPNdetRemove = mode;
    }

    public void setSSAmassAction(boolean value) {
        this.ssaMassActionKineticsEnabled = value;
    }

    public boolean isSSAMassAction() {
        return this.ssaMassActionKineticsEnabled;
    }

    public double getCalculationsAccuracy() {
        return this.calculationsAccuracy;
    }

    public void setCalculationsAccuracy(double calculationsAccuracy) {
        this.calculationsAccuracy = calculationsAccuracy;
    }

    public void setTimeSimulationStatus_XTPN(boolean value) {
        this.simulateTime = value;
    }

    public boolean isTimeSimulation_XTPN() {
        return this.simulateTime;
    }

    public void setSimSteps_XTPN(long value) {
        this.simSteps_XTPN = value;
    }

    public long getSimSteps_XTPN() {
        return this.simSteps_XTPN;
    }

    public void setSimTime_XTPN(double value) {
        this.simMaxTime_XTPN = value;
    }

    public double getSimTime_XTPN() {
        return this.simMaxTime_XTPN;
    }

    public void setSimRepetitions_XTPN(int value) {
        this.simRepetitions_XTPN = value;
    }

    public int getSimRepetitions_XTPN() {
        return this.simRepetitions_XTPN;
    }

    public void setPartialRecordingStetsStatus(boolean value) {
        this.recordSomeSteps = value;
    }

    public boolean isPartialRecordingSteps() {
        return this.recordSomeSteps;
    }

    public void setRecordedSteps(int value) {
        this.recordedSteps = value;
    }

    public int getRecordedSteps() {
        return this.recordedSteps;
    }

    public void setStatsRecordingStatus(boolean value) {
        this.recordStatictis = value;
    }

    public boolean isStatsRecorded() {
        return this.recordStatictis;
    }

    public void setXTPNreadArcPreserveTokensLifetime(boolean value) {
        this.readArcXTPNactive = value;
    }

    public boolean isXTPNreadArcPreserveTokensLifetime() {
        return this.readArcXTPNactive;
    }

    public void setXTPNreadArcDontTakeTokens(boolean value) {
        this.readArcXTPNdontTakeTokens = value;
    }

    public boolean isXTPNreadArcDontTakeTokens() {
        return this.readArcXTPNdontTakeTokens;
    }

    public static enum SimNetType {
        BASIC,
        TIME,
        HYBRID,
        COLOR,
        XTPN,
        XTPNfunc,
        XTPNext,
        XTPNext_func;

    }
}

