/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.analyse.InvariantsCalculator;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.SPNdataVector;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.petrinet.simulators.HighQualityRandom;
import holmes.petrinet.simulators.IEngine;
import holmes.petrinet.simulators.IRandomGenerator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StandardRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SPNengine
implements IEngine {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private Map<Place, ArrayList<Transition>> involvedTransitionsMap;
    private Map<Transition, ArrayList<Place>> involvedPlacesMap;
    private Map<Transition, ArrayList<Place>> prePlacesMap;
    private Transition lastFired;
    private IRandomGenerator generator;
    private ArrayList<Transition> transitions;
    private ArrayList<Transition> launchableTransitions;
    private ArrayList<Transition> transitionSTtypeUpdateList;
    private ArrayList<Transition> activeReadyToFireTransitions;
    private ArrayList<Transition> immTransitions;
    private ArrayList<Transition> immFireListTransitionsOPTION;
    private ArrayList<Transition> detTransitions;
    private ArrayList<Transition> detTransitionsSequence;
    private ArrayList<Transition> detPrioritySequence;
    private ArrayList<Transition> schTransitions;
    private ArrayList<Transition> stochasticTransitions;
    private SimulatorGlobals settings;
    private int settingImmediateMode = 2;
    private boolean settingDetRemoval;
    private HashMap<Place, Integer> placesMap;
    private HashMap<Transition, Integer> transitionsMap;
    private ArrayList<ArrayList<Integer>> tpIncidenceMatrix;

    @Override
    public void setEngine(SimulatorGlobals.SimNetType simulationType, boolean maxMode, boolean singleMode, ArrayList<Transition> transitions, ArrayList<Transition> time_transitions, ArrayList<Place> places) {
        int i;
        this.lastFired = null;
        this.launchableTransitions = new ArrayList();
        this.transitionSTtypeUpdateList = new ArrayList();
        this.involvedPlacesMap = new HashMap<Transition, ArrayList<Place>>();
        this.involvedTransitionsMap = new HashMap<Place, ArrayList<Transition>>();
        this.prePlacesMap = new HashMap<Transition, ArrayList<Place>>();
        this.settings = SPNengine.overlord.simSettings;
        this.placesMap = new HashMap();
        this.transitionsMap = new HashMap();
        this.activeReadyToFireTransitions = new ArrayList();
        this.immTransitions = new ArrayList();
        this.immFireListTransitionsOPTION = new ArrayList();
        this.detTransitions = new ArrayList();
        this.detTransitionsSequence = new ArrayList();
        this.detPrioritySequence = new ArrayList();
        this.schTransitions = new ArrayList();
        this.stochasticTransitions = new ArrayList();
        this.transitions = transitions;
        this.generator = SPNengine.overlord.simSettings.getGeneratorType() == 1 ? new HighQualityRandom(System.currentTimeMillis()) : new StandardRandom(System.currentTimeMillis());
        this.transitionSTtypeUpdateList.addAll(transitions);
        this.prepareTransitionsSystem();
        for (Transition transition : transitions) {
            ArrayList<Place> placesVector = new ArrayList<Place>();
            for (Node node : transition.getInputNodes()) {
                placesVector.add((Place)node);
            }
            ArrayList prePlacesVector = new ArrayList(placesVector);
            this.prePlacesMap.put(transition, prePlacesVector);
            for (Node node3 : transition.getOutputNodes()) {
                if (placesVector.contains((Place)node3)) continue;
                placesVector.add((Place)node3);
            }
            this.involvedPlacesMap.put(transition, placesVector);
        }
        for (Place place : places) {
            ArrayList<Transition> transitionsVector = new ArrayList<Transition>();
            for (Node node : place.getOutputNodes()) {
                if (transitionsVector.contains((Transition)node)) continue;
                transitionsVector.add((Transition)node);
            }
            this.involvedTransitionsMap.put(place, transitionsVector);
        }
        for (i = 0; i < places.size(); ++i) {
            this.placesMap.put(places.get(i), i);
        }
        for (i = 0; i < transitions.size(); ++i) {
            this.transitionsMap.put(transitions.get(i), i);
        }
        InvariantsCalculator ic = new InvariantsCalculator(true);
        this.tpIncidenceMatrix = ic.getCMatrix();
        for (int t = 0; t < transitions.size(); ++t) {
            for (int p = 0; p < places.size(); ++p) {
                int value = this.tpIncidenceMatrix.get(t).get(p);
                value = value < 0 ? -value : value;
                this.tpIncidenceMatrix.get(t).set(p, value);
            }
        }
        this.settingImmediateMode = this.settings.getSPNimmediateMode();
        this.settingDetRemoval = this.settings.isSPNdetRemoveMode();
    }

    private void prepareTransitionsSystem() {
        SPNdataVector SPNvector = overlord.getWorkspace().getProject().accessFiringRatesManager().getCurrentSPNdataVector();
        for (int t = 0; t < this.transitions.size(); ++t) {
            Transition transition = this.transitions.get(t);
            transition.spnExtension.setFiringRate(SPNvector.getFiringRate(t));
            transition.spnExtension.setSPNbox(SPNvector.getSPNtransitionContainer(t));
            transition.spnExtension.setSPNtype(SPNvector.getStochasticType(t));
            if (transition.spnExtension.getSPNtype() == TransitionSPNExtension.StochaticsType.IM) {
                this.immTransitions.add(transition);
                continue;
            }
            if (transition.spnExtension.getSPNtype() == TransitionSPNExtension.StochaticsType.DT) {
                this.detTransitions.add(transition);
                continue;
            }
            if (transition.spnExtension.getSPNtype() == TransitionSPNExtension.StochaticsType.SchT) {
                this.schTransitions.add(transition);
                continue;
            }
            this.stochasticTransitions.add(transition);
        }
        int imSize = this.immTransitions.size();
        if (imSize > 1) {
            for (int t = 0; t < imSize; ++t) {
                Transition trans1 = this.immTransitions.get(t);
                int swapT2 = t;
                for (int t2 = t + 1; t2 < imSize; ++t2) {
                    if (this.immTransitions.get((int)t2).spnExtension.getSPNbox().IM_priority <= trans1.spnExtension.getSPNbox().IM_priority) continue;
                    trans1 = this.immTransitions.get(t2);
                    swapT2 = t2;
                }
                if (swapT2 == t) continue;
                Collections.swap(this.immTransitions, swapT2, t);
            }
        }
    }

    @Override
    public ArrayList<Transition> getTransLaunchList(boolean emptySteps) {
        Transition immFired;
        if (!this.settingDetRemoval) {
            for (Transition trans : this.detPrioritySequence) {
                if (!trans.isActive()) continue;
                this.detPrioritySequence.remove(trans);
                this.lastFired = trans;
                this.updateSTtransitionsList(this.lastFired);
                this.launchableTransitions.clear();
                this.launchableTransitions.add(this.lastFired);
                return this.launchableTransitions;
            }
        }
        if ((immFired = this.immediateFireSubsystem()) != null) {
            this.lastFired = immFired;
            this.updateSTtransitionsList(this.lastFired);
            this.launchableTransitions.clear();
            this.launchableTransitions.add(this.lastFired);
            return this.launchableTransitions;
        }
        Transition detFired = this.deterministicDelayFireSubsystem();
        if (detFired != null) {
            this.lastFired = detFired;
            this.updateSTtransitionsList(this.lastFired);
            this.launchableTransitions.clear();
            this.launchableTransitions.add(this.lastFired);
            return this.launchableTransitions;
        }
        this.activeReadyToFireTransitions.clear();
        for (Transition trans : this.stochasticTransitions) {
            if (!trans.isActive()) continue;
            if (this.transitionSTtypeUpdateList.contains(trans)) {
                this.setProbFunction(trans);
                this.transitionSTtypeUpdateList.remove(trans);
            }
            this.activeReadyToFireTransitions.add(trans);
        }
        if (!this.activeReadyToFireTransitions.isEmpty()) {
            double compProbValue = this.activeReadyToFireTransitions.get((int)0).spnExtension.getSPNprobTime();
            ArrayList<Transition> toFire = new ArrayList<Transition>();
            for (Transition trans : this.activeReadyToFireTransitions) {
                double nextProbValue = trans.spnExtension.getSPNprobTime();
                if (compProbValue == nextProbValue) {
                    toFire.add(trans);
                    continue;
                }
                if (!(nextProbValue < compProbValue)) continue;
                toFire.clear();
                toFire.add(trans);
                compProbValue = nextProbValue;
            }
            int selected = this.generator.nextInt(toFire.size());
            this.lastFired = (Transition)toFire.get(selected);
            this.updateSTtransitionsList(this.lastFired);
            this.launchableTransitions.clear();
            this.launchableTransitions.add(this.lastFired);
            return this.launchableTransitions;
        }
        return null;
    }

    private Transition immediateFireSubsystem() {
        if (this.immTransitions.isEmpty()) {
            return null;
        }
        if (this.settingImmediateMode == 0) {
            this.shuffleSamePriority();
            for (Transition trans : this.immTransitions) {
                if (!trans.isActive()) continue;
                return trans;
            }
            return null;
        }
        if (this.settingImmediateMode == 1) {
            if (!this.immFireListTransitionsOPTION.isEmpty()) {
                Transition youAreFired = this.immFireListTransitionsOPTION.get(0);
                this.immFireListTransitionsOPTION.remove(0);
                return youAreFired;
            }
            this.shuffleSamePriority();
            for (Transition trans : this.immTransitions) {
                if (!trans.isActive()) continue;
                trans.bookRequiredTokens();
                this.immFireListTransitionsOPTION.add(trans);
            }
            for (Transition trans : this.immFireListTransitionsOPTION) {
                trans.returnBookedTokens();
            }
            if (!this.immFireListTransitionsOPTION.isEmpty()) {
                Transition youAreFired = this.immFireListTransitionsOPTION.get(0);
                this.immFireListTransitionsOPTION.remove(0);
                return youAreFired;
            }
            return null;
        }
        ArrayList<Transition> roulette = new ArrayList<Transition>();
        int prioritySum = 0;
        for (Transition trans : this.immTransitions) {
            if (!trans.isActive()) continue;
            trans.bookRequiredTokens();
            roulette.add(trans);
            prioritySum += trans.spnExtension.getSPNbox().IM_priority;
        }
        if (roulette.isEmpty()) {
            return null;
        }
        for (Transition trans : roulette) {
            trans.returnBookedTokens();
        }
        if (prioritySum == 0) {
            return (Transition)roulette.get(0);
        }
        int ball = (int)this.generator.nextLong(prioritySum);
        int cumulativeProbability = 0;
        for (Transition trans : roulette) {
            if (ball >= (cumulativeProbability += trans.spnExtension.getSPNbox().IM_priority)) continue;
            return trans;
        }
        return null;
    }

    private void shuffleSamePriority() {
        int size = this.immTransitions.size();
        for (int i = 0; i < size; ++i) {
            int rangeJ = i;
            for (int j = i + 1; j < size; ++j) {
                if (this.immTransitions.get((int)i).spnExtension.getSPNbox().IM_priority != this.immTransitions.get((int)j).spnExtension.getSPNbox().IM_priority) continue;
                ++rangeJ;
            }
            if (rangeJ == i) continue;
            int diff = rangeJ - i;
            for (int k = i; k < rangeJ; ++k) {
                int r = this.generator.nextInt(diff + 1);
                Collections.swap(this.immTransitions, k, i + r);
            }
        }
    }

    private Transition deterministicDelayFireSubsystem() {
        if (!this.detTransitionsSequence.isEmpty()) {
            for (Transition trans : this.detTransitionsSequence) {
                --trans.spnExtension.getSPNbox().tmp_DET_counter;
                if (trans.spnExtension.getSPNbox().tmp_DET_counter != 0) continue;
                if (trans.isActive()) {
                    this.detTransitionsSequence.remove(trans);
                    return trans;
                }
                this.detTransitionsSequence.remove(trans);
                if (this.settingDetRemoval) continue;
                this.detPrioritySequence.add(trans);
            }
        }
        for (Transition trans : this.detTransitions) {
            if (this.detTransitionsSequence.contains(trans) || !trans.isActive()) continue;
            trans.bookRequiredTokens();
            int detSize = this.detTransitionsSequence.size();
            if (detSize > 0) {
                this.detTransitionsSequence.add(this.generator.nextInt(detSize), trans);
            } else {
                this.detTransitionsSequence.add(trans);
            }
            trans.spnExtension.getSPNbox().tmp_DET_counter = trans.spnExtension.getSPNbox().DET_delay;
        }
        for (Transition trans : this.detTransitionsSequence) {
            trans.returnBookedTokens();
        }
        return null;
    }

    private void updateSTtransitionsList(Transition lastFiredTransition) {
        if (lastFiredTransition.spnExtension.getSPNtype() == TransitionSPNExtension.StochaticsType.ST) {
            this.transitionSTtypeUpdateList.add(lastFiredTransition);
        }
        ArrayList<Place> changedPlaces = this.involvedPlacesMap.get(lastFiredTransition);
        for (Place place : changedPlaces) {
            for (Transition trans : this.involvedTransitionsMap.get(place)) {
                if (this.transitionSTtypeUpdateList.contains(trans) || trans.spnExtension.getSPNtype() != TransitionSPNExtension.StochaticsType.ST) continue;
                this.transitionSTtypeUpdateList.add(trans);
            }
        }
        for (Transition t : this.transitions) {
            if (t.getOutputArcs().isEmpty() && !this.transitionSTtypeUpdateList.contains(t) && t.spnExtension.getSPNtype() == TransitionSPNExtension.StochaticsType.ST) {
                this.transitionSTtypeUpdateList.add(t);
            }
            if (!t.getInputArcs().isEmpty() || this.transitionSTtypeUpdateList.contains(t) || t.spnExtension.getSPNtype() != TransitionSPNExtension.StochaticsType.ST) continue;
            this.transitionSTtypeUpdateList.add(t);
        }
    }

    private void setProbFunction(Transition transition) {
        double denominator;
        ArrayList<Place> prePlaces;
        long massActionKineticModifier = 1L;
        if (this.settings.isSSAMassAction() && !(prePlaces = this.prePlacesMap.get(transition)).isEmpty()) {
            massActionKineticModifier = Long.MAX_VALUE;
            for (Place prePlace : prePlaces) {
                int placeLoc = this.placesMap.get(prePlace);
                int transLoc = this.transitionsMap.get(transition);
                int weight = this.tpIncidenceMatrix.get(transLoc).get(placeLoc);
                if (weight == 0) {
                    weight = prePlace.getTokensNumber();
                }
                long firingNumber = prePlace.getTokensNumber() / weight;
                massActionKineticModifier = Math.min(massActionKineticModifier, firingNumber);
            }
        }
        if ((denominator = (double)massActionKineticModifier * transition.spnExtension.getFiringRate()) == 0.0) {
            denominator = 1.0E-23;
        }
        double probTime = -(Math.log(1.0 - this.generator.nextDouble()) / denominator);
        transition.spnExtension.setSPNprobTime(probTime);
    }

    @Override
    public void setNetSimType(SimulatorGlobals.SimNetType simulationType) {
    }

    @Override
    public void setMaxMode(boolean value) {
    }

    @Override
    public void setSingleMode(boolean value) {
    }

    @Override
    public IRandomGenerator getGenerator() {
        return this.generator;
    }
}

