/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StateSimulator;
import holmes.petrinet.simulators.xtpn.StateSimDataContainer;
import holmes.petrinet.simulators.xtpn.StateSimulatorXTPN;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class QuickSimTools {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private StateSimulator stateSimulatorPN;
    private StateSimulatorXTPN stateSimulatorXTPN;
    private boolean scanTransitions = true;
    private boolean scanPlaces = true;
    private boolean markArcs = true;
    private HolmesRoundedButton startSimButton = null;

    public QuickSimTools(HolmesDockWindowsTable holmesDockWindowsTable) {
    }

    public void acquireData(boolean scanTransitions, boolean scanPlaces, boolean markArcs, boolean repetitions, JProgressBar quickProgressBar) {
        if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, lang.getText("QST_entry001"), lang.getText("QST_entry001t"), 0);
        } else {
            this.scanTransitions = scanTransitions;
            this.scanPlaces = scanPlaces;
            this.markArcs = markArcs;
            if (repetitions) {
                this.statsData(quickProgressBar);
            } else {
                this.vectorData(quickProgressBar);
            }
        }
    }

    public void acquireDataXTPN(boolean bySteps, int steps, double time, boolean repeate, int repetitions, boolean knockout, JProgressBar quickProgressBar, HolmesRoundedButton button) {
        if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, lang.getText("QST_entry002"), lang.getText("QST_entry002t"), 0);
            return;
        }
        this.startSimButton = button;
        boolean isKnockout = false;
        if (knockout) {
            if (repeate) {
                for (Transition trans : overlord.getWorkspace().getProject().getTransitions()) {
                    if (!trans.isKnockedOut()) continue;
                    isKnockout = true;
                    break;
                }
                if (!isKnockout) {
                    JOptionPane.showMessageDialog(null, lang.getText("QST_entry003"), lang.getText("QST_entry003t"), 1);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(null, lang.getText("QST_entry004"), lang.getText("QST_entry004t"), 1);
                return;
            }
        }
        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
            this.stateSimulatorXTPN = new StateSimulatorXTPN();
            this.stateSimulatorXTPN.initiateSim(QuickSimTools.overlord.simSettings);
            QuickSimTools.overlord.simSettings.setNetType(SimulatorGlobals.SimNetType.XTPN, true);
            QuickSimTools.overlord.simSettings.setSimSteps_XTPN(steps);
            QuickSimTools.overlord.simSettings.setSimTime_XTPN(time);
            QuickSimTools.overlord.simSettings.setTimeSimulationStatus_XTPN(!bySteps);
            QuickSimTools.overlord.simSettings.setSimRepetitions_XTPN(repetitions);
            this.startSimButton.setEnabled(false);
            overlord.getWorkspace().getProject().setSimulationActive(true);
            if (repeate) {
                if (knockout) {
                    this.stateSimulatorXTPN.setThreadDetails(3, this, QuickSimTools.overlord.simSettings, quickProgressBar, button);
                } else {
                    this.stateSimulatorXTPN.setThreadDetails(2, this, QuickSimTools.overlord.simSettings, quickProgressBar, button);
                }
            } else {
                this.stateSimulatorXTPN.setThreadDetails(1, this, QuickSimTools.overlord.simSettings, quickProgressBar, button);
            }
            Thread myThread = new Thread(this.stateSimulatorXTPN);
            myThread.start();
        }
    }

    private void statsData(JProgressBar quickProgressBar) {
        this.stateSimulatorPN = new StateSimulator();
        this.stateSimulatorPN.initiateSim(true, null);
        this.stateSimulatorPN.setThreadDetails(5, quickProgressBar, this);
        Thread myThread = new Thread(this.stateSimulatorPN);
        myThread.start();
    }

    private void vectorData(JProgressBar quickProgressBar) {
        this.stateSimulatorPN = new StateSimulator();
        this.stateSimulatorPN.initiateSim(true, null);
        this.stateSimulatorPN.setThreadDetails(6, quickProgressBar, this);
        Thread myThread = new Thread(this.stateSimulatorPN);
        myThread.start();
    }

    public void finishedStatsData(ArrayList<ArrayList<Double>> quickSimAllStats, ArrayList<Transition> transitions, ArrayList<Place> places) {
        int p;
        int t;
        ArrayList<Double> avgFire = quickSimAllStats.get(0);
        ArrayList<Double> avgTokens = quickSimAllStats.get(2);
        QuickSimTools.overlord.simSettings.quickSimToken = true;
        int transSize = transitions.size();
        int placesSize = places.size();
        double max = 0.0;
        for (t = 0; t < transSize; ++t) {
            if (!(avgFire.get(t) > max)) continue;
            max = avgFire.get(t);
        }
        if (QuickSimTools.overlord.simSettings.isMaxMode()) {
            max = 1.0;
        }
        for (t = 0; t < transSize; ++t) {
            Transition trans = transitions.get(t);
            double firing = avgFire.get(t);
            String tmp = Tools.cutValueExt(firing, 6);
            trans.qSimBoxT.qSimFired = firing = Double.parseDouble(tmp);
            trans.drawGraphBoxT.setAddText(Tools.cutValueExt(firing, 8));
            double reliance = firing / max;
            trans.qSimBoxT.qSimFillValue = (int)(30.0 * reliance);
            if (firing < 0.05) {
                trans.qSimBoxT.qSimFillColor = Color.RED;
                trans.qSimBoxT.qSimFillValue = 5;
            } else {
                trans.qSimBoxT.qSimFillColor = firing < 0.15 ? Color.ORANGE : Color.GREEN;
            }
            if (this.scanTransitions) {
                for (ElementLocation el : trans.getElementLocations()) {
                    el.qSimDrawed = true;
                }
                trans.qSimBoxT.qSimDrawed = true;
                trans.qSimBoxT.qSimDrawStats = true;
                if (firing < 0.01) {
                    trans.qSimArcSign = true;
                    trans.qSimBoxT.qSimOvalColor = Color.RED;
                    continue;
                }
                trans.qSimArcSign = false;
                continue;
            }
            trans.qSimBoxT.qSimDrawed = false;
            trans.qSimBoxT.qSimDrawStats = false;
            trans.qSimArcSign = false;
        }
        double maxT = 0.0;
        for (p = 0; p < placesSize; ++p) {
            if (!(avgTokens.get(p) > maxT)) continue;
            maxT = avgTokens.get(p);
        }
        for (p = 0; p < placesSize; ++p) {
            double avgT;
            Place place = places.get(p);
            place.qSimBoxP.qSimTokens = avgT = avgTokens.get(p).doubleValue();
            if (avgT == 0.0) {
                place.qSimBoxP.qSimFillColor = Color.BLACK;
                place.qSimBoxP.qSimOvalColor = Color.RED;
            } else if (avgT < 1.0) {
                place.qSimBoxP.qSimFillColor = Color.RED;
                place.qSimBoxP.qSimFillValue = 4;
            } else if (avgT < 5.0) {
                place.qSimBoxP.qSimFillColor = Color.ORANGE;
                place.qSimBoxP.qSimFillValue = 8;
            } else {
                double reliance = avgT / maxT;
                int fill = (int)(30.0 * reliance);
                if (fill < 8) {
                    fill = 8;
                }
                place.qSimBoxP.qSimFillValue = fill;
                place.qSimBoxP.qSimFillColor = Color.GREEN;
            }
            if (this.scanPlaces) {
                place.qSimBoxP.qSimDrawed = true;
                place.qSimBoxP.qSimDrawStats = true;
                for (ElementLocation el : place.getElementLocations()) {
                    el.qSimDrawed = true;
                }
                place.qSimArcSign = avgT == 0.0;
                continue;
            }
            place.qSimBoxP.qSimDrawed = false;
            place.qSimBoxP.qSimDrawStats = false;
            place.qSimArcSign = false;
        }
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        for (Arc arc : arcs) {
            if (arc.getStartNode().qSimArcSign && arc.getEndNode().qSimArcSign) {
                arc.arcQSimBox.qSimForcedArc = true;
                arc.arcQSimBox.qSimForcedColor = Color.RED;
            } else {
                arc.arcQSimBox.qSimForcedArc = false;
                arc.arcQSimBox.qSimForcedColor = Color.BLACK;
            }
            if (this.markArcs) continue;
            arc.arcQSimBox.qSimForcedArc = false;
            arc.arcQSimBox.qSimForcedColor = Color.BLACK;
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void finishedStatsDataXTPN(StateSimDataContainer result, ArrayList<TransitionXTPN> transitions, ArrayList<PlaceXTPN> places) {
        String s;
        long minutes;
        String m;
        HolmesNotepad note = new HolmesNotepad(800, 600);
        note.addTextLineNL(lang.getText("QST_entry005"), "text");
        note.addTextLineNL(lang.getText("QST_entry006") + "  " + Tools.cutValue(result.simSteps), "text");
        note.addTextLineNL(lang.getText("QST_entry007") + "   " + Tools.cutValue(result.simTime), "text");
        note.addTextLineNL(lang.getText("QST_entry008") + " " + (int)result.simReps, "text");
        long milisecond = result.compTime;
        long seconds = milisecond /= 1000L;
        long hours = seconds / 3600L;
        String h = "" + hours;
        if (h.length() == 1) {
            h = "0" + h;
        }
        if ((m = "" + (minutes = (seconds -= hours * 3600L) / 60L)).length() == 1) {
            m = "0" + m;
        }
        if ((s = "" + (seconds -= minutes * 60L)).length() == 1) {
            s = "0" + s;
        }
        note.addTextLine(lang.getText("QST_entry009") + " ", "text");
        note.addTextLineNL(h + ":" + m + ":" + s, "text");
        int transIndex = 0;
        double simSteps = result.simSteps;
        double simTime = result.simTime;
        note.addTextLineNL("", "bold");
        note.addTextLineNL(lang.getText("QST_entry010"), "bold");
        for (TransitionXTPN trans : transitions) {
            double tmpSteps = result.transitionsStatistics.get(transIndex).get(0);
            double tmpTime = result.transitionsStatistics.get(transIndex).get(4);
            note.addTextLine(lang.getText("QST_entry011") + " ", "text");
            note.addTextLine("" + transIndex, "bold");
            note.addTextLine(" (" + trans.getName() + ")", "bold");
            note.addTextLine(" " + lang.getText("QST_entry012") + " ", "text");
            note.addTextLineNL(this.getTransType(trans), "bold");
            String strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry013"), (int)tmpSteps, Tools.cutValue(tmpSteps * 100.0 / simSteps), Tools.cutValue(tmpTime), Tools.cutValue(tmpTime * 100.0 / simTime));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry013", "error", true);
            }
            note.addTextLineNL(strB, "text");
            tmpSteps = result.transitionsStatistics.get(transIndex).get(1);
            tmpTime = result.transitionsStatistics.get(transIndex).get(5);
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry014"), (int)tmpSteps, Tools.cutValue(tmpSteps * 100.0 / simSteps), Tools.cutValue(tmpTime), Tools.cutValue(tmpTime * 100.0 / simTime));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry014", "error", true);
            }
            note.addTextLineNL(strB, "text");
            tmpSteps = result.transitionsStatistics.get(transIndex).get(2);
            tmpTime = result.transitionsStatistics.get(transIndex).get(6);
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry015"), (int)tmpSteps, Tools.cutValue(tmpSteps * 100.0 / simSteps), Tools.cutValue(tmpTime), Tools.cutValue(tmpTime * 100.0 / simTime));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry015", "error", true);
            }
            note.addTextLineNL(strB, "text");
            tmpSteps = result.transitionsStatistics.get(transIndex).get(3);
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry016"), (int)tmpSteps);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry016", "error", true);
            }
            note.addTextLineNL(strB, "text");
            note.addTextLineNL("", "text");
            ++transIndex;
        }
        note.addTextLineNL("", "bold");
        note.addTextLineNL(lang.getText("QST_entry017"), "bold");
        int placeIndex = 0;
        for (PlaceXTPN place : places) {
            note.addTextLine(lang.getText("QST_entry018") + " ", "text");
            note.addTextLine("" + placeIndex, "bold");
            note.addTextLine(" (" + place.getName() + ")", "bold");
            note.addTextLine(lang.getText("QST_entry019") + " ", "text");
            note.addTextLineNL(this.getPlaceType(place), "bold");
            double avgTokens = result.avgTokens.get(placeIndex);
            note.addTextLineNL(lang.getText("QST_entry020") + " " + Tools.cutValue(avgTokens), "text");
            ++placeIndex;
        }
        note.setCaretFirstLine();
        note.setVisible(true);
        this.startSimButton.setEnabled(true);
        overlord.getWorkspace().getProject().setSimulationActive(false);
    }

    public void finishedStatsDataXTPN_Knockout(ArrayList<StateSimDataContainer> result, ArrayList<TransitionXTPN> transitions, ArrayList<PlaceXTPN> places) {
        HolmesNotepad note = new HolmesNotepad(800, 600);
        note.addTextLineNL(lang.getText("QST_entry021"), "text");
        note.addTextLineNL(lang.getText("QST_entry022") + " " + (int)result.get((int)0).simReps, "text");
        note.addTextLineNL(lang.getText("QST_entry023"), "bold");
        note.addTextLine(lang.getText("QST_entry024") + "  ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)0).simSteps), "bold");
        note.addTextLine(lang.getText("QST_entry025") + "   ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)0).simTime), "bold");
        note.addTextLine(lang.getText("QST_entry026") + "        ", "text");
        note.addTextLineNL(Tools.getTime(result.get((int)0).compTime), "text");
        note.addTextLineNL(lang.getText("QST_entry027"), "bold");
        note.addTextLine(lang.getText("QST_entry028") + "  ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)1).simSteps), "bold");
        note.addTextLine(lang.getText("QST_entry029") + "   ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)1).simTime), "bold");
        note.addTextLine(lang.getText("QST_entry030") + "        ", "text");
        note.addTextLineNL(Tools.getTime(result.get((int)1).compTime), "text");
        int transIndex = 0;
        double simStepsRef = result.get((int)0).simSteps;
        double simTimeRef = result.get((int)0).simTime;
        double simStepsKnock = result.get((int)1).simSteps;
        double simTimeKnock = result.get((int)1).simTime;
        note.addTextLineNL("", "bold");
        note.addTextLineNL(lang.getText("QST_entry031"), "bold");
        for (TransitionXTPN trans : transitions) {
            double tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(0);
            double tmpTimeRef = result.get((int)0).transitionsStatistics.get(transIndex).get(4);
            double tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(0);
            double tmpTimeKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(4);
            double tmpStepsPercentRef = tmpStepsRef * 100.0 / simStepsRef;
            double tmpTimePercentRef = tmpTimeRef * 100.0 / simTimeRef;
            double tmpStepsPercentKnock = tmpStepsKnock * 100.0 / simStepsKnock;
            double tmpTimePercentKnock = tmpTimeKnock * 100.0 / simTimeKnock;
            note.addTextLine(lang.getText("QST_entry032") + " ", "text");
            note.addTextLine("" + transIndex, "bold");
            note.addTextLine(" (" + trans.getName() + ")", "bold");
            note.addTextLine(lang.getText("QST_entry033") + " ", "text");
            note.addTextLineNL(this.getTransType(trans), "bold");
            String strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry034"), (int)tmpStepsRef, Tools.cutValue(tmpStepsPercentRef), Tools.cutValue(tmpTimeRef), Tools.cutValue(tmpTimePercentRef));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry034", "error", true);
            }
            note.addTextLineNL(strB, "text");
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry035"), (int)tmpStepsKnock, Tools.cutValue(tmpStepsPercentKnock), Tools.cutValue(tmpTimeKnock), Tools.cutValue(tmpTimePercentKnock));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry035", "error", true);
            }
            note.addTextLineNL(strB, "text");
            double diffSteps = tmpStepsRef - tmpStepsKnock;
            String signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            double diffTime = tmpTimeRef - tmpTimeKnock;
            String signT = "+";
            if (diffTime > 0.0) {
                signT = "-";
            }
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry036"), signS, (int)Math.abs(tmpStepsRef - tmpStepsKnock), signS, Tools.cutValue(Math.abs(tmpStepsPercentRef - tmpStepsPercentKnock)), signT, Tools.cutValue(Math.abs(tmpTimeRef - tmpTimeKnock)), signT, Tools.cutValue(Math.abs(tmpTimePercentRef - tmpTimePercentKnock)));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry036", "error", true);
            }
            String textDeltaInactive = strB;
            tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(1);
            tmpTimeRef = result.get((int)0).transitionsStatistics.get(transIndex).get(5);
            tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(1);
            tmpTimeKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(5);
            tmpStepsPercentRef = tmpStepsRef * 100.0 / simStepsRef;
            tmpTimePercentRef = tmpTimeRef * 100.0 / simTimeRef;
            tmpStepsPercentKnock = tmpStepsKnock * 100.0 / simStepsKnock;
            tmpTimePercentKnock = tmpTimeKnock * 100.0 / simTimeKnock;
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry037"), (int)tmpStepsRef, Tools.cutValue(tmpStepsPercentRef), Tools.cutValue(tmpTimeRef), Tools.cutValue(tmpTimePercentRef));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry037", "error", true);
            }
            note.addTextLineNL(strB, "text");
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry038"), (int)tmpStepsKnock, Tools.cutValue(tmpStepsPercentKnock), Tools.cutValue(tmpTimeKnock), Tools.cutValue(tmpTimePercentKnock));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry038", "error", true);
            }
            note.addTextLineNL(strB, "text");
            diffSteps = tmpStepsRef - tmpStepsKnock;
            signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            diffTime = tmpTimeRef - tmpTimeKnock;
            signT = "+";
            if (diffTime > 0.0) {
                signT = "-";
            }
            strB = "err.";
            try {
                strB = String.format("   \u0394Act.  :  %s%d (%s%s%%) | \u0394\u03c4: %s%s (%s%s%%)", signS, (int)Math.abs(tmpStepsRef - tmpStepsKnock), signS, Tools.cutValue(Math.abs(tmpStepsPercentRef - tmpStepsPercentKnock)), signT, Tools.cutValue(Math.abs(tmpTimeRef - tmpTimeKnock)), signT, Tools.cutValue(Math.abs(tmpTimePercentRef - tmpTimePercentKnock)));
            }
            catch (Exception e) {
                overlord.log(lang.getText("in-code") + " incode", "error", true);
            }
            String textDeltaActive = strB;
            tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(2);
            tmpTimeRef = result.get((int)0).transitionsStatistics.get(transIndex).get(6);
            tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(2);
            tmpTimeKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(6);
            tmpStepsPercentRef = tmpStepsRef * 100.0 / simStepsRef;
            tmpTimePercentRef = tmpTimeRef * 100.0 / simTimeRef;
            tmpStepsPercentKnock = tmpStepsKnock * 100.0 / simStepsKnock;
            tmpTimePercentKnock = tmpTimeKnock * 100.0 / simTimeKnock;
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry040"), (int)tmpStepsRef, Tools.cutValue(tmpStepsPercentRef), Tools.cutValue(tmpTimeRef), Tools.cutValue(tmpTimePercentRef));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry040", "error", true);
            }
            note.addTextLineNL(strB, "text");
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry041"), (int)tmpStepsKnock, Tools.cutValue(tmpStepsPercentKnock), Tools.cutValue(tmpTimeKnock), Tools.cutValue(tmpTimePercentKnock));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry041", "error", true);
            }
            note.addTextLineNL(strB, "text");
            diffSteps = tmpStepsRef - tmpStepsKnock;
            signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            diffTime = tmpTimeRef - tmpTimeKnock;
            signT = "+";
            if (diffTime > 0.0) {
                signT = "-";
            }
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry042"), signS, (int)Math.abs(tmpStepsRef - tmpStepsKnock), signS, Tools.cutValue(Math.abs(tmpStepsPercentRef - tmpStepsPercentKnock)), signT, Tools.cutValue(Math.abs(tmpTimeRef - tmpTimeKnock)), signT, Tools.cutValue(Math.abs(tmpTimePercentRef - tmpTimePercentKnock)));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry042", "error", true);
            }
            String textDeltaProduction = strB;
            tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(3);
            tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(3);
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry043"), (int)tmpStepsRef, (int)tmpStepsKnock);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry043", "error", true);
            }
            note.addTextLineNL(strB, "text");
            diffSteps = tmpStepsRef - tmpStepsKnock;
            signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            strB = "err.";
            try {
                strB = String.format(lang.getText("QST_entry044"), signS, (int)Math.abs(tmpStepsRef - tmpStepsKnock));
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " QST_entry044", "error", true);
            }
            String textDeltaFire = strB;
            note.addTextLineNL(textDeltaInactive, "text");
            note.addTextLineNL(textDeltaActive, "text");
            note.addTextLineNL(textDeltaProduction, "text");
            note.addTextLineNL(textDeltaFire, "text");
            note.addTextLineNL("", "text");
            ++transIndex;
        }
        note.addTextLineNL("", "bold");
        note.addTextLineNL(lang.getText("QST_entry045"), "bold");
        int placeIndex = 0;
        for (PlaceXTPN place : places) {
            note.addTextLine(lang.getText("QST_entry046") + " ", "text");
            note.addTextLine("" + placeIndex, "bold");
            note.addTextLine(" (" + place.getName() + ")", "bold");
            note.addTextLine(lang.getText("QST_entry047") + " ", "text");
            note.addTextLineNL(this.getPlaceType(place), "bold");
            double avgTokensRef = result.get((int)0).avgTokens.get(placeIndex);
            note.addTextLine(lang.getText("QST_entry048"), "bold");
            note.addTextLineNL(Tools.cutValue(avgTokensRef), "text");
            double avgTokensKnock = result.get((int)1).avgTokens.get(placeIndex);
            note.addTextLine(lang.getText("QST_entry049"), "bold");
            note.addTextLineNL(Tools.cutValue(avgTokensKnock), "text");
            ++placeIndex;
        }
        note.setCaretFirstLine();
        note.setVisible(true);
        this.startSimButton.setEnabled(true);
        overlord.getWorkspace().getProject().setSimulationActive(false);
    }

    private String getTransType(TransitionXTPN transition) {
        if (transition.isAlphaModeActive() && transition.isBetaModeActive()) {
            return "XTPN";
        }
        if (transition.isAlphaModeActive()) {
            return "TPN";
        }
        if (transition.isBetaModeActive()) {
            return "DPN";
        }
        return "classical PN";
    }

    private String getPlaceType(PlaceXTPN place) {
        if (place.isGammaModeActive()) {
            return "time-place";
        }
        return "classical place";
    }
}

