/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.util.ArrayList;

public class GraphicalSimulatorLogger {
    private HolmesNotepad log = overlord.getSimLog();
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public void logStart(SimulatorGlobals.SimNetType simulationType, boolean writeHistory, GraphicalSimulator.SimulatorMode sm, boolean maximumMode) {
        String histWrite = "yes";
        if (!writeHistory) {
            histWrite = "no";
        }
        String max = "maximum";
        if (!maximumMode) {
            max = "50/50";
        }
        String message = lang.getText("GSL_entry001") + " ";
        this.log.addText(message, "t", true, false);
        message = simulationType.toString();
        this.log.addText(message, "b", false, false);
        message = " " + lang.getText("GSL_entry003") + " ";
        this.log.addText(message, "t", false, false);
        this.log.addText(max, "b", false, false);
        this.log.addText(" / ", "t", false, false);
        this.log.addText(sm.toString(), "b", false, false);
        message = " " + lang.getText("GSL_entry002") + " ";
        this.log.addText(message, "t", false, false);
        this.log.addText(histWrite, "b", false, true);
    }

    public void logSimStopped(long step) {
        this.log.addText(lang.getText("GSL_entry004") + " ", "t", true, false);
        this.log.addText("" + step, "t", false, true);
    }

    public void logSimStepFinished(ArrayList<Transition> launchingTransitions, boolean details) {
        for (Transition transition : launchingTransitions) {
            String strB;
            Node p;
            ArrayList<Arc> inArcs = transition.getInputArcs();
            ArrayList<Arc> outArcs = transition.getOutputArcs();
            ArrayList<Node> prePlaces = new ArrayList<Node>();
            ArrayList<Node> postPlaces = new ArrayList<Node>();
            ArrayList<String> prePlacesInfo = new ArrayList<String>();
            ArrayList<Integer> prePlacesInfoTokens = new ArrayList<Integer>();
            ArrayList<String> postPlacesInfo = new ArrayList<String>();
            ArrayList<Integer> postPlacesInfoTokens = new ArrayList<Integer>();
            int tokensTaken = 0;
            int tokensProduced = 0;
            for (Arc a : inArcs) {
                p = a.getStartNode();
                if (!prePlaces.contains(p)) {
                    prePlaces.add(p);
                } else {
                    strB = "err.";
                    try {
                        strB = String.format(lang.getText("GSL_entry005"), transition.getName(), p.getName());
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentryLNGexc") + " GSL_entry005", "error", true);
                    }
                    this.log.addText(strB, "warning", true, true);
                }
                tokensTaken += a.getWeight();
                prePlacesInfo.add(p.getName());
                prePlacesInfoTokens.add(a.getWeight());
            }
            for (Arc a : outArcs) {
                p = a.getEndNode();
                if (!postPlaces.contains(p)) {
                    postPlaces.add(p);
                } else {
                    strB = "err.";
                    try {
                        strB = String.format(lang.getText("GSL_entry005"), transition.getName(), p.getName());
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentryLNGexc") + " GSL_entry005", "error", true);
                    }
                    this.log.addText(strB, "warning", true, true);
                }
                tokensProduced += a.getWeight();
                postPlacesInfo.add(p.getName());
                postPlacesInfoTokens.add(a.getWeight());
            }
            this.log.addText("  " + lang.getText("GSL_entry006") + " ", "t", false, false);
            this.log.addText(transition.getName(), "b", false, false);
            this.log.addText("  " + lang.getText("GSL_entry007") + " ", "t", false, false);
            this.log.addText("" + tokensTaken, "b", false, false);
            this.log.addText("  " + lang.getText("GSL_entry008") + " ", "t", false, false);
            this.log.addText("" + tokensProduced, "b", false, false);
            this.log.addText("  " + lang.getText("GSL_entry009") + " ", "t", false, false);
            this.log.addText("" + prePlacesInfo.size(), "b", false, false);
            this.log.addText("", "t", false, false);
            this.log.addText("  " + lang.getText("GSL_entry010") + " ", "t", false, false);
            this.log.addText("" + postPlacesInfo.size(), "b", false, false);
            this.log.addText("", "t", false, true);
            if (!details) continue;
            int m = this.getMaxLength(prePlacesInfo, 0);
            m = this.getMaxLength(postPlacesInfo, m);
            if (!prePlacesInfo.isEmpty()) {
                for (int i = 0; i < prePlacesInfo.size(); ++i) {
                    this.log.addText("     (preP) ", "t", false, false);
                    this.log.addText(Tools.setToSize(prePlacesInfo.get(i), m + 2, false) + ": ", "nodeName", false, false);
                    this.log.addText("-" + String.valueOf(prePlacesInfoTokens.get(i)), "b", false, true);
                }
            } else {
                this.log.addText("     (preP) " + Tools.setToSize("---", m + 2, false) + ": ", "t", false, false);
                this.log.addText(lang.getText("GSL_entry011"), "b", false, true);
            }
            if (!postPlacesInfo.isEmpty()) {
                for (int i = 0; i < postPlacesInfo.size(); ++i) {
                    this.log.addText("     (postP)", "t", false, false);
                    this.log.addText(Tools.setToSize(postPlacesInfo.get(i), m + 2, false) + ": ", "nodeName", false, false);
                    this.log.addText("+" + String.valueOf(postPlacesInfoTokens.get(i)), "b", false, true);
                }
                continue;
            }
            this.log.addText("     (postP)" + Tools.setToSize("---", m + 2, false) + ": ", "t", false, false);
            this.log.addText(lang.getText("GSL_entry012"), "b", false, true);
        }
    }

    private int getMaxLength(ArrayList<String> prePlacesInfo, int currentMax) {
        int max = currentMax;
        for (String s : prePlacesInfo) {
            if (s.length() <= max) continue;
            max = s.length();
        }
        return max;
    }

    public void logBackupCreated() {
        this.log.addText("   " + lang.getText("GSL_entry013"), "t", false, true);
    }

    public void logSimReset() {
        this.log.addText(lang.getText("GSL_entry014"), "b", true, true);
        String stars = "**********************************************************************************************************";
        this.log.addText(stars, "b", false, true);
    }

    public void logSimPause(boolean pause) {
        if (pause) {
            this.log.addText("   " + lang.getText("GSL_entry015"), "t", false, true);
        } else {
            this.log.addText("   " + lang.getText("GSL_entry016"), "t", false, true);
        }
    }
}

