/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.functions.FunctionsTools;
import holmes.petrinet.simulators.GraphicalSimulatorLogger;
import holmes.petrinet.simulators.SimulationStep;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.SimulatorStandardPN;
import holmes.windows.HolmesNotepad;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.Timer;

public class GraphicalSimulator {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private SimulatorGlobals.SimNetType netSimType;
    private SimulatorMode simulatorStatus = SimulatorMode.STOPPED;
    private SimulatorMode previousSimStatus = SimulatorMode.STOPPED;
    private PetriNet petriNet;
    private int delay = 30;
    private boolean simulationActive = false;
    private Timer timer;
    private ArrayList<Transition> launchingTransitions = new ArrayList();
    private Stack<SimulationStep> actionStack;
    private boolean maxMode = false;
    private boolean singleMode = false;
    private boolean writeHistory = true;
    private long timeCounter = -1L;
    private boolean simLogEnabled = true;
    private GraphicalSimulatorLogger nsl = new GraphicalSimulatorLogger();
    private SimulatorStandardPN engine;
    private boolean emptySteps = false;

    public GraphicalSimulator(SimulatorGlobals.SimNetType type, PetriNet net) {
        this.netSimType = type;
        this.petriNet = net;
        this.launchingTransitions = new ArrayList();
        this.actionStack = new Stack();
        this.engine = new SimulatorStandardPN();
    }

    public void resetSimulator() {
        this.simulatorStatus = SimulatorMode.STOPPED;
        this.previousSimStatus = SimulatorMode.STOPPED;
        this.simulationActive = false;
        this.setMaxMode(false);
        this.setSingleMode(false);
        this.writeHistory = true;
        this.timeCounter = -1L;
        this.actionStack.removeAllElements();
        this.engine.setEngine(this.netSimType, this.isMaxMode(), this.isSingleMode(), this.petriNet.getTransitions(), this.petriNet.getTimeTransitions(), this.petriNet.getPlaces());
        this.emptySteps = false;
    }

    public void startSimulation(SimulatorMode simulatorMode) {
        ArrayList<Transition> transitions = this.petriNet.getTransitions();
        ArrayList<Transition> time_transitions = this.petriNet.getTimeTransitions();
        ArrayList<Place> places = this.petriNet.getPlaces();
        try {
            this.simLogEnabled = overlord.getSettingsManager().getValue("simLogEnabled").equals("1");
        }
        catch (Exception e) {
            this.simLogEnabled = false;
        }
        this.nsl.logStart(this.netSimType, this.writeHistory, simulatorMode, this.isMaxMode());
        HolmesNotepad notepad = new HolmesNotepad(640, 480);
        boolean status = FunctionsTools.validateFunctionNet(notepad, places);
        if (status) {
            notepad.setVisible(true);
        } else {
            notepad.dispose();
        }
        this.engine.setEngine(this.netSimType, this.isMaxMode(), this.isSingleMode(), transitions, time_transitions, places);
        if (this.simLogEnabled) {
            this.nsl.logBackupCreated();
        }
        this.previousSimStatus = this.getSimulatorStatus();
        this.setSimulatorStatus(simulatorMode);
        this.setSimulationActive(true);
        SimulationPerformer taskPerformer = new SimulationPerformer();
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationDisruptButtons();
        this.checkSimulatorNetType();
        switch (this.getSimulatorStatus()) {
            case LOOP: {
                taskPerformer = new StepLoopPerformer(true);
                break;
            }
            case SINGLE_TRANSITION_LOOP: {
                taskPerformer = new SingleTransitionPerformer(true);
                break;
            }
            case SINGLE_TRANSITION: {
                taskPerformer = new SingleTransitionPerformer();
                break;
            }
            case STEP: {
                taskPerformer = new StepLoopPerformer();
                break;
            }
            case ACTION_BACK: {
                taskPerformer = new StepBackPerformer();
                break;
            }
            case LOOP_BACK: {
                this.launchingTransitions.clear();
                taskPerformer = new StepBackPerformer(true);
                break;
            }
            case PAUSED: {
                break;
            }
            case STOPPED: {
                break;
            }
        }
        this.setTimer(new Timer(this.getDelay(), taskPerformer));
        this.getTimer().start();
    }

    private boolean isPossibleStep() {
        ArrayList<Transition> transitions = this.petriNet.getTransitions();
        if (this.netSimType == SimulatorGlobals.SimNetType.COLOR) {
            for (Transition transition : transitions) {
                if (!(transition instanceof TransitionColored ? ((TransitionColored)transition).isColorActive() : transition.isActive())) continue;
                return true;
            }
        } else {
            for (Transition transition : transitions) {
                if (transition.isActive()) {
                    return true;
                }
                if (!(transition.timeExtension.getDPNtimer() >= 0.0) || transition.timeExtension.getDPNduration() == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    public int setGraphicalSimulatorNetType(int type) {
        int check = GraphicalSimulator.overlord.simSettings.checkSimulatorNetType(type);
        if (check == 0) {
            this.netSimType = SimulatorGlobals.SimNetType.BASIC;
            this.engine.setNetSimType(this.netSimType);
            return 0;
        }
        if (check == 1) {
            this.netSimType = SimulatorGlobals.SimNetType.TIME;
            this.engine.setNetSimType(this.netSimType);
            return 1;
        }
        if (check == 2) {
            this.netSimType = SimulatorGlobals.SimNetType.HYBRID;
            this.engine.setNetSimType(this.netSimType);
            return 2;
        }
        if (check == 3) {
            this.netSimType = SimulatorGlobals.SimNetType.COLOR;
            this.engine.setNetSimType(this.netSimType);
            return 3;
        }
        return -1;
    }

    public SimulatorGlobals.SimNetType getSimNetType() {
        return this.netSimType;
    }

    private void checkSimulatorNetType() {
        if (this.netSimType == SimulatorGlobals.SimNetType.BASIC) {
            boolean colorDetected = false;
            for (Node n : this.petriNet.getNodes()) {
                if (!(n instanceof Place)) continue;
                if (!((Place)n).isColored) break;
                colorDetected = true;
                break;
            }
            if (colorDetected) {
                JOptionPane.showMessageDialog(null, lang.getText("GS_entry001"), lang.getText("GS_entry001t"), 0);
                GraphicalSimulator.overlord.getSimulatorBox().getCurrentDockWindow().simMode.setSelectedIndex(3);
                this.netSimType = SimulatorGlobals.SimNetType.COLOR;
                this.engine.setNetSimType(this.netSimType);
            }
        } else if (this.netSimType == SimulatorGlobals.SimNetType.TIME) {
            for (Node n : this.petriNet.getNodes()) {
                if (n instanceof Place || !(n instanceof Transition) || ((Transition)n).getTransType() == Transition.TransitionType.TPN) continue;
                JOptionPane.showMessageDialog(null, lang.getText("GS_entry002"), lang.getText("GS_entry002t"), 0);
                GraphicalSimulator.overlord.getSimulatorBox().getCurrentDockWindow().simMode.setSelectedIndex(2);
                this.netSimType = SimulatorGlobals.SimNetType.HYBRID;
                this.engine.setNetSimType(this.netSimType);
            }
        } else if (this.netSimType == SimulatorGlobals.SimNetType.HYBRID) {
            JOptionPane.showMessageDialog(null, lang.getText("GS_entry003"), lang.getText("problem"), 0);
        }
    }

    public void launchSubtractPhase(ArrayList<Transition> transitions, boolean backtracking) {
        for (Transition transition : transitions) {
            transition.setLaunching(true);
            ArrayList<Arc> arcs = !backtracking ? transition.getInputArcs() : transition.getOutputArcs();
            if (transition.timeExtension.getDPNtimer() > 0.0) continue;
            for (Arc arc : arcs) {
                Place place;
                arc.setSimulationForwardDirection(!backtracking);
                arc.setTransportingTokens(true);
                if (!backtracking) {
                    place = (Place)arc.getStartNode();
                    if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                        arc.setTransportingTokens(false);
                        continue;
                    }
                    if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                        int tokens = place.getTokensNumber();
                        place.addTokensNumber(-tokens);
                        continue;
                    }
                    if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
                        place.addTokensNumber(-arc.getWeight());
                        continue;
                    }
                    if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                        try {
                            ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(0), 0);
                            ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(1), 1);
                            ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(2), 2);
                            ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(3), 3);
                            ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(4), 4);
                            ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(5), 5);
                        }
                        catch (Exception ex) {
                            overlord.log(lang.getText("LOGentry00403exception") + "\n" + ex.getMessage(), "error", true);
                        }
                        continue;
                    }
                    FunctionsTools.functionalExtraction(transition, arc, place);
                    continue;
                }
                place = (Place)arc.getEndNode();
                if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                    arc.setTransportingTokens(false);
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                    place.addTokensNumber(-1);
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
                    place.addTokensNumber(-arc.getWeight());
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                    try {
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(0), 0);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(1), 1);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(2), 2);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(3), 3);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(4), 4);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(5), 5);
                    }
                    catch (Exception ex) {
                        overlord.log(lang.getText("LOGentry00404exception") + "\n" + ex.getMessage(), "error", true);
                    }
                    continue;
                }
                FunctionsTools.functionalExtraction(transition, arc, place);
            }
        }
    }

    public void launchSingleSubtractPhase(ArrayList<Transition> transitions, boolean backtracking, Transition chosenTransition) {
        ArrayList<Arc> arcs;
        Transition transition;
        if (transitions.isEmpty()) {
            return;
        }
        if (!backtracking) {
            transition = transitions.get(0);
            arcs = transition.getInputArcs();
        } else {
            transition = chosenTransition;
            arcs = transition.getOutputArcs();
        }
        transition.setLaunching(true);
        for (Arc arc : arcs) {
            Place place;
            arc.setSimulationForwardDirection(!backtracking);
            arc.setTransportingTokens(true);
            if (!backtracking) {
                place = (Place)arc.getStartNode();
                if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                    arc.setTransportingTokens(false);
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                    int tokens = place.getTokensNumber();
                    place.addTokensNumber(-tokens);
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
                    place.addTokensNumber(-arc.getWeight());
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                    try {
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(0), 0);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(1), 1);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(2), 2);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(3), 3);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(4), 4);
                        ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(5), 5);
                    }
                    catch (Exception ex) {
                        overlord.log(lang.getText("LOGentry00405exception") + "\n" + ex.getMessage(), "error", true);
                    }
                    continue;
                }
                FunctionsTools.functionalExtraction(transition, arc, place);
                continue;
            }
            place = (Place)arc.getEndNode();
            if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                arc.setTransportingTokens(false);
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                place.addTokensNumber(-1);
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
                place.addTokensNumber(-arc.getWeight());
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                try {
                    ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(0), 0);
                    ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(1), 1);
                    ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(2), 2);
                    ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(3), 3);
                    ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(4), 4);
                    ((PlaceColored)place).modifyColorTokensNumber(-arc.getColorWeight(5), 5);
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00406exception") + "\n" + ex.getMessage(), "error", true);
                }
                continue;
            }
            FunctionsTools.functionalExtraction(transition, arc, place);
        }
    }

    public void launchAddPhaseGraphics(ArrayList<Transition> transitions, boolean backtracking) {
        for (Transition tran : transitions) {
            tran.setLaunching(true);
            ArrayList<Arc> arcs = !backtracking ? tran.getOutputArcs() : tran.getInputArcs();
            for (Arc arc : arcs) {
                if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) continue;
                arc.setSimulationForwardDirection(!backtracking);
                arc.setTransportingTokens(true);
            }
        }
    }

    public void launchSingleAddPhaseGraphics(ArrayList<Transition> transitions, boolean backtracking, Transition chosenTransition) {
        ArrayList<Arc> arcs;
        Transition tran;
        if (transitions.isEmpty()) {
            return;
        }
        if (!backtracking) {
            tran = transitions.get(0);
            arcs = tran.getOutputArcs();
        } else {
            tran = chosenTransition;
            arcs = tran.getInputArcs();
        }
        tran.setLaunching(true);
        for (Arc arc : arcs) {
            if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) continue;
            arc.setSimulationForwardDirection(!backtracking);
            arc.setTransportingTokens(true);
        }
    }

    public void launchAddPhase(ArrayList<Transition> transitions, boolean backtracking) {
        for (Transition transition : transitions) {
            transition.setLaunching(false);
            ArrayList<Arc> arcs = !backtracking ? transition.getOutputArcs() : transition.getInputArcs();
            for (Arc arc : arcs) {
                Place place = !backtracking ? (Place)arc.getEndNode() : (Place)arc.getStartNode();
                if (arc.getArcType() != Arc.TypeOfArc.NORMAL && arc.getArcType() != Arc.TypeOfArc.COLOR && arc.getArcType() != Arc.TypeOfArc.READARC) {
                    String strB = "err.";
                    try {
                        strB = String.format(lang.getText("LOGentry00407"), place.getName(), arc);
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00407", "error", true);
                    }
                    overlord.log(strB, "warning", true);
                }
                if (arc.getArcType() == Arc.TypeOfArc.COLOR && place.isColored) {
                    try {
                        ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(0), 0);
                        ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(1), 1);
                        ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(2), 2);
                        ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(3), 3);
                        ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(4), 4);
                        ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(5), 5);
                    }
                    catch (Exception ex) {
                        overlord.log(lang.getText("LOGentry00408exception") + "\n" + ex.getMessage(), "error", true);
                    }
                    continue;
                }
                FunctionsTools.functionalAddition(transition, arc, place);
            }
            transition.timeExtension.resetTimeVariables();
        }
        transitions.clear();
    }

    public void launchSingleAddPhase(ArrayList<Transition> transitions, boolean backtracking, Transition chosenTransition) {
        ArrayList<Arc> arcs;
        Transition transition;
        if (transitions.isEmpty()) {
            return;
        }
        if (!backtracking) {
            transition = transitions.get(0);
            arcs = transition.getOutputArcs();
        } else {
            transition = chosenTransition;
            arcs = transition.getInputArcs();
        }
        for (Arc arc : arcs) {
            if (arc.getArcType() == Arc.TypeOfArc.READARC) continue;
            Place place = !backtracking ? (Place)arc.getEndNode() : (Place)arc.getStartNode();
            if (arc.getArcType() != Arc.TypeOfArc.NORMAL && arc.getArcType() != Arc.TypeOfArc.COLOR && arc.getArcType() != Arc.TypeOfArc.READARC) {
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("LOGentry00409"), place.getName(), arc);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00409", "error", true);
                }
                overlord.log(strB, "warning", true);
            }
            if (arc.getArcType() == Arc.TypeOfArc.COLOR && place.isColored) {
                try {
                    ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(0), 0);
                    ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(1), 1);
                    ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(2), 2);
                    ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(3), 3);
                    ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(4), 4);
                    ((PlaceColored)place).modifyColorTokensNumber(arc.getColorWeight(5), 5);
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00410exception") + "\n" + ex.getMessage(), "error", true);
                }
                continue;
            }
            FunctionsTools.functionalAddition(transition, arc, place);
        }
        transitions.remove(transition);
    }

    public void stop() {
        ((SimulationPerformer)this.getTimer().getActionListeners()[0]).scheduleStop();
    }

    public void pause() {
        if (this.getSimulatorStatus() != SimulatorMode.PAUSED && this.getSimulatorStatus() != SimulatorMode.STOPPED) {
            this.pauseSimulation();
        } else if (this.getSimulatorStatus() == SimulatorMode.PAUSED) {
            this.unpauseSimulation();
        } else if (this.getSimulatorStatus() == SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, lang.getText("GS_entry004"), lang.getText("GS_entry004t"), 0);
        }
    }

    private void stopSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationInitiateButtons();
        this.timer.stop();
        this.previousSimStatus = this.simulatorStatus;
        this.setSimulatorStatus(SimulatorMode.STOPPED);
        this.setSimulationActive(false);
        this.nsl.logSimStopped(this.timeCounter);
    }

    private void pauseSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlyUnpauseButton();
        this.timer.stop();
        this.previousSimStatus = this.simulatorStatus;
        this.setSimulatorStatus(SimulatorMode.PAUSED);
        if (this.simLogEnabled) {
            this.nsl.logSimPause(true);
        }
    }

    private void unpauseSimulation() {
        overlord.getSimulatorBox().getCurrentDockWindow().allowOnlySimulationDisruptButtons();
        if (this.previousSimStatus != SimulatorMode.STOPPED) {
            this.timer.start();
            this.setSimulatorStatus(this.previousSimStatus);
        }
        if (this.simLogEnabled) {
            this.nsl.logSimPause(false);
        }
    }

    public boolean isSimulationActive() {
        return this.simulationActive;
    }

    public void setSimulationActive(boolean simulationActive) {
        this.simulationActive = simulationActive;
        overlord.getWorkspace().getProject().setSimulationActive(this.isSimulationActive());
    }

    public Timer getTimer() {
        return this.timer;
    }

    private void setTimer(Timer timer) {
        this.timer = timer;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(Integer delay) {
        if (this.timer != null) {
            this.timer.setDelay(delay);
        }
        this.delay = delay;
    }

    public SimulatorMode getSimulatorStatus() {
        return this.simulatorStatus;
    }

    private void setSimulatorStatus(SimulatorMode mode) {
        this.simulatorStatus = mode;
    }

    public void setHistoryMode(boolean status) {
        this.writeHistory = status;
    }

    public boolean isHistoryMode() {
        return this.writeHistory;
    }

    public void setSimLogging(boolean status) {
        this.simLogEnabled = status;
    }

    public boolean isSimLogging() {
        return this.simLogEnabled;
    }

    public long getSimulatorTimeStep() {
        return this.timeCounter;
    }

    public GraphicalSimulatorLogger getSimLogger() {
        return this.nsl;
    }

    private ArrayList<Transition> cloneTransitionArray(ArrayList<Transition> transitions) {
        return new ArrayList<Transition>(transitions);
    }

    public boolean isMaxMode() {
        return this.maxMode;
    }

    public void setMaxMode(boolean value) {
        this.maxMode = value;
        this.engine.setMaxMode(value);
    }

    public boolean isSingleMode() {
        return this.singleMode;
    }

    public void setSingleMode(boolean value) {
        this.singleMode = value;
        this.engine.setSingleMode(value);
    }

    public static enum SimulatorMode {
        LOOP,
        SINGLE_TRANSITION_LOOP,
        SINGLE_TRANSITION,
        STEP,
        STOPPED,
        PAUSED,
        ACTION_BACK,
        LOOP_BACK,
        XTPNLOOP;

    }

    private class SimulationPerformer
    implements ActionListener {
        protected int transitionDelay;
        protected boolean subtractPhase;
        protected boolean finishedAddPhase;
        protected boolean scheduledStop;
        protected int remainingTransitionsAmount;

        private SimulationPerformer() {
            this.transitionDelay = GraphicalSimulator.overlord.simSettings.getTransitionGraphicDelay();
            this.subtractPhase = true;
            this.finishedAddPhase = true;
            this.scheduledStop = false;
            this.remainingTransitionsAmount = GraphicalSimulator.this.launchingTransitions.size();
        }

        protected void updateStepCounter() {
            overlord.getWorkspace().getProject().incrementGraphicalSimulationStep();
        }

        public void scheduleStop() {
            this.scheduledStop = true;
        }

        public void executeScheduledStop() {
            GraphicalSimulator.this.stopSimulation();
            this.scheduledStop = false;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.updateStepCounter();
        }
    }

    private class StepLoopPerformer
    extends SimulationPerformer {
        private boolean loop;

        public StepLoopPerformer() {
            this.loop = false;
        }

        public StepLoopPerformer(boolean looping) {
            this.loop = looping;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int DEFAULT_COUNTER = GraphicalSimulator.overlord.simSettings.getTransitionGraphicDelay();
            this.updateStepCounter();
            if (this.transitionDelay >= DEFAULT_COUNTER && this.subtractPhase) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                } else if (GraphicalSimulator.this.isPossibleStep()) {
                    if (this.remainingTransitionsAmount == 0) {
                        ++GraphicalSimulator.this.timeCounter;
                        GraphicalSimulator.overlord.io.updateTimeStep(false, GraphicalSimulator.this.timeCounter, 0.0, 0.0);
                        GraphicalSimulator.overlord.simSettings.currentStep = GraphicalSimulator.this.timeCounter;
                        GraphicalSimulator.this.launchingTransitions = GraphicalSimulator.this.engine.getTransLaunchList(GraphicalSimulator.this.emptySteps);
                        this.remainingTransitionsAmount = GraphicalSimulator.this.launchingTransitions.size();
                    }
                    if (GraphicalSimulator.this.isHistoryMode()) {
                        GraphicalSimulator.this.actionStack.push(new SimulationStep(SimulatorMode.STEP, GraphicalSimulator.this.cloneTransitionArray(GraphicalSimulator.this.launchingTransitions)));
                        if (GraphicalSimulator.this.actionStack.peek().getPendingTransitions() == null) {
                            overlord.log(lang.getText("LOGentry00411"), "error", true);
                        }
                    }
                    GraphicalSimulator.this.launchSubtractPhase(GraphicalSimulator.this.launchingTransitions, false);
                    for (int t = 0; t < GraphicalSimulator.this.launchingTransitions.size(); ++t) {
                        Transition test_t = GraphicalSimulator.this.launchingTransitions.get(t);
                        if (!test_t.timeExtension.isDPN() || test_t.timeExtension.getDPNtimer() != 0.0 || test_t.timeExtension.getDPNduration() == 0.0) continue;
                        GraphicalSimulator.this.launchingTransitions.remove(test_t);
                        --t;
                    }
                    this.subtractPhase = false;
                } else {
                    GraphicalSimulator.this.setSimulationActive(false);
                    GraphicalSimulator.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, lang.getText("GS_entry005"), lang.getText("GS_entry005t"), 1);
                }
                this.transitionDelay = 0;
            } else if (this.transitionDelay >= DEFAULT_COUNTER && !this.subtractPhase) {
                GraphicalSimulator.this.launchAddPhaseGraphics(GraphicalSimulator.this.launchingTransitions, false);
                this.finishedAddPhase = false;
                this.transitionDelay = 0;
            } else if (this.transitionDelay >= DEFAULT_COUNTER - 5 && !this.finishedAddPhase) {
                boolean detailedLogging = true;
                if (GraphicalSimulator.this.simLogEnabled) {
                    GraphicalSimulator.this.nsl.logSimStepFinished(GraphicalSimulator.this.launchingTransitions, detailedLogging);
                }
                GraphicalSimulator.this.launchAddPhase(GraphicalSimulator.this.launchingTransitions, false);
                this.finishedAddPhase = true;
                this.subtractPhase = true;
                this.remainingTransitionsAmount = 0;
                if (!this.loop) {
                    this.scheduleStop();
                }
                ++this.transitionDelay;
            } else {
                ++this.transitionDelay;
            }
        }
    }

    private class SingleTransitionPerformer
    extends SimulationPerformer {
        private boolean loop;

        public SingleTransitionPerformer() {
            this.loop = false;
        }

        public SingleTransitionPerformer(boolean looping) {
            this.loop = looping;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int DEFAULT_COUNTER = GraphicalSimulator.overlord.simSettings.getTransitionGraphicDelay();
            this.updateStepCounter();
            if (this.transitionDelay >= DEFAULT_COUNTER && this.subtractPhase) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                } else if (GraphicalSimulator.this.isPossibleStep()) {
                    if (this.remainingTransitionsAmount == 0) {
                        ++GraphicalSimulator.this.timeCounter;
                        GraphicalSimulator.overlord.io.updateTimeStep(false, GraphicalSimulator.this.timeCounter, 0.0, 0.0);
                        GraphicalSimulator.overlord.simSettings.currentStep = GraphicalSimulator.this.timeCounter;
                        GraphicalSimulator.this.launchingTransitions = GraphicalSimulator.this.engine.getTransLaunchList(GraphicalSimulator.this.emptySteps);
                        this.remainingTransitionsAmount = GraphicalSimulator.this.launchingTransitions.size();
                    }
                    if (GraphicalSimulator.this.isHistoryMode()) {
                        GraphicalSimulator.this.actionStack.push(new SimulationStep(SimulatorMode.SINGLE_TRANSITION, GraphicalSimulator.this.launchingTransitions.get(0), GraphicalSimulator.this.cloneTransitionArray(GraphicalSimulator.this.launchingTransitions)));
                    }
                    GraphicalSimulator.this.launchSingleSubtractPhase(GraphicalSimulator.this.launchingTransitions, false, null);
                    for (int t = 0; t < GraphicalSimulator.this.launchingTransitions.size(); ++t) {
                        Transition test_t = GraphicalSimulator.this.launchingTransitions.get(t);
                        if (!test_t.timeExtension.isDPN() || test_t.timeExtension.getDPNtimer() != 0.0 || test_t.timeExtension.getDPNduration() == 0.0) continue;
                        GraphicalSimulator.this.launchingTransitions.remove(test_t);
                        --t;
                    }
                    this.subtractPhase = false;
                } else {
                    GraphicalSimulator.this.setSimulationActive(false);
                    GraphicalSimulator.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, lang.getText("GS_entry005"), lang.getText("GS_entry005t"), 1);
                    overlord.log(lang.getText("LOGentry00412"), "text", true);
                }
                this.transitionDelay = 0;
            } else if (this.transitionDelay >= DEFAULT_COUNTER && !this.subtractPhase) {
                GraphicalSimulator.this.launchSingleAddPhaseGraphics(GraphicalSimulator.this.launchingTransitions, false, null);
                this.finishedAddPhase = false;
                this.transitionDelay = 0;
            } else if (this.transitionDelay >= DEFAULT_COUNTER - 5 && !this.finishedAddPhase) {
                GraphicalSimulator.this.launchSingleAddPhase(GraphicalSimulator.this.launchingTransitions, false, null);
                this.remainingTransitionsAmount = GraphicalSimulator.this.launchingTransitions.size();
                this.finishedAddPhase = true;
                this.subtractPhase = true;
                if (!this.loop) {
                    this.scheduleStop();
                }
                ++this.transitionDelay;
            } else {
                ++this.transitionDelay;
            }
        }
    }

    private class StepBackPerformer
    extends SimulationPerformer {
        private boolean loop;
        ArrayList<Transition> currentTransitions = new ArrayList();
        SimulationStep currentStep;

        public StepBackPerformer() {
            this.loop = false;
        }

        public StepBackPerformer(boolean looping) {
            this.loop = looping;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int DEFAULT_COUNTER = GraphicalSimulator.overlord.simSettings.getTransitionGraphicDelay();
            this.updateStepCounter();
            if (this.transitionDelay >= DEFAULT_COUNTER && this.subtractPhase) {
                if (this.scheduledStop) {
                    this.executeScheduledStop();
                } else if (!GraphicalSimulator.this.actionStack.empty()) {
                    --GraphicalSimulator.this.timeCounter;
                    GraphicalSimulator.overlord.io.updateTimeStep(false, GraphicalSimulator.this.timeCounter, 0.0, 0.0);
                    GraphicalSimulator.overlord.simSettings.currentStep = GraphicalSimulator.this.timeCounter;
                    this.currentStep = GraphicalSimulator.this.actionStack.pop();
                    if (this.currentStep.getType() == SimulatorMode.STEP) {
                        GraphicalSimulator.this.launchSubtractPhase(this.currentStep.getPendingTransitions(), true);
                    } else if (this.currentStep.getType() == SimulatorMode.SINGLE_TRANSITION) {
                        GraphicalSimulator.this.launchSingleSubtractPhase(this.currentStep.getPendingTransitions(), true, this.currentStep.getLaunchedTransition());
                    }
                    this.subtractPhase = false;
                } else {
                    GraphicalSimulator.this.setSimulationActive(false);
                    GraphicalSimulator.this.stopSimulation();
                    JOptionPane.showMessageDialog(null, lang.getText("GS_entry006"), lang.getText("GS_entry006t"), 1);
                }
                this.transitionDelay = 0;
            } else if (this.transitionDelay >= DEFAULT_COUNTER && !this.subtractPhase) {
                if (this.currentStep.getType() == SimulatorMode.STEP) {
                    GraphicalSimulator.this.launchAddPhaseGraphics(this.currentStep.getPendingTransitions(), true);
                } else if (this.currentStep.getType() == SimulatorMode.SINGLE_TRANSITION) {
                    GraphicalSimulator.this.launchSingleAddPhaseGraphics(this.currentStep.getPendingTransitions(), true, this.currentStep.getLaunchedTransition());
                }
                this.finishedAddPhase = false;
                this.transitionDelay = 0;
            } else if (this.transitionDelay >= DEFAULT_COUNTER - 5 && !this.finishedAddPhase) {
                if (this.currentStep.getType() == SimulatorMode.STEP) {
                    GraphicalSimulator.this.launchAddPhase(this.currentStep.getPendingTransitions(), true);
                } else if (this.currentStep.getType() == SimulatorMode.SINGLE_TRANSITION) {
                    GraphicalSimulator.this.launchSingleAddPhase(this.currentStep.getPendingTransitions(), true, this.currentStep.getLaunchedTransition());
                }
                this.finishedAddPhase = true;
                this.subtractPhase = true;
                if (!this.loop) {
                    this.scheduleStop();
                }
                ++this.transitionDelay;
            } else {
                ++this.transitionDelay;
            }
        }
    }
}

