/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.functions;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.functions.FunctionContainer;
import holmes.windows.HolmesNotepad;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import org.nfunk.jep.JEP;

public class FunctionsTools {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public static boolean revalidateFunctions(Place place, int placeIndex) {
        boolean removedAnything = false;
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        for (Transition transition : transitions) {
            for (FunctionContainer fc : transition.fpnExtension.accessFunctionsList()) {
                if (!fc.involvedPlaces.containsKey("p" + placeIndex)) continue;
                int transIndex = transitions.indexOf(transition);
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("LOGentry00395"), fc.simpleExpression, fc.fID, transIndex, placeIndex);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00395", "error", true);
                }
                overlord.log(strB, "warning", true);
                fc.enabled = false;
                fc.correct = false;
                fc.simpleExpression = fc.simpleExpression.replaceAll("p" + placeIndex, " ??? ");
                fc.involvedPlaces.remove("p" + placeIndex);
                fc.currentValue = -1.0;
                removedAnything = true;
            }
        }
        return removedAnything;
    }

    public static void resetPlaceVector(FunctionContainer fc, JTextArea commentField, ArrayList<Place> places) {
        int placesNumber = places.size();
        fc.involvedPlaces.clear();
        Pattern p = Pattern.compile("p\\d+");
        Matcher m = p.matcher(fc.simpleExpression);
        ArrayList<String> foundPlaces = new ArrayList<String>();
        while (m.find()) {
            String x = m.group();
            foundPlaces.add(x);
            int index = Integer.parseInt(x.substring(1));
            if (index >= placesNumber || index < 0) {
                fc.simpleExpression = fc.simpleExpression.replace(x, " ??? ");
                if (commentField == null) continue;
                commentField.append(lang.getText("FT_entry001") + x + "\n");
                continue;
            }
            Place place = places.get(index);
            String key = "p" + index;
            if (fc.involvedPlaces.containsKey(key)) continue;
            fc.involvedPlaces.put(key, place);
        }
    }

    public static boolean validateFunctionNet(HolmesNotepad notepad, ArrayList<Place> places) {
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        boolean logErrors = false;
        boolean errorsFlag = false;
        if (notepad != null) {
            logErrors = true;
            notepad.addTextLineNL(lang.getText("FT_entry002"), "text");
            notepad.addTextLineNL("", "text");
        }
        int transCounter = -1;
        for (Transition transition : transitions) {
            ++transCounter;
            if (!transition.fpnExtension.isFunctional()) continue;
            for (FunctionContainer fc : transition.fpnExtension.accessFunctionsList()) {
                if (!fc.enabled) continue;
                FunctionsTools.resetPlaceVector(fc, null, places);
                if (fc.simpleExpression.contains("???") || fc.simpleExpression.isEmpty()) {
                    errorsFlag = true;
                    fc.enabled = false;
                    fc.correct = false;
                    if (logErrors) {
                        notepad.addTextLineNL("t" + transCounter + " : " + String.valueOf(fc), "text");
                    }
                }
                try {
                    JEP myParser = new JEP();
                    myParser.addStandardFunctions();
                    for (String key : fc.involvedPlaces.keySet()) {
                        Place place = fc.involvedPlaces.get(key);
                        myParser.addVariable(key, place.getTokensNumber());
                    }
                    myParser.parseExpression(fc.simpleExpression);
                    if (myParser.hasError()) {
                        HolmesNotepad note = new HolmesNotepad(640, 480);
                        note.setVisible(true);
                        notepad.addTextLineNL("  " + lang.getText("FT_entry003"), "text");
                        note.addTextLineNL("    * " + myParser.getErrorInfo(), "text");
                        fc.enabled = false;
                        fc.correct = false;
                        continue;
                    }
                    fc.correct = true;
                }
                catch (Exception e) {
                    errorsFlag = true;
                    notepad.addTextLineNL("   " + lang.getText("FT_entry004"), "text");
                    fc.enabled = false;
                    fc.correct = false;
                }
            }
        }
        return errorsFlag;
    }

    public static boolean validateFunction(FunctionContainer fc, String newEquation, boolean silence, JTextArea commentField, ArrayList<Place> places) {
        fc.simpleExpression = newEquation;
        FunctionsTools.resetPlaceVector(fc, commentField, places);
        if (fc.simpleExpression.contains("???") || fc.simpleExpression.isEmpty()) {
            return false;
        }
        try {
            JEP myParser = new JEP();
            myParser.addStandardFunctions();
            for (String key : fc.involvedPlaces.keySet()) {
                Place place = fc.involvedPlaces.get(key);
                myParser.addVariable(key, place.getTokensNumber());
            }
            myParser.parseExpression(fc.simpleExpression);
            boolean errors = myParser.hasError();
            if (errors) {
                HolmesNotepad note = new HolmesNotepad(640, 480);
                note.setVisible(true);
                note.addTextLineNL(myParser.getErrorInfo(), "text");
                if (commentField != null) {
                    commentField.append(myParser.getErrorInfo() + "\n");
                }
                fc.enabled = false;
                fc.correct = false;
            } else {
                fc.correct = true;
            }
            return !errors;
        }
        catch (Exception e) {
            commentField.append(lang.getText("FT_entry005") + " " + fc.simpleExpression + "\n");
            fc.enabled = false;
            fc.correct = false;
            return false;
        }
    }

    public static boolean getFunctionDecision(int startPlaceTokens, Arc arc, int nonFuncWeight, Transition transition) {
        try {
            FunctionContainer fc = transition.fpnExtension.getFunctionContainer(arc);
            if (fc != null) {
                fc.currentValue = nonFuncWeight;
            }
            if (fc != null && fc.enabled && fc.correct) {
                fc.currentValue = FunctionsTools.getFunctionValue(fc);
                fc.currentValue = fc.currentValue <= 0.0 ? (double)nonFuncWeight : fc.currentValue;
                return !((double)startPlaceTokens < fc.currentValue);
            }
            return startPlaceTokens >= arc.getWeight();
        }
        catch (Exception e) {
            return startPlaceTokens >= arc.getWeight();
        }
    }

    private static double getFunctionValue(FunctionContainer fc) {
        try {
            JEP myParser = new JEP();
            myParser.addStandardFunctions();
            for (String key : fc.involvedPlaces.keySet()) {
                Place place = fc.involvedPlaces.get(key);
                if (place instanceof PlaceXTPN) {
                    if (((PlaceXTPN)place).isGammaModeActive()) {
                        myParser.addVariable(key, ((PlaceXTPN)place).accessMultiset().size());
                        continue;
                    }
                    myParser.addVariable(key, place.getTokensNumber());
                    continue;
                }
                myParser.addVariable(key, place.getTokensNumber());
            }
            myParser.parseExpression(fc.simpleExpression);
            return myParser.getValue();
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00396exception") + " " + fc.simpleExpression + "\n" + e.getMessage(), "error", true);
            return -1.0;
        }
    }

    public static void functionalExtraction(Transition transition, Arc arc, Place place) {
        if (transition.fpnExtension.isFunctional()) {
            FunctionContainer fc = transition.fpnExtension.getFunctionContainer(arc);
            if (fc != null) {
                fc.currentValue = FunctionsTools.getFunctionValue(fc);
                fc.currentValue = fc.currentValue <= 0.0 ? (double)arc.getWeight() : fc.currentValue;
                place.addTokensNumber(-((int)fc.currentValue));
            } else {
                place.addTokensNumber(-arc.getWeight());
            }
        } else {
            place.addTokensNumber(-arc.getWeight());
        }
    }

    public static int getFunctionalArcWeight(Transition transition, Arc arc, Place place) {
        if (transition.fpnExtension.isFunctional()) {
            FunctionContainer fc = transition.fpnExtension.getFunctionContainer(arc);
            if (fc != null && fc.enabled && fc.correct) {
                fc.currentValue = FunctionsTools.getFunctionValue(fc);
                fc.currentValue = fc.currentValue <= 0.0 ? (double)arc.getWeight() : fc.currentValue;
                return (int)fc.currentValue;
            }
            return arc.getWeight();
        }
        return arc.getWeight();
    }

    public static void functionalAddition(Transition transition, Arc arc, Place place) {
        if (transition.fpnExtension.isFunctional()) {
            FunctionContainer fc = transition.fpnExtension.getFunctionContainer(arc);
            if (fc != null) {
                if (fc.enabled && fc.correct) {
                    fc.currentValue = FunctionsTools.getFunctionValue(fc);
                    fc.currentValue = fc.currentValue <= 0.0 ? (double)arc.getWeight() : fc.currentValue;
                    place.addTokensNumber((int)fc.currentValue);
                } else {
                    place.addTokensNumber(arc.getWeight());
                }
            } else {
                place.addTokensNumber(arc.getWeight());
            }
        } else {
            place.addTokensNumber(arc.getWeight());
        }
    }
}

