/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements.extensions;

import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.functions.FunctionContainer;
import java.io.Serializable;
import java.util.ArrayList;

public class TransitionFPNExtension
implements Serializable {
    private boolean isFunctional = false;
    protected ArrayList<FunctionContainer> fList;
    private Transition masterTransition;

    public TransitionFPNExtension(Transition trans) {
        this.masterTransition = trans;
    }

    public void setFunctional(boolean value) {
        this.isFunctional = value;
    }

    public boolean isFunctional() {
        return this.isFunctional;
    }

    public ArrayList<FunctionContainer> accessFunctionsList() {
        return this.fList;
    }

    public void createNewFunctionsVector() {
        this.fList = new ArrayList();
    }

    public void checkFunctions(ArrayList<Arc> arcs, ArrayList<Place> places) {
        int placeIndex;
        FunctionContainer fc;
        int fSize = this.fList.size();
        ArrayList<Arc> fArcs = new ArrayList<Arc>();
        for (int f = 0; f < fSize; ++f) {
            FunctionContainer fc2 = this.fList.get(f);
            if (!arcs.contains(fc2.arc)) {
                this.fList.remove(f);
                --f;
                --fSize;
                continue;
            }
            fArcs.add(fc2.arc);
        }
        ArrayList<Arc> inArcs = this.masterTransition.getInputArcs();
        ArrayList<Arc> outArcs = this.masterTransition.getOutputArcs();
        for (Arc arc : inArcs) {
            if (fArcs.contains(arc)) continue;
            fc = new FunctionContainer(this.masterTransition);
            placeIndex = places.indexOf((Place)arc.getStartNode());
            fc.fID = "p" + placeIndex + "-->T";
            fc.arc = arc;
            fc.inTransArc = true;
            this.fList.add(fc);
        }
        for (Arc arc : outArcs) {
            if (fArcs.contains(arc)) continue;
            fc = new FunctionContainer(this.masterTransition);
            placeIndex = places.indexOf((Place)arc.getEndNode());
            fc.fID = "T-->p" + placeIndex;
            fc.arc = arc;
            fc.inTransArc = false;
            this.fList.add(fc);
        }
    }

    public boolean updateFunctionString(String fID, String expression, boolean correct, boolean enabled) {
        for (FunctionContainer fc : this.accessFunctionsList()) {
            if (!fc.fID.equals(fID)) continue;
            fc.simpleExpression = expression;
            fc.correct = correct;
            fc.enabled = enabled;
            return true;
        }
        return false;
    }

    public FunctionContainer getFunctionContainer(String fID) {
        for (FunctionContainer fc : this.accessFunctionsList()) {
            if (!fc.fID.equals(fID)) continue;
            return fc;
        }
        return null;
    }

    public FunctionContainer getFunctionContainer(Arc arc) {
        for (FunctionContainer fc : this.accessFunctionsList()) {
            if (!fc.arc.equals(arc)) continue;
            return fc;
        }
        return null;
    }
}

