/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.ElementDraw;
import holmes.graphpanel.ElementDrawSettings;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.containers.PlaceGraphicsContainer;
import holmes.petrinet.elements.containers.PlaceQSimContainer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;

public class Place
extends Node {
    private static final long serialVersionUID = 2346995422046987174L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    protected PlaceType placeType = PlaceType.PN;
    protected static int realRadius = 18;
    protected int tokensNumber = 0;
    protected int reservedTokens = 0;
    public PlaceGraphicsContainer drawGraphBoxP = new PlaceGraphicsContainer();
    public PlaceQSimContainer qSimBoxP = new PlaceQSimContainer();
    public boolean isColored = false;
    protected boolean isXTPN = false;
    protected double ssaValue = 0.0;
    protected boolean isConcentration = false;

    public Place(int nodeId, int sheetId, Point placePosition) {
        super(sheetId, nodeId, placePosition, realRadius);
        this.setName("Place" + IdGenerator.getNextPlaceId());
        this.setType(PetriNetElement.PetriNetElementType.PLACE);
    }

    public Place(int nodeId, ArrayList<ElementLocation> elementLocations, String name, String comment, int tokensNumber) {
        super(nodeId, elementLocations, realRadius);
        this.setName(name);
        this.setComment(comment);
        this.setTokensNumber(tokensNumber);
        this.setType(PetriNetElement.PetriNetElementType.PLACE);
    }

    public Place(int nodeId, ArrayList<ElementLocation> elementLocations) {
        super(nodeId, elementLocations, realRadius);
        this.setName("Place" + IdGenerator.getNextPlaceId());
        this.setType(PetriNetElement.PetriNetElementType.PLACE);
    }

    @Override
    public void draw(Graphics2D g, int sheetId, ElementDrawSettings eds) {
        ElementDraw.drawElement(this, g, sheetId, eds);
    }

    public ArrayList<Transition> getInputTransitions() {
        ArrayList<Transition> preTransitions = new ArrayList<Transition>();
        for (ElementLocation el : this.getElementLocations()) {
            for (Arc arc : el.getInArcs()) {
                Node n = arc.getStartNode();
                if (preTransitions.contains((Transition)n)) continue;
                preTransitions.add((Transition)n);
            }
        }
        return preTransitions;
    }

    public ArrayList<Transition> getOutputTransitions() {
        ArrayList<Transition> postTransitions = new ArrayList<Transition>();
        for (ElementLocation el : this.getElementLocations()) {
            for (Arc arc : el.getOutArcs()) {
                Node n = arc.getEndNode();
                if (postTransitions.contains((Transition)n)) continue;
                postTransitions.add((Transition)n);
            }
        }
        return postTransitions;
    }

    public int getTokensNumber() {
        return this.tokensNumber;
    }

    public void setTokensNumber(int tokensNumber) {
        this.tokensNumber = tokensNumber;
        if (tokensNumber < 0) {
            String strB = "err.";
            try {
                strB = String.format(lang.getText("LOGentry00389"), this.getName(), this.getTokensNumber());
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00389", "error", true);
            }
            overlord.log(strB, "error", true);
        }
    }

    public void addTokensNumber(int delta) {
        if (this.tokensNumber + delta < 0) {
            this.tokensNumber = 0;
            overlord.log(lang.getText("LOGentry00390") + " " + this.getName(), "error", true);
        } else {
            this.tokensNumber += delta;
        }
    }

    public int getReservedTokens() {
        return this.reservedTokens;
    }

    public void reserveTokens(int tokensTaken) {
        this.reservedTokens += tokensTaken;
    }

    public int getNonReservedTokensNumber() {
        return this.tokensNumber - this.getReservedTokens();
    }

    public void freeReservedTokens() {
        this.reservedTokens = 0;
    }

    public PlaceType getPlaceType() {
        return this.placeType;
    }

    public void setPlaceType(PlaceType value) {
        this.placeType = value;
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name == null) {
            return "(P)null";
        }
        return "(P" + overlord.getWorkspace().getProject().getPlaces().indexOf(this) + ")";
    }

    public void setSSAvalue(double value) {
        this.ssaValue = value;
    }

    public double getSSAvalue() {
        return this.ssaValue;
    }

    public void setSSAconcentrationStatus(boolean value) {
        this.isConcentration = value;
    }

    public boolean isSSAconcentration() {
        return this.isConcentration;
    }

    public static enum PlaceType {
        PN,
        CPN,
        XTPN;

    }
}

