/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.settings.SettingsManager;
import holmes.graphpanel.EditorResources;
import holmes.graphpanel.ElementDrawSettings;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.utilities.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

public abstract class Node
extends PetriNetElement {
    private static final long serialVersionUID = -8569201372990876149L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<ElementLocation> elementLocations = new ArrayList();
    private ArrayList<ElementLocation> namesLocations = new ArrayList();
    private ArrayList<ElementLocation> alphaLocations = new ArrayList();
    private ArrayList<ElementLocation> betaLocations = new ArrayList();
    private ArrayList<ElementLocation> gammaLocations = new ArrayList();
    private ArrayList<ElementLocation> tauLocations = new ArrayList();
    private boolean isPortal = false;
    protected boolean invisible = false;
    private int radius = 20;
    public boolean qSimArcSign = false;
    public Color branchColor = null;
    public ArrayList<Color> branchBorderColors = new ArrayList();
    private static final Font f_Big = new Font("TimesRoman", 1, 14);
    private static final Font f_BigL = new Font("TimesRoman", 0, 14);
    private static final Font f_SmallL = new Font("TimesRoman", 1, 12);

    public Node(int sheetId, int nodeId, Point nodePosition, int radius) {
        this.setRadius(radius);
        this.setID(nodeId);
        this.getNodeLocations().add(new ElementLocation(sheetId, nodePosition, this));
        this.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(sheetId, new Point(0, 0), this));
        this.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(sheetId, new Point(0, 0), this));
        this.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(sheetId, new Point(0, 0), this));
        this.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(sheetId, new Point(0, 0), this));
        this.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(sheetId, new Point(0, 0), this));
    }

    public Node(int nodeId, ArrayList<ElementLocation> elementLocations, int radius) {
        this.setRadius(radius);
        this.setID(nodeId);
        for (ElementLocation el : elementLocations) {
            el.setParentNode(this);
        }
        this.setElementLocations(elementLocations);
        if (elementLocations.size() > 1) {
            this.setPortal(true);
        }
    }

    public Node(int nodeId, ElementLocation elementLocation, int radius) {
        this.setRadius(radius);
        this.setID(nodeId);
        elementLocation.setParentNode(this);
        this.getElementLocations().add(elementLocation);
        this.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(elementLocation.getSheetID(), new Point(0, 0), this));
    }

    public ArrayList<Point> getNodePositions(int sheetId) {
        ArrayList<Point> returnPoints = new ArrayList<Point>();
        for (ElementLocation e : this.getNodeLocations()) {
            if (e.getSheetID() != sheetId) continue;
            returnPoints.add(e.getPosition());
        }
        return returnPoints;
    }

    public ArrayList<Point> getNodeNamePositions(int sheetId, GUIManager.locationMoveType nameType) {
        ArrayList<Point> returnPoints = new ArrayList<Point>();
        for (ElementLocation e : this.getTextsLocations(nameType)) {
            if (e.getSheetID() != sheetId) continue;
            returnPoints.add(e.getPosition());
        }
        return returnPoints;
    }

    public ArrayList<ElementLocation> getNodeLocations(int sheetId) {
        ArrayList<ElementLocation> returnPoints = new ArrayList<ElementLocation>();
        for (ElementLocation e : this.getElementLocations()) {
            if (e.getSheetID() != sheetId) continue;
            returnPoints.add(e);
        }
        return returnPoints;
    }

    public ElementLocation getLastLocation() {
        if (this.getNodeLocations().isEmpty()) {
            return null;
        }
        return this.getNodeLocations().get(this.getNodeLocations().size() - 1);
    }

    public void draw(Graphics2D g, int sheetId, ElementDrawSettings eds) {
        g.setColor(Color.black);
        g.setFont(new Font("Tahoma", 0, 11));
        int width = g.getFontMetrics().stringWidth(this.getName());
        for (Point p : this.getNodePositions(sheetId)) {
            g.drawString(this.getName(), p.x - width / 2, p.y + this.getRadius() + 15);
        }
    }

    public void drawPortalLines(Graphics2D g, int sheetId, ElementDrawSettings eds) {
        block6: {
            block5: {
                g.setColor(EditorResources.selectionColorLevel2);
                g.setStroke(EditorResources.glowStrokeLevel2);
                if (!(this instanceof Place)) break block5;
                Place p = (Place)this;
                if (!p.isPortal()) break block6;
                ArrayList<ElementLocation> nodeLocations = this.getNodeLocations(sheetId);
                for (int i = 0; i < nodeLocations.size(); ++i) {
                    if (!nodeLocations.get(i).isSelected()) continue;
                    Point nodePoint = nodeLocations.get(i).getPosition();
                    for (ElementLocation nodeLocation : nodeLocations) {
                        if (nodeLocations.get(i) == nodeLocation) continue;
                        Point nodePoint2 = nodeLocation.getPosition();
                        g.drawLine(nodePoint.x, nodePoint.y, nodePoint2.x, nodePoint2.y);
                    }
                    return;
                }
                break block6;
            }
            if (this instanceof Transition) {
                Transition t = (Transition)this;
                ArrayList<ElementLocation> nodeLocations = this.getNodeLocations(sheetId);
                for (int i = 0; i < nodeLocations.size(); ++i) {
                    if (!nodeLocations.get(i).isSelected()) continue;
                    Point nodePoint = nodeLocations.get(i).getPosition();
                    for (ElementLocation nodeLocation : nodeLocations) {
                        if (nodeLocations.get(i) == nodeLocation) continue;
                        Point nodePoint2 = nodeLocation.getPosition();
                        g.drawLine(nodePoint.x, nodePoint.y, nodePoint2.x, nodePoint2.y);
                    }
                    return;
                }
            }
        }
    }

    public void drawName(Graphics2D g, int sheetId, ArrayList<Node> places, ArrayList<Node> transitions, ArrayList<Node> timeTransitions, ArrayList<Node> metanodes) {
        block41: {
            int drawY;
            int drawX;
            ArrayList<Point> nodePoints;
            block40: {
                Point nodePoint;
                int i;
                SettingsManager sm = overlord.getSettingsManager();
                boolean lowerIndexID = sm.getValue("editorShortNameLowerIndex").equals("1");
                Object name = this.getName();
                Object xtpnID = "";
                int add_transY = 0;
                if (sm.getValue("editorShowShortNames").equals("1")) {
                    if (this instanceof Place) {
                        x = places.indexOf(this);
                        if (lowerIndexID) {
                            xtpnID = "" + x;
                            name = "p";
                        } else {
                            name = "p" + x;
                        }
                    } else if (this instanceof Transition) {
                        x = transitions.indexOf(this);
                        if (lowerIndexID) {
                            xtpnID = "" + x;
                            name = "t";
                        } else {
                            name = "t" + x;
                        }
                    } else {
                        x = metanodes.indexOf(this);
                        name = "M" + x;
                    }
                }
                if (this instanceof Transition) {
                    add_transY = 3;
                }
                g.setColor(Color.black);
                if (sm.getValue("editorGraphFontBold").equals("0")) {
                    g.setFont(new Font("Tahoma", 0, Integer.parseInt(sm.getValue("editorGraphFontSize"))));
                } else {
                    g.setFont(new Font("Tahoma", 1, Integer.parseInt(sm.getValue("editorGraphFontSize"))));
                }
                int name_width = g.getFontMetrics().stringWidth((String)name);
                nodePoints = this.getNodePositions(sheetId);
                ArrayList<Point> namesPoints = this.getNodeNamePositions(sheetId, GUIManager.locationMoveType.NAME);
                for (i = 0; i < nodePoints.size(); ++i) {
                    nodePoint = nodePoints.get(i);
                    Point namePoint = namesPoints.get(i);
                    drawX = nodePoint.x - name_width / 2 + namePoint.x;
                    drawY = nodePoint.y + this.getRadius() + 15 + namePoint.y;
                    if (drawX < 0) {
                        drawX = nodePoint.x - name_width / 2;
                    }
                    if (drawY < 0) {
                        drawY = nodePoint.y + this.getRadius() + 15;
                    }
                    if (lowerIndexID) {
                        int size = Integer.parseInt(sm.getValue("editorGraphFontSize"));
                        int offset = 0;
                        if (size > 16) {
                            offset += 2;
                        }
                        if (size > 19) {
                            offset += 2;
                        }
                        if (this instanceof Transition) {
                            g.drawString((String)name, drawX, drawY + add_transY);
                            g.drawString((String)xtpnID, drawX + 8 + offset, drawY + add_transY + 5);
                            continue;
                        }
                        if (!(this instanceof Place)) continue;
                        g.drawString((String)name, drawX, drawY + add_transY);
                        g.drawString((String)xtpnID, drawX + 10 + offset, drawY + add_transY + 5);
                        continue;
                    }
                    g.drawString((String)name, drawX, drawY + add_transY);
                }
                if (!(this instanceof Place)) break block40;
                if (!(this instanceof PlaceXTPN)) break block41;
                for (i = 0; i < this.gammaLocations.size(); ++i) {
                    if (this.gammaLocations.get(i).getSheetID() != sheetId) continue;
                    nodePoint = nodePoints.get(i);
                    Point gammaPoint = this.gammaLocations.get(i).getPosition();
                    drawX = nodePoint.x + gammaPoint.x - 50;
                    drawY = nodePoint.y + gammaPoint.y - 24;
                    if (((PlaceXTPN)this).isGammaModeActive()) {
                        if (!((PlaceXTPN)this).isGammaRangeVisible()) continue;
                        int franctionDigits = ((PlaceXTPN)this).getFractionForPlaceXTPN();
                        g.setColor(EditorResources.gammaColor);
                        g.setFont(f_BigL);
                        double gamma = ((PlaceXTPN)this).getGammaMaxValue();
                        String gammaMaxVal = "\u221e";
                        if (gamma < 2.147483645E9) {
                            gammaMaxVal = Tools.cutValueExt(((PlaceXTPN)this).getGammaMaxValue(), franctionDigits);
                        }
                        String gammaStr = "\u03b3: [" + Tools.cutValueExt(((PlaceXTPN)this).getGammaMinValue(), franctionDigits) + ", " + gammaMaxVal + "]";
                        g.drawString(gammaStr, drawX, drawY);
                        continue;
                    }
                    g.setColor(Color.GRAY);
                    g.setFont(f_SmallL);
                    g.drawString("(NORMAL PLACE)", drawX, drawY);
                }
                break block41;
            }
            if (this instanceof Transition && this instanceof TransitionXTPN) {
                int drawY2;
                int drawX2;
                Point nodePoint;
                int i;
                TransitionXTPN transXTPN = (TransitionXTPN)this;
                if (this.alphaLocations.size() + this.betaLocations.size() - this.tauLocations.size() - this.namesLocations.size() != 0) {
                    overlord.log(lang.getText("LOGentry00377critErr"), "error", true);
                    return;
                }
                if (transXTPN.qSimXTPN.showQSimXTPN) {
                    for (i = 0; i < this.alphaLocations.size(); ++i) {
                        if (this.namesLocations.get(i).getSheetID() != sheetId) continue;
                        nodePoint = nodePoints.get(i);
                        drawX = nodePoint.x + transXTPN.qSimXTPN.xOff - 40;
                        drawY = nodePoint.y + transXTPN.qSimXTPN.yOff;
                        g.drawString(transXTPN.qSimXTPN.text1, drawX, drawY);
                        g.drawString(transXTPN.qSimXTPN.text2, drawX, drawY + 15);
                        g.drawString(transXTPN.qSimXTPN.text3, drawX, drawY + 30);
                        g.drawString(transXTPN.qSimXTPN.text4, drawX, drawY + 45);
                    }
                } else {
                    for (i = 0; i < this.alphaLocations.size(); ++i) {
                        if (this.namesLocations.get(i).getSheetID() != sheetId) continue;
                        nodePoint = nodePoints.get(i);
                        if (transXTPN.isAlphaModeActive() && transXTPN.isAlphaRangeVisible()) {
                            Point alphaPoint = this.alphaLocations.get(i).getPosition();
                            drawX2 = nodePoint.x + alphaPoint.x - 40;
                            drawY2 = nodePoint.y + alphaPoint.y - 28;
                            if (transXTPN.isAlphaModeActive()) {
                                g.setColor(EditorResources.alphaColor);
                                g.setFont(f_BigL);
                                String alfa = "\u03b1: [" + Tools.cutValueExt(transXTPN.getAlphaMinValue(), transXTPN.getFraction_xTPN()) + ", " + Tools.cutValueExt(transXTPN.getAlphaMaxValue(), transXTPN.getFraction_xTPN()) + "]";
                                if (!transXTPN.isBetaModeActive()) {
                                    g.drawString(alfa, drawX2, drawY2);
                                } else {
                                    g.drawString(alfa, drawX2, drawY2 - 16);
                                }
                            }
                        }
                        if (!transXTPN.isBetaModeActive() || !transXTPN.isBetaRangeVisible()) continue;
                        Point betaPoint = this.betaLocations.get(i).getPosition();
                        drawX2 = nodePoint.x + betaPoint.x - 40;
                        drawY2 = nodePoint.y + betaPoint.y - 28;
                        if (!transXTPN.isBetaModeActive()) continue;
                        g.setFont(f_BigL);
                        g.setColor(EditorResources.betaColor);
                        String beta = "\u03b2: [" + Tools.cutValueExt(transXTPN.getBetaMinValue(), transXTPN.getFraction_xTPN()) + ", " + Tools.cutValueExt(transXTPN.getBetaMaxValue(), transXTPN.getFraction_xTPN()) + "]";
                        g.drawString(beta, drawX2, drawY2);
                    }
                }
                for (i = 0; i < this.alphaLocations.size(); ++i) {
                    Object timerB;
                    Object timerA;
                    if (this.namesLocations.get(i).getSheetID() != sheetId) continue;
                    nodePoint = nodePoints.get(i);
                    if (!transXTPN.isTauTimerVisible()) continue;
                    Point tauPoint = this.tauLocations.get(i).getPosition();
                    drawX2 = nodePoint.x + tauPoint.x - 5;
                    drawY2 = nodePoint.y + tauPoint.y - 15;
                    g.setFont(f_BigL);
                    if (!transXTPN.isTauTimerVisible()) continue;
                    double alphaTime = transXTPN.getTauAlphaValue();
                    double betaTime = transXTPN.getTauBetaValue();
                    double u_alfaTime = transXTPN.getTimerAlfaValue();
                    double v_betaTime = transXTPN.getTimerBetaValue();
                    boolean isAlpha = transXTPN.isAlphaModeActive();
                    boolean isBeta = transXTPN.isBetaModeActive();
                    g.setColor(EditorResources.tauColor);
                    if (alphaTime < 0.0 && betaTime < 0.0) {
                        if (isAlpha) {
                            timerA = "\u03c4(\u03b1): #\u279f#";
                            g.drawString((String)timerA, drawX2 + 40, drawY2 + 12);
                        }
                        if (!isBeta) continue;
                        timerB = "\u03c4(\u03b2): #\u279f#";
                        g.drawString((String)timerB, drawX2 + 40, drawY2 + 26);
                        continue;
                    }
                    if (alphaTime < 0.0) {
                        if (isAlpha) {
                            timerA = "\u03c4(\u03b1): #\u279f#";
                            g.drawString((String)timerA, drawX2 + 40, drawY2 + 12);
                        }
                        if (!isBeta) continue;
                        timerB = "\u03c4(\u03b2): " + Tools.cutValueExt(v_betaTime, transXTPN.getFraction_xTPN()) + "\u279f" + Tools.cutValueExt(betaTime, transXTPN.getFraction_xTPN());
                        g.drawString((String)timerB, drawX2 + 40, drawY2 + 26);
                        continue;
                    }
                    if (betaTime < 0.0) {
                        if (isAlpha) {
                            timerA = "\u03c4(\u03b1): " + Tools.cutValueExt(u_alfaTime, transXTPN.getFraction_xTPN()) + "\u279f" + Tools.cutValueExt(alphaTime, transXTPN.getFraction_xTPN());
                            g.drawString((String)timerA, drawX2 + 40, drawY2 + 12);
                        }
                        if (!isBeta) continue;
                        timerB = "\u03c4(\u03b2): #\u279f#";
                        g.drawString((String)timerB, drawX2 + 40, drawY2 + 26);
                        continue;
                    }
                    if (isAlpha) {
                        timerA = "\u03c4(\u03b1): " + Tools.cutValueExt(u_alfaTime, transXTPN.getFraction_xTPN()) + "\u279f" + Tools.cutValueExt(alphaTime, transXTPN.getFraction_xTPN());
                        g.drawString((String)timerA, drawX2 + 40, drawY2 + 12);
                    }
                    if (!isBeta) continue;
                    timerB = "\u03c4(\u03b2): " + Tools.cutValueExt(v_betaTime, transXTPN.getFraction_xTPN()) + "\u279f" + Tools.cutValueExt(betaTime, transXTPN.getFraction_xTPN());
                    g.drawString((String)timerB, drawX2 + 40, drawY2 + 26);
                }
            }
        }
    }

    public boolean contains(Point point, int sheetId) {
        for (Point p : this.getNodePositions(sheetId)) {
            if (p.x - this.getRadius() >= point.x || p.y - this.getRadius() >= point.y || p.x + this.getRadius() <= point.x || p.y + this.getRadius() <= point.y) continue;
            return true;
        }
        return false;
    }

    public ElementLocation getLocationWhichContains(Point point, int sheetId, int additionalRange) {
        for (ElementLocation e : this.getNodeLocations(sheetId)) {
            if (e.getPosition().x - this.getRadius() - additionalRange >= point.x || e.getPosition().y - this.getRadius() - additionalRange >= point.y || e.getPosition().x + this.getRadius() + additionalRange <= point.x || e.getPosition().y + this.getRadius() + additionalRange <= point.y) continue;
            return e;
        }
        return null;
    }

    public ArrayList<ElementLocation> getLocationsWhichAreContained(Rectangle rectangle, int sheetId) {
        ArrayList<ElementLocation> returnElementLocations = new ArrayList<ElementLocation>();
        for (ElementLocation el : this.getNodeLocations(sheetId)) {
            if (!rectangle.contains(el.getPosition())) continue;
            returnElementLocations.add(el);
        }
        return returnElementLocations;
    }

    public void selectAllPortals() {
        if (!this.isPortal()) {
            return;
        }
        for (ElementLocation el : this.getNodeLocations()) {
            if (el.isSelected()) continue;
            el.setPortalSelected(true);
        }
    }

    public void deselectAllPortals() {
        if (!this.isPortal()) {
            return;
        }
        for (ElementLocation el : this.getNodeLocations()) {
            el.setPortalSelected(false);
        }
    }

    public void forceDeselection() {
        if (!this.isPortal()) {
            return;
        }
        for (ElementLocation el : this.getNodeLocations()) {
            el.setPortalSelected(false);
            el.setSelected(false);
        }
    }

    public boolean checkAllPortalsSelection() {
        if (!this.isPortal()) {
            return false;
        }
        for (ElementLocation el : this.getNodeLocations()) {
            if (!el.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isPortal() {
        return this.isPortal;
    }

    public void setPortal(boolean isPortal) {
        this.isPortal = isPortal;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public ArrayList<ElementLocation> getNodeLocations() {
        return this.getElementLocations();
    }

    public boolean removeElementLocation(ElementLocation el) {
        int nodeElLocIndex = this.getNodeLocations().indexOf(el);
        this.getTextsLocations(GUIManager.locationMoveType.NAME).remove(nodeElLocIndex);
        if (el.getParentNode() instanceof PlaceXTPN || el.getParentNode() instanceof TransitionXTPN) {
            this.getTextsLocations(GUIManager.locationMoveType.ALPHA).remove(nodeElLocIndex);
            this.getTextsLocations(GUIManager.locationMoveType.BETA).remove(nodeElLocIndex);
            this.getTextsLocations(GUIManager.locationMoveType.GAMMA).remove(nodeElLocIndex);
            this.getTextsLocations(GUIManager.locationMoveType.TAU).remove(nodeElLocIndex);
        }
        this.getNodeLocations().remove(el);
        int subNet = el.getSheetID();
        if (subNet > 0) {
            boolean found = false;
            for (ElementLocation element : this.getElementLocations()) {
                if (element.getSheetID() != subNet) continue;
                found = true;
                break;
            }
            if (!found) {
                Node.overlord.subnetsHQ.clearAllMetaArcs(this, subNet);
            }
        }
        return !this.getNodeLocations().isEmpty();
    }

    public ArrayList<Arc> getInputArcs() {
        ArrayList<Arc> totalInArcs = new ArrayList<Arc>();
        for (ElementLocation location : this.getNodeLocations()) {
            totalInArcs.addAll(location.getInArcs());
        }
        return totalInArcs;
    }

    public ArrayList<Arc> getOutputArcs() {
        ArrayList<Arc> totalOutArcs = new ArrayList<Arc>();
        for (ElementLocation location : this.getNodeLocations()) {
            totalOutArcs.addAll(location.getOutArcs());
        }
        return totalOutArcs;
    }

    public ArrayList<Node> getInputNodes() {
        ArrayList<Node> totalInNodes = new ArrayList<Node>();
        for (Arc arc : this.getInputArcs()) {
            totalInNodes.add(arc.getStartNode());
        }
        return totalInNodes;
    }

    public ArrayList<Node> getOutputNodes() {
        ArrayList<Node> totalOutNodes = new ArrayList<Node>();
        for (Arc arc : this.getOutputArcs()) {
            totalOutNodes.add(arc.getEndNode());
        }
        return totalOutNodes;
    }

    public ArrayList<Node> getNeighborsNodes() {
        ArrayList<Node> totalNodes = new ArrayList<Node>();
        for (Arc arc : this.getOutputArcs()) {
            totalNodes.add(arc.getEndNode());
        }
        for (Arc arc : this.getInputArcs()) {
            totalNodes.add(arc.getStartNode());
        }
        return totalNodes;
    }

    public String toString() {
        String type = this instanceof Place ? "(P)" : (this instanceof Transition ? "(T)" : (this instanceof MetaNode ? "(M)" : "(?)"));
        return "ID: " + this.getID() + type;
    }

    public ArrayList<ElementLocation> getElementLocations() {
        return this.elementLocations;
    }

    public void setElementLocations(ArrayList<ElementLocation> elementLocations) {
        this.elementLocations = elementLocations;
    }

    public ArrayList<ElementLocation> getTextsLocations(GUIManager.locationMoveType dataType) {
        return switch (dataType) {
            case GUIManager.locationMoveType.ALPHA -> this.alphaLocations;
            case GUIManager.locationMoveType.BETA -> this.betaLocations;
            case GUIManager.locationMoveType.GAMMA -> this.gammaLocations;
            case GUIManager.locationMoveType.TAU -> this.tauLocations;
            default -> this.namesLocations;
        };
    }

    public void setTextsLocations(ArrayList<ElementLocation> namesLocations, GUIManager.locationMoveType nameType) {
        switch (nameType) {
            case ALPHA: {
                this.alphaLocations = namesLocations;
                break;
            }
            case BETA: {
                this.betaLocations = namesLocations;
                break;
            }
            case GAMMA: {
                this.gammaLocations = namesLocations;
                break;
            }
            case TAU: {
                this.tauLocations = namesLocations;
                break;
            }
            default: {
                this.namesLocations = namesLocations;
            }
        }
    }

    public int getTextLocation_X(int index, GUIManager.locationMoveType nameType) {
        switch (nameType) {
            case NAME: {
                if (index >= this.namesLocations.size()) {
                    overlord.log(lang.getText("LOGentry00378critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.namesLocations.get((int)index).getPosition().x;
            }
            case ALPHA: {
                if (index >= this.alphaLocations.size()) {
                    overlord.log(lang.getText("LOGentry00379critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.alphaLocations.get((int)index).getPosition().x;
            }
            case BETA: {
                if (index >= this.betaLocations.size()) {
                    overlord.log(lang.getText("LOGentry00380critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.betaLocations.get((int)index).getPosition().x;
            }
            case GAMMA: {
                if (index >= this.gammaLocations.size()) {
                    overlord.log(lang.getText("LOGentry00381critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.gammaLocations.get((int)index).getPosition().x;
            }
            case TAU: {
                if (index >= this.tauLocations.size()) {
                    overlord.log(lang.getText("LOGentry00382critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.tauLocations.get((int)index).getPosition().x;
            }
        }
        if (index >= this.namesLocations.size()) {
            overlord.log(lang.getText("LOGentry00383critErr") + " " + this.getName(), "error", true);
            return 0;
        }
        return this.namesLocations.get((int)index).getPosition().x;
    }

    public int getTextLocation_Y(int index, GUIManager.locationMoveType nameType) {
        switch (nameType) {
            case ALPHA: {
                if (index >= this.alphaLocations.size()) {
                    overlord.log(lang.getText("LOGentry00384critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.alphaLocations.get((int)index).getPosition().y;
            }
            case BETA: {
                if (index >= this.betaLocations.size()) {
                    overlord.log(lang.getText("LOGentry00385critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.betaLocations.get((int)index).getPosition().y;
            }
            case GAMMA: {
                if (index >= this.gammaLocations.size()) {
                    overlord.log(lang.getText("LOGentry00386critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.gammaLocations.get((int)index).getPosition().y;
            }
            case TAU: {
                if (index >= this.tauLocations.size()) {
                    overlord.log(lang.getText("LOGentry00387critErr") + " " + this.getName(), "error", true);
                    return 0;
                }
                return this.tauLocations.get((int)index).getPosition().y;
            }
        }
        if (index >= this.namesLocations.size()) {
            overlord.log(lang.getText("LOGentry00388critErr") + " " + this.getName(), "error", true);
            return 0;
        }
        return this.namesLocations.get((int)index).getPosition().y;
    }

    public void setInvisibility(boolean status) {
        this.invisible = status;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public ArrayList<Arc> getNeighborsArcs() {
        ArrayList<Arc> totalInArcs = new ArrayList<Arc>();
        for (ElementLocation location : this.getNodeLocations()) {
            totalInArcs.addAll(location.getInArcs());
            totalInArcs.addAll(location.getOutArcs());
        }
        return totalInArcs;
    }
}

