/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SSAplacesVector;
import holmes.petrinet.elements.Place;
import java.util.ArrayList;

public class SSAplacesManager {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private PetriNet pn;
    private ArrayList<SSAplacesVector> ssaMatrix;
    public int selectedSSAvector = 0;

    public SSAplacesManager(PetriNet net) {
        this.pn = net;
        this.ssaMatrix = new ArrayList();
        this.ssaMatrix.add(new SSAplacesVector());
    }

    public void addPlace() {
        for (SSAplacesVector pVector : this.ssaMatrix) {
            pVector.addPlace(0.0);
        }
    }

    public boolean removePlace(int index) {
        if (index >= this.ssaMatrix.get(0).getSize()) {
            return false;
        }
        for (SSAplacesVector pVector : this.ssaMatrix) {
            boolean status = pVector.removePlace(index);
            if (status) continue;
            overlord.log(lang.getText("LOGentry00376critErr"), "error", true);
            return false;
        }
        return true;
    }

    public SSAplacesVector getSSAvector(int index) {
        if (index >= this.ssaMatrix.size()) {
            return null;
        }
        return this.ssaMatrix.get(index);
    }

    public SSAplacesVector getCurrentSSAvector() {
        return this.ssaMatrix.get(this.selectedSSAvector);
    }

    public void addCurrentStateAsSSAvector() {
        SSAplacesVector pVector = new SSAplacesVector();
        for (Place place : this.pn.getPlaces()) {
            pVector.addPlace(place.getSSAvalue());
        }
        this.ssaMatrix.add(pVector);
    }

    public void createCleanSSAvector() {
        this.reset(false);
        int placesNumber = this.pn.getPlacesNumber();
        for (int p = 0; p < placesNumber; ++p) {
            this.ssaMatrix.get(0).addPlace(0.0);
        }
    }

    public void setNetworkSSAvector(int stateID) {
        ArrayList<Place> places = this.pn.getPlaces();
        SSAplacesVector psVector = this.ssaMatrix.get(stateID);
        for (int p = 0; p < places.size(); ++p) {
            Place place = places.get(p);
            place.setSSAvalue(psVector.getTokens(p));
        }
        this.selectedSSAvector = stateID;
    }

    public void restoreCurrentSSAvector() {
        ArrayList<Place> places = this.pn.getPlaces();
        SSAplacesVector psVector = this.ssaMatrix.get(this.selectedSSAvector);
        for (int p = 0; p < places.size(); ++p) {
            Place place = places.get(p);
            place.setSSAvalue(psVector.getTokens(p));
        }
    }

    public void removeSSAvector(int stateID) {
        this.ssaMatrix.remove(stateID);
        this.selectedSSAvector = 0;
    }

    public void replaceSSAvectorWithNetState(int stateID) {
        ArrayList<Place> places = this.pn.getPlaces();
        SSAplacesVector psVector = this.ssaMatrix.get(stateID);
        for (int p = 0; p < places.size(); ++p) {
            psVector.accessVector().set(p, places.get(p).getSSAvalue());
        }
    }

    public String getSSAvectorDescription(int selected) {
        return this.ssaMatrix.get(selected).getDescription();
    }

    public void setSSAvectorDescription(int selected, String newText) {
        this.ssaMatrix.get(selected).setDescription(newText);
    }

    public ArrayList<SSAplacesVector> accessSSAmatrix() {
        return this.ssaMatrix;
    }

    public void reset(boolean isLoading) {
        this.ssaMatrix = new ArrayList();
        if (!isLoading) {
            this.ssaMatrix.add(new SSAplacesVector());
        }
        this.selectedSSAvector = 0;
    }
}

