/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.SPNtransitionData;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import java.util.ArrayList;

public class SPNdataVector {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<SPNtransitionData> dataVector = new ArrayList();
    private SPNvectorSuperType SPNvectorType = SPNvectorSuperType.SPN;
    private String SPNvectorDescription = lang.getText("SPNDV_entry001");

    public SPNtransitionData newContainer(String frFunction, TransitionSPNExtension.StochaticsType subType) {
        return new SPNtransitionData(frFunction, subType);
    }

    public SPNtransitionData newContainer() {
        return new SPNtransitionData();
    }

    public SPNtransitionData getSPNtransitionContainer(int index) {
        if (index >= this.dataVector.size()) {
            return null;
        }
        return this.dataVector.get(index);
    }

    public void addTrans(String value, TransitionSPNExtension.StochaticsType sType) {
        this.dataVector.add(new SPNtransitionData(value, sType));
    }

    public boolean removeTrans(int index) {
        if (index >= this.dataVector.size()) {
            return false;
        }
        this.dataVector.remove(index);
        return true;
    }

    public int getSize() {
        return this.dataVector.size();
    }

    public double getFiringRate(int index) {
        if (index >= this.dataVector.size()) {
            return -1.0;
        }
        try {
            return Double.parseDouble(this.dataVector.get((int)index).ST_function);
        }
        catch (Exception e) {
            String strB = "err.";
            try {
                strB = String.format(lang.getText("LOGentry00374exception"), index);
            }
            catch (Exception ex2) {
                overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00374exception", "error", true);
            }
            overlord.log(strB + "\n" + e.getMessage(), "warning", true);
            return 1.0;
        }
    }

    public TransitionSPNExtension.StochaticsType getStochasticType(int index) {
        if (index >= this.dataVector.size()) {
            return TransitionSPNExtension.StochaticsType.ST;
        }
        return this.dataVector.get((int)index).sType;
    }

    public void setDescription(String description) {
        this.SPNvectorDescription = description;
    }

    public String getDescription() {
        return this.SPNvectorDescription;
    }

    public void setSyperType(SPNvectorSuperType type) {
        this.SPNvectorType = type;
    }

    public SPNvectorSuperType getSuperType() {
        return this.SPNvectorType;
    }

    public void setSPNtype(SPNvectorSuperType type) {
        this.SPNvectorType = type;
    }

    public SPNvectorSuperType getSPNtype() {
        return this.SPNvectorType;
    }

    public ArrayList<SPNtransitionData> accessVector() {
        return this.dataVector;
    }

    public static enum SPNvectorSuperType {
        SPN,
        SSA;

    }
}

