/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.NetSimulationData;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class NetSimulationDataCore
implements Serializable {
    private static final long serialVersionUID = -2180386709205258057L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<NetSimulationData> referenceSets = new ArrayList();
    private ArrayList<NetSimulationData> knockoutSets = new ArrayList();
    private ArrayList<Long> seriesData = new ArrayList();
    public boolean saved = false;

    public boolean addNewReferenceSet(NetSimulationData refSet) {
        this.referenceSets.add(refSet);
        this.saved = false;
        return true;
    }

    public ArrayList<NetSimulationData> accessReferenceSets() {
        return this.referenceSets;
    }

    public NetSimulationData getReferenceSet(int index) {
        if (index < this.referenceSets.size()) {
            return this.referenceSets.get(index);
        }
        return null;
    }

    public boolean addNewDataSet(NetSimulationData refSet) {
        this.knockoutSets.add(refSet);
        this.saved = false;
        return true;
    }

    public ArrayList<NetSimulationData> accessKnockoutDataSets() {
        return this.knockoutSets;
    }

    public NetSimulationData getKnockoutSet(int index) {
        if (index < this.knockoutSets.size()) {
            return this.knockoutSets.get(index);
        }
        return null;
    }

    public void addNewSeries(long value) {
        if (!this.seriesData.contains(value)) {
            this.seriesData.add(value);
        }
    }

    public ArrayList<Long> accessSeries() {
        return this.seriesData;
    }

    public void removeSeries(long IDseries) {
        int knockSize = this.knockoutSets.size();
        for (int s = 0; s < knockSize; ++s) {
            if (this.knockoutSets.get(s).getIDseries() != IDseries) continue;
            this.knockoutSets.remove(s);
            --s;
            --knockSize;
        }
        this.seriesData.remove(IDseries);
    }

    public NetSimulationData returnSeriesFirst(long IDseries) {
        for (NetSimulationData nsd : this.knockoutSets) {
            if (nsd.getIDseries() != IDseries) continue;
            return nsd;
        }
        return null;
    }

    public ArrayList<NetSimulationData> getSeriesDatasets(long IDseries) {
        ArrayList<NetSimulationData> result = new ArrayList<NetSimulationData>();
        NetSimulationData tmp = this.returnSeriesFirst(IDseries);
        int transSize = tmp.transNumber;
        for (NetSimulationData data : this.knockoutSets) {
            if (data.getIDseries() != IDseries) continue;
            result.add(data);
        }
        if (result.size() != transSize) {
            overlord.log(lang.getText("LOGentry00338"), "error", true);
            return null;
        }
        return result;
    }

    public boolean loadDataSets() {
        NetSimulationDataCore core = new NetSimulationDataCore();
        String lastPath = overlord.getLastPath();
        String newLocation = "";
        try {
            FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter("Simulation Data (.sim)", new String[]{"sim"})};
            newLocation = Tools.selectFileDialog(lastPath, filter, lang.getText("NSDC_entry001"), "", "");
            if (newLocation.isEmpty()) {
                return false;
            }
            File test = new File(newLocation);
            if (!test.exists()) {
                return false;
            }
            FileInputStream fis = new FileInputStream(newLocation);
            ObjectInputStream ois = new ObjectInputStream(fis);
            core = (NetSimulationDataCore)ois.readObject();
            ois.close();
            fis.close();
            overlord.getWorkspace().getProject().setNewKnockoutData(core);
            return true;
        }
        catch (Exception ioe) {
            String msg = lang.getText("LOGentry00339exception") + " " + newLocation;
            overlord.log(msg, "error", true);
            overlord.log(ioe.getMessage(), "error", false);
            return false;
        }
    }

    public boolean saveDataSets() {
        try {
            String lastPath = overlord.getLastPath();
            FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter("Simulation Data (.sim)", new String[]{"sim"})};
            Object newLocation = Tools.selectFileDialog(lastPath, filter, lang.getText("NSDC_entry002"), "", "");
            if (((String)newLocation).isEmpty()) {
                return false;
            }
            if (!((String)newLocation).contains(".sim")) {
                newLocation = (String)newLocation + ".sim";
            }
            FileOutputStream fos = new FileOutputStream((String)newLocation);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            NetSimulationDataCore core = overlord.getWorkspace().getProject().accessSimKnockoutData();
            oos.writeObject(core);
            oos.close();
            fos.close();
            return true;
        }
        catch (IOException ioe) {
            overlord.log(lang.getText("LOGentry00340exception") + "\n" + ioe.getMessage(), "error", true);
            return false;
        }
    }
}

