/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public class MultisetM
implements Serializable {
    private static final long serialVersionUID = 2161649872359143583L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private final ArrayList<ArrayList<Double>> multisetM_ArrayLists = new ArrayList();
    private final ArrayList<Integer> placesGammasVector = new ArrayList();
    private String stateType = "XTPN";
    private String stateDescription = lang.getText("MSM_entry001");

    public void clearMultiset() {
        this.multisetM_ArrayLists.clear();
        this.placesGammasVector.clear();
        this.stateType = "XTPN";
        this.stateDescription = lang.getText("MSM_entry001");
    }

    public void addMultiset_K_toMultiset_M(ArrayList<Double> multisetK, int isGammaMode) {
        this.multisetM_ArrayLists.add(multisetK);
        this.placesGammasVector.add(isGammaMode);
    }

    public boolean removePlaceFromMultiset_M(int index) {
        if (index >= this.multisetM_ArrayLists.size()) {
            return false;
        }
        this.multisetM_ArrayLists.remove(index);
        this.placesGammasVector.remove(index);
        return true;
    }

    public int getMultiset_M_Size() {
        return this.multisetM_ArrayLists.size();
    }

    public ArrayList<Double> accessMultiset_K(int index) {
        if (index >= this.multisetM_ArrayLists.size()) {
            return null;
        }
        return this.multisetM_ArrayLists.get(index);
    }

    public void setNewMultiset_K(int index, ArrayList<Double> multisetK, int isGammaMode) {
        if (index < this.multisetM_ArrayLists.size()) {
            this.multisetM_ArrayLists.set(index, multisetK);
            this.placesGammasVector.set(index, isGammaMode);
        }
    }

    public void addTokensMultiset_K(int index, ArrayList<Double> newMultiSetK, boolean sort) {
        if (index < this.multisetM_ArrayLists.size()) {
            ArrayList<Double> oldMultiset = this.multisetM_ArrayLists.get(index);
            oldMultiset.addAll(newMultiSetK);
            if (sort) {
                Collections.sort(oldMultiset);
                Collections.reverse(oldMultiset);
            }
        }
    }

    public boolean isPlaceStoredAsGammaActive(int placeIndex) {
        return this.placesGammasVector.get(placeIndex) == 1;
    }

    public void setPlaceGammaStatus(int placeIndex, boolean isGammaMode) {
        if (isGammaMode) {
            this.placesGammasVector.set(placeIndex, 1);
        } else {
            this.placesGammasVector.set(placeIndex, 0);
        }
    }

    public void addToken(int index, double token) {
        if (index < this.multisetM_ArrayLists.size()) {
            ArrayList<Double> oldMultiset = this.multisetM_ArrayLists.get(index);
            oldMultiset.add(token);
            if (token == 0.0) {
                Collections.sort(oldMultiset);
                Collections.reverse(oldMultiset);
            }
        }
    }

    public void overwriteMultiset_M_withNetState() {
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        int placesNumber = places.size();
        for (int p = 0; p < placesNumber; ++p) {
            if (!(places.get(p) instanceof PlaceXTPN)) {
                overlord.log(lang.getText("LOGentry00337critErr"), "error", true);
                return;
            }
            ArrayList<Double> multiset = ((PlaceXTPN)places.get(p)).accessMultiset();
            ArrayList<Double> newMultiset = new ArrayList<Double>(multiset);
            this.multisetM_ArrayLists.set(p, newMultiset);
            if (((PlaceXTPN)places.get(p)).isGammaModeActive()) {
                this.placesGammasVector.set(p, 1);
                continue;
            }
            this.placesGammasVector.set(p, 1);
        }
    }

    public void setDescription(String description) {
        this.stateDescription = description;
    }

    public String getDescription() {
        return this.stateDescription;
    }

    public void setStateType(String type) {
        this.stateType = type;
    }

    public String getStateType() {
        return this.stateType;
    }

    public ArrayList<ArrayList<Double>> accessArrayListSOfMultiset_M() {
        return this.multisetM_ArrayLists;
    }

    public ArrayList<Integer> accessPlacesGammaVector() {
        return this.placesGammasVector;
    }
}

