/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.analyse.InvariantsTools;
import holmes.analyse.MCTCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import java.util.Collection;

public class MauritiusMap {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    BTNode root = new BTNode();
    ArrayList<Transition> transitions;
    ArrayList<String> transMCTNames;

    public MauritiusMap(ArrayList<ArrayList<Integer>> invariants, int rootTransition, int coverageVal, int mode) {
        this.root.type = NodeType.ROOT;
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.transMCTNames = this.getMCTNamesVector();
        invariants = this.addIndexToInvariants(invariants);
        if (mode == 0) {
            ArrayList<ArrayList<Integer>> antiInvariants = InvariantsTools.returnT_invWithoutTransition(invariants, rootTransition);
            this.createMTreeV2(antiInvariants, rootTransition, this.root);
        } else if (mode == 1) {
            ArrayList<ArrayList<Integer>> invariantsWITHroot = InvariantsTools.returnT_invWithTransition(invariants, rootTransition);
            ArrayList<ArrayList<Integer>> invariantsWITHOUTroot = InvariantsTools.returnT_invWithoutTransition(invariants, rootTransition);
            ArrayList<Integer> antiVector = InvariantsTools.getFrequency(invariantsWITHOUTroot, true);
            for (int i = 0; i < invariantsWITHroot.size(); ++i) {
                ArrayList<Integer> modInv = invariantsWITHroot.get(i);
                for (int j = 0; j < antiVector.size(); ++j) {
                    if (antiVector.get(j) <= 0) continue;
                    modInv.set(j, 0);
                }
            }
            this.createMTreeV2(invariantsWITHroot, rootTransition, this.root);
        } else if (mode == 2) {
            ArrayList<ArrayList<Integer>> invariantsWITHroot = InvariantsTools.returnT_invWithTransition(invariants, rootTransition);
            ArrayList<ArrayList<Integer>> invariantsWITHOUTroot = InvariantsTools.returnT_invWithoutTransition(invariants, rootTransition);
            ArrayList<Integer> antiVector = InvariantsTools.getFrequency(invariantsWITHOUTroot, true);
            ArrayList<Integer> knockVector = InvariantsTools.getFrequency(invariantsWITHroot, true);
            float treshold = (float)(100 - coverageVal) / 100.0f;
            for (int j = 0; j < antiVector.size(); ++j) {
                try {
                    float x = (float)antiVector.get(j).intValue() / (float)(antiVector.get(j) + knockVector.get(j));
                    if (!(x < treshold)) continue;
                    antiVector.set(j, 0);
                    continue;
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00544exception") + "\n" + ex.getMessage(), "error", true);
                }
            }
            for (int i = 0; i < invariantsWITHroot.size(); ++i) {
                ArrayList<Integer> modInv = invariantsWITHroot.get(i);
                for (int j = 0; j < antiVector.size(); ++j) {
                    if (antiVector.get(j) <= 0) continue;
                    modInv.set(j, 0);
                }
            }
            this.createMTreeV2(invariantsWITHroot, rootTransition, this.root);
        } else {
            ArrayList<ArrayList<Integer>> subInvariants = InvariantsTools.returnT_invWithTransition(invariants, rootTransition);
            this.createMTreeV2(subInvariants, rootTransition, this.root);
        }
    }

    private ArrayList<ArrayList<Integer>> addIndexToInvariants(ArrayList<ArrayList<Integer>> originalInvariants) {
        ArrayList<ArrayList<Integer>> newInvariants = new ArrayList<ArrayList<Integer>>();
        int invNumber = originalInvariants.size();
        for (int i = 0; i < invNumber; ++i) {
            ArrayList<Integer> newInvariant = new ArrayList<Integer>((Collection)originalInvariants.get(i));
            newInvariant.add(i);
            newInvariants.add(newInvariant);
        }
        return newInvariants;
    }

    private ArrayList<String> getMCTNamesVector() {
        MCTCalculator analyzer = overlord.getWorkspace().getProject().getMCTanalyzer();
        ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
        ArrayList<String> resultNames = new ArrayList<String>();
        for (Transition t : this.transitions) {
            resultNames.add(t.getName());
        }
        if (mct.isEmpty()) {
            return resultNames;
        }
        mct = MCTCalculator.getSortedMCT(mct, false);
        int mctNo = 0;
        for (ArrayList<Transition> arr : mct) {
            ++mctNo;
            for (Transition t : arr) {
                int id = this.transitions.indexOf(t);
                String name = t.getName() + "_MCT" + mctNo;
                resultNames.set(id, name);
            }
        }
        return resultNames;
    }

    public BTNode getRoot() {
        return this.root;
    }

    private void createMTreeV2(ArrayList<ArrayList<Integer>> subInvariants, int chosenTrans, BTNode currentNode) {
        int maxTransition = -1;
        int howManyLeft = 0;
        if (chosenTrans == -1) {
            ArrayList<Integer> transFrequency = InvariantsTools.getFrequency(subInvariants, true);
            maxTransition = this.getPositionOfMostImportantTransition(transFrequency);
            howManyLeft = this.getSupportSize(transFrequency);
        } else {
            maxTransition = chosenTrans;
            ArrayList<Integer> transFrequency = InvariantsTools.getFrequency(subInvariants, true);
            howManyLeft = this.getSupportSize(transFrequency);
        }
        if (maxTransition == -1) {
            currentNode.transFrequency = -1;
            return;
        }
        ArrayList<ArrayList<Integer>> invsWithCurrentNode = InvariantsTools.returnT_invWithTransition(subInvariants, maxTransition);
        ArrayList<ArrayList<Integer>> invsWithoutCurrentNode = InvariantsTools.returnT_invWithoutTransition(subInvariants, maxTransition);
        if (invsWithoutCurrentNode.isEmpty() || howManyLeft == 0) {
            currentNode.transName = this.transMCTNames.get(maxTransition);
            currentNode.transLocation = maxTransition;
            currentNode.transFrequency = invsWithCurrentNode.size();
            currentNode.myInvariantsIDs = this.addInvsIndices(invsWithCurrentNode);
            currentNode.othersFrequency = invsWithoutCurrentNode.size();
            currentNode.theRestInvariantsIDs = this.addInvsIndices(invsWithoutCurrentNode);
            currentNode.leftChild = null;
            if (howManyLeft > 1) {
                BTNode rightNode;
                if (currentNode.type != NodeType.ROOT) {
                    currentNode.type = NodeType.BRANCH;
                }
                currentNode.rightChild = rightNode = new BTNode();
                this.cleanTransDataInInv(invsWithCurrentNode, maxTransition);
                this.createMTreeV2(invsWithCurrentNode, -1, rightNode);
                if (rightNode.transLocation == -1) {
                    currentNode.rightChild = null;
                }
            } else {
                if (currentNode.type != NodeType.ROOT) {
                    currentNode.type = NodeType.LEAF;
                }
                currentNode.rightChild = null;
            }
        } else {
            BTNode leftNode;
            BTNode rightNode;
            if (currentNode.type != NodeType.ROOT) {
                currentNode.type = NodeType.BRANCH;
            }
            currentNode.transName = this.transMCTNames.get(maxTransition);
            currentNode.transLocation = maxTransition;
            currentNode.transFrequency = invsWithCurrentNode.size();
            currentNode.myInvariantsIDs = this.addInvsIndices(invsWithCurrentNode);
            currentNode.othersFrequency = invsWithoutCurrentNode.size();
            currentNode.theRestInvariantsIDs = this.addInvsIndices(invsWithoutCurrentNode);
            currentNode.rightChild = rightNode = new BTNode();
            currentNode.leftChild = leftNode = new BTNode();
            this.cleanTransDataInInv(invsWithCurrentNode, maxTransition);
            this.createMTreeV2(invsWithCurrentNode, -1, rightNode);
            if (rightNode.transLocation == -1) {
                currentNode.rightChild = null;
            }
            this.createMTreeV2(invsWithoutCurrentNode, -1, leftNode);
            if (leftNode.transLocation == -1) {
                currentNode.leftChild = null;
            }
        }
    }

    private ArrayList<Integer> addInvsIndices(ArrayList<ArrayList<Integer>> invsWithCurrentNode) {
        ArrayList<Integer> idVector = new ArrayList<Integer>();
        if (invsWithCurrentNode.isEmpty()) {
            return idVector;
        }
        int invSize = invsWithCurrentNode.get(0).size();
        for (ArrayList<Integer> inv : invsWithCurrentNode) {
            idVector.add(inv.get(invSize - 1));
        }
        return idVector;
    }

    private int getSupportSize(ArrayList<Integer> vector) {
        int res = 0;
        for (int el : vector) {
            if (el <= 0) continue;
            ++res;
        }
        return res;
    }

    private int getMaximumValue(ArrayList<Integer> vector) {
        int maxVal = 0;
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            if (vector.get(i) <= maxVal) continue;
            maxVal = vector.get(i);
        }
        return maxVal;
    }

    private int getPositionOfMostImportantTransition(ArrayList<Integer> vector) {
        int res = 0;
        int pos = -1;
        int size = vector.size();
        for (int i = 0; i < size; ++i) {
            if (vector.get(i) <= res) continue;
            res = vector.get(i);
            pos = i;
        }
        return pos;
    }

    private ArrayList<Integer> getMaximalPositions(ArrayList<Integer> freq, int max) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int size = freq.size();
        for (int i = 0; i < size; ++i) {
            if (freq.get(i) != max) continue;
            result.add(i);
        }
        return result;
    }

    private void cleanTransDataInInv(ArrayList<ArrayList<Integer>> invariants, int trans) {
        for (ArrayList<Integer> vector : invariants) {
            vector.set(trans, 0);
        }
    }

    public MauritiusMap(ArrayList<ArrayList<Integer>> invariants) {
        this.root.type = NodeType.ROOT;
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.transMCTNames = this.getMCTNamesVector();
        this.createMTree(invariants, -1, this.root, null);
    }

    private void createMTree(ArrayList<ArrayList<Integer>> subInvariants, int chosenTrans, BTNode currentNode, ArrayList<Integer> antiVector) {
        int maxTransition = -1;
        int howManyLeft = 0;
        if (chosenTrans == -1) {
            ArrayList<Integer> transFrequency = InvariantsTools.getFrequency(subInvariants, true);
            ArrayList<Integer> tmpFreq = new ArrayList<Integer>(transFrequency);
            for (int i = 0; i < tmpFreq.size(); ++i) {
                if (antiVector.get(i) <= 0) continue;
                tmpFreq.set(i, 0);
            }
            maxTransition = this.getPositionOfMostImportantTransition(tmpFreq);
            howManyLeft = antiVector.size() - this.getSupportSize(antiVector);
            if (maxTransition != -1) {
                antiVector.set(maxTransition, 99);
            }
        } else {
            maxTransition = chosenTrans;
            howManyLeft = antiVector.size() - this.getSupportSize(antiVector);
            if (maxTransition != -1) {
                antiVector.set(maxTransition, 99);
            }
        }
        if (maxTransition == -1) {
            currentNode.transFrequency = -1;
            return;
        }
        ArrayList<ArrayList<Integer>> rightInvariants = InvariantsTools.returnT_invWithTransition(subInvariants, maxTransition);
        ArrayList<ArrayList<Integer>> leftInvariants = InvariantsTools.returnT_invWithoutTransition(subInvariants, maxTransition);
        if (leftInvariants.isEmpty() || howManyLeft == 0) {
            currentNode.transName = this.transMCTNames.get(maxTransition);
            currentNode.transLocation = maxTransition;
            currentNode.transFrequency = rightInvariants.size();
            if (currentNode.transFrequency == 0) {
                boolean bl = true;
            }
            currentNode.othersFrequency = leftInvariants.size();
            currentNode.leftChild = null;
            if (howManyLeft > 1) {
                BTNode rightNode;
                if (currentNode.type != NodeType.ROOT) {
                    currentNode.type = NodeType.BRANCH;
                }
                currentNode.rightChild = rightNode = new BTNode();
                this.cleanTransDataInInv(rightInvariants, maxTransition);
                this.createMTree(rightInvariants, -1, rightNode, antiVector);
                if (rightNode.transLocation == -1) {
                    currentNode.rightChild = null;
                }
            } else {
                if (currentNode.type != NodeType.ROOT) {
                    currentNode.type = NodeType.LEAF;
                }
                currentNode.rightChild = null;
            }
        } else {
            BTNode leftNode;
            BTNode rightNode;
            if (currentNode.type != NodeType.ROOT) {
                currentNode.type = NodeType.BRANCH;
            }
            currentNode.transName = this.transMCTNames.get(maxTransition);
            currentNode.transLocation = maxTransition;
            currentNode.transFrequency = rightInvariants.size();
            currentNode.othersFrequency = leftInvariants.size();
            currentNode.rightChild = rightNode = new BTNode();
            currentNode.leftChild = leftNode = new BTNode();
            this.cleanTransDataInInv(rightInvariants, maxTransition);
            this.createMTree(rightInvariants, -1, rightNode, antiVector);
            if (rightNode.transLocation == -1) {
                currentNode.rightChild = null;
            }
            this.createMTree(leftInvariants, -1, leftNode, antiVector);
            if (leftNode.transLocation == -1) {
                currentNode.leftChild = null;
            }
        }
    }

    public static class BTNode {
        public NodeType type = NodeType.VERTEX;
        public String transName;
        public int transLocation = -1;
        public int transFrequency;
        public int othersFrequency;
        public BTNode leftChild;
        public BTNode rightChild;
        public ArrayList<Integer> myInvariantsIDs;
        public ArrayList<Integer> theRestInvariantsIDs;
    }

    public static enum NodeType {
        ROOT,
        BRANCH,
        LEAF,
        VERTEX;

    }
}

