/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.MCSoperations;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class MCSDataMatrix {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<ArrayList<ArrayList<Integer>>> mcsDataCore;
    private ArrayList<ArrayList<ArrayList<Integer>>> mcsSetsInfo;
    private ArrayList<String> transNames;
    private int matrixSize;

    public MCSDataMatrix() {
        this.resetMSC();
    }

    public void resetMSC() {
        this.mcsDataCore = new ArrayList();
        this.mcsSetsInfo = new ArrayList();
        this.transNames = new ArrayList();
        this.matrixSize = 0;
    }

    public void initiateMCS() {
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        this.matrixSize = transitions.size();
        this.mcsDataCore = new ArrayList();
        for (int i = 0; i < this.matrixSize; ++i) {
            ArrayList newVector = new ArrayList();
            this.mcsDataCore.add(newVector);
            ArrayList infoVector = new ArrayList();
            this.mcsSetsInfo.add(infoVector);
            this.transNames.add(transitions.get(i).getName());
        }
    }

    public int getSize() {
        return this.matrixSize;
    }

    public void insertMCS(ArrayList<ArrayList<Integer>> mcsList, ArrayList<ArrayList<Integer>> mcsListInfo, int pos, boolean warning) {
        if (pos < this.matrixSize) {
            if (!warning) {
                this.mcsDataCore.set(pos, mcsList);
                this.mcsSetsInfo.set(pos, mcsListInfo);
            } else if (!this.mcsDataCore.get(pos).isEmpty()) {
                Object[] options = new Object[]{lang.getText("replace"), lang.getText("cancel")};
                int decision = JOptionPane.showOptionDialog(null, lang.getText("MCSDM_entry001"), lang.getText("MCSDM_entry001t"), 0, 2, null, options, options[1]);
                if (decision != 1) {
                    this.mcsDataCore.set(pos, mcsList);
                    this.mcsSetsInfo.set(pos, mcsListInfo);
                }
            } else {
                this.mcsDataCore.set(pos, mcsList);
                this.mcsSetsInfo.set(pos, mcsListInfo);
            }
        } else {
            overlord.log(lang.getText("LOGentry003340") + " " + this.matrixSize, "error", true);
        }
    }

    public int getCalculatedMCSnumber() {
        int size = 0;
        for (ArrayList<ArrayList<Integer>> list : this.mcsDataCore) {
            if (list.isEmpty()) continue;
            ++size;
        }
        return size;
    }

    public ArrayList<ArrayList<Integer>> getMCSlist(int pos) {
        if (pos < this.matrixSize) {
            return this.mcsDataCore.get(pos);
        }
        overlord.log(lang.getText("LOGentry00335") + " " + this.matrixSize, "warning", true);
        return null;
    }

    public ArrayList<ArrayList<Integer>> getMCSlistInfo(int pos) {
        if (pos < this.matrixSize) {
            return this.mcsSetsInfo.get(pos);
        }
        overlord.log(lang.getText("LOGentry00336") + " " + this.matrixSize, "warning", true);
        return null;
    }

    public boolean checkDataReplacing() {
        int dataSize = this.getCalculatedMCSnumber();
        if (dataSize > 0) {
            Object[] options = new Object[]{lang.getText("replace"), lang.getText("saveAndReplace"), lang.getText("cancel")};
            int decision = JOptionPane.showOptionDialog(null, lang.getText("MCSDM_entry002"), lang.getText("MCSDM_entry002t"), 0, 2, null, options, options[1]);
            if (decision == 2) {
                return false;
            }
            if (decision == 0) {
                return true;
            }
            boolean status = MCSoperations.saveAllMCS(this);
            if (!status) {
                JOptionPane.showMessageDialog(null, lang.getText("MCSDM_entry003"), lang.getText("MCSDM_entry003t"), 0);
            }
            return status;
        }
        return true;
    }

    public ArrayList<ArrayList<ArrayList<Integer>>> accessMCSdata() {
        return this.mcsDataCore;
    }

    public ArrayList<ArrayList<ArrayList<Integer>>> accessMCSinfo() {
        return this.mcsSetsInfo;
    }

    public ArrayList<String> accessMCStransitions() {
        return this.transNames;
    }
}

