/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel.popupmenu;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.IOprotocols;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.popupmenu.GraphPanelPopupMenu;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.subnets.SubnetsActions;
import holmes.utilities.HolmesFileView;
import holmes.workspace.ExtensionFileFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SheetPopupMenu
extends GraphPanelPopupMenu {
    private static final long serialVersionUID = 3206422633820189233L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    public int x;
    public int y;
    public int sheetID = -1;

    public SheetPopupMenu(GraphPanel graphPanel, PetriNetElement.PetriNetElementType pne) {
        super(graphPanel, pne);
        this.sheetID = graphPanel.getSheetId();
        this.addMenuItem(lang.getText("SPM_entry001"), "", e -> this.getGraphPanel().getSelectionManager().selectAllElementLocations());
        this.addSeparator();
        this.add(this.pasteMenuItem);
        this.addSeparator();
        this.addMenuItem(lang.getText("SPM_entry002"), "refresh.png", e -> {
            this.getGraphPanel().invalidate();
            this.getGraphPanel().repaint();
        });
        this.addMenuItem(lang.getText("SPM_entry003"), "clearColors.png", e -> SheetPopupMenu.overlord.reset.clearGraphColors());
        this.addMenuItem(lang.getText("SPM_entry004"), "picture_save.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.exportToPicture();
            }

            private void exportToPicture() {
                String lastPath = overlord.getLastPath();
                JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
                fc.setFileView(new HolmesFileView());
                ExtensionFileFilter pngFilter = new ExtensionFileFilter(".png - Portable Network Graphics", new String[]{"png"});
                ExtensionFileFilter bmpFilter = new ExtensionFileFilter(".bmp -  Bitmap Image", new String[]{"bmp"});
                ExtensionFileFilter jpegFilter = new ExtensionFileFilter(".jpeg - JPEG Image", new String[]{"jpeg"});
                ExtensionFileFilter jpgFilter = new ExtensionFileFilter(".jpg - JPEG Image", new String[]{"jpg"});
                fc.setFileFilter(pngFilter);
                fc.addChoosableFileFilter(pngFilter);
                fc.addChoosableFileFilter(bmpFilter);
                fc.addChoosableFileFilter(jpegFilter);
                fc.addChoosableFileFilter(jpgFilter);
                fc.setAcceptAllFileFilterUsed(false);
                if (fc.showSaveDialog(null) == 0) {
                    File file = fc.getSelectedFile();
                    String ext = "";
                    String extension = fc.getFileFilter().getDescription();
                    if (extension.contains(".png")) {
                        ext = ".png";
                    }
                    if (extension.contains(".bmp")) {
                        ext = ".bmp";
                    }
                    if (extension.contains(".jpeg") || extension.contains(".jpg")) {
                        ext = ".jpeg";
                    }
                    BufferedImage image = SheetPopupMenu.this.getGraphPanel().createImageFromSheet();
                    try {
                        String ext2 = "";
                        String path = file.getPath();
                        if (ext.equals(".png") && !path.contains(".png")) {
                            ext2 = ".png";
                        }
                        if (ext.equals(".bmp") && !file.getPath().contains(".bmp")) {
                            ext2 = ".bmp";
                        }
                        if (ext.equals(".jpeg") && !file.getPath().contains(".jpeg")) {
                            ext2 = ".jpeg";
                        }
                        if (ext.equals(".jpeg") && !file.getPath().contains(".jpg")) {
                            ext2 = ".jpg";
                        }
                        ImageIO.write((RenderedImage)image, ext.substring(1), new File(file.getPath() + ext2));
                        overlord.setLastPath(file.getParentFile().getPath());
                    }
                    catch (IOException ex) {
                        overlord.log(lang.getText("LOGentry00371exception") + "\n" + ex.getMessage(), "error", true);
                    }
                }
            }
        });
        this.addSeparator();
        this.addMenuItem(lang.getText("SPM_entry005"), "undo.png", e -> this.getGraphPanel().setZoom(100, this.getGraphPanel().getZoom()));
        JMenu zoomMenu = new JMenu(lang.getText("SPM_entry006"));
        this.add(zoomMenu);
        zoomMenu.add(this.createMenuItem("200%", "", null, arg0 -> this.getGraphPanel().setZoom(200, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("100%", "", null, arg0 -> this.getGraphPanel().setZoom(100, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("80%", "", null, arg0 -> this.getGraphPanel().setZoom(80, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("50%", "", null, arg0 -> this.getGraphPanel().setZoom(50, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("30%", "", null, arg0 -> this.getGraphPanel().setZoom(30, this.getGraphPanel().getZoom())));
        this.addSeparator();
        this.addMenuItem(lang.getText("SPM_entry007"), "smallInvisibility.png", e -> {
            if (this.getGraphPanel().getSelectionManager().getSelectedElementLocations().isEmpty()) {
                return;
            }
            for (Transition trans : overlord.getWorkspace().getProject().getTransitions()) {
                trans.setInvisibility(false);
            }
            for (Place place : overlord.getWorkspace().getProject().getPlaces()) {
                place.setInvisibility(false);
            }
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        this.addMenuItem(lang.getText("SPM_entry008"), "offlineSmall.png", e -> {
            if (this.getGraphPanel().getSelectionManager().getSelectedElementLocations().isEmpty()) {
                return;
            }
            for (Transition trans : overlord.getWorkspace().getProject().getTransitions()) {
                trans.setKnockout(false);
            }
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        this.addSeparator();
        JMenu analMenu = new JMenu(lang.getText("SPM_entry009"));
        this.add(analMenu);
        analMenu.add(this.createMenuItem(lang.getText("SPM_entry010"), "invImportPopup.png", null, arg0 -> SheetPopupMenu.overlord.io.loadExternalAnalysis(true)));
        analMenu.add(this.createMenuItem(lang.getText("SPM_entry011"), "generateINA.png", null, arg0 -> SheetPopupMenu.overlord.io.fastGenerateTinvariants()));
        analMenu.add(this.createMenuItem(lang.getText("SPM_entry012"), "generateMCT.png", null, arg0 -> overlord.generateMCT()));
        JMenu mctSubMenu = new JMenu(lang.getText("SPM_entry013"));
        analMenu.add(mctSubMenu);
        JMenuItem mct1 = this.createMenuItem(lang.getText("SPM_entry014"), "", null, arg0 -> SheetPopupMenu.overlord.io.generateSimpleMCTFile());
        mctSubMenu.add(mct1);
        JMenuItem mct2 = this.createMenuItem(lang.getText("SPM_entry015"), "", null, arg0 -> {});
        mct2.setEnabled(false);
        mctSubMenu.add(mct2);
        JMenuItem mct3 = this.createMenuItem(lang.getText("SPM_entry016"), "", null, arg0 -> {});
        mct3.setEnabled(false);
        mctSubMenu.add(mct3);
        JMenu netMenu = new JMenu(lang.getText("SPM_entry017"));
        this.add(netMenu);
        netMenu.add(this.createMenuItem(lang.getText("SPM_entry018"), "", null, arg0 -> SheetPopupMenu.overlord.io.markTransitions(0)));
        netMenu.add(this.createMenuItem(lang.getText("SPM_entry019"), "", null, arg0 -> SheetPopupMenu.overlord.io.markTransitions(1)));
        netMenu.add(this.createMenuItem(lang.getText("SPM_entry020"), "", null, arg0 -> SheetPopupMenu.overlord.io.markTransitions(2)));
        netMenu.add(this.createMenuItem(lang.getText("SPM_entry021"), "", null, arg0 -> SheetPopupMenu.overlord.subnetsHQ.checkSnoopyCompatibility()));
        if (this.sheetID != 0) {
            netMenu.add(this.createMenuItem(lang.getText("SPM_entry022"), "", null, arg0 -> overlord.testRemovePanel(this.sheetID)));
        }
        this.addSeparator();
        JMenu subImpMenu = new JMenu(lang.getText("SPM_entry023"));
        this.add(subImpMenu);
        subImpMenu.add(this.createMenuItem(lang.getText("SPM_entry024"), "", null, arg0 -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                IOprotocols io = new IOprotocols();
                io.importSubnetFromFile(file.getAbsolutePath(), 0, 0);
            }
        }));
        subImpMenu.add(this.createMenuItem(lang.getText("SPM_entry025"), "", null, arg0 -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                IOprotocols io = new IOprotocols();
                for (ElementLocation el : this.getGraphPanel().getSelectionManager().getSelectedElementLocations()) {
                    el.setSelected(false);
                }
            }
        }));
        if (this.getGraphPanel().getSheetId() != 0) {
            this.addMenuItem(lang.getText("SPM_entry026"), "", e -> SubnetsActions.addExistingElement(graphPanel));
        }
    }

    private void exportToFile() {
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter pngFilter = new ExtensionFileFilter(".png - Portable Network Graphics", new String[]{"png"});
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter(".bmp -  Bitmap Image", new String[]{"bmp"});
        ExtensionFileFilter jpegFilter = new ExtensionFileFilter(".jpeg - JPEG Image", new String[]{"jpeg"});
        fc.setFileFilter(pngFilter);
        fc.addChoosableFileFilter(pngFilter);
        fc.addChoosableFileFilter(bmpFilter);
        fc.addChoosableFileFilter(jpegFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String ext = "";
            String extension = fc.getFileFilter().getDescription();
            if (extension.contains(".png")) {
                ext = ".png";
            }
            if (extension.contains(".bmp")) {
                ext = ".bmp";
            }
            if (extension.contains(".jpeg")) {
                ext = ".jpeg";
            }
            BufferedImage image = this.getGraphPanel().createImageFromSheet();
            try {
                ImageIO.write((RenderedImage)image, ext.substring(1), new File(file.getPath() + ext));
                overlord.log(lang.getText("LOGentry00372") + " " + file.getPath() + ext, "text", true);
            }
            catch (IOException ex) {
                overlord.log(lang.getText("LOGentry00373exception") + "\n" + ex.getMessage(), "error", true);
            }
        }
    }
}

