/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel.popupmenu;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.popupmenu.GraphPanelPopupMenu;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.subnets.SubnetsActions;
import holmes.windows.HolmesNodeInfo;
import holmes.windows.xtpn.HolmesNodeInfoXTPN;
import javax.swing.JOptionPane;

public class NodePopupMenu
extends GraphPanelPopupMenu {
    private static final long serialVersionUID = -8988739887642243733L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ElementLocation elocation;

    public NodePopupMenu(GraphPanel graphPanel, ElementLocation eloc, PetriNetElement.PetriNetElementType pne, Object pneObject) {
        super(graphPanel, pne);
        this.elocation = eloc;
        if (pne != PetriNetElement.PetriNetElementType.ARC) {
            this.addMenuItem(lang.getText("NPM_entry001"), "", e -> {
                if (this.getGraphPanel().getSelectionManager().getSelectedElementLocations().isEmpty()) {
                    return;
                }
                Node n = this.getGraphPanel().getSelectionManager().getSelectedElementLocations().get(0).getParentNode();
                if (n instanceof Place) {
                    if (n instanceof PlaceXTPN) {
                        HolmesNodeInfoXTPN ani = new HolmesNodeInfoXTPN((PlaceXTPN)n, this.elocation, overlord.getFrame());
                        ani.setVisible(true);
                    } else {
                        HolmesNodeInfo ani = new HolmesNodeInfo((Place)n, overlord.getFrame());
                        ani.setVisible(true);
                    }
                } else if (n instanceof Transition) {
                    if (n instanceof TransitionXTPN) {
                        HolmesNodeInfoXTPN ani = new HolmesNodeInfoXTPN((TransitionXTPN)n, this.elocation, overlord.getFrame());
                        ani.setVisible(true);
                    } else {
                        HolmesNodeInfo ani = new HolmesNodeInfo((Transition)n, overlord.getFrame());
                        ani.setVisible(true);
                    }
                } else if (n instanceof MetaNode) {
                    HolmesNodeInfo ani = new HolmesNodeInfo((MetaNode)n, overlord.getFrame());
                    ani.setVisible(true);
                }
            });
        }
        if (pne != PetriNetElement.PetriNetElementType.META) {
            this.addMenuItem(lang.getText("delete"), "cross.png", e -> {
                if (NodePopupMenu.overlord.reset.isSimulatorActiveWarning(lang.getText("NPM_entry002"), "Warning")) {
                    return;
                }
                if (NodePopupMenu.overlord.reset.isXTPNSimulatorActiveWarning(lang.getText("NPM_entry003"), "Warning")) {
                    return;
                }
                Object[] options = new Object[]{lang.getText("delete"), lang.getText("cancel")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("NPM_entry004"), lang.getText("NPM_entry004t"), 0, 3, null, options, options[0]);
                if (n == 0) {
                    this.getGraphPanel().getSelectionManager().deleteAllSelectedElements();
                    this.getGraphPanel().getSelectionManager().deselectAllElementLocations();
                    overlord.markNetChange();
                }
            });
        }
        if (pne != PetriNetElement.PetriNetElementType.META) {
            this.addSeparator();
            this.add(this.cutMenuItem);
            this.add(this.copyMenuItem);
            this.add(this.pasteMenuItem);
        }
        if (graphPanel.getSelectionManager().getSelectedElementLocations().size() > 1 && graphPanel.getSelectionManager().getSelectedElementLocations().stream().allMatch(location -> eloc.getParentNode() == location.getParentNode())) {
            this.addMenuItem(lang.getText("NPM_entry005"), "", e -> NodePopupMenu.overlord.subnetsHQ.mergePortals(eloc, graphPanel.getSelectionManager().getSelectedElementLocations()));
        }
        if (graphPanel.getSelectionManager().getSelectedElementLocations().stream().map(ElementLocation::getParentNode).filter(MetaNode.class::isInstance).findAny().isEmpty() && !graphPanel.getSelectionManager().getSelectedElementLocations().isEmpty()) {
            this.addSeparator();
            this.addMenuItem(lang.getText("NPM_entry006"), "", e -> NodePopupMenu.overlord.subnetsHQ.createSubnetFromSelectedElements(graphPanel));
            if (NodePopupMenu.overlord.subnetsHQ.getSubnetElementLocations(graphPanel.getSheetId()).stream().anyMatch(location -> location.getParentNode() instanceof MetaNode)) {
                this.addMenuItem(lang.getText("NPM_entry007"), "", e -> SubnetsActions.openTransferElementsToSubnet(graphPanel, true));
                this.addMenuItem(lang.getText("NPM_entry008"), "", e -> SubnetsActions.openTransferElementsToSubnet(graphPanel, false));
                this.addMenuItem(lang.getText("NPM_entry009"), "", e -> SubnetsActions.openCopyElementsToSubnet(graphPanel));
            }
        }
        this.addSeparator();
    }
}

