/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel.popupmenu;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.popupmenu.NodePopupMenu;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JMenu;
import javax.swing.JOptionPane;

public class MetaNodePopupMenu
extends NodePopupMenu {
    private static final long serialVersionUID = 8356818331350683029L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public MetaNodePopupMenu(GraphPanel graphPanel, ElementLocation el, PetriNetElement.PetriNetElementType pne) {
        super(graphPanel, el, pne, el.getParentNode());
        if (graphPanel.getSelectionManager().getSelectedElementLocations().size() == 1) {
            this.addMenuItem(lang.getText("MNPM_entry001"), "cross.png", e -> {
                Object[] options = new Object[]{lang.getText("delete"), lang.getText("cancel")};
                MetaNode metaNode = (MetaNode)el.getParentNode();
                int id = metaNode.getRepresentedSheetID();
                long uniquePlaces = MetaNodePopupMenu.overlord.subnetsHQ.getSubnetElementLocations(id).stream().map(ElementLocation::getParentNode).filter(Place.class::isInstance).collect(Collectors.toSet()).stream().filter(node -> node.getNodeLocations().stream().allMatch(location -> location.getSheetID() == id)).count();
                long uniqueTransitions = MetaNodePopupMenu.overlord.subnetsHQ.getSubnetElementLocations(id).stream().map(ElementLocation::getParentNode).filter(Transition.class::isInstance).collect(Collectors.toSet()).stream().filter(node -> node.getNodeLocations().stream().allMatch(location -> location.getSheetID() == id)).count();
                StringBuilder builder = new StringBuilder();
                builder.append(String.format(lang.getText("MNPM_entry002"), id, uniquePlaces, uniqueTransitions));
                builder.append(String.format(lang.getText("MNPM_entry003"), new Object[0]));
                String parentName = MetaNodePopupMenu.overlord.subnetsHQ.getMetanode(metaNode.getMySheetID()).map(PetriNetElement::getName).orElse("Subnet0");
                builder.append(parentName).append(String.format("%n", new Object[0]));
                List<String> childrenNames = MetaNodePopupMenu.overlord.subnetsHQ.getSubnetElementLocations(id).stream().map(ElementLocation::getParentNode).filter(MetaNode.class::isInstance).map(MetaNode.class::cast).map(PetriNetElement::getName).toList();
                builder.append(String.join((CharSequence)String.format("%n", new Object[0]), childrenNames));
                int n = JOptionPane.showOptionDialog(null, builder.toString(), lang.getText("MNPM_entry004"), 0, 3, null, options, options[0]);
                if (n == 0) {
                    MetaNodePopupMenu.overlord.subnetsHQ.deleteSubnet(graphPanel.getSelectionManager().getSelectedMetanode());
                    overlord.markNetChange();
                }
            });
            this.addMenuItem(lang.getText("unwrap"), "", e -> {
                Object[] options = new Object[]{lang.getText("unwrap"), lang.getText("cancel")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("MNPM_entry005"), lang.getText("MNPM_entry005t"), 0, 3, null, options, options[0]);
                if (n == 0) {
                    MetaNodePopupMenu.overlord.subnetsHQ.unwrapSubnet(graphPanel);
                    overlord.markNetChange();
                }
            });
            this.addMenuItem(lang.getText("MNPM_entry006"), "", e -> {
                Object[] options = new Object[]{lang.getText("delete"), lang.getText("cancel")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("MNPM_entry007"), lang.getText("MNPM_entry007t"), 0, 3, null, options, options[0]);
                if (n == 0) {
                    MetaNodePopupMenu.overlord.subnetsHQ.clearMetaArcs(List.of(el));
                    this.getGraphPanel().repaint();
                    overlord.markNetChange();
                }
            });
        }
        JMenu fixMenu = new JMenu(lang.getText("MNPM_entry008"));
        this.add(fixMenu);
        fixMenu.add(this.createMenuItem(lang.getText("MNPM_entry009"), "invImportPopup.png", null, new ActionListener(){
            private ElementLocation elMeta;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MetaNodePopupMenu.this.getGraphPanel().getSelectionManager().deselectAllElementLocations();
                MetaNodePopupMenu.overlord.subnetsHQ.fixMetaArcsNumber((MetaNode)this.elMeta.getParentNode());
                MetaNodePopupMenu.this.getGraphPanel().repaint();
                overlord.markNetChange();
            }

            private ActionListener yesWeCan(ElementLocation inLoc) {
                this.elMeta = inLoc;
                return this;
            }
        }.yesWeCan(el)));
    }
}

