/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.EditorResources;
import holmes.graphpanel.ElementDrawSettings;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.utilities.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;

public final class ElementDraw {
    private static final Font f_plain = new Font("TimesRoman", 0, 10);
    private static final Font f_bold = new Font("TimesRoman", 1, 12);
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    private ElementDraw() {
    }

    private static void drawCrossHair(Graphics2D g, int x, int y, Color color, boolean light) {
        g.setColor(color);
        int bigger = 0;
        if (light) {
            g.setStroke(new BasicStroke(2.0f));
            ++bigger;
        } else {
            g.setStroke(new BasicStroke(4.0f));
        }
        g.drawOval(x - bigger, y - bigger, 60 + bigger, 60 + bigger);
        g.fillArc(x + 20, y + 41, 20, 20, -45, -90);
        g.fillArc(x - 1, y + 20, 20, 20, -135, -90);
        g.fillArc(x + 20, y - 1, 20, 20, -225, -90);
        g.fillArc(x + 41, y + 20, 20, 20, -315, -90);
        g.fillArc(x + 35, y + 36, 20, 20, 0, -90);
        g.fillArc(x + 5, y + 36, 20, 20, -90, -90);
        g.fillArc(x + 5, y + 5, 20, 20, -180, -90);
        g.fillArc(x + 35, y + 5, 20, 20, -270, -90);
    }

    public static Graphics2D drawElement(Node node, Graphics2D g, int sheetId, ElementDrawSettings eds) {
        block110: {
            block111: {
                block109: {
                    if (!(node instanceof Transition)) break block109;
                    Transition trans = (Transition)node;
                    Color portalColor = new Color(224, 224, 224);
                    Color normalColor = new Color(224, 224, 224);
                    Color tpnNormalColor = Color.GRAY;
                    if (eds.nonDefColors) {
                        normalColor = EditorResources.transDefColor;
                        portalColor = EditorResources.transDefColor;
                    }
                    if (eds.snoopyMode) {
                        normalColor = Color.WHITE;
                        if (!eds.nonDefColors) {
                            portalColor = Color.LIGHT_GRAY;
                        } else if (portalColor.equals(new Color(224, 224, 224))) {
                            portalColor = Color.LIGHT_GRAY;
                        }
                    }
                    for (ElementLocation el : trans.getNodeLocations(sheetId)) {
                        Color oldC;
                        Font old;
                        int posX;
                        Color oldC2;
                        Font old2;
                        int posY;
                        int radius = trans.getRadius();
                        g.setColor(Color.WHITE);
                        Rectangle nodeBounds = new Rectangle(el.getPosition().x - radius, el.getPosition().y - radius, radius * 2, radius * 2);
                        if (eds.view3d) {
                            Color backup = g.getColor();
                            g.setColor(Color.LIGHT_GRAY);
                            g.fillRect(nodeBounds.x + 4, nodeBounds.y + 4, nodeBounds.width + 1, nodeBounds.height + 1);
                            g.setColor(Color.GRAY);
                            g.fillRect(nodeBounds.x + 3, nodeBounds.y + 3, nodeBounds.width + 1, nodeBounds.height + 1);
                            g.setColor(Color.DARK_GRAY);
                            g.fillRect(nodeBounds.x + 2, nodeBounds.y + 2, nodeBounds.width + 1, nodeBounds.height + 1);
                            g.setColor(Color.BLACK);
                            g.fillRect(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width + 1, nodeBounds.height + 1);
                            g.setColor(Color.WHITE);
                            g.fillRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                            g.setColor(backup);
                        }
                        if (!trans.isLaunching()) {
                            if (trans.drawGraphBoxT.isGlowed_MTC()) {
                                g.setColor(EditorResources.glowMTCTransitonColorLevel1);
                                g.setStroke(EditorResources.glowStrokeLevel1);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.glowMTCTransitonColorLevel2);
                                g.setStroke(EditorResources.glowStrokeLevel2);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.glowMTCTransitonColorLevel3);
                                g.setStroke(EditorResources.glowStrokeLevel3);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                            } else if (trans.drawGraphBoxT.isGlowed()) {
                                g.setColor(EditorResources.glowTransitonColorLevel1);
                                g.setStroke(EditorResources.glowStrokeLevel1);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.glowTransitonColorLevel2);
                                g.setStroke(EditorResources.glowStrokeLevel2);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.glowTransitonColorLevel3);
                                g.setStroke(EditorResources.glowStrokeLevel3);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                            } else if (trans.isGlowed_Sub()) {
                                g.setColor(EditorResources.glowMTCTransitonColorLevel1);
                                g.setStroke(EditorResources.glowStrokeLevel1);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.glowMTCTransitonColorLevel2);
                                g.setStroke(EditorResources.glowStrokeLevel2);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.glowMTCTransitonColorLevel3);
                                g.setStroke(EditorResources.glowStrokeLevel3);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                            }
                            if (el.isSelected()) {
                                g.setColor(EditorResources.selectionColorLevel1);
                                g.setStroke(EditorResources.glowStrokeLevel1);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.selectionColorLevel2);
                                g.setStroke(EditorResources.glowStrokeLevel2);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(EditorResources.selectionColorLevel3);
                                g.setStroke(EditorResources.glowStrokeLevel3);
                                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                try {
                                    ElementDraw.drawCrossHair(g, nodeBounds.x - trans.getRadius(), nodeBounds.y - trans.getRadius(), EditorResources.lightSky, false);
                                }
                                catch (Exception ex) {
                                    overlord.log(lang.getText("LOGentry00322exception") + "\n" + ex.getMessage(), "error", true);
                                }
                            }
                        } else {
                            g.setColor(EditorResources.launchColorLevel1);
                            g.setStroke(EditorResources.glowStrokeLevel1);
                            g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                            g.setColor(EditorResources.launchColorLevel2);
                            g.setStroke(EditorResources.glowStrokeLevel2);
                            g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                            g.setColor(EditorResources.launchColorLevel3);
                            g.setStroke(EditorResources.glowStrokeLevel3);
                            g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        }
                        if (trans.drawGraphBoxT.isGlowed()) {
                            g.setColor(EditorResources.glowTransitonColorLevel3);
                            int row = 4;
                            g.fillRect(nodeBounds.x - row, nodeBounds.y - row, nodeBounds.width + 2 * row, nodeBounds.height + 2 * row);
                        } else if (trans.drawGraphBoxT.isGlowed_MTC()) {
                            g.setColor(EditorResources.glowMTCTransitonColorLevel3);
                        } else if (trans.drawGraphBoxT.isColorChanged()) {
                            g.setColor(trans.drawGraphBoxT.getTransitionNewColor());
                        } else if (el.isSelected()) {
                            g.setColor(EditorResources.selectionColorLevel3);
                        } else {
                            g.setColor(normalColor);
                            if (((Transition)node).getTransType() == Transition.TransitionType.TPN) {
                                g.setColor(tpnNormalColor);
                            }
                        }
                        Color back = g.getColor();
                        g.setColor(Color.white);
                        g.fillRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(back);
                        if (trans.qSimBoxT.qSimDrawed && el.qSimDrawed) {
                            if (trans.qSimBoxT.qSimFired == 0.0) {
                                if (trans.qSimBoxT.qSimDrawStats) {
                                    try {
                                        g.setColor(new Color(96, 96, 96));
                                        g.fillRect(nodeBounds.x + 2, nodeBounds.y + 10, 23, 10);
                                        g.setColor(Color.BLACK);
                                        g.drawRect(nodeBounds.x + 2, nodeBounds.y + 10, 23, 10);
                                        g.fillRect(nodeBounds.x + 25, nodeBounds.y + 12, 3, 6);
                                        g.setColor(Color.RED);
                                        g.drawLine(nodeBounds.x + 15, nodeBounds.y + 11, nodeBounds.x + 13, nodeBounds.y + 15);
                                        g.drawLine(nodeBounds.x + 13, nodeBounds.y + 15, nodeBounds.x + 16, nodeBounds.y + 14);
                                        g.drawLine(nodeBounds.x + 16, nodeBounds.y + 14, nodeBounds.x + 14, nodeBounds.y + 19);
                                    }
                                    catch (Exception ex) {
                                        overlord.log(lang.getText("LOGentry00323exception") + "\n" + ex.getMessage(), "error", true);
                                    }
                                }
                                g.setColor(trans.qSimBoxT.qSimOvalColor);
                                g.setStroke(new BasicStroke(2.5f));
                                int os = trans.qSimBoxT.qSimOvalSize;
                                g.drawOval(nodeBounds.x - os, nodeBounds.y - os, nodeBounds.width + 2 * os, nodeBounds.height + 2 * os);
                                g.drawOval(nodeBounds.x - (os + 1), nodeBounds.y - (os + 1), nodeBounds.width + (2 * os + 2), nodeBounds.height + (2 * os + 2));
                            } else if (trans.qSimBoxT.qSimDrawStats) {
                                g.setColor(trans.qSimBoxT.qSimFillColor);
                                g.fillRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(Color.white);
                                g.fillRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height - (trans.qSimBoxT.qSimFillValue - 2));
                            }
                        } else {
                            g.fillRect(nodeBounds.x + 2, nodeBounds.y + 2, nodeBounds.width - 3, nodeBounds.height - 3);
                        }
                        g.setColor(Color.BLACK);
                        g.setStroke(new BasicStroke(1.5f));
                        g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        ElementDraw.timeTransitionsSpecialFeatures(g, trans, nodeBounds);
                        if (trans.fpnExtension.isFunctional()) {
                            int posX2 = nodeBounds.x + nodeBounds.width / 2 - g.getFontMetrics().stringWidth("f") / 2 - 3;
                            posY = nodeBounds.y + nodeBounds.height / 2 + 5;
                            old2 = g.getFont();
                            oldC2 = g.getColor();
                            g.setFont(new Font("Garamond", 3, 22));
                            g.setColor(Color.RED);
                            g.drawString("f", posX2, posY);
                            g.setFont(old2);
                            g.setColor(oldC2);
                        }
                        if (trans.getTransType() == Transition.TransitionType.CPN) {
                            int posX3 = nodeBounds.x + nodeBounds.width / 2 - g.getFontMetrics().stringWidth("C") / 2 - 3;
                            posY = nodeBounds.y + nodeBounds.height / 2 + 8;
                            old2 = g.getFont();
                            oldC2 = g.getColor();
                            g.setFont(new Font("Garamond", 1, 22));
                            g.setColor(Color.RED);
                            g.drawString("C", posX3, posY);
                            g.setFont(old2);
                            g.setColor(oldC2);
                        }
                        if (trans.drawGraphBoxT.getFiring_INV() > 0) {
                            int posX4 = nodeBounds.x + nodeBounds.width + 6 - g.getFontMetrics().stringWidth(Integer.toString(trans.drawGraphBoxT.getFiring_INV())) / 2;
                            posY = nodeBounds.y;
                            g.setColor(Color.BLACK);
                            g.setFont(new Font("Garamond", 1, 16));
                            g.drawString(Integer.toString(trans.drawGraphBoxT.getFiring_INV()), posX4, posY);
                        }
                        if (trans.drawGraphBoxT.isColorChanged() && trans.drawGraphBoxT.getNumericalValueVisibility()) {
                            String clNumber = ElementDraw.formatD(trans.drawGraphBoxT.getNumericalValueDOUBLE());
                            posX = nodeBounds.x + nodeBounds.width - g.getFontMetrics().stringWidth(clNumber) / 2;
                            int posY2 = nodeBounds.y - 1;
                            old = g.getFont();
                            oldC = g.getColor();
                            g.setFont(new Font("TimesRoman", 1, 14));
                            g.setColor(Color.black);
                            g.drawString(clNumber, posX - 5 + trans.drawGraphBoxT.valueXoff, posY2 + trans.drawGraphBoxT.valueYoff);
                            g.setFont(old);
                            g.setColor(oldC);
                        }
                        if (trans.isKnockedOut()) {
                            try {
                                BufferedImage img = ImageIO.read(Objects.requireNonNull(ElementDraw.class.getResource("/icons/offlineTransition2.png")));
                                g.drawImage(img, null, nodeBounds.x - (trans.getRadius() + 2), nodeBounds.y - (trans.getRadius() + 2));
                            }
                            catch (Exception ex) {
                                overlord.log(lang.getText("LOGentry00324exception") + "\n" + ex.getMessage(), "error", true);
                            }
                        }
                        if (trans.isInvisible()) {
                            try {
                                BufferedImage img = ImageIO.read(Objects.requireNonNull(ElementDraw.class.getResource("/icons/invisibility2.png")));
                                g.drawImage(img, null, nodeBounds.x - (trans.getRadius() - 10), nodeBounds.y - (trans.getRadius() - 8));
                            }
                            catch (Exception ex) {
                                overlord.log(lang.getText("LOGentry00325exception") + "\n" + ex.getMessage(), "error", true);
                            }
                        }
                        if (trans.drawGraphBoxT.isShowedAddText()) {
                            String txt = trans.drawGraphBoxT.returnAddText();
                            posX = nodeBounds.x + nodeBounds.width - g.getFontMetrics().stringWidth(txt) / 2;
                            int posY3 = nodeBounds.y - 1;
                            old = g.getFont();
                            oldC = g.getColor();
                            g.setFont(new Font("TimesRoman", 1, 14));
                            g.setColor(Color.BLACK);
                            g.drawString(txt, posX + trans.drawGraphBoxT.txtXoff, posY3 + trans.drawGraphBoxT.txtYoff);
                            g.setFont(old);
                            g.setColor(oldC);
                        }
                        if (el.isPortalSelected() && !el.isSelected()) {
                            if (eds.snoopyMode) {
                                g.setColor(EditorResources.selectionColorLevel3);
                                g.fillRect(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 2, nodeBounds.height - 2);
                            }
                            ElementDraw.drawCrossHair(g, nodeBounds.x - trans.getRadius(), nodeBounds.y - trans.getRadius(), EditorResources.lightSky2, true);
                        }
                        if (trans.isPortal()) {
                            if (eds.snoopyMode) {
                                g.setColor(normalColor);
                                g.fillRect(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 2, nodeBounds.height - 2);
                            } else if (eds.newPlacePortal) {
                                g.setColor(Color.black);
                                g.fillRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(normalColor);
                                g.fillRect(nodeBounds.x + 4, nodeBounds.y + 4, nodeBounds.width - 8, nodeBounds.height - 8);
                            } else {
                                g.setColor(Color.black);
                                g.drawRect(nodeBounds.x + 3, nodeBounds.y + 3, nodeBounds.width - 6, nodeBounds.height - 6);
                            }
                        }
                        if (trans.branchColor != null) {
                            Color oldColor = g.getColor();
                            g.setColor(trans.branchColor);
                            g.drawRect(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 1, nodeBounds.height - 1);
                            g.setColor(oldColor);
                            trans.drawGraphBoxT.setColorWithNumber(true, trans.branchColor, false, 0.0, true, "");
                        }
                        if (!trans.branchBorderColors.isEmpty()) {
                            int x = 0;
                            int y = 0;
                            for (Color c : trans.branchBorderColors) {
                                g.setColor(Color.black);
                                g.fillOval(nodeBounds.x + 40 + x, nodeBounds.y + y, 6, 6);
                                g.setColor(c);
                                g.fillOval(nodeBounds.x + 40 + x, nodeBounds.y + y, 5, 5);
                                if ((y += 6) != 42) continue;
                                y = 0;
                                x += 6;
                            }
                        }
                        if (!eds.color && !(trans instanceof TransitionColored)) continue;
                        try {
                            assert (trans instanceof TransitionColored);
                            ElementDraw.coloredTransitionDemo(g, (TransitionColored)trans, nodeBounds);
                        }
                        catch (Exception ex) {
                            overlord.log(lang.getText("LOGentry00326exception") + "\n" + ex.getMessage(), "error", true);
                        }
                    }
                    break block110;
                }
                if (!(node instanceof Place)) break block111;
                Place place = (Place)node;
                Color portalColor = Color.WHITE;
                Color normalColor = Color.WHITE;
                if (eds.nonDefColors) {
                    normalColor = EditorResources.placeDefColor;
                    portalColor = EditorResources.placeDefColor;
                }
                if (eds.snoopyMode) {
                    if (!eds.nonDefColors) {
                        portalColor = Color.LIGHT_GRAY;
                    } else if (portalColor.equals(Color.WHITE)) {
                        portalColor = Color.LIGHT_GRAY;
                    }
                }
                for (ElementLocation el : node.getNodeLocations(sheetId)) {
                    Color oldC;
                    Font old;
                    Rectangle nodeBounds = new Rectangle(el.getPosition().x - place.getRadius(), el.getPosition().y - place.getRadius(), place.getRadius() * 2, place.getRadius() * 2);
                    if (eds.view3d) {
                        Color backup = g.getColor();
                        g.setColor(Color.DARK_GRAY);
                        g.fillOval(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width + 1, nodeBounds.height + 1);
                        g.fillOval(nodeBounds.x + 2, nodeBounds.y + 2, nodeBounds.width + 1, nodeBounds.height + 1);
                        g.setColor(normalColor);
                        g.fillOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(backup);
                    }
                    if (place.isGlowed_Sub()) {
                        g.setColor(EditorResources.glowMTCTransitonColorLevel1);
                        g.setStroke(EditorResources.glowStrokeLevel1);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(EditorResources.glowMTCTransitonColorLevel2);
                        g.setStroke(EditorResources.glowStrokeLevel2);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(EditorResources.glowMTCTransitonColorLevel3);
                        g.setStroke(EditorResources.glowStrokeLevel3);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                    }
                    if (el.isSelected() && !el.isPortalSelected()) {
                        g.setColor(EditorResources.selectionColorLevel1);
                        g.setStroke(EditorResources.glowStrokeLevel1);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(EditorResources.selectionColorLevel2);
                        g.setStroke(EditorResources.glowStrokeLevel2);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(EditorResources.selectionColorLevel3);
                        g.setStroke(EditorResources.glowStrokeLevel3);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        try {
                            ElementDraw.drawCrossHair(g, nodeBounds.x - (place.getRadius() - 6), nodeBounds.y - (place.getRadius() - 6), EditorResources.lightSky, false);
                        }
                        catch (Exception ex) {
                            overlord.log(lang.getText("LOGentry00327exception") + "\n" + ex.getMessage(), "error", true);
                        }
                    } else if (el.isPortalSelected()) {
                        g.setColor(EditorResources.selectionColorLevel1);
                        g.setStroke(EditorResources.glowStrokeLevel1);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(EditorResources.selectionColorLevel2);
                        g.setStroke(EditorResources.glowStrokeLevel2);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(EditorResources.selectionColorLevel3);
                        g.setStroke(EditorResources.glowStrokeLevel3);
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                    }
                    if (place.isGlowed_Sub()) {
                        g.setColor(EditorResources.glowMTCTransitonColorLevel3);
                    } else if (el.isSelected()) {
                        g.setColor(EditorResources.selectionColorLevel3);
                    } else {
                        g.setColor(normalColor);
                    }
                    g.fillOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                    if (!eds.nonDefColors) {
                        Color backup = g.getColor();
                        g.setColor(Color.white);
                        g.fillOval(nodeBounds.x + 3, nodeBounds.y + 3, nodeBounds.width - 3, nodeBounds.height - 3);
                        g.setColor(backup);
                        g.fillOval(nodeBounds.x + 3, nodeBounds.y + 3, nodeBounds.width - 3, nodeBounds.height - 3);
                    }
                    g.setColor(Color.BLACK);
                    g.setStroke(new BasicStroke(1.5f));
                    g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                    if (eds.crazyColors && !(place instanceof PlaceXTPN)) {
                        g.setColor(ElementDraw.getColor(place.getTokensNumber()));
                        g.fillOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                        g.setColor(Color.DARK_GRAY);
                        g.setStroke(new BasicStroke(1.5f));
                        g.drawOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                    }
                    if (place.isInvisible()) {
                        try {
                            BufferedImage img = ImageIO.read(Objects.requireNonNull(ElementDraw.class.getResource("/icons/invisibility2.png")));
                            g.drawImage(img, null, nodeBounds.x - (place.getRadius() - 15), nodeBounds.y - (place.getRadius() - 13));
                        }
                        catch (Exception ex) {
                            overlord.log(lang.getText("LOGentry00328exception") + "\n" + ex.getMessage(), "error", true);
                        }
                    }
                    if (place instanceof PlaceXTPN) {
                        if (((PlaceXTPN)place).isGammaModeActive()) {
                            g.setColor(EditorResources.lightGray);
                            int[] xpoints = new int[]{nodeBounds.x + 10, nodeBounds.x + 27, nodeBounds.x + 19};
                            int[] ypoints = new int[]{nodeBounds.y + 9, nodeBounds.y + 9, nodeBounds.y + 18};
                            Polygon p = new Polygon(xpoints, ypoints, 3);
                            g.fillPolygon(p);
                            int[] xpoints2 = new int[]{nodeBounds.x + 10, nodeBounds.x + 27, nodeBounds.x + 19};
                            int[] ypoints2 = new int[]{nodeBounds.y + 28, nodeBounds.y + 28, nodeBounds.y + 19};
                            p = new Polygon(xpoints2, ypoints2, 3);
                            g.fillPolygon(p);
                            g.setColor(Color.GRAY);
                            g.drawLine(nodeBounds.x + 9, nodeBounds.y + 9, nodeBounds.x + 28, nodeBounds.y + 9);
                            g.drawLine(nodeBounds.x + 9, nodeBounds.y + 28, nodeBounds.x + 28, nodeBounds.y + 28);
                            g.drawLine(nodeBounds.x + 10, nodeBounds.y + 10, nodeBounds.x + 27, nodeBounds.y + 27);
                            g.drawLine(nodeBounds.x + 10, nodeBounds.y + 27, nodeBounds.x + 27, nodeBounds.y + 10);
                        } else {
                            g.setColor(Color.LIGHT_GRAY);
                            g.drawLine(nodeBounds.x + 10, nodeBounds.y + 10, nodeBounds.x + 27, nodeBounds.y + 10);
                            g.drawLine(nodeBounds.x + 10, nodeBounds.y + 27, nodeBounds.x + 27, nodeBounds.y + 27);
                            g.drawLine(nodeBounds.x + 11, nodeBounds.y + 11, nodeBounds.x + 26, nodeBounds.y + 26);
                            g.drawLine(nodeBounds.x + 11, nodeBounds.y + 26, nodeBounds.x + 26, nodeBounds.y + 11);
                        }
                        g.setColor(Color.black);
                        g.setFont(new Font("TimesRoman", 0, 7));
                    }
                    if (place.qSimBoxP.qSimDrawed && el.qSimDrawed) {
                        if (place.qSimBoxP.qSimTokens == 0.0) {
                            g.setColor(place.qSimBoxP.qSimOvalColor);
                            g.setStroke(new BasicStroke(2.5f));
                            int os = place.qSimBoxP.qSimOvalSize;
                            g.drawOval(nodeBounds.x - os, nodeBounds.y - os, nodeBounds.width + 2 * os, nodeBounds.height + 2 * os);
                            g.drawOval(nodeBounds.x - (os + 1), nodeBounds.y - (os + 1), nodeBounds.width + (2 * os + 2), nodeBounds.height + (2 * os + 2));
                        } else if (place.qSimBoxP.qSimDrawStats) {
                            g.setStroke(new BasicStroke(1.0f));
                            g.setColor(place.qSimBoxP.qSimFillColor);
                            g.fillRect(nodeBounds.x + 35, nodeBounds.y - 25, 10, nodeBounds.height);
                            g.setColor(Color.WHITE);
                            g.fillRect(nodeBounds.x + 35, nodeBounds.y - 25, 10, nodeBounds.height - (place.qSimBoxP.qSimFillValue - 2));
                            g.setColor(Color.BLACK);
                            g.drawRect(nodeBounds.x + 35, nodeBounds.y - 25, 10, nodeBounds.height);
                        }
                    }
                    if (place.drawGraphBoxP.isColorChanged()) {
                        Color oldColor = g.getColor();
                        g.setColor(place.drawGraphBoxP.getPlaceNewColor());
                        g.fillOval(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 1, nodeBounds.height - 1);
                        g.setColor(oldColor);
                    }
                    if (place.drawGraphBoxP.getNumericalValueVisibility()) {
                        String clNumber = ElementDraw.formatD(place.drawGraphBoxP.getNumericalValueDOUBLE());
                        int posX = nodeBounds.x + nodeBounds.width - g.getFontMetrics().stringWidth(clNumber) / 2;
                        int posY = nodeBounds.y - 1;
                        old = g.getFont();
                        oldC = g.getColor();
                        g.setFont(new Font("TimesRoman", 1, 14));
                        g.setColor(Color.black);
                        g.drawString(clNumber, posX - 5 + place.drawGraphBoxP.valueXoff, posY + place.drawGraphBoxP.valueYoff);
                        g.setFont(old);
                        g.setColor(oldC);
                    }
                    if (place.drawGraphBoxP.showAddText()) {
                        String txt = place.drawGraphBoxP.returnAddText();
                        int posX = nodeBounds.x + nodeBounds.width - g.getFontMetrics().stringWidth(txt) / 2;
                        int posY = nodeBounds.y - 1;
                        old = g.getFont();
                        oldC = g.getColor();
                        g.setFont(new Font("TimesRoman", 1, 14));
                        g.setColor(Color.BLACK);
                        g.drawString(txt, posX + place.drawGraphBoxP.txtXoff, posY + place.drawGraphBoxP.txtYoff);
                        g.setFont(old);
                        g.setColor(oldC);
                    }
                    if (el.isPortalSelected() && !el.isSelected()) {
                        if (eds.snoopyMode) {
                            g.setColor(EditorResources.selectionColorLevel3);
                            g.fillOval(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 2, nodeBounds.height - 2);
                        }
                        ElementDraw.drawCrossHair(g, nodeBounds.x - (place.getRadius() - 6), nodeBounds.y - (place.getRadius() - 6), EditorResources.lightSky2, true);
                    }
                    if (place.isPortal()) {
                        if (eds.snoopyMode) {
                            g.setColor(portalColor);
                            g.fillOval(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 2, nodeBounds.height - 2);
                        } else {
                            g.drawOval(nodeBounds.x + 3, nodeBounds.y + 3, nodeBounds.width - 6, nodeBounds.height - 6);
                            if (eds.newPlacePortal) {
                                g.setColor(Color.black);
                                g.fillOval(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                                g.setColor(Color.white);
                                g.fillOval(nodeBounds.x + 4, nodeBounds.y + 4, nodeBounds.width - 8, nodeBounds.height - 8);
                            } else {
                                g.setColor(Color.white);
                                g.fillOval(nodeBounds.x + 4, nodeBounds.y + 4, nodeBounds.width - 8, nodeBounds.height - 8);
                            }
                        }
                    }
                    ElementDraw.drawTokens(g, place, nodeBounds);
                    if (place.branchColor != null) {
                        Color oldColor = g.getColor();
                        g.setColor(place.branchColor);
                        g.fillOval(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width - 1, nodeBounds.height - 1);
                        g.setColor(oldColor);
                    }
                    if (!place.branchBorderColors.isEmpty()) {
                        int x = 0;
                        int y = 0;
                        for (Color c : place.branchBorderColors) {
                            g.setColor(Color.black);
                            g.fillOval(nodeBounds.x + 40 + x, nodeBounds.y + y, 6, 6);
                            g.setColor(c);
                            g.fillOval(nodeBounds.x + 40 + x, nodeBounds.y + y, 5, 5);
                            if ((y += 6) != 42) continue;
                            y = 0;
                            x += 6;
                        }
                    }
                    if (!eds.color && !(place instanceof PlaceColored)) continue;
                    try {
                        assert (place instanceof PlaceColored);
                        ElementDraw.coloredPlaceDemo(g, (PlaceColored)place, nodeBounds);
                    }
                    catch (Exception ex) {
                        overlord.log(lang.getText("LOGentry00329exception") + "\n" + ex.getMessage(), "error", true);
                    }
                }
                break block110;
            }
            if (!(node instanceof MetaNode)) break block110;
            MetaNode metanode = (MetaNode)node;
            for (ElementLocation el : metanode.getNodeLocations(sheetId)) {
                int radius = metanode.getRadius();
                Rectangle nodeBounds = new Rectangle(el.getPosition().x - radius, el.getPosition().y - radius, radius * 2, radius * 2);
                g.setColor(new Color(224, 224, 224));
                g.setColor(Color.DARK_GRAY);
                g.setStroke(new BasicStroke(1.5f));
                g.drawRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                g.drawRect(nodeBounds.x + 1, nodeBounds.y + 1, nodeBounds.width, nodeBounds.height);
                g.drawRect(nodeBounds.x + 2, nodeBounds.y + 2, nodeBounds.width, nodeBounds.height);
                g.setColor(Color.LIGHT_GRAY);
                g.fillRect(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height);
                if (((MetaNode)node).getMetaType() == MetaNode.MetaType.SUBNETTRANS) {
                    g.setStroke(new BasicStroke(2.0f));
                    g.setColor(Color.RED);
                    g.drawLine(nodeBounds.x + 7, nodeBounds.y + 7, nodeBounds.x + 23, nodeBounds.y + 7);
                    g.drawLine(nodeBounds.x + 7, nodeBounds.y + 23, nodeBounds.x + 23, nodeBounds.y + 23);
                    g.drawLine(nodeBounds.x + 7, nodeBounds.y + 7, nodeBounds.x + 7, nodeBounds.y + 23);
                    g.drawLine(nodeBounds.x + 23, nodeBounds.y + 7, nodeBounds.x + 23, nodeBounds.y + 23);
                } else if (((MetaNode)node).getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                    g.setStroke(new BasicStroke(2.0f));
                    g.setColor(Color.RED);
                    g.drawOval(nodeBounds.x + 6, nodeBounds.y + 6, 18, 18);
                } else if (((MetaNode)node).getMetaType() == MetaNode.MetaType.SUBNET) {
                    g.setStroke(new BasicStroke(2.0f));
                    g.setColor(Color.RED);
                    g.drawOval(nodeBounds.x + 6, nodeBounds.y + 6, 18, 18);
                    g.drawLine(nodeBounds.x + 10, nodeBounds.y + 10, nodeBounds.x + 20, nodeBounds.y + 10);
                    g.drawLine(nodeBounds.x + 10, nodeBounds.y + 20, nodeBounds.x + 20, nodeBounds.y + 20);
                    g.drawLine(nodeBounds.x + 10, nodeBounds.y + 10, nodeBounds.x + 10, nodeBounds.y + 20);
                    g.drawLine(nodeBounds.x + 20, nodeBounds.y + 10, nodeBounds.x + 20, nodeBounds.y + 20);
                }
                g.setColor(Color.black);
                g.setFont(new Font("TimesRoman", 0, 7));
                g.setColor(EditorResources.glowTransitonTextColor);
            }
        }
        return g;
    }

    private static void timeTransitionsSpecialFeatures(Graphics2D g, Transition trans, Rectangle nodeBounds) {
        if (trans.getTransType() == Transition.TransitionType.TPN) {
            int dpnTextOffset = -5;
            if (trans.timeExtension.isTPN()) {
                dpnTextOffset = -15;
                g.setColor(Color.black);
                g.setFont(f_plain);
                String eft = String.valueOf(trans.timeExtension.getEFT());
                g.drawString(eft, nodeBounds.x + 35, nodeBounds.y + 8);
                String lft = String.valueOf(trans.timeExtension.getLFT());
                g.drawString(lft, nodeBounds.x + 35, nodeBounds.y + 28);
                int intTimer = (int)trans.timeExtension.getTPNtimer();
                int intFireTime = (int)trans.timeExtension.getTPNtimerLimit();
                Object timeInfo = intTimer + "  /  " + intFireTime;
                if (!trans.isActive()) {
                    timeInfo = "# / #";
                }
                int offset = -9;
                if (((String)timeInfo).length() < 7) {
                    offset = 4;
                } else if (((String)timeInfo).length() < 9) {
                    offset = 1;
                } else if (((String)timeInfo).length() < 10) {
                    offset = -3;
                } else if (((String)timeInfo).length() < 11) {
                    offset = -5;
                } else if (((String)timeInfo).length() < 12) {
                    offset = -7;
                }
                g.drawString((String)timeInfo, nodeBounds.x + offset, nodeBounds.y - 4);
            }
            if (trans.timeExtension.isDPN()) {
                Object dur = String.valueOf(trans.timeExtension.getDPNduration());
                dur = trans.timeExtension.getDPNtimer() >= 0.0 ? trans.timeExtension.getDPNtimer() + " / " + (String)dur : " # / " + (String)dur;
                int offset = ((String)(dur = "(" + (String)dur + ")")).length() < 9 ? -1 : (((String)dur).length() < 10 ? -3 : (((String)dur).length() < 11 ? -7 : (((String)dur).length() < 12 ? -10 : -13)));
                g.setFont(f_bold);
                g.setColor(Color.red);
                g.drawString((String)dur, nodeBounds.x + offset, nodeBounds.y + dpnTextOffset);
                g.setColor(Color.black);
                g.setFont(f_plain);
            }
            g.setColor(Color.LIGHT_GRAY);
            g.drawLine(nodeBounds.x + 8, nodeBounds.y + 7, nodeBounds.x + 22, nodeBounds.y + 7);
            g.drawLine(nodeBounds.x + 8, nodeBounds.y + 23, nodeBounds.x + 22, nodeBounds.y + 23);
            g.drawLine(nodeBounds.x + 9, nodeBounds.y + 8, nodeBounds.x + 21, nodeBounds.y + 22);
            g.drawLine(nodeBounds.x + 9, nodeBounds.y + 22, nodeBounds.x + 21, nodeBounds.y + 8);
            g.setColor(Color.black);
            g.setFont(new Font("TimesRoman", 0, 7));
        } else if (trans instanceof TransitionXTPN) {
            g.setColor(Color.DARK_GRAY);
            g.drawLine(nodeBounds.x + 8, nodeBounds.y + 7, nodeBounds.x + 22, nodeBounds.y + 7);
            g.drawLine(nodeBounds.x + 8, nodeBounds.y + 23, nodeBounds.x + 22, nodeBounds.y + 23);
            g.drawLine(nodeBounds.x + 9, nodeBounds.y + 8, nodeBounds.x + 21, nodeBounds.y + 22);
            g.drawLine(nodeBounds.x + 9, nodeBounds.y + 22, nodeBounds.x + 21, nodeBounds.y + 8);
            g.setColor(Color.black);
            g.setFont(new Font("TimesRoman", 0, 7));
        }
    }

    public static Graphics2D drawArc(Arc arc, Graphics2D g, int sheetId, int zoom, ElementDrawSettings eds) {
        if (arc.getLocationSheetId() != sheetId) {
            return g;
        }
        boolean prodSim = arc.arcXTPNbox.getXTPNprodStatus();
        boolean actSim = arc.arcXTPNbox.getXTPNactStatus();
        Stroke sizeStroke = g.getStroke();
        ArrayList<Point> breakPoints = arc.accessBreaks();
        int breaks = breakPoints.size();
        Point startP = new Point(arc.getStartLocation().getPosition());
        Point endP = new Point();
        int endRadius = 0;
        if (arc.getEndLocation() == null) {
            endP = arc.getTempEndPoint();
        } else {
            endP = (Point)arc.getEndLocation().getPosition().clone();
            endRadius = arc.getEndLocation().getParentNode().getRadius();
        }
        int distX = Tools.absolute(startP.x - endP.x);
        int distY = Tools.absolute(startP.y - endP.y);
        if (distX == distY) {
            startP.setLocation(startP.x + 1, startP.y);
        }
        int incFactorM = 0;
        int incFactorRadius = 0;
        if (arc.arcQSimBox.qSimForcedArc) {
            incFactorM = 6;
            incFactorRadius = 15;
        }
        Point tmpStart = (Point)startP.clone();
        if (breaks > 0) {
            tmpStart = breakPoints.get(breaks - 1);
        }
        double alfa = endP.x - tmpStart.x + endP.y - tmpStart.y == 0 ? 0.0 : Math.atan(((double)endP.y - (double)tmpStart.y) / ((double)endP.x - (double)tmpStart.x));
        double alfaCos = Math.cos(alfa);
        double alfaSin = Math.sin(alfa);
        double sign = endP.x < tmpStart.x ? 1.0 : -1.0;
        double M = 4 + incFactorM;
        double xp = (double)endP.x + (double)endRadius * alfaCos * sign;
        double yp = (double)endP.y + (double)endRadius * alfaSin * sign;
        double xl = (double)endP.x + (double)(endRadius + 10 + incFactorRadius) * alfaCos * sign + M * alfaSin;
        double yl = (double)endP.y + (double)(endRadius + 10 + incFactorRadius) * alfaSin * sign - M * alfaCos;
        double xk = (double)endP.x + (double)(endRadius + 10 + incFactorRadius) * alfaCos * sign - M * alfaSin;
        double yk = (double)endP.y + (double)(endRadius + 10 + incFactorRadius) * alfaSin * sign + M * alfaCos;
        if (arc.getSelected()) {
            g.setColor(EditorResources.selectionColorLevel3);
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(startP.x, startP.y, endP.x, endP.y);
            g.drawPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
        }
        if (arc.isGlowed_Sub() && breaks == 0) {
            g.setColor(EditorResources.glowMTCTransitonColorLevel3);
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(startP.x, startP.y, endP.x, endP.y);
            g.drawPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
        }
        g.setStroke(new BasicStroke(1.0f));
        if (arc.getIsCorect()) {
            if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                g.setStroke(new BasicStroke(2.0f));
                g.setColor(Color.blue);
            } else {
                g.setColor(Color.darkGray);
            }
        } else {
            g.setColor(new Color(176, 23, 31));
        }
        if (arc.getPairedArc() == null || arc.isMainArcOfPair()) {
            if (arc.getArcType() == Arc.TypeOfArc.META_ARC) {
                g.setColor(new Color(30, 144, 255, 150));
                Stroke backup = g.getStroke();
                g.setStroke(new BasicStroke(4.0f));
                g.drawLine(startP.x, startP.y, (int)xp, (int)yp);
                g.drawLine(startP.x, startP.y, (int)xp, (int)yp);
                g.drawLine(startP.x, startP.y, (int)xp, (int)yp);
                g.setStroke(backup);
            } else {
                if (arc.arcXTPNbox.isXTPN() || arc.arcXTPNbox.isXTPNinhibitor()) {
                    g.setStroke(new BasicStroke(2.0f));
                } else {
                    g.setStroke(new BasicStroke(eds.arcSize));
                }
                if (breaks > 0) {
                    ElementDraw.drawBreaks(g, arc, startP, (int)xp, (int)yp, breakPoints, breaks, eds);
                } else if (!arc.arcDecoBox.layers.isEmpty()) {
                    int move = 0;
                    for (Color color : arc.arcDecoBox.layers) {
                        g.setColor(Color.black);
                        backup = g.getStroke();
                        g.setStroke(new BasicStroke(3.0f));
                        g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                        g.setColor(color);
                        g.setStroke(new BasicStroke(2.0f));
                        g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                        g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                        g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                        g.setStroke(backup);
                        move += 3;
                    }
                } else {
                    if (arc.arcXTPNbox.isXTPN()) {
                        if (actSim) {
                            g.setColor(EditorResources.activationXTPNcolor);
                        } else if (prodSim) {
                            g.setColor(EditorResources.productionXTPNcolor);
                        } else {
                            g.setStroke(new BasicStroke(eds.arcSize));
                            g.setColor(EditorResources.arcNeutralXTPNcolor);
                        }
                    } else if (arc.arcXTPNbox.isXTPNinhibitor()) {
                        g.setColor(EditorResources.inhibitorXTPNcolor);
                    }
                    g.drawLine(startP.x, startP.y, (int)xp, (int)yp);
                }
            }
        } else {
            if (arc.arcXTPNbox.isXTPN() || arc.arcXTPNbox.isXTPNinhibitor()) {
                g.setStroke(new BasicStroke(2.0f));
            } else {
                g.setStroke(new BasicStroke(eds.arcSize));
            }
            if (breaks > 0) {
                ElementDraw.drawBreaks(g, arc, startP, (int)xp, (int)yp, breakPoints, breaks, eds);
            } else if (!arc.arcDecoBox.layers.isEmpty()) {
                int move = 0;
                for (Color color : arc.arcDecoBox.layers) {
                    g.setColor(Color.black);
                    backup = g.getStroke();
                    g.setStroke(new BasicStroke(3.0f));
                    g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                    g.setColor(color);
                    g.setStroke(new BasicStroke(2.0f));
                    g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                    g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                    g.drawLine(startP.x + move, startP.y + move, (int)xp + move, (int)yp + move);
                    g.setStroke(backup);
                    move += 3;
                }
            } else {
                if (arc.arcXTPNbox.isXTPN()) {
                    if (actSim) {
                        g.setColor(EditorResources.activationXTPNcolor);
                    } else if (prodSim) {
                        g.setColor(EditorResources.productionXTPNcolor);
                    }
                } else if (arc.arcXTPNbox.isXTPNinhibitor()) {
                    g.setColor(EditorResources.inhibitorXTPNcolor);
                }
                g.drawLine(startP.x, startP.y, (int)xp, (int)yp);
            }
        }
        if (arc.arcDecoBox.isColorChanged() && breaks == 0) {
            Color oldColor = g.getColor();
            g.setColor(arc.arcDecoBox.getArcNewColor());
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(startP.x, startP.y, endP.x, endP.y);
            g.drawPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
            g.setColor(oldColor);
        }
        if (arc.arcQSimBox.qSimForcedArc && breaks == 0) {
            g.setColor(arc.arcQSimBox.qSimForcedColor);
            g.setStroke(new BasicStroke(4.0f));
            g.drawLine(startP.x, startP.y, (int)xp, (int)yp);
            alfa = endP.x - startP.x + endP.y - startP.y == 0 ? 0.0 : Math.atan(((double)endP.y - (double)startP.y) / ((double)endP.x - (double)startP.x));
            alfaCos = Math.cos(alfa);
            alfaSin = Math.sin(alfa);
            sign = endP.x < startP.x ? 1.0 : -1.0;
            M = 4 + incFactorM;
            xp = (double)endP.x + (double)endRadius * alfaCos * sign;
            yp = (double)endP.y + (double)endRadius * alfaSin * sign;
            xl = (double)endP.x + (double)(endRadius + 10 + incFactorRadius) * alfaCos * sign + M * alfaSin;
            yl = (double)endP.y + (double)(endRadius + 10 + incFactorRadius) * alfaSin * sign - M * alfaCos;
            xk = (double)endP.x + (double)(endRadius + 10 + incFactorRadius) * alfaCos * sign - M * alfaSin;
            yk = (double)endP.y + (double)(endRadius + 10 + incFactorRadius) * alfaSin * sign + M * alfaCos;
        }
        g.setStroke(sizeStroke);
        if (arc.getArcType() == Arc.TypeOfArc.NORMAL || arc.getArcType() == Arc.TypeOfArc.READARC) {
            if (arc.arcXTPNbox.isXTPN()) {
                M += 2.0;
                if (actSim) {
                    g.setColor(EditorResources.activationXTPNcolor);
                } else if (prodSim) {
                    g.setColor(EditorResources.productionXTPNcolor);
                } else {
                    g.setStroke(new BasicStroke(eds.arcSize));
                    g.setColor(EditorResources.arcNeutralXTPNcolor);
                }
                xl = (double)endP.x + (double)(endRadius + 20) * alfaCos * sign + M * alfaSin;
                yl = (double)endP.y + (double)(endRadius + 20) * alfaSin * sign - M * alfaCos;
                xk = (double)endP.x + (double)(endRadius + 20) * alfaCos * sign - M * alfaSin;
                yk = (double)endP.y + (double)(endRadius + 20) * alfaSin * sign + M * alfaCos;
                g.fillPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
            } else {
                g.fillPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
            }
        } else if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
            g.fillPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
        } else if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
            if (arc.arcXTPNbox.isXTPNinhibitor()) {
                g.setColor(EditorResources.inhibitorXTPNcolor);
                g.setStroke(new BasicStroke(2.0f));
            }
            int xPos = (int)((xl + xk) / 2.0);
            int yPos = (int)((yl + yk) / 2.0);
            double piiii = 3.14;
            if (!(alfaSin > -0.45 && alfaSin < 0.45 || alfaCos > 0.0 && alfaCos < 0.45)) {
                double angle = Math.abs(alfaSin) + Math.abs(alfaCos);
                piiii = 3.14 + 12.52 * (angle / 2.0);
            }
            int xT = (int)(((double)xPos - xp) / piiii);
            int yT = (int)(((double)yPos - yp) / piiii);
            if (arc.arcQSimBox.qSimForcedArc) {
                g.setColor(arc.arcQSimBox.qSimForcedColor);
                g.setStroke(new BasicStroke(4.0f));
                g.drawOval(xPos - 6 - xT, yPos - 6 - yT, 12, 12);
            } else {
                g.setColor(EditorResources.graphPanelColor);
                g.fillOval(xPos - 6 - xT, yPos - 6 - yT, 12, 12);
                g.setColor(Color.black);
                g.drawOval(xPos - 6 - xT, yPos - 6 - yT, 12, 12);
            }
        } else if (arc.getArcType() == Arc.TypeOfArc.RESET) {
            g.fillPolygon(new int[]{(int)xp, (int)xl, (int)xk}, new int[]{(int)yp, (int)yl, (int)yk}, 3);
            xl = (double)endP.x + (double)(endRadius + 30) * alfaCos * sign + M * alfaSin;
            yl = (double)endP.y + (double)(endRadius + 30) * alfaSin * sign - M * alfaCos;
            xk = (double)endP.x + (double)(endRadius + 30) * alfaCos * sign - M * alfaSin;
            yk = (double)endP.y + (double)(endRadius + 30) * alfaSin * sign + M * alfaCos;
            double newxp = (double)endP.x - (double)(endRadius - 45) * alfaCos * sign;
            double newyp = (double)endP.y - (double)(endRadius - 45) * alfaSin * sign;
            g.fillPolygon(new int[]{(int)newxp, (int)xl, (int)xk}, new int[]{(int)newyp, (int)yl, (int)yk}, 3);
        } else if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
            int xPos = (int)((xl + xk) / 2.0);
            int yPos = (int)((yl + yk) / 2.0);
            int xT = (int)(((double)xPos - xp) / 3.14);
            int yT = (int)(((double)yPos - yp) / 3.14);
            g.fillOval(xPos - 4 - xT, yPos - 4 - yT, 8, 8);
            xT = (int)((double)xPos - xp);
            yT = (int)((double)yPos - yp);
            g.fillOval(xPos - 4 + xT, yPos - 4 + yT, 8, 8);
        } else if (arc.getArcType() == Arc.TypeOfArc.META_ARC) {
            double Mmeta = 6.0;
            double xpmeta = (double)endP.x + (double)(endRadius - 10) * alfaCos * sign;
            double ypmeta = (double)endP.y + (double)(endRadius - 10) * alfaSin * sign;
            double xlmeta = (double)endP.x + (double)(endRadius + 13) * alfaCos * sign + Mmeta * alfaSin;
            double ylmeta = (double)endP.y + (double)(endRadius + 13) * alfaSin * sign - Mmeta * alfaCos;
            double xkmeta = (double)endP.x + (double)(endRadius + 13) * alfaCos * sign - Mmeta * alfaSin;
            double ykmeta = (double)endP.y + (double)(endRadius + 13) * alfaSin * sign + Mmeta * alfaCos;
            g.setColor(new Color(30, 144, 255, 250));
            g.fillPolygon(new int[]{(int)xpmeta, (int)xlmeta, (int)xkmeta}, new int[]{(int)ypmeta, (int)ylmeta, (int)ykmeta}, 3);
        }
        Object wTxt = Integer.toString(arc.getWeight());
        if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
            wTxt = arc.getColorWeight(0) + "," + arc.getColorWeight(1) + "," + arc.getColorWeight(2) + "," + arc.getColorWeight(3) + "," + arc.getColorWeight(4) + "," + arc.getColorWeight(5);
        }
        if (arc.getWeight() > 1 || arc.getArcType() == Arc.TypeOfArc.COLOR) {
            if (!arc.accessBreaks().isEmpty()) {
                Point breakP = arc.accessBreaks().get(0);
                g.setFont(new Font("Tahoma", 0, 18));
                g.drawString((String)wTxt, breakP.x, breakP.y - 10);
            } else {
                int x_weight = (endP.x + startP.x) / 2;
                int y_weight = (endP.y + startP.y) / 2;
                double atang = Math.toDegrees(Math.atan2(endP.y - startP.y, endP.x - startP.x));
                if (atang < 0.0) {
                    atang += 360.0;
                }
                if (atang == 90.0 || atang == 270.0) {
                    x_weight += 10;
                }
                if ((atang %= 90.0) < 45.0) {
                    y_weight += 5;
                    x_weight -= 5;
                } else {
                    y_weight -= 15;
                }
                g.setFont(new Font("Tahoma", 0, 18));
                if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                    int aW0 = arc.getColorWeight(0);
                    int aW1 = arc.getColorWeight(1);
                    int aW2 = arc.getColorWeight(2);
                    int aW3 = arc.getColorWeight(3);
                    int aW4 = arc.getColorWeight(4);
                    int aW5 = arc.getColorWeight(5);
                    int defract = 0;
                    if (aW0 > 0) {
                        defract += 7;
                    }
                    if (aW1 > 0) {
                        defract += 7;
                    }
                    if (aW2 > 0) {
                        defract += 7;
                    }
                    if (aW3 > 0) {
                        defract += 7;
                    }
                    if (aW4 > 0) {
                        defract += 7;
                    }
                    if (aW5 > 0) {
                        defract += 7;
                    }
                    x_weight -= defract;
                    y_weight += 10;
                    if (aW0 > 0) {
                        g.setColor(EditorResources.cRed);
                        g.drawString("" + aW0, x_weight, y_weight);
                        x_weight += 11;
                    }
                    if (aW1 > 0) {
                        g.setColor(EditorResources.cGreen);
                        g.drawString("" + aW1, x_weight, y_weight);
                        x_weight += 11;
                    }
                    if (aW2 > 0) {
                        g.setColor(EditorResources.cBlue);
                        g.drawString("" + aW2, x_weight, y_weight);
                        x_weight += 11;
                    }
                    if (aW3 > 0) {
                        g.setColor(EditorResources.cYellow);
                        g.drawString("" + aW3, x_weight, y_weight);
                        x_weight += 11;
                    }
                    if (aW4 > 0) {
                        g.setColor(EditorResources.cGrey);
                        g.drawString("" + aW4, x_weight, y_weight);
                        x_weight += 11;
                    }
                    if (aW5 > 0) {
                        g.setColor(EditorResources.cBlack);
                        g.drawString("" + aW5, x_weight, y_weight);
                        x_weight += 11;
                    }
                } else {
                    g.drawString((String)wTxt, x_weight, y_weight + 10);
                }
            }
        }
        return g;
    }

    private static void drawBreaks(Graphics2D g, Arc arc, Point startP, int endPx, int endPy, ArrayList<Point> breaksVector, int breaks, ElementDrawSettings eds) {
        Color oldColor;
        Color oldColor2;
        if (arc.arcQSimBox.qSimForcedArc) {
            g.setColor(arc.arcQSimBox.qSimForcedColor);
            g.setStroke(new BasicStroke(4.0f));
        }
        boolean prodSim = arc.arcXTPNbox.getXTPNprodStatus();
        boolean actSim = arc.arcXTPNbox.getXTPNactStatus();
        if (arc.arcXTPNbox.isXTPN()) {
            if (actSim) {
                g.setColor(EditorResources.activationXTPNcolor);
                g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
            } else if (prodSim) {
                g.setColor(EditorResources.productionXTPNcolor);
                g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
            } else {
                g.setStroke(new BasicStroke(eds.arcSize));
                g.setColor(EditorResources.arcNeutralXTPNcolor);
                g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
            }
        } else if (arc.arcXTPNbox.isXTPNinhibitor()) {
            g.setColor(EditorResources.inhibitorXTPNcolor);
            g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
        } else {
            g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
        }
        if (arc.arcDecoBox.isColorChanged()) {
            oldColor2 = g.getColor();
            g.setColor(arc.arcDecoBox.getArcNewColor());
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
            g.setColor(oldColor2);
        }
        if (arc.isGlowed_Sub()) {
            oldColor2 = g.getColor();
            g.setColor(EditorResources.glowMTCTransitonColorLevel3);
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(startP.x, startP.y, breaksVector.get((int)0).x, breaksVector.get((int)0).y);
            g.setColor(oldColor2);
        }
        if (!arc.arcDecoBox.layers.isEmpty()) {
            int move = 0;
            for (Color color : arc.arcDecoBox.layers) {
                g.setColor(Color.black);
                Stroke backup = g.getStroke();
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(startP.x + move, startP.y + move, breaksVector.get((int)0).x + move, breaksVector.get((int)0).y + move);
                g.setColor(color);
                g.setStroke(new BasicStroke(2.0f));
                g.drawLine(startP.x + move, startP.y + move, breaksVector.get((int)0).x + move, breaksVector.get((int)0).y + move);
                g.drawLine(startP.x + move, startP.y + move, breaksVector.get((int)0).x + move, breaksVector.get((int)0).y + move);
                g.drawLine(startP.x + move, startP.y + move, breaksVector.get((int)0).x + move, breaksVector.get((int)0).y + move);
                g.setStroke(backup);
                move += 3;
            }
        }
        for (int b = 1; b < breaks; ++b) {
            Point breakPoint = breaksVector.get(b - 1);
            if (arc.arcXTPNbox.isXTPN()) {
                if (actSim) {
                    g.setColor(EditorResources.activationXTPNcolor);
                    g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
                } else if (prodSim) {
                    g.setColor(EditorResources.productionXTPNcolor);
                    g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
                } else {
                    g.setStroke(new BasicStroke(eds.arcSize));
                    g.setColor(EditorResources.arcNeutralXTPNcolor);
                    g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
                }
            } else if (arc.arcXTPNbox.isXTPNinhibitor()) {
                g.setColor(EditorResources.inhibitorXTPNcolor);
                g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
            } else {
                g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
            }
            g.fillOval(breakPoint.x - 3, breakPoint.y - 3, 6, 6);
            if (arc.arcDecoBox.isColorChanged()) {
                Color oldColor3 = g.getColor();
                g.setColor(arc.arcDecoBox.getArcNewColor());
                g.setStroke(EditorResources.glowStrokeArc);
                g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
                g.setColor(oldColor3);
            }
            if (arc.isGlowed_Sub()) {
                Color oldColor4 = g.getColor();
                g.setColor(EditorResources.glowMTCTransitonColorLevel3);
                g.setStroke(EditorResources.glowStrokeArc);
                g.drawLine(breakPoint.x, breakPoint.y, breaksVector.get((int)b).x, breaksVector.get((int)b).y);
                g.setColor(oldColor4);
            }
            int move = 0;
            for (Color color : arc.arcDecoBox.layers) {
                g.setColor(Color.black);
                Stroke backup = g.getStroke();
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(breakPoint.x + move, breakPoint.y + move, breaksVector.get((int)b).x + move, breaksVector.get((int)b).y + move);
                g.setColor(color);
                g.setStroke(new BasicStroke(2.0f));
                g.drawLine(breakPoint.x + move, breakPoint.y + move, breaksVector.get((int)b).x + move, breaksVector.get((int)b).y + move);
                g.drawLine(breakPoint.x + move, breakPoint.y + move, breaksVector.get((int)b).x + move, breaksVector.get((int)b).y + move);
                g.drawLine(breakPoint.x + move, breakPoint.y + move, breaksVector.get((int)b).x + move, breaksVector.get((int)b).y + move);
                g.setStroke(backup);
                move += 3;
            }
        }
        Point lastPoint = breaksVector.get(breaks - 1);
        if (arc.arcXTPNbox.isXTPN()) {
            if (actSim) {
                g.setColor(EditorResources.activationXTPNcolor);
                g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
            } else if (prodSim) {
                g.setColor(EditorResources.productionXTPNcolor);
                g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
            } else {
                g.setStroke(new BasicStroke(eds.arcSize));
                g.setColor(EditorResources.arcNeutralXTPNcolor);
                g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
            }
        } else if (arc.arcXTPNbox.isXTPNinhibitor()) {
            g.setColor(EditorResources.inhibitorXTPNcolor);
            g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
        } else {
            g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
        }
        g.fillOval(lastPoint.x - 3, lastPoint.y - 3, 6, 6);
        if (arc.arcDecoBox.isColorChanged()) {
            oldColor = g.getColor();
            g.setColor(arc.arcDecoBox.getArcNewColor());
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
            g.setColor(oldColor);
        }
        if (arc.isGlowed_Sub()) {
            oldColor = g.getColor();
            g.setColor(EditorResources.glowMTCTransitonColorLevel3);
            g.setStroke(EditorResources.glowStrokeArc);
            g.drawLine(lastPoint.x, lastPoint.y, endPx, endPy);
            g.setColor(oldColor);
        }
        if (!arc.arcDecoBox.layers.isEmpty()) {
            int move = 0;
            for (Color color : arc.arcDecoBox.layers) {
                g.setColor(Color.black);
                Stroke backup = g.getStroke();
                g.setStroke(new BasicStroke(3.0f));
                g.drawLine(lastPoint.x + move, lastPoint.y + move, endPx + move, endPy + move);
                g.setColor(color);
                g.setStroke(new BasicStroke(2.0f));
                g.drawLine(lastPoint.x + move, lastPoint.y + move, endPx + move, endPy + move);
                g.drawLine(lastPoint.x + move, lastPoint.y + move, endPx + move, endPy + move);
                g.drawLine(lastPoint.x + move, lastPoint.y + move, endPx + move, endPy + move);
                g.setStroke(backup);
                move += 3;
            }
        }
    }

    private static void drawTokens(Graphics2D g, Place place, Rectangle nodeBounds) {
        g.setColor(Color.black);
        g.setFont(new Font("TimesRoman", 1, 14));
        if (place.isColored) {
            int posX = nodeBounds.x + nodeBounds.width / 2 - g.getFontMetrics().stringWidth("C") / 2 - 3;
            int posY = nodeBounds.y + nodeBounds.height / 2 + 8;
            Font old = g.getFont();
            Color oldC = g.getColor();
            g.setFont(new Font("Garamond", 1, 22));
            g.setColor(Color.RED);
            g.drawString("C", posX, posY);
            g.setFont(old);
            g.setColor(oldC);
            return;
        }
        if (place instanceof PlaceXTPN) {
            if (place.getTokensNumber() == 1) {
                int x = nodeBounds.x + nodeBounds.width / 2;
                int y = nodeBounds.y + nodeBounds.height / 2;
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y - 5, 10, 10);
            } else if (place.getTokensNumber() == 2) {
                int x = nodeBounds.x + nodeBounds.width / 2;
                int y = nodeBounds.y + nodeBounds.height / 2;
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 12, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 12, y - 5, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 2, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 2, y - 5, 10, 10);
            } else if (place.getTokensNumber() == 3) {
                int x = nodeBounds.x + nodeBounds.width / 2;
                int y = nodeBounds.y + nodeBounds.height / 2;
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y - 10, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y - 10, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 12, y + 1, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 12, y + 1, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 2, y + 1, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 2, y + 1, 10, 10);
            } else if (place.getTokensNumber() == 4) {
                int x = nodeBounds.x + nodeBounds.width / 2;
                int y = nodeBounds.y + nodeBounds.height / 2;
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 12, y - 11, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 12, y - 11, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 2, y - 11, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 2, y - 11, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 12, y + 1, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 12, y + 1, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 2, y + 1, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 2, y + 1, 10, 10);
            } else if (place.getTokensNumber() == 5) {
                int x = nodeBounds.x + nodeBounds.width / 2;
                int y = nodeBounds.y + nodeBounds.height / 2;
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y - 16, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y - 16, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 16, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 16, y - 5, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y - 5, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 6, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 6, y - 5, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y + 6, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y + 6, 10, 10);
            } else if (place.getTokensNumber() == 6) {
                int x = nodeBounds.x + nodeBounds.width / 2;
                int y = nodeBounds.y + nodeBounds.height / 2;
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y - 16, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y - 16, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 16, y - 7, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 16, y - 7, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 5, y - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 5, y - 5, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 6, y - 7, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 6, y - 7, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x - 11, y + 4, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x - 11, y + 4, 10, 10);
                g.setColor(EditorResources.tokenDefaultColor);
                g.fillOval(x + 2, y + 4, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval(x + 2, y + 4, 10, 10);
            } else if (place.getTokensNumber() > 6) {
                g.setColor(Color.RED);
                g.setFont(new Font("TimesRoman", 1, 18));
                g.drawString(Integer.toString(place.getTokensNumber()), nodeBounds.x + nodeBounds.width / 2 - g.getFontMetrics().stringWidth(Integer.toString(place.getTokensNumber())) / 2, nodeBounds.y + nodeBounds.height / 2 + 6);
            }
        } else if (place.getTokensNumber() == 1) {
            int x = nodeBounds.x + nodeBounds.width / 2;
            int y = nodeBounds.y + nodeBounds.height / 2;
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x - 5, y - 5, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x - 5, y - 5, 10, 10);
        } else if (place.getTokensNumber() == 2) {
            int x = nodeBounds.x + nodeBounds.width / 2;
            int y = nodeBounds.y + nodeBounds.height / 2;
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x - 12, y - 5, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x - 12, y - 5, 10, 10);
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x + 2, y - 5, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x + 2, y - 5, 10, 10);
        } else if (place.getTokensNumber() == 3) {
            int x = nodeBounds.x + nodeBounds.width / 2;
            int y = nodeBounds.y + nodeBounds.height / 2;
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x - 5, y - 10, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x - 5, y - 10, 10, 10);
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x - 12, y + 1, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x - 12, y + 1, 10, 10);
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x + 2, y + 1, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x + 2, y + 1, 10, 10);
        } else if (place.getTokensNumber() == 4) {
            int x = nodeBounds.x + nodeBounds.width / 2;
            int y = nodeBounds.y + nodeBounds.height / 2;
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x - 12, y - 11, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x - 12, y - 11, 10, 10);
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x + 2, y - 11, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x + 2, y - 11, 10, 10);
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x - 12, y + 1, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x - 12, y + 1, 10, 10);
            g.setColor(EditorResources.tokenDefaultColor);
            g.fillOval(x + 2, y + 1, 10, 10);
            g.setColor(Color.black);
            g.setStroke(EditorResources.tokenDefaultStroke);
            g.drawOval(x + 2, y + 1, 10, 10);
        } else if (place.getTokensNumber() > 4) {
            g.drawString(Integer.toString(place.getTokensNumber()), nodeBounds.x + nodeBounds.width / 2 - g.getFontMetrics().stringWidth(Integer.toString(place.getTokensNumber())) / 2, nodeBounds.y + nodeBounds.height / 2 + 5);
        }
    }

    private static String formatD(double value) {
        DecimalFormat df = new DecimalFormat("#.####");
        Object txt = "";
        txt = (String)txt + df.format(value);
        txt = ((String)txt).replace(",", ".");
        return txt;
    }

    private static Color getColor(int tokens) {
        long steps = ElementDraw.overlord.simSettings.currentStep;
        if (steps > 10L) {
            if (tokens < 10) {
                return Color.white;
            }
            if ((double)tokens > (double)steps * 0.65) {
                return new Color(255, 0, 0);
            }
            if ((double)tokens > (double)steps * 0.6) {
                return new Color(255, 96, 0);
            }
            if ((double)tokens > (double)steps * 0.55) {
                return new Color(255, 164, 0);
            }
            if ((double)tokens > (double)steps * 0.45) {
                return new Color(255, 220, 0);
            }
            if ((double)tokens > (double)steps * 0.4) {
                return new Color(255, 255, 0);
            }
            if ((double)tokens > (double)steps * 0.35) {
                return new Color(196, 255, 0);
            }
            if ((double)tokens > (double)steps * 0.25) {
                return new Color(154, 255, 0);
            }
            if ((double)tokens > (double)steps * 0.2) {
                return new Color(100, 255, 0);
            }
            if ((double)tokens > (double)steps * 0.15) {
                return new Color(0, 200, 0);
            }
            return new Color(0, 164, 0);
        }
        return Color.white;
    }

    public static void drawMovingToken(Graphics2D g, int sheetId, Arc arc) {
        int STEP_COUNT = ElementDraw.overlord.simSettings.getArcGraphicDelay();
        int step = arc.getGraphicalSimulationSteps();
        if (!arc.isTransportingTokens || arc.getLocationSheetId() != sheetId || step > STEP_COUNT) {
            return;
        }
        int weight = arc.getWeight();
        ArrayList<Point> breakPoints = arc.accessBreaks();
        int breaks = breakPoints.size();
        Point startPos = arc.getStartLocation().getPosition();
        Point endPos = arc.getEndLocation().getPosition();
        double arcWidth = 0.0;
        if (breaks > 0) {
            ElementDraw.handleBrokenArc(g, STEP_COUNT, step, breakPoints, breaks, startPos, endPos, arcWidth, weight, arc);
        } else {
            double b;
            double a;
            arcWidth = Math.hypot(startPos.x - endPos.x, startPos.y - endPos.y);
            double stepSize = arcWidth / (double)STEP_COUNT;
            if (arc.isSimulationForwardDirection()) {
                a = (double)startPos.x - stepSize * (double)step * (double)(startPos.x - endPos.x) / arcWidth;
                b = (double)startPos.y - stepSize * (double)step * (double)(startPos.y - endPos.y) / arcWidth;
            } else {
                a = (double)endPos.x + stepSize * (double)step * (double)(startPos.x - endPos.x) / arcWidth;
                b = (double)endPos.y + stepSize * (double)step * (double)(startPos.y - endPos.y) / arcWidth;
            }
            g.setColor(EditorResources.tokenDefaultColor);
            boolean trollMode = false;
            if (trollMode) {
                try {
                    BufferedImage img = ImageIO.read(ElementDraw.class.getResource("/icons/tokenV2.png"));
                    g.drawImage(img, null, (int)a - 5, (int)b - 5);
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00604exception") + "\n" + ex.getMessage(), "error", true);
                }
            } else {
                g.fillOval((int)a - 5, (int)b - 5, 10, 10);
                g.setColor(Color.black);
                g.setStroke(EditorResources.tokenDefaultStroke);
                g.drawOval((int)a - 5, (int)b - 5, 10, 10);
            }
            Object wTxt = Integer.toString(weight);
            if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                wTxt = arc.getColorWeight(0) + "," + arc.getColorWeight(1) + "," + arc.getColorWeight(2) + "," + arc.getColorWeight(3) + "," + arc.getColorWeight(4) + "," + arc.getColorWeight(5);
            }
            Font font1 = new Font("Tahoma", 1, 14);
            Font font2 = new Font("Tahoma", 1, 13);
            Font font3 = new Font("Tahoma", 0, 12);
            TextLayout textLayout1 = new TextLayout((String)wTxt, font1, g.getFontRenderContext());
            TextLayout textLayout2 = new TextLayout((String)wTxt, font2, g.getFontRenderContext());
            TextLayout textLayout3 = new TextLayout((String)wTxt, font3, g.getFontRenderContext());
            g.setColor(new Color(255, 255, 255, 70));
            textLayout1.draw(g, (int)a + 10, (int)b);
            g.setColor(new Color(255, 255, 255, 150));
            textLayout2.draw(g, (int)a + 10, (int)b);
            g.setColor(Color.black);
            textLayout3.draw(g, (int)a + 10, (int)b);
        }
    }

    public static void drawSubnetsIcons(Graphics2D g) {
        if (overlord.getWorkspace().getSelectedSheet().getId() != 0) {
            return;
        }
        int x = 20;
        int y = 20;
        List<MetaNode> metaNodes = overlord.getWorkspace().getProject().getMetaNodes().stream().sorted(Comparator.comparingInt(MetaNode::getMySheetID).thenComparing(MetaNode::getRepresentedSheetID)).toList();
        for (MetaNode metaNode : metaNodes) {
            if (metaNode.getMySheetID() == 0) {
                g.setColor(new Color(94, 179, 48));
            } else {
                g.setColor(new Color(73, 86, 204));
            }
            g.fillRect(x, y, 40, 40);
            g.setColor(Color.BLACK);
            String label = String.format("%d-%d", metaNode.getMySheetID(), metaNode.getRepresentedSheetID());
            ElementDraw.drawCenteredString(g, label, x, y + 40, 40, 20);
            x += 60;
        }
    }

    private static void drawCenteredString(Graphics g, String text, int x, int y, int width, int height) {
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int textX = x + (width - metrics.stringWidth(text)) / 2;
        int textY = y + (height - metrics.getHeight()) / 2 + metrics.getAscent();
        g.drawString(text, textX, textY);
    }

    private static void handleBrokenArc(Graphics2D g, int STEP_COUNT, int step, ArrayList<Point> breakPoints, int breaks, Point startPos, Point endPos, double arcWidth, int weight, Arc arc) {
        double a = 0.0;
        double b = 0.0;
        ArrayList<Double> segmentLengths = new ArrayList<Double>();
        ArrayList<Point> allPointsVector = new ArrayList<Point>();
        double tmp = Math.hypot(startPos.x - breakPoints.get((int)0).x, startPos.y - breakPoints.get((int)0).y);
        segmentLengths.add(tmp);
        allPointsVector.add(startPos);
        arcWidth += tmp;
        allPointsVector.add(breakPoints.get(0));
        for (int br = 1; br < breaks; ++br) {
            tmp = Math.hypot(breakPoints.get((int)(br - 1)).x - breakPoints.get((int)br).x, breakPoints.get((int)(br - 1)).y - breakPoints.get((int)br).y);
            segmentLengths.add(tmp);
            allPointsVector.add(breakPoints.get(br));
            arcWidth += tmp;
        }
        tmp = Math.hypot(breakPoints.get((int)(breaks - 1)).x - endPos.x, breakPoints.get((int)(breaks - 1)).y - endPos.y);
        segmentLengths.add(tmp);
        allPointsVector.add(endPos);
        double stepSize = (arcWidth += tmp) / (double)STEP_COUNT;
        double endPoint = stepSize * (double)step;
        double counter = (Double)segmentLengths.get(0);
        for (int i = 1; i < segmentLengths.size() + 1; ++i) {
            if (counter > endPoint) {
                double distInCurrent = counter - endPoint;
                double tylePrzeszedl = (Double)segmentLengths.get(i - 1) - distInCurrent;
                double proportion = tylePrzeszedl / (Double)segmentLengths.get(i - 1);
                Point startingPoint = (Point)allPointsVector.get(i - 1);
                Point endingPoint = (Point)allPointsVector.get(i);
                int signX = 1;
                int signY = 1;
                if (startingPoint.x > endingPoint.x) {
                    signX = -1;
                }
                if (startingPoint.y > endingPoint.y) {
                    signY = -1;
                }
                int distX = Math.abs(startingPoint.x - endingPoint.x);
                int distY = Math.abs(startingPoint.y - endingPoint.y);
                a = (double)startingPoint.x + (double)signX * proportion * (double)distX;
                b = (double)startingPoint.y + (double)signY * proportion * (double)distY;
                break;
            }
            if (i >= segmentLengths.size()) continue;
            counter += ((Double)segmentLengths.get(i)).doubleValue();
        }
        g.setColor(EditorResources.tokenDefaultColor);
        g.fillOval((int)a - 5, (int)b - 5, 10, 10);
        g.setColor(Color.black);
        g.setStroke(EditorResources.tokenDefaultStroke);
        g.drawOval((int)a - 5, (int)b - 5, 10, 10);
        Object wTxt = Integer.toString(weight);
        if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
            wTxt = arc.getColorWeight(0) + "," + arc.getColorWeight(1) + "," + arc.getColorWeight(2) + "," + arc.getColorWeight(3) + "," + arc.getColorWeight(4) + "," + arc.getColorWeight(5);
        }
        Font font1 = new Font("Tahoma", 1, 14);
        Font font2 = new Font("Tahoma", 1, 13);
        Font font3 = new Font("Tahoma", 0, 12);
        TextLayout textLayout1 = new TextLayout((String)wTxt, font1, g.getFontRenderContext());
        TextLayout textLayout2 = new TextLayout((String)wTxt, font2, g.getFontRenderContext());
        TextLayout textLayout3 = new TextLayout((String)wTxt, font3, g.getFontRenderContext());
        g.setColor(new Color(255, 255, 255, 70));
        textLayout1.draw(g, (int)a + 10, (int)b);
        g.setColor(new Color(255, 255, 255, 150));
        textLayout2.draw(g, (int)a + 10, (int)b);
        g.setColor(Color.black);
        textLayout3.draw(g, (int)a + 10, (int)b);
    }

    private static void coloredTransitionDemo(Graphics2D g, TransitionColored trans, Rectangle nodeBounds) {
        Font currentFont = g.getFont();
        Font newFont = currentFont.deriveFont((float)currentFont.getSize() * 1.4f);
        g.setFont(newFont);
        int r0 = trans.getRequiredColoredTokens(0);
        int r1 = trans.getRequiredColoredTokens(1);
        int r2 = trans.getRequiredColoredTokens(2);
        int r3 = trans.getRequiredColoredTokens(3);
        int r4 = trans.getRequiredColoredTokens(4);
        int r5 = trans.getRequiredColoredTokens(5);
        String txtT0 = "" + r0;
        String txtT1 = "" + r1;
        String txtT2 = "" + r2;
        String txtT3 = "" + r3;
        String txtT4 = "" + r4;
        String txtT5 = "" + r5;
        int txtW0 = g.getFontMetrics().stringWidth(txtT0);
        int txtW1 = g.getFontMetrics().stringWidth(txtT1);
        int txtW2 = g.getFontMetrics().stringWidth(txtT2);
        int txtW3 = g.getFontMetrics().stringWidth(txtT3);
        int txtW4 = g.getFontMetrics().stringWidth(txtT4);
        int txtW5 = g.getFontMetrics().stringWidth(txtT5);
        g.setColor(Color.black);
        String txt = "<";
        int posX = nodeBounds.x - g.getFontMetrics().stringWidth(txt) / 2 - 15;
        int posY = nodeBounds.y - 1;
        g.drawString(txt, posX, posY);
        int lastSize = g.getFontMetrics().stringWidth(txt);
        if (r0 > 0) {
            g.setColor(EditorResources.cRed);
            g.drawString(txtT0, posX += txtW0 - 6 * txtT0.length() + lastSize, posY);
            lastSize = txtW0;
        }
        if (r1 > 0) {
            g.setColor(EditorResources.cGreen);
            g.drawString(txtT1, posX += txtW1 - 6 * txtT1.length() + lastSize, posY);
            lastSize = txtW1;
        }
        if (r2 > 0) {
            g.setColor(EditorResources.cBlue);
            g.drawString(txtT2, posX += txtW2 - 6 * txtT2.length() + lastSize, posY);
            lastSize = txtW2;
        }
        if (r3 > 0) {
            g.setColor(EditorResources.cYellow);
            g.drawString(txtT3, posX += txtW3 - 6 * txtT3.length() + lastSize, posY);
            lastSize = txtW3;
        }
        if (r4 > 0) {
            g.setColor(EditorResources.cGrey);
            g.drawString(txtT4, posX += txtW4 - 6 * txtT4.length() + lastSize, posY);
            lastSize = txtW4;
        }
        if (r5 > 0) {
            g.setColor(EditorResources.cBlack);
            g.drawString(txtT5, posX += txtW5 - 6 * txtT5.length() + lastSize, posY);
            lastSize = txtW5;
        }
        txt = ">";
        g.setColor(EditorResources.cBlack);
        g.drawString(txt, posX += g.getFontMetrics().stringWidth(txt), posY);
        g.setFont(currentFont);
    }

    private static void coloredPlaceDemo(Graphics2D g, PlaceColored place, Rectangle nodeBounds) {
        Font currentFont = g.getFont();
        Font newFont = currentFont.deriveFont((float)currentFont.getSize() * 1.4f);
        g.setFont(newFont);
        String txtT0 = "" + place.getColorTokensNumber(0);
        String txtT1 = "" + place.getColorTokensNumber(1);
        String txtT2 = "" + place.getColorTokensNumber(2);
        String txtT3 = "" + place.getColorTokensNumber(3);
        String txtT4 = "" + place.getColorTokensNumber(4);
        String txtT5 = "" + place.getColorTokensNumber(5);
        int txtW0 = g.getFontMetrics().stringWidth(txtT0);
        int txtW1 = g.getFontMetrics().stringWidth(txtT1);
        int txtW2 = g.getFontMetrics().stringWidth(txtT2);
        int txtW3 = g.getFontMetrics().stringWidth(txtT3);
        int txtW4 = g.getFontMetrics().stringWidth(txtT4);
        int txtW5 = g.getFontMetrics().stringWidth(txtT5);
        g.setColor(Color.black);
        String txt = "[";
        int posX = nodeBounds.x - g.getFontMetrics().stringWidth(txt) / 2 - 15;
        int posY = nodeBounds.y - 1;
        g.drawString(txt, posX, posY);
        g.setColor(EditorResources.cRed);
        g.drawString(txtT0, posX += txtW0 - 8 * txtT0.length(), posY);
        g.setColor(EditorResources.cGreen);
        g.drawString(txtT1, posX += txtW1 - 10 * txtT1.length() + txtW0, posY);
        g.setColor(EditorResources.cBlue);
        g.drawString(txtT2, posX += txtW2 - 10 * txtT2.length() + txtW1, posY);
        g.setColor(EditorResources.cYellow);
        g.drawString(txtT3, posX += txtW3 - 10 * txtT3.length() + txtW2, posY);
        g.setColor(EditorResources.cGrey);
        g.drawString(txtT4, posX += txtW4 - 10 * txtT4.length() + txtW3, posY);
        g.setColor(EditorResources.cBlack);
        g.drawString(txtT5, posX += txtW5 - 10 * txtT5.length() + txtW4, posY);
        txt = "]";
        g.setColor(EditorResources.cBlack);
        g.drawString(txt, posX += g.getFontMetrics().stringWidth(txt) + txtW5 - 5, posY);
        g.setFont(currentFont);
    }
}

