/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io.snoopy;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.snoopy.SnoopyWriterCoarse;
import holmes.files.io.snoopy.SnoopyWriterPlace;
import holmes.files.io.snoopy.SnoopyWriterTransition;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.subnets.SubnetsTools;
import java.awt.Point;
import java.io.BufferedWriter;
import java.util.ArrayList;

public class SnoopyWriterArc {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<Place> places;
    private ArrayList<Transition> transitions;
    private ArrayList<MetaNode> metanodes;
    private ArrayList<Arc> arcs;
    private ArrayList<SnoopyWriterPlace> snoopyWriterPlaces;
    private ArrayList<Integer> holmesPlacesID;
    private ArrayList<SnoopyWriterTransition> snoopyWriterTransitions;
    private ArrayList<Integer> holmesTransitionsID;
    private ArrayList<SnoopyWriterCoarse> snoopyWriterCoarsePlaces;
    private ArrayList<Integer> holmesCoarsePlacesID;
    private ArrayList<SnoopyWriterCoarse> snoopyWriterCoarseTransitions;
    private ArrayList<Integer> holmesCoarseTransitionsID;

    public SnoopyWriterArc(ArrayList<Place> places, ArrayList<Transition> transitions, ArrayList<MetaNode> metanodes, ArrayList<Arc> arcs, ArrayList<MetaNode> coarsePlaces, ArrayList<MetaNode> coarseTransitions, ArrayList<SnoopyWriterPlace> snoopyWriterPlaces, ArrayList<Integer> holmesPlacesID, ArrayList<SnoopyWriterTransition> snoopyWriterTransitions, ArrayList<Integer> holmesTransitionsID, ArrayList<SnoopyWriterCoarse> snoopyWriterCoarsePlaces, ArrayList<Integer> holmesCoarsePlacesID, ArrayList<SnoopyWriterCoarse> snoopyWriterCoarseTransitions, ArrayList<Integer> holmesCoarseTransitionsID) {
        this.places = places;
        this.transitions = transitions;
        this.metanodes = metanodes;
        this.arcs = arcs;
        this.snoopyWriterPlaces = snoopyWriterPlaces;
        this.holmesPlacesID = holmesPlacesID;
        this.snoopyWriterTransitions = snoopyWriterTransitions;
        this.holmesTransitionsID = holmesTransitionsID;
        this.snoopyWriterCoarsePlaces = snoopyWriterCoarsePlaces;
        this.holmesCoarsePlacesID = holmesCoarsePlacesID;
        this.snoopyWriterCoarseTransitions = snoopyWriterCoarseTransitions;
        this.holmesCoarseTransitionsID = holmesCoarseTransitionsID;
    }

    public int addArcsAndCoarseToFile(BufferedWriter bw, int currentActiveID, boolean extended, Object ... blackBox) {
        Arc.TypeOfArc arcType = Arc.TypeOfArc.NORMAL;
        arcType = extended ? (Arc.TypeOfArc)((Object)blackBox[0]) : Arc.TypeOfArc.NORMAL;
        int howMany = 0;
        int xOff = 0;
        int baseIDforNode = currentActiveID;
        ArrayList<Arc> normalArcs = new ArrayList<Arc>();
        ArrayList<Arc> metaArcs = new ArrayList<Arc>();
        for (Arc arc : this.arcs) {
            if (arc.getArcType() == Arc.TypeOfArc.META_ARC) {
                metaArcs.add(arc);
                continue;
            }
            if (arc.getArcType() != arcType) continue;
            normalArcs.add(arc);
        }
        int metaArcsTotal = metaArcs.size();
        ArrayList<Node> interfacesIN = new ArrayList<Node>();
        ArrayList<Node> interfacesOUT = new ArrayList<Node>();
        for (MetaNode mnode : this.metanodes) {
            Node inter;
            ElementLocation alpha = mnode.getElementLocations().get(0);
            for (Arc a : alpha.accessMetaInArcs()) {
                inter = a.getStartNode();
                if (interfacesIN.contains(inter)) continue;
                interfacesIN.add(inter);
            }
            for (Arc a : alpha.accessMetaOutArcs()) {
                inter = a.getEndNode();
                if (interfacesOUT.contains(inter)) continue;
                interfacesOUT.add(inter);
            }
        }
        for (Arc arc : normalArcs) {
            try {
                int sheetMainID;
                Object NET1target;
                int NET1addToSPPEDAsTarget;
                int addToSPPEDAsTarget;
                Object source;
                int startLocIndex;
                boolean ok;
                int subnet;
                ElementLocation arcStartElLocation = arc.getStartLocation();
                ElementLocation arcEndElLocation = arc.getEndLocation();
                Node startN = arc.getStartNode();
                Node endN = arc.getEndNode();
                int weight = arc.getWeight();
                String comment = this.removeEnters(arc.getComment());
                int nodeSourceID = 0;
                int realSourceID = 0;
                int realSourceX = 0;
                int realSourceY = 0;
                int nodeTargetID = 0;
                int realTargetID = 0;
                int realTargetX = 0;
                int realTargetY = 0;
                int halfX = 0;
                int halfY = 0;
                int NET1realSourceID = 0;
                int NET1realSourceX = 0;
                int NET1realSourceY = 0;
                int NET1realTargetID = 0;
                int NET1realTargetX = 0;
                int NET1realTargetY = 0;
                int NET1halfX = 0;
                int NET1halfY = 0;
                if (interfacesIN.contains(startN) && !interfacesOUT.contains(endN) && arcStartElLocation.getSheetID() != 0) {
                    subnet = arcStartElLocation.getSheetID();
                    MetaNode metanode = SubnetsTools.getMetaForSubnet(this.metanodes, subnet);
                    if (startN instanceof Place) {
                        boolean holmes;
                        if (metanode.getMetaType() != MetaNode.MetaType.SUBNETTRANS) {
                            overlord.log(lang.getText("LOGentry00117critErr"), "error", true);
                        }
                        if (holmes = this.weNeedToGoDeeper(metanode, startN, true)) {
                            baseIDforNode = this.omgThisIsCrazy(arcStartElLocation, arcEndElLocation, arc, metaArcs, baseIDforNode, true, bw, arcType);
                            ++howMany;
                            continue;
                        }
                        metaInArc = null;
                        for (Arc cand_arc : metaArcs) {
                            if (!cand_arc.getEndNode().equals(metanode) || !cand_arc.getStartNode().equals(startN)) continue;
                            metaInArc = cand_arc;
                            break;
                        }
                        if (!(ok = metaArcs.remove(metaInArc))) {
                            overlord.log(lang.getText("LOGentry00118critErr"), "error", true);
                        }
                        addToSPPEDAsSource = this.holmesPlacesID.lastIndexOf(startN.getID());
                        startLocIndex = startN.getElementLocations().indexOf(arcStartElLocation);
                        source = this.snoopyWriterPlaces.get(addToSPPEDAsSource);
                        nodeSourceID = ((SnoopyWriterPlace)source).snoopyStartingID;
                        realSourceID = ((SnoopyWriterPlace)source).grParents.get(startLocIndex);
                        realSourceX = ((SnoopyWriterPlace)source).grParentsLocation.get((int)startLocIndex).x;
                        realSourceY = ((SnoopyWriterPlace)source).grParentsLocation.get((int)startLocIndex).y;
                        addToSPPEDAsTarget = this.holmesTransitionsID.lastIndexOf(endN.getID());
                        endLocIndex = endN.getElementLocations().indexOf(arcEndElLocation);
                        target = this.snoopyWriterTransitions.get(addToSPPEDAsTarget);
                        nodeTargetID = ((SnoopyWriterTransition)target).snoopyStartingID;
                        realTargetID = ((SnoopyWriterTransition)target).grParents.get(endLocIndex);
                        realTargetX = ((SnoopyWriterTransition)target).grParentsLocation.get((int)endLocIndex).x;
                        realTargetY = ((SnoopyWriterTransition)target).grParentsLocation.get((int)endLocIndex).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        NET1el = metaInArc.getStartLocation();
                        NET1startLocIndex = startN.getElementLocations().indexOf(NET1el);
                        NET1addToSPPEDAsSource = this.holmesPlacesID.lastIndexOf(startN.getID());
                        NET1source = this.snoopyWriterPlaces.get(NET1addToSPPEDAsSource);
                        NET1realSourceID = ((SnoopyWriterPlace)NET1source).grParents.get(NET1startLocIndex);
                        NET1realSourceX = ((SnoopyWriterPlace)NET1source).grParentsLocation.get((int)NET1startLocIndex).x;
                        NET1realSourceY = ((SnoopyWriterPlace)NET1source).grParentsLocation.get((int)NET1startLocIndex).y;
                        NET1addToSPPEDAsTarget = this.holmesCoarseTransitionsID.lastIndexOf(metanode.getID());
                        NET1target = this.snoopyWriterCoarseTransitions.get(NET1addToSPPEDAsTarget);
                        NET1realTargetID = ((SnoopyWriterCoarse)NET1target).grParents.get(0);
                        NET1realTargetX = ((SnoopyWriterCoarse)NET1target).grParentsLocation.get((int)0).x;
                        NET1realTargetY = ((SnoopyWriterCoarse)NET1target).grParentsLocation.get((int)0).y;
                        NET1halfX = (NET1realTargetX + NET1realSourceX) / 2;
                        NET1halfY = (NET1realTargetY + NET1realSourceY) / 2;
                    } else {
                        boolean deepSh;
                        if (metanode.getMetaType() != MetaNode.MetaType.SUBNETPLACE) {
                            overlord.log(lang.getText("LOGentry00119critErr"), "error", true);
                        }
                        if (deepSh = this.weNeedToGoDeeper(metanode, startN, true)) {
                            baseIDforNode = this.omgThisIsCrazy(arcStartElLocation, arcEndElLocation, arc, metaArcs, baseIDforNode, true, bw, arcType);
                            ++howMany;
                            continue;
                        }
                        metaInArc = null;
                        for (Arc cand_arc : metaArcs) {
                            if (!cand_arc.getEndNode().equals(metanode) || !cand_arc.getStartNode().equals(startN)) continue;
                            metaInArc = cand_arc;
                            break;
                        }
                        if (!(ok = metaArcs.remove(metaInArc))) {
                            overlord.log(lang.getText("LOGentry00120critErr"), "error", true);
                        }
                        addToSPPEDAsSource = this.holmesTransitionsID.lastIndexOf(startN.getID());
                        SnoopyWriterTransition source2 = this.snoopyWriterTransitions.get(addToSPPEDAsSource);
                        int startLocIndex2 = startN.getElementLocations().indexOf(arcStartElLocation);
                        nodeSourceID = source2.snoopyStartingID;
                        realSourceID = source2.grParents.get(startLocIndex2);
                        realSourceX = source2.grParentsLocation.get((int)startLocIndex2).x;
                        realSourceY = source2.grParentsLocation.get((int)startLocIndex2).y;
                        addToSPPEDAsTarget = this.holmesPlacesID.lastIndexOf(endN.getID());
                        endLocIndex = endN.getElementLocations().indexOf(arcEndElLocation);
                        target = this.snoopyWriterPlaces.get(addToSPPEDAsTarget);
                        nodeTargetID = ((SnoopyWriterPlace)target).snoopyStartingID;
                        realTargetID = ((SnoopyWriterPlace)target).grParents.get(endLocIndex);
                        realTargetX = ((SnoopyWriterPlace)target).grParentsLocation.get((int)endLocIndex).x;
                        realTargetY = ((SnoopyWriterPlace)target).grParentsLocation.get((int)endLocIndex).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        NET1el = metaInArc.getStartLocation();
                        NET1startLocIndex = startN.getElementLocations().indexOf(NET1el);
                        NET1addToSPPEDAsSource = this.holmesTransitionsID.lastIndexOf(startN.getID());
                        NET1source = this.snoopyWriterTransitions.get(NET1addToSPPEDAsSource);
                        NET1realSourceID = ((SnoopyWriterTransition)NET1source).grParents.get(NET1startLocIndex);
                        NET1realSourceX = ((SnoopyWriterTransition)NET1source).grParentsLocation.get((int)NET1startLocIndex).x;
                        NET1realSourceY = ((SnoopyWriterTransition)NET1source).grParentsLocation.get((int)NET1startLocIndex).y;
                        NET1addToSPPEDAsTarget = this.holmesCoarsePlacesID.lastIndexOf(metanode.getID());
                        NET1target = this.snoopyWriterCoarsePlaces.get(NET1addToSPPEDAsTarget);
                        NET1realTargetID = ((SnoopyWriterCoarse)NET1target).grParents.get(0);
                        NET1realTargetX = ((SnoopyWriterCoarse)NET1target).grParentsLocation.get((int)0).x;
                        NET1realTargetY = ((SnoopyWriterCoarse)NET1target).grParentsLocation.get((int)0).y;
                        NET1halfX = (NET1realTargetX + NET1realSourceX) / 2;
                        NET1halfY = (NET1realTargetY + NET1realSourceY) / 2;
                    }
                    int grParent = baseIDforNode + 5;
                    int grParent2 = baseIDforNode + 20;
                    sheetMainID = metanode.getElementLocations().get(0).getSheetID() + 1;
                    int subNetID = metanode.getRepresentedSheetID() + 1;
                    this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + baseIDforNode + "\" net=\"" + sheetMainID + "\">");
                    if (arc.getArcType() != Arc.TypeOfArc.RESET) {
                        this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + (baseIDforNode + 1) + "\" net=\"" + sheetMainID + "\">");
                        this.write(bw, "          <![CDATA[" + weight + "]]>");
                        this.write(bw, "          <graphics count=\"2\">");
                        xOff = 20;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (NET1halfX + xOff) + ".00\" y=\"" + NET1halfY + ".00\" id=\"" + (baseIDforNode + 2) + "\" net=\"" + sheetMainID + "\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + (baseIDforNode + 21) + "\" net=\"" + subNetID + "\" show=\"1\" grparent=\"" + grParent2 + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                    }
                    this.write(bw, "        <attribute name=\"Comment\" id=\"" + (baseIDforNode + 3) + "\" net=\"" + sheetMainID + "\">");
                    this.write(bw, "          <![CDATA[" + comment + "]]>");
                    this.write(bw, "          <graphics count=\"2\">");
                    xOff = 40;
                    this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (NET1halfX + xOff) + ".00\" y=\"" + NET1halfY + ".00\" id=\"" + (baseIDforNode + 4) + "\" net=\"" + sheetMainID + "\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                    this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + (baseIDforNode + 22) + "\" net=\"" + subNetID + "\" show=\"1\" grparent=\"" + grParent2 + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                    this.write(bw, "          </graphics>");
                    this.write(bw, "        </attribute>");
                    this.write(bw, "        <graphics count=\"2\">");
                    this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"" + sheetMainID + "\" source=\"" + NET1realSourceID + "\" target=\"" + NET1realTargetID + "\" state=\"4\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                    this.write(bw, "            <points count=\"2\">");
                    this.write(bw, "              <point x=\"" + NET1realSourceX + ".00\" y=\"" + NET1realSourceY + ".00\"/>");
                    this.write(bw, "              <point x=\"" + NET1realTargetX + ".00\" y=\"" + NET1realTargetY + ".00\"/>");
                    this.write(bw, "            </points>");
                    this.write(bw, "          </graphic>");
                    this.write(bw, "          <graphic id=\"" + grParent2 + "\" net=\"" + subNetID + "\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"8\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                    this.write(bw, "            <points count=\"2\">");
                    this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                    this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                    this.write(bw, "            </points>");
                    this.write(bw, "          </graphic>");
                    this.write(bw, "        </graphics>");
                    this.write(bw, "      </edge>");
                    ++howMany;
                    baseIDforNode += 23;
                    continue;
                }
                if (!interfacesIN.contains(startN) && interfacesOUT.contains(endN) && arcStartElLocation.getSheetID() != 0) {
                    subnet = arcEndElLocation.getSheetID();
                    MetaNode metanode = SubnetsTools.getMetaForSubnet(this.metanodes, subnet);
                    if (endN instanceof Place) {
                        if (metanode.getMetaType() != MetaNode.MetaType.SUBNETTRANS) {
                            overlord.log(lang.getText("LOGentry00121critErr"), "error", true);
                        }
                        if (deepSh = this.weNeedToGoDeeper(metanode, startN, false)) {
                            baseIDforNode = this.omgThisIsCrazy(arcEndElLocation, arcStartElLocation, arc, metaArcs, baseIDforNode, false, bw, arcType);
                            ++howMany;
                            continue;
                        }
                        metaOutArc = null;
                        for (Arc cand_arc : metaArcs) {
                            if (!cand_arc.getStartNode().equals(metanode) || !cand_arc.getEndNode().equals(endN)) continue;
                            metaOutArc = cand_arc;
                            break;
                        }
                        if (!(ok = metaArcs.remove(metaOutArc))) {
                            overlord.log(lang.getText("LOGentry00122critErr"), "error", true);
                        }
                        addToSPPEDAsSource = this.holmesTransitionsID.lastIndexOf(startN.getID());
                        startLocIndex = startN.getElementLocations().indexOf(arcStartElLocation);
                        source = this.snoopyWriterTransitions.get(addToSPPEDAsSource);
                        nodeSourceID = ((SnoopyWriterTransition)source).snoopyStartingID;
                        realSourceID = ((SnoopyWriterTransition)source).grParents.get(startLocIndex);
                        realSourceX = ((SnoopyWriterTransition)source).grParentsLocation.get((int)startLocIndex).x;
                        realSourceY = ((SnoopyWriterTransition)source).grParentsLocation.get((int)startLocIndex).y;
                        addToSPPEDAsTarget = this.holmesPlacesID.lastIndexOf(endN.getID());
                        int endLocIndex = endN.getElementLocations().indexOf(arcEndElLocation);
                        SnoopyWriterPlace target = this.snoopyWriterPlaces.get(addToSPPEDAsTarget);
                        nodeTargetID = target.snoopyStartingID;
                        realTargetID = target.grParents.get(endLocIndex);
                        realTargetX = target.grParentsLocation.get((int)endLocIndex).x;
                        realTargetY = target.grParentsLocation.get((int)endLocIndex).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        NET1addToSPPEDAsSource = this.holmesCoarseTransitionsID.lastIndexOf(metanode.getID());
                        NET1source = this.snoopyWriterCoarseTransitions.get(NET1addToSPPEDAsSource);
                        NET1realSourceID = NET1source.grParents.get(0);
                        NET1realSourceX = NET1source.grParentsLocation.get((int)0).x;
                        NET1realSourceY = NET1source.grParentsLocation.get((int)0).y;
                        NET1el = metaOutArc.getEndLocation();
                        int NET1endLocIndex = endN.getElementLocations().indexOf(NET1el);
                        NET1addToSPPEDAsTarget = this.holmesPlacesID.lastIndexOf(endN.getID());
                        NET1target = this.snoopyWriterPlaces.get(NET1addToSPPEDAsTarget);
                        NET1realTargetID = ((SnoopyWriterPlace)NET1target).grParents.get(NET1endLocIndex);
                        NET1realTargetX = ((SnoopyWriterPlace)NET1target).grParentsLocation.get((int)NET1endLocIndex).x;
                        NET1realTargetY = ((SnoopyWriterPlace)NET1target).grParentsLocation.get((int)NET1endLocIndex).y;
                        NET1halfX = (NET1realTargetX + NET1realSourceX) / 2;
                        NET1halfY = (NET1realTargetY + NET1realSourceY) / 2;
                    } else {
                        if (metanode.getMetaType() != MetaNode.MetaType.SUBNETPLACE) {
                            overlord.log(lang.getText("LOGentry00123critErr"), "error", true);
                        }
                        if (deepSh = this.weNeedToGoDeeper(metanode, startN, false)) {
                            baseIDforNode = this.omgThisIsCrazy(arcEndElLocation, arcStartElLocation, arc, metaArcs, baseIDforNode, false, bw, arcType);
                            ++howMany;
                            continue;
                        }
                        metaOutArc = null;
                        for (Arc cand_arc : metaArcs) {
                            if (!cand_arc.getStartNode().equals(metanode) || !cand_arc.getEndNode().equals(endN)) continue;
                            metaOutArc = cand_arc;
                            break;
                        }
                        if (!(ok = metaArcs.remove(metaOutArc))) {
                            overlord.log(lang.getText("LOGentry00124critErr"), "error", true);
                        }
                        addToSPPEDAsSource = this.holmesPlacesID.lastIndexOf(startN.getID());
                        SnoopyWriterPlace source3 = this.snoopyWriterPlaces.get(addToSPPEDAsSource);
                        int startLocIndex3 = startN.getElementLocations().indexOf(arcStartElLocation);
                        nodeSourceID = source3.snoopyStartingID;
                        realSourceID = source3.grParents.get(startLocIndex3);
                        realSourceX = source3.grParentsLocation.get((int)startLocIndex3).x;
                        realSourceY = source3.grParentsLocation.get((int)startLocIndex3).y;
                        addToSPPEDAsTarget = this.holmesTransitionsID.lastIndexOf(endN.getID());
                        SnoopyWriterTransition target = this.snoopyWriterTransitions.get(addToSPPEDAsTarget);
                        int endLocIndex = endN.getElementLocations().indexOf(arcEndElLocation);
                        nodeTargetID = target.snoopyStartingID;
                        realTargetID = target.grParents.get(endLocIndex);
                        realTargetX = target.grParentsLocation.get((int)endLocIndex).x;
                        realTargetY = target.grParentsLocation.get((int)endLocIndex).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        NET1addToSPPEDAsSource = this.holmesCoarsePlacesID.lastIndexOf(metanode.getID());
                        NET1source = this.snoopyWriterCoarsePlaces.get(NET1addToSPPEDAsSource);
                        NET1realSourceID = NET1source.grParents.get(0);
                        NET1realSourceX = NET1source.grParentsLocation.get((int)0).x;
                        NET1realSourceY = NET1source.grParentsLocation.get((int)0).y;
                        NET1el = metaOutArc.getEndLocation();
                        int NET1EndLocIndex = endN.getElementLocations().indexOf(NET1el);
                        NET1addToSPPEDAsTarget = this.holmesTransitionsID.lastIndexOf(endN.getID());
                        NET1target = this.snoopyWriterTransitions.get(NET1addToSPPEDAsTarget);
                        NET1realTargetID = ((SnoopyWriterTransition)NET1target).grParents.get(NET1EndLocIndex);
                        NET1realTargetX = ((SnoopyWriterTransition)NET1target).grParentsLocation.get((int)NET1EndLocIndex).x;
                        NET1realTargetY = ((SnoopyWriterTransition)NET1target).grParentsLocation.get((int)NET1EndLocIndex).y;
                        NET1halfX = (NET1realTargetX + NET1realSourceX) / 2;
                        NET1halfY = (NET1realTargetY + NET1realSourceY) / 2;
                    }
                    int grParent = baseIDforNode + 5;
                    int grParent2 = baseIDforNode + 20;
                    sheetMainID = metanode.getElementLocations().get(0).getSheetID() + 1;
                    int subNetID = metanode.getRepresentedSheetID() + 1;
                    this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + baseIDforNode + "\" net=\"" + sheetMainID + "\">");
                    if (arc.getArcType() != Arc.TypeOfArc.RESET) {
                        this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + (baseIDforNode + 1) + "\" net=\"" + sheetMainID + "\">");
                        this.write(bw, "          <![CDATA[" + weight + "]]>");
                        this.write(bw, "          <graphics count=\"2\">");
                        xOff = 20;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (NET1halfX + xOff) + ".00\" y=\"" + NET1halfY + ".00\" id=\"" + (baseIDforNode + 2) + "\" net=\"" + sheetMainID + "\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + (baseIDforNode + 21) + "\" net=\"" + subNetID + "\" show=\"1\" grparent=\"" + grParent2 + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                    }
                    this.write(bw, "        <attribute name=\"Comment\" id=\"" + (baseIDforNode + 3) + "\" net=\"" + sheetMainID + "\">");
                    this.write(bw, "          <![CDATA[" + comment + "]]>");
                    this.write(bw, "          <graphics count=\"2\">");
                    xOff = 40;
                    this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (NET1halfX + xOff) + ".00\" y=\"" + NET1halfY + ".00\" id=\"" + (baseIDforNode + 4) + "\" net=\"" + sheetMainID + "\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                    this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + (baseIDforNode + 22) + "\" net=\"" + subNetID + "\" show=\"1\" grparent=\"" + grParent2 + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                    this.write(bw, "          </graphics>");
                    this.write(bw, "        </attribute>");
                    this.write(bw, "        <graphics count=\"2\">");
                    this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"" + sheetMainID + "\" source=\"" + NET1realSourceID + "\" target=\"" + NET1realTargetID + "\" state=\"4\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                    this.write(bw, "            <points count=\"2\">");
                    this.write(bw, "              <point x=\"" + NET1realSourceX + ".00\" y=\"" + NET1realSourceY + ".00\"/>");
                    this.write(bw, "              <point x=\"" + NET1realTargetX + ".00\" y=\"" + NET1realTargetY + ".00\"/>");
                    this.write(bw, "            </points>");
                    this.write(bw, "          </graphic>");
                    this.write(bw, "          <graphic id=\"" + grParent2 + "\" net=\"" + subNetID + "\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"8\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                    this.write(bw, "            <points count=\"2\">");
                    this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                    this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                    this.write(bw, "            </points>");
                    this.write(bw, "          </graphic>");
                    this.write(bw, "        </graphics>");
                    this.write(bw, "      </edge>");
                    ++howMany;
                    baseIDforNode += 23;
                    continue;
                }
                if (interfacesIN.contains(startN) && interfacesOUT.contains(endN) && arcStartElLocation.getSheetID() == 0) {
                    overlord.log(lang.getText("LOGentry00125"), "error", true);
                    continue;
                }
                if (startN instanceof Place) {
                    addToSPPEDAsSource = this.holmesPlacesID.lastIndexOf(startN.getID());
                    startLocIndex = startN.getElementLocations().indexOf(arcStartElLocation);
                    source = this.snoopyWriterPlaces.get(addToSPPEDAsSource);
                    nodeSourceID = ((SnoopyWriterPlace)source).snoopyStartingID;
                    realSourceID = ((SnoopyWriterPlace)source).grParents.get(startLocIndex);
                    realSourceX = ((SnoopyWriterPlace)source).grParentsLocation.get((int)startLocIndex).x;
                    realSourceY = ((SnoopyWriterPlace)source).grParentsLocation.get((int)startLocIndex).y;
                    addToSPPEDAsTarget = this.holmesTransitionsID.lastIndexOf(endN.getID());
                    endLocIndex = endN.getElementLocations().indexOf(arcEndElLocation);
                    target = this.snoopyWriterTransitions.get(addToSPPEDAsTarget);
                    nodeTargetID = ((SnoopyWriterTransition)target).snoopyStartingID;
                    realTargetID = ((SnoopyWriterTransition)target).grParents.get(endLocIndex);
                    realTargetX = ((SnoopyWriterTransition)target).grParentsLocation.get((int)endLocIndex).x;
                    realTargetY = ((SnoopyWriterTransition)target).grParentsLocation.get((int)endLocIndex).y;
                    halfX = (realTargetX + realSourceX) / 2;
                    halfY = (realTargetY + realSourceY) / 2;
                } else {
                    addToSPPEDAsSource = this.holmesTransitionsID.lastIndexOf(startN.getID());
                    startLocIndex = startN.getElementLocations().indexOf(arcStartElLocation);
                    source = this.snoopyWriterTransitions.get(addToSPPEDAsSource);
                    nodeSourceID = ((SnoopyWriterTransition)source).snoopyStartingID;
                    realSourceID = ((SnoopyWriterTransition)source).grParents.get(startLocIndex);
                    realSourceX = ((SnoopyWriterTransition)source).grParentsLocation.get((int)startLocIndex).x;
                    realSourceY = ((SnoopyWriterTransition)source).grParentsLocation.get((int)startLocIndex).y;
                    addToSPPEDAsTarget = this.holmesPlacesID.lastIndexOf(endN.getID());
                    endLocIndex = endN.getElementLocations().indexOf(arcEndElLocation);
                    target = this.snoopyWriterPlaces.get(addToSPPEDAsTarget);
                    nodeTargetID = ((SnoopyWriterPlace)target).snoopyStartingID;
                    realTargetID = ((SnoopyWriterPlace)target).grParents.get(endLocIndex);
                    realTargetX = ((SnoopyWriterPlace)target).grParentsLocation.get((int)endLocIndex).x;
                    realTargetY = ((SnoopyWriterPlace)target).grParentsLocation.get((int)endLocIndex).y;
                    halfX = (realTargetX + realSourceX) / 2;
                    halfY = (realTargetY + realSourceY) / 2;
                }
                int grParent = baseIDforNode + 5;
                int sheetMainID2 = arcStartElLocation.getSheetID() + 1;
                this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + baseIDforNode + "\" net=\"" + sheetMainID2 + "\">");
                if (arc.getArcType() != Arc.TypeOfArc.RESET) {
                    this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + (baseIDforNode + 1) + "\" net=\"" + sheetMainID2 + "\">");
                    this.write(bw, "          <![CDATA[" + weight + "]]>");
                    this.write(bw, "          <graphics count=\"1\">");
                    xOff = 20;
                    this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + (baseIDforNode + 2) + "\" net=\"" + sheetMainID2 + "\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                    this.write(bw, "          </graphics>");
                    this.write(bw, "        </attribute>");
                }
                this.write(bw, "        <attribute name=\"Comment\" id=\"" + (baseIDforNode + 3) + "\" net=\"" + sheetMainID2 + "\">");
                this.write(bw, "          <![CDATA[" + comment + "]]>");
                this.write(bw, "          <graphics count=\"1\">");
                xOff = 40;
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + (baseIDforNode + 4) + "\" net=\"" + sheetMainID2 + "\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                this.write(bw, "          </graphics>");
                this.write(bw, "        </attribute>");
                this.write(bw, "        <graphics count=\"1\">");
                this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"" + sheetMainID2 + "\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"1\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                if (arc.accessBreaks().isEmpty()) {
                    this.write(bw, "            <points count=\"2\">");
                    this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                    this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                } else {
                    this.write(bw, "            <points count=\"" + (arc.accessBreaks().size() + 2) + "\">");
                    this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                    for (Point point : arc.accessBreaks()) {
                        this.write(bw, "              <point x=\"" + point.x + ".00\" y=\"" + point.y + ".00\"/>");
                    }
                    this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                }
                this.write(bw, "            </points>");
                this.write(bw, "          </graphic>");
                this.write(bw, "        </graphics>");
                this.write(bw, "      </edge>");
                ++howMany;
                baseIDforNode += 6;
            }
            catch (Exception e) {
                baseIDforNode += 100;
                overlord.log("Unable to create arc: " + arc.toString(), "error", true);
            }
        }
        int arcNumber = normalArcs.size() - metaArcsTotal;
        if (howMany != arcNumber) {
            overlord.log(lang.getText("LOGentry00126"), "error", true);
            if (howMany > arcNumber) {
                overlord.log(lang.getText("LOGentry00127"), "error", true);
            } else {
                overlord.log(lang.getText("LOGentry00128"), "error", true);
            }
        }
        return baseIDforNode + 1;
    }

    private int omgThisIsCrazy(ElementLocation interfaceNodeElLocation, ElementLocation arcEndElLocation, Arc arcus, ArrayList<Arc> metaArcs, int baseIDforNode, boolean isInInterface, BufferedWriter bw, Arc.TypeOfArc arcType) {
        int i;
        int i2;
        int IDbackup = baseIDforNode;
        int spaceBetweenIDs = 0;
        Node startNode = interfaceNodeElLocation.getParentNode();
        Node endNode = arcEndElLocation.getParentNode();
        ArrayList<PathPackage> subnetsPath = this.recreateSubnetsPath(interfaceNodeElLocation, arcEndElLocation, arcus, isInInterface, metaArcs);
        int pathSize = subnetsPath.size();
        int mainSourceID = -1;
        int mainTargetID = -1;
        ArrayList<Integer> subSourceIDs = new ArrayList<Integer>();
        ArrayList<Point> subSourcePoint = new ArrayList<Point>();
        ArrayList<Integer> subTargetIDs = new ArrayList<Integer>();
        ArrayList<Point> subTargetPoint = new ArrayList<Point>();
        ArrayList<Point> halfPoint = new ArrayList<Point>();
        ArrayList<Integer> grParents = new ArrayList<Integer>();
        for (i2 = 0; i2 < pathSize; ++i2) {
            if (i2 == 0) {
                grParents.add(IDbackup += 5);
                continue;
            }
            if (i2 == 1) {
                grParents.add(IDbackup += 15);
                continue;
            }
            grParents.add(IDbackup += 5);
        }
        if (startNode instanceof Place) {
            index = this.holmesPlacesID.lastIndexOf(startNode.getID());
            mainSourceID = this.snoopyWriterPlaces.get((int)index).snoopyStartingID;
            index = this.holmesTransitionsID.lastIndexOf(endNode.getID());
            mainTargetID = this.snoopyWriterTransitions.get((int)index).snoopyStartingID;
        } else {
            index = this.holmesTransitionsID.lastIndexOf(startNode.getID());
            mainSourceID = this.snoopyWriterTransitions.get((int)index).snoopyStartingID;
            index = this.holmesPlacesID.lastIndexOf(endNode.getID());
            mainTargetID = this.snoopyWriterPlaces.get((int)index).snoopyStartingID;
        }
        for (i2 = 0; i2 < pathSize; ++i2) {
            int index;
            Object source;
            PathPackage happy = subnetsPath.get(i2);
            Node sourceNode = happy.source.getParentNode();
            Node targetNode = happy.target.getParentNode();
            if (sourceNode instanceof Place) {
                int index2 = this.holmesPlacesID.lastIndexOf(sourceNode.getID());
                startLocIndex = sourceNode.getElementLocations().indexOf(happy.source);
                source = this.snoopyWriterPlaces.get(index2);
                subSourceIDs.add(((SnoopyWriterPlace)source).grParents.get(startLocIndex));
                subSourcePoint.add(((SnoopyWriterPlace)source).grParentsLocation.get(startLocIndex));
            } else if (sourceNode instanceof Transition) {
                int index3 = this.holmesTransitionsID.lastIndexOf(sourceNode.getID());
                startLocIndex = sourceNode.getElementLocations().indexOf(happy.source);
                source = this.snoopyWriterTransitions.get(index3);
                subSourceIDs.add(((SnoopyWriterTransition)source).grParents.get(startLocIndex));
                subSourcePoint.add(((SnoopyWriterTransition)source).grParentsLocation.get(startLocIndex));
            } else if (sourceNode instanceof MetaNode) {
                MetaNode sMetaNode = (MetaNode)sourceNode;
                if (sMetaNode.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                    index = this.holmesCoarsePlacesID.lastIndexOf(sourceNode.getID());
                    source = this.snoopyWriterCoarsePlaces.get(index);
                    subSourceIDs.add(((SnoopyWriterCoarse)source).grParents.get(0));
                    subSourcePoint.add(((SnoopyWriterCoarse)source).grParentsLocation.get(0));
                } else {
                    if (sMetaNode.getMetaType() != MetaNode.MetaType.SUBNETTRANS) {
                        overlord.log(lang.getText("LOGentry00129a") + " " + arcus.toString() + " " + lang.getText("LOGentry00129b") + String.valueOf((Object)sMetaNode.getMetaType()), "error", true);
                        return IDbackup + 1 + spaceBetweenIDs;
                    }
                    index = this.holmesCoarseTransitionsID.lastIndexOf(sourceNode.getID());
                    source = this.snoopyWriterCoarseTransitions.get(index);
                    subSourceIDs.add(((SnoopyWriterCoarse)source).grParents.get(0));
                    subSourcePoint.add(((SnoopyWriterCoarse)source).grParentsLocation.get(0));
                }
            } else {
                overlord.log(lang.getText("LOGentry00130a") + " " + arcus.toString() + " " + lang.getText("LOGentry00130b") + String.valueOf(sourceNode), "error", true);
                return IDbackup + 1 + spaceBetweenIDs;
            }
            if (targetNode instanceof Place) {
                int index4 = this.holmesPlacesID.lastIndexOf(targetNode.getID());
                endLocIndex = targetNode.getElementLocations().indexOf(happy.target);
                source = this.snoopyWriterPlaces.get(index4);
                subTargetIDs.add(((SnoopyWriterPlace)source).grParents.get(endLocIndex));
                subTargetPoint.add(((SnoopyWriterPlace)source).grParentsLocation.get(endLocIndex));
            } else if (targetNode instanceof Transition) {
                int index5 = this.holmesTransitionsID.lastIndexOf(targetNode.getID());
                endLocIndex = targetNode.getElementLocations().indexOf(happy.target);
                source = this.snoopyWriterTransitions.get(index5);
                subTargetIDs.add(((SnoopyWriterTransition)source).grParents.get(endLocIndex));
                subTargetPoint.add(((SnoopyWriterTransition)source).grParentsLocation.get(endLocIndex));
            } else if (targetNode instanceof MetaNode) {
                MetaNode sMetaNode = (MetaNode)targetNode;
                if (sMetaNode.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                    index = this.holmesCoarsePlacesID.lastIndexOf(targetNode.getID());
                    source = this.snoopyWriterCoarsePlaces.get(index);
                    subTargetIDs.add(((SnoopyWriterCoarse)source).grParents.get(0));
                    subTargetPoint.add(((SnoopyWriterCoarse)source).grParentsLocation.get(0));
                } else {
                    if (sMetaNode.getMetaType() != MetaNode.MetaType.SUBNETTRANS) {
                        overlord.log(lang.getText("LOGentry00131a") + " " + arcus.toString() + " " + lang.getText("LOGentry00131b") + String.valueOf((Object)sMetaNode.getMetaType()), "error", true);
                        return IDbackup + 1 + spaceBetweenIDs;
                    }
                    index = this.holmesCoarseTransitionsID.lastIndexOf(targetNode.getID());
                    source = this.snoopyWriterCoarseTransitions.get(index);
                    subTargetIDs.add(((SnoopyWriterCoarse)source).grParents.get(0));
                    subTargetPoint.add(((SnoopyWriterCoarse)source).grParentsLocation.get(0));
                }
            } else {
                overlord.log(lang.getText("LOGentry00132a") + " " + arcus.toString() + " " + lang.getText("LOGentry00132b") + String.valueOf(sourceNode), "error", true);
                return IDbackup + 1 + spaceBetweenIDs;
            }
            Point sPoint = (Point)subSourcePoint.get(subSourcePoint.size() - 1);
            Point tPoint = (Point)subTargetPoint.get(subTargetPoint.size() - 1);
            int halfX = (tPoint.x + sPoint.x) / 2;
            int halfY = (tPoint.y + sPoint.y) / 2;
            halfPoint.add(new Point(halfX, halfY));
        }
        this.write(bw, "      <edge source=\"" + mainSourceID + "\" target=\"" + mainTargetID + "\" id=\"" + ((Integer)grParents.get(0) - 5) + "\" net=\"" + subnetsPath.get((int)0).subnet + "\">");
        int xOff = 20;
        if (arcType != Arc.TypeOfArc.RESET) {
            this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + ((Integer)grParents.get(0) - 4) + "\" net=\"" + (subnetsPath.get((int)0).subnet + 1) + "\">");
            this.write(bw, "          <![CDATA[" + arcus.getWeight() + "]]>");
            this.write(bw, "          <graphics count=\"" + pathSize + "\">");
            for (int i3 = 0; i3 < pathSize; ++i3) {
                int id = -1;
                id = i3 == 0 ? (Integer)grParents.get(i3) - 3 : (Integer)grParents.get(i3) + 1;
                this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (((Point)halfPoint.get((int)i3)).x + xOff) + ".00\" y=\"" + ((Point)halfPoint.get((int)i3)).y + ".00\" id=\"" + id + "\" net=\"" + (subnetsPath.get((int)i3).subnet + 1) + "\" show=\"1\" grparent=\"" + String.valueOf(grParents.get(i3)) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            }
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
        }
        this.write(bw, "        <attribute name=\"Comment\" id=\"" + ((Integer)grParents.get(0) - 2) + "\" net=\"" + (subnetsPath.get((int)0).subnet + 1) + "\">");
        this.write(bw, "          <![CDATA[" + this.removeEnters(arcus.getComment()) + "]]>");
        this.write(bw, "          <graphics count=\"" + pathSize + "\">");
        xOff = 40;
        for (i = 0; i < pathSize; ++i) {
            int id = -1;
            id = i == 0 ? (Integer)grParents.get(i) - 1 : (Integer)grParents.get(i) + 2;
            this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (((Point)halfPoint.get((int)i)).x + xOff) + ".00\" y=\"" + ((Point)halfPoint.get((int)i)).y + ".00\" id=\"" + id + "\" net=\"" + (subnetsPath.get((int)i).subnet + 1) + "\" show=\"1\" grparent=\"" + String.valueOf(grParents.get(i)) + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
        }
        this.write(bw, "          </graphics>");
        this.write(bw, "        </attribute>");
        this.write(bw, "        <graphics count=\"2\">");
        for (i = 0; i < pathSize; ++i) {
            int state = 8;
            if (i == pathSize - 1) {
                state = 4;
            }
            this.write(bw, "          <graphic id=\"" + String.valueOf(grParents.get(i)) + "\" net=\"" + (subnetsPath.get((int)i).subnet + 1) + "\" source=\"" + String.valueOf(subSourceIDs.get(i)) + "\" target=\"" + String.valueOf(subTargetIDs.get(i)) + "\" state=\"" + state + "\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
            this.write(bw, "            <points count=\"2\">");
            this.write(bw, "              <point x=\"" + ((Point)subSourcePoint.get((int)i)).x + ".00\" y=\"" + ((Point)subSourcePoint.get((int)i)).y + ".00\"/>");
            this.write(bw, "              <point x=\"" + ((Point)subTargetPoint.get((int)i)).x + ".00\" y=\"" + ((Point)subTargetPoint.get((int)i)).y + ".00\"/>");
            this.write(bw, "            </points>");
            this.write(bw, "          </graphic>");
        }
        this.write(bw, "        </graphics>");
        this.write(bw, "      </edge>");
        for (i = 1; i < pathSize; ++i) {
            metaArcs.remove(subnetsPath.get((int)i).arc);
        }
        return IDbackup + 1 + spaceBetweenIDs;
    }

    private ArrayList<PathPackage> recreateSubnetsPath(ElementLocation arcStartElLocation, ElementLocation arcEndElLocation, Arc arcus, boolean isInInterface, ArrayList<Arc> metaArcs) {
        ArrayList<PathPackage> result = new ArrayList<PathPackage>();
        PathPackage first = new PathPackage();
        first.subnet = arcStartElLocation.getSheetID();
        first.arc = arcus;
        if (isInInterface) {
            first.source = arcStartElLocation;
            first.target = arcEndElLocation;
        } else {
            first.source = arcEndElLocation;
            first.target = arcStartElLocation;
        }
        result.add(first);
        ArrayList<Integer> path = new ArrayList<Integer>();
        boolean search = true;
        Node startNode = arcStartElLocation.getParentNode();
        path.add(arcStartElLocation.getSheetID());
        while (search) {
            int pathSize = path.size();
            int metaSheetToFind = (Integer)path.get(pathSize - 1);
            boolean findAnything = false;
            for (MetaNode meta : this.metanodes) {
                PathPackage dp;
                if (findAnything) break;
                if (meta.getRepresentedSheetID() != metaSheetToFind) continue;
                if (isInInterface) {
                    for (Arc arc : meta.getElementLocations().get(0).accessMetaInArcs()) {
                        if (!metaArcs.contains(arc) || !arc.getStartNode().equals(startNode) || path.contains(arc.getStartLocation().getSheetID())) continue;
                        dp = new PathPackage();
                        dp.subnet = arc.getStartLocation().getSheetID();
                        dp.source = arc.getStartLocation();
                        dp.target = meta.getElementLocations().get(0);
                        dp.arc = arc;
                        result.add(dp);
                        path.add(arc.getStartLocation().getSheetID());
                        findAnything = true;
                    }
                    continue;
                }
                for (Arc arc : meta.getElementLocations().get(0).accessMetaOutArcs()) {
                    if (!metaArcs.contains(arc) || !arc.getEndNode().equals(startNode) || path.contains(arc.getEndLocation().getSheetID())) continue;
                    dp = new PathPackage();
                    dp.subnet = arc.getEndLocation().getSheetID();
                    dp.source = meta.getElementLocations().get(0);
                    dp.target = arc.getEndLocation();
                    dp.arc = arc;
                    result.add(dp);
                    path.add(arc.getEndLocation().getSheetID());
                    findAnything = true;
                }
            }
            if (findAnything) continue;
            search = false;
            return result;
        }
        return result;
    }

    private boolean weNeedToGoDeeper(MetaNode metanode, Node startN, boolean isInInterface) {
        int metaSheet = metanode.getElementLocations().get(0).getSheetID();
        if (metaSheet == 0) {
            return false;
        }
        for (MetaNode meta : this.metanodes) {
            if (meta.getRepresentedSheetID() != metaSheet) continue;
            if (isInInterface) {
                for (Arc arc : meta.getElementLocations().get(0).accessMetaInArcs()) {
                    if (!arc.getStartNode().equals(startN)) continue;
                    return true;
                }
                continue;
            }
            for (Arc arc : meta.getElementLocations().get(0).accessMetaOutArcs()) {
                if (!arc.getEndNode().equals(startN)) continue;
                return true;
            }
        }
        return false;
    }

    public void addArcsToFile(BufferedWriter bw, int currentActiveID) {
        int halfY;
        int halfX;
        int realTargetY;
        int realTargetX;
        int realTargetID;
        int nodeTargetID;
        int counter;
        ElementLocation destinationLoc;
        Object target;
        int addToSPPEDAsTarget;
        int realSourceY;
        int realSourceX;
        int realSourceID;
        int nodeSourceID;
        Object source;
        int addToSPPEDAsSource;
        Node sourceHolmes;
        Node targetHolmes;
        int grParent;
        String comment;
        ArrayList<Arc> outArcs;
        int location;
        int howMany = 0;
        int nextID = currentActiveID;
        int xOff = 0;
        for (Place p : this.places) {
            location = -1;
            for (ElementLocation el : p.getElementLocations()) {
                ++location;
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    try {
                        int weight = a.getWeight();
                        comment = this.removeEnters(a.getComment());
                        grParent = currentActiveID + 5;
                        targetHolmes = a.getEndNode();
                        sourceHolmes = a.getStartNode();
                        addToSPPEDAsSource = this.holmesPlacesID.lastIndexOf(sourceHolmes.getID());
                        if (addToSPPEDAsSource == -1) {
                            return;
                        }
                        source = this.snoopyWriterPlaces.get(addToSPPEDAsSource);
                        nodeSourceID = ((SnoopyWriterPlace)source).snoopyStartingID;
                        realSourceID = ((SnoopyWriterPlace)source).grParents.get(location);
                        realSourceX = ((SnoopyWriterPlace)source).grParentsLocation.get((int)location).x;
                        realSourceY = ((SnoopyWriterPlace)source).grParentsLocation.get((int)location).y;
                        addToSPPEDAsTarget = this.holmesTransitionsID.lastIndexOf(targetHolmes.getID());
                        target = this.snoopyWriterTransitions.get(addToSPPEDAsTarget);
                        destinationLoc = a.getEndLocation();
                        counter = -1;
                        for (ElementLocation whichOne : targetHolmes.getElementLocations()) {
                            ++counter;
                            if (!whichOne.equals(destinationLoc)) continue;
                            break;
                        }
                        nodeTargetID = ((SnoopyWriterTransition)target).snoopyStartingID;
                        realTargetID = ((SnoopyWriterTransition)target).grParents.get(counter);
                        realTargetX = ((SnoopyWriterTransition)target).grParentsLocation.get((int)counter).x;
                        realTargetY = ((SnoopyWriterTransition)target).grParentsLocation.get((int)counter).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + nextID + "\" net=\"1\">");
                        this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + ++nextID + "\" net=\"1\">");
                        this.write(bw, "          <![CDATA[" + weight + "]]>");
                        this.write(bw, "          <graphics count=\"1\">");
                        xOff = 20;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                        this.write(bw, "        <attribute name=\"Comment\" id=\"" + ++nextID + "\" net=\"1\">");
                        this.write(bw, "          <![CDATA[" + comment + "]]>");
                        this.write(bw, "          <graphics count=\"1\">");
                        xOff = 40;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        ++nextID;
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                        this.write(bw, "        <graphics count=\"1\">");
                        this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"1\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"1\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                        if (a.accessBreaks().isEmpty()) {
                            this.write(bw, "            <points count=\"2\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        } else {
                            this.write(bw, "            <points count=\"" + (a.accessBreaks().size() + 2) + "\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            for (Point point : a.accessBreaks()) {
                                this.write(bw, "              <point x=\"" + point.x + ".00\" y=\"" + point.y + ".00\"/>");
                            }
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        }
                        this.write(bw, "            </points>");
                        this.write(bw, "          </graphic>");
                        this.write(bw, "        </graphics>");
                        this.write(bw, "      </edge>");
                        ++howMany;
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentry00133a") + " " + a.getStartNode().getName() + " " + lang.getText("LOGentry00133b") + " " + a.getEndNode().getName(), "error", true);
                    }
                }
            }
        }
        for (Transition t : this.transitions) {
            location = -1;
            for (ElementLocation el : t.getElementLocations()) {
                ++location;
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    try {
                        int weight = a.getWeight();
                        comment = a.getComment();
                        grParent = currentActiveID + 5;
                        targetHolmes = a.getEndNode();
                        sourceHolmes = a.getStartNode();
                        addToSPPEDAsSource = this.holmesTransitionsID.lastIndexOf(sourceHolmes.getID());
                        if (addToSPPEDAsSource == -1) {
                            return;
                        }
                        source = this.snoopyWriterTransitions.get(addToSPPEDAsSource);
                        nodeSourceID = ((SnoopyWriterTransition)source).snoopyStartingID;
                        realSourceID = ((SnoopyWriterTransition)source).grParents.get(location);
                        realSourceX = ((SnoopyWriterTransition)source).grParentsLocation.get((int)location).x;
                        realSourceY = ((SnoopyWriterTransition)source).grParentsLocation.get((int)location).y;
                        addToSPPEDAsTarget = this.holmesPlacesID.lastIndexOf(targetHolmes.getID());
                        target = this.snoopyWriterPlaces.get(addToSPPEDAsTarget);
                        destinationLoc = a.getEndLocation();
                        counter = -1;
                        for (ElementLocation whichOne : targetHolmes.getElementLocations()) {
                            ++counter;
                            if (!whichOne.equals(destinationLoc)) continue;
                            break;
                        }
                        nodeTargetID = ((SnoopyWriterPlace)target).snoopyStartingID;
                        realTargetID = ((SnoopyWriterPlace)target).grParents.get(counter);
                        realTargetX = ((SnoopyWriterPlace)target).grParentsLocation.get((int)counter).x;
                        realTargetY = ((SnoopyWriterPlace)target).grParentsLocation.get((int)counter).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + nextID + "\" net=\"1\">");
                        this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + ++nextID + "\" net=\"1\">");
                        this.write(bw, "          <![CDATA[" + weight + "]]>");
                        this.write(bw, "          <graphics count=\"1\">");
                        xOff = 20;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                        this.write(bw, "        <attribute name=\"Comment\" id=\"" + ++nextID + "\" net=\"1\">");
                        this.write(bw, "          <![CDATA[" + comment + "]]>");
                        this.write(bw, "          <graphics count=\"1\">");
                        xOff = 40;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        ++nextID;
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                        this.write(bw, "        <graphics count=\"1\">");
                        this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"1\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"1\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                        if (a.accessBreaks().isEmpty()) {
                            this.write(bw, "            <points count=\"2\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        } else {
                            this.write(bw, "            <points count=\"" + (a.accessBreaks().size() + 2) + "\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            for (Point point : a.accessBreaks()) {
                                this.write(bw, "              <point x=\"" + point.x + ".00\" y=\"" + point.y + ".00\"/>");
                            }
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        }
                        this.write(bw, "            </points>");
                        this.write(bw, "          </graphic>");
                        this.write(bw, "        </graphics>");
                        this.write(bw, "      </edge>");
                        ++howMany;
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentry00134a") + " " + a.getStartNode().getName() + " " + lang.getText("LOGentry00134b") + " " + a.getEndNode().getName(), "error", true);
                    }
                }
            }
        }
        int arcNumber = overlord.getWorkspace().getProject().getArcs().size();
        if (howMany != arcNumber) {
            overlord.log(lang.getText("LOGentry00135"), "error", true);
            if (howMany > arcNumber) {
                overlord.log(lang.getText("LOGentry00136"), "error", true);
            } else {
                overlord.log(lang.getText("LOGentry00137"), "error", true);
            }
        }
    }

    public int addArcsInfoExtended(BufferedWriter bw, int currentActiveID, Arc.TypeOfArc arcClass, int howManyToSave) {
        int halfY;
        int halfX;
        int realTargetY;
        int realTargetX;
        int realTargetID;
        int nodeTargetID;
        int counter;
        ElementLocation destinationLoc;
        Object target;
        int addToSPPEDAsTarget;
        int realSourceY;
        int realSourceX;
        int realSourceID;
        int nodeSourceID;
        Object source;
        int addToSPPEDAsSource;
        Node sourceHolmes;
        Node targetHolmes;
        int grParent;
        String comment;
        ArrayList<Arc> outArcs;
        int location;
        int howManySaved = 0;
        int nextID = currentActiveID;
        int xOff = 0;
        for (Place p : this.places) {
            location = -1;
            for (ElementLocation el : p.getElementLocations()) {
                ++location;
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    try {
                        if (a.getArcType() != arcClass) continue;
                        int weight = a.getWeight();
                        comment = a.getComment();
                        grParent = currentActiveID + 5;
                        targetHolmes = a.getEndNode();
                        sourceHolmes = a.getStartNode();
                        addToSPPEDAsSource = this.holmesPlacesID.lastIndexOf(sourceHolmes.getID());
                        if (addToSPPEDAsSource == -1) {
                            return nextID + 10;
                        }
                        source = this.snoopyWriterPlaces.get(addToSPPEDAsSource);
                        nodeSourceID = ((SnoopyWriterPlace)source).snoopyStartingID;
                        realSourceID = ((SnoopyWriterPlace)source).grParents.get(location);
                        realSourceX = ((SnoopyWriterPlace)source).grParentsLocation.get((int)location).x;
                        realSourceY = ((SnoopyWriterPlace)source).grParentsLocation.get((int)location).y;
                        addToSPPEDAsTarget = this.holmesTransitionsID.lastIndexOf(targetHolmes.getID());
                        target = this.snoopyWriterTransitions.get(addToSPPEDAsTarget);
                        destinationLoc = a.getEndLocation();
                        counter = -1;
                        for (ElementLocation whichOne : targetHolmes.getElementLocations()) {
                            ++counter;
                            if (!whichOne.equals(destinationLoc)) continue;
                            break;
                        }
                        nodeTargetID = ((SnoopyWriterTransition)target).snoopyStartingID;
                        realTargetID = ((SnoopyWriterTransition)target).grParents.get(counter);
                        realTargetX = ((SnoopyWriterTransition)target).grParentsLocation.get((int)counter).x;
                        realTargetY = ((SnoopyWriterTransition)target).grParentsLocation.get((int)counter).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + nextID + "\" net=\"1\">");
                        ++nextID;
                        if (arcClass != Arc.TypeOfArc.RESET) {
                            this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + nextID + "\" net=\"1\">");
                            this.write(bw, "          <![CDATA[" + weight + "]]>");
                            this.write(bw, "          <graphics count=\"1\">");
                            xOff = 20;
                            this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                            ++nextID;
                            this.write(bw, "          </graphics>");
                            this.write(bw, "        </attribute>");
                        }
                        this.write(bw, "        <attribute name=\"Comment\" id=\"" + nextID + "\" net=\"1\">");
                        this.write(bw, "          <![CDATA[" + comment + "]]>");
                        this.write(bw, "          <graphics count=\"1\">");
                        xOff = 40;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        ++nextID;
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                        this.write(bw, "        <graphics count=\"1\">");
                        this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"1\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"1\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                        if (a.accessBreaks().isEmpty()) {
                            this.write(bw, "            <points count=\"2\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        } else {
                            this.write(bw, "            <points count=\"" + (a.accessBreaks().size() + 2) + "\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            for (Point point : a.accessBreaks()) {
                                this.write(bw, "              <point x=\"" + point.x + ".00\" y=\"" + point.y + ".00\"/>");
                            }
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        }
                        this.write(bw, "            </points>");
                        this.write(bw, "          </graphic>");
                        this.write(bw, "        </graphics>");
                        this.write(bw, "      </edge>");
                        ++howManySaved;
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentry00138a") + " " + a.getStartNode().getName() + " " + lang.getText("LOGentry00138b") + " " + a.getEndNode().getName(), "error", true);
                    }
                }
            }
        }
        for (Transition t : this.transitions) {
            location = -1;
            for (ElementLocation el : t.getElementLocations()) {
                ++location;
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    try {
                        if (a.getArcType() != arcClass || a.getArcType() == Arc.TypeOfArc.READARC) continue;
                        int weight = a.getWeight();
                        comment = a.getComment();
                        grParent = currentActiveID + 5;
                        targetHolmes = a.getEndNode();
                        sourceHolmes = a.getStartNode();
                        addToSPPEDAsSource = this.holmesTransitionsID.lastIndexOf(sourceHolmes.getID());
                        if (addToSPPEDAsSource == -1) {
                            return nextID + 10;
                        }
                        source = this.snoopyWriterTransitions.get(addToSPPEDAsSource);
                        nodeSourceID = ((SnoopyWriterTransition)source).snoopyStartingID;
                        realSourceID = ((SnoopyWriterTransition)source).grParents.get(location);
                        realSourceX = ((SnoopyWriterTransition)source).grParentsLocation.get((int)location).x;
                        realSourceY = ((SnoopyWriterTransition)source).grParentsLocation.get((int)location).y;
                        addToSPPEDAsTarget = this.holmesPlacesID.lastIndexOf(targetHolmes.getID());
                        target = this.snoopyWriterPlaces.get(addToSPPEDAsTarget);
                        destinationLoc = a.getEndLocation();
                        counter = -1;
                        for (ElementLocation whichOne : targetHolmes.getElementLocations()) {
                            ++counter;
                            if (!whichOne.equals(destinationLoc)) continue;
                            break;
                        }
                        nodeTargetID = ((SnoopyWriterPlace)target).snoopyStartingID;
                        realTargetID = ((SnoopyWriterPlace)target).grParents.get(counter);
                        realTargetX = ((SnoopyWriterPlace)target).grParentsLocation.get((int)counter).x;
                        realTargetY = ((SnoopyWriterPlace)target).grParentsLocation.get((int)counter).y;
                        halfX = (realTargetX + realSourceX) / 2;
                        halfY = (realTargetY + realSourceY) / 2;
                        this.write(bw, "      <edge source=\"" + nodeSourceID + "\" target=\"" + nodeTargetID + "\" id=\"" + nextID + "\" net=\"1\">");
                        ++nextID;
                        if (arcClass != Arc.TypeOfArc.RESET) {
                            this.write(bw, "        <attribute name=\"Multiplicity\" id=\"" + nextID + "\" net=\"1\">");
                            this.write(bw, "          <![CDATA[" + weight + "]]>");
                            this.write(bw, "          <graphics count=\"1\">");
                            xOff = 20;
                            this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                            ++nextID;
                            this.write(bw, "          </graphics>");
                            this.write(bw, "        </attribute>");
                        }
                        this.write(bw, "        <attribute name=\"Comment\" id=\"" + nextID + "\" net=\"1\">");
                        this.write(bw, "          <![CDATA[" + comment + "]]>");
                        this.write(bw, "          <graphics count=\"1\">");
                        xOff = 40;
                        this.write(bw, "            <graphic xoff=\"" + xOff + ".00\" x=\"" + (halfX + xOff) + ".00\" y=\"" + halfY + ".00\" id=\"" + ++nextID + "\" net=\"1\" show=\"1\" grparent=\"" + grParent + "\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
                        ++nextID;
                        this.write(bw, "          </graphics>");
                        this.write(bw, "        </attribute>");
                        this.write(bw, "        <graphics count=\"1\">");
                        this.write(bw, "          <graphic id=\"" + grParent + "\" net=\"1\" source=\"" + realSourceID + "\" target=\"" + realTargetID + "\" state=\"1\" show=\"1\" pen=\"0,0,0\" brush=\"0,0,0\" edge_designtype=\"3\">");
                        if (a.accessBreaks().isEmpty()) {
                            this.write(bw, "            <points count=\"2\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        } else {
                            this.write(bw, "            <points count=\"" + (a.accessBreaks().size() + 2) + "\">");
                            this.write(bw, "              <point x=\"" + realSourceX + ".00\" y=\"" + realSourceY + ".00\"/>");
                            for (Point point : a.accessBreaks()) {
                                this.write(bw, "              <point x=\"" + point.x + ".00\" y=\"" + point.y + ".00\"/>");
                            }
                            this.write(bw, "              <point x=\"" + realTargetX + ".00\" y=\"" + realTargetY + ".00\"/>");
                        }
                        this.write(bw, "            </points>");
                        this.write(bw, "          </graphic>");
                        this.write(bw, "        </graphics>");
                        this.write(bw, "      </edge>");
                        ++howManySaved;
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentry00139a") + " " + a.getStartNode().getName() + " " + lang.getText("LOGentry00139b") + " " + a.getEndNode().getName(), "error", true);
                    }
                }
            }
        }
        if (howManySaved != howManyToSave && arcClass != Arc.TypeOfArc.READARC) {
            overlord.log(lang.getText("LOGentry00140"), "error", true);
            if (howManySaved > howManyToSave) {
                overlord.log(lang.getText("LOGentry00141"), "error", true);
            } else {
                overlord.log(lang.getText("LOGentry00142"), "error", true);
            }
        }
        return nextID;
    }

    private void write(BufferedWriter bw, String text) {
        try {
            bw.write(text + "\n");
        }
        catch (Exception e) {
            return;
        }
    }

    private String removeEnters(String txt) {
        txt = txt.replace("\n", " ");
        return txt;
    }

    static class PathPackage {
        int subnet = -1;
        public ElementLocation source = null;
        public ElementLocation target = null;
        public Arc arc = null;

        PathPackage() {
        }
    }
}

