/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io.snoopy;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.snoopy.SnoopyWriterArc;
import holmes.files.io.snoopy.SnoopyWriterCoarse;
import holmes.files.io.snoopy.SnoopyWriterPlace;
import holmes.files.io.snoopy.SnoopyWriterTimeTransition;
import holmes.files.io.snoopy.SnoopyWriterTransition;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.varia.Check;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;

public class SnoopyWriter {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<Place> places;
    private ArrayList<Transition> transitions;
    private ArrayList<MetaNode> metanodes;
    private ArrayList<Arc> arcs;
    private ArrayList<MetaNode> coarsePlaces = new ArrayList();
    private ArrayList<MetaNode> coarseTransitions = new ArrayList();
    private ArrayList<SnoopyWriterPlace> snoopyWriterPlaces;
    private ArrayList<Integer> holmesPlacesID = new ArrayList();
    private ArrayList<SnoopyWriterTransition> snoopyWriterTransitions;
    private ArrayList<Integer> holmesTransitionsID = new ArrayList();
    private ArrayList<SnoopyWriterCoarse> snoopyWriterCoarsePlaces;
    private ArrayList<Integer> holmesCoarsePlacesID = new ArrayList();
    private ArrayList<SnoopyWriterCoarse> snoopyWriterCoarseTransitions;
    private ArrayList<Integer> holmesCoarseTransitionsID = new ArrayList();

    public SnoopyWriter() {
        this.places = overlord.getWorkspace().getProject().getPlaces();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.metanodes = overlord.getWorkspace().getProject().getMetaNodes();
        for (MetaNode meta : this.metanodes) {
            if (meta.getMetaType() == MetaNode.MetaType.SUBNETPLACE) {
                this.coarsePlaces.add(meta);
            }
            if (meta.getMetaType() != MetaNode.MetaType.SUBNETTRANS) continue;
            this.coarseTransitions.add(meta);
        }
        this.arcs = overlord.getWorkspace().getProject().getArcs();
        this.snoopyWriterPlaces = new ArrayList();
        this.snoopyWriterTransitions = new ArrayList();
        this.snoopyWriterCoarsePlaces = new ArrayList();
        this.snoopyWriterCoarseTransitions = new ArrayList();
    }

    public boolean writeSPPED(String filePath) {
        boolean status = SnoopyWriter.overlord.subnetsHQ.checkSnoopyCompatibility();
        if (!status) {
            JOptionPane.showMessageDialog(null, lang.getText("SW_entry001"), lang.getText("problem"), 0);
            return false;
        }
        int currentActiveID = 226;
        int arcsNumber = 0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));
            this.write(bw, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.write(bw, "<?xml-stylesheet type=\"text/xsl\" href=\"/xsl/spped2svg.xsl\"?>");
            this.write(bw, "<Snoopy version=\"2\" revision=\"1.13\">");
            this.write(bw, "  <netclass name=\"Petri Net\"/>");
            this.write(bw, "  <nodeclasses count=\"4\">");
            int placesNumber = this.places.size();
            this.write(bw, "    <nodeclass count=\"" + placesNumber + "\" name=\"Place\">");
            int globalPlaceId = 0;
            for (Place p : this.places) {
                SnoopyWriterPlace sPlace = new SnoopyWriterPlace(p);
                this.snoopyWriterPlaces.add(sPlace);
                this.holmesPlacesID.add(p.getID());
                ArrayList<ElementLocation> clones = p.getElementLocations();
                for (ElementLocation el : clones) {
                    arcsNumber += el.getOutArcs().size();
                }
                currentActiveID = sPlace.writePlaceInfoToFile(bw, currentActiveID, globalPlaceId);
                currentActiveID = sPlace.portal ? (currentActiveID += 13) : ++currentActiveID;
                ++globalPlaceId;
            }
            this.write(bw, "    </nodeclass>");
            int transNumber = this.transitions.size();
            this.write(bw, "    <nodeclass count=\"" + transNumber + "\" name=\"Transition\">");
            int globalTransId = 0;
            for (Transition t : this.transitions) {
                SnoopyWriterTransition sTransition = new SnoopyWriterTransition(t);
                this.snoopyWriterTransitions.add(sTransition);
                this.holmesTransitionsID.add(t.getID());
                ArrayList<ElementLocation> clones = t.getElementLocations();
                for (ElementLocation el : clones) {
                    arcsNumber += el.getOutArcs().size();
                }
                currentActiveID = sTransition.writeTransitionInfoToFile(bw, currentActiveID, globalTransId);
                ++currentActiveID;
                ++globalTransId;
            }
            this.write(bw, "    </nodeclass>");
            boolean weAreInDeepShit = false;
            if (this.coarsePlaces.isEmpty()) {
                this.write(bw, "    <nodeclass count=\"0\" name=\"Coarse Place\"/>");
            } else {
                weAreInDeepShit = true;
                int coarsePnumber = this.coarsePlaces.size();
                this.write(bw, "    <nodeclass count=\"" + coarsePnumber + "\" name=\"Coarse Place\">");
                int globalCoarsePlaceId = 0;
                for (MetaNode m : this.coarsePlaces) {
                    SnoopyWriterCoarse sCoarseP = new SnoopyWriterCoarse(m);
                    this.snoopyWriterCoarsePlaces.add(sCoarseP);
                    this.holmesCoarsePlacesID.add(m.getID());
                    currentActiveID = sCoarseP.writeMetaNodeInfoToFile(bw, currentActiveID, globalCoarsePlaceId);
                    ++currentActiveID;
                    ++globalCoarsePlaceId;
                }
                this.write(bw, "    </nodeclass>");
            }
            if (this.coarseTransitions.isEmpty()) {
                this.write(bw, "    <nodeclass count=\"0\" name=\"Coarse Transition\"/>");
            } else {
                weAreInDeepShit = true;
                int coarseTnumber = this.coarseTransitions.size();
                this.write(bw, "    <nodeclass count=\"" + coarseTnumber + "\" name=\"Coarse Transition\">");
                int globalCoarseTransitionId = 0;
                for (MetaNode m : this.coarseTransitions) {
                    SnoopyWriterCoarse sCoarseT = new SnoopyWriterCoarse(m);
                    this.snoopyWriterCoarseTransitions.add(sCoarseT);
                    this.holmesCoarseTransitionsID.add(m.getID());
                    currentActiveID = sCoarseT.writeMetaNodeInfoToFile(bw, currentActiveID, globalCoarseTransitionId);
                    ++currentActiveID;
                    ++globalCoarseTransitionId;
                }
                this.write(bw, "    </nodeclass>");
            }
            this.write(bw, "  </nodeclasses>");
            SnoopyWriterArc arcWriter = new SnoopyWriterArc(this.places, this.transitions, this.metanodes, this.arcs, this.coarsePlaces, this.coarseTransitions, this.snoopyWriterPlaces, this.holmesPlacesID, this.snoopyWriterTransitions, this.holmesTransitionsID, this.snoopyWriterCoarsePlaces, this.holmesCoarsePlacesID, this.snoopyWriterCoarseTransitions, this.holmesCoarseTransitionsID);
            this.write(bw, "  <edgeclasses count=\"1\">");
            this.write(bw, "    <edgeclass count=\"" + arcsNumber + "\" name=\"Edge\">");
            if (weAreInDeepShit) {
                arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, false, new Object[0]);
            } else {
                arcWriter.addArcsToFile(bw, currentActiveID);
            }
            this.write(bw, "    </edgeclass>");
            this.write(bw, "  </edgeclasses>");
            this.writeEnding(bw);
            bw.write("</Snoopy>\n");
            bw.close();
            overlord.log(lang.getText("SW_entry002") + " " + filePath, "text", true);
            overlord.markNetSaved();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00113_1exception") + " " + filePath, "error", true);
            overlord.log(e.getMessage(), "error", false);
            return false;
        }
    }

    public boolean writeSPEPT(String filePath) {
        boolean status = SnoopyWriter.overlord.subnetsHQ.checkSnoopyCompatibility();
        if (!status) {
            JOptionPane.showMessageDialog(null, lang.getText("SW_entry003"), lang.getText("problem"), 0);
            return false;
        }
        int currentActiveID = 226;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));
            this.write(bw, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.write(bw, "<?xml-stylesheet type=\"text/xsl\" href=\"/xsl/spped2svg.xsl\"?>");
            this.write(bw, "<Snoopy version=\"2\" revision=\"1.13\">");
            this.write(bw, "  <netclass name=\"Extended Petri Net\"/>");
            this.write(bw, "  <nodeclasses count=\"4\">");
            int placesNumber = this.places.size();
            this.write(bw, "    <nodeclass count=\"" + placesNumber + "\" name=\"Place\">");
            int globalPlaceId = 0;
            for (Place p : this.places) {
                SnoopyWriterPlace sPlace = new SnoopyWriterPlace(p);
                this.snoopyWriterPlaces.add(sPlace);
                this.holmesPlacesID.add(p.getID());
                currentActiveID = sPlace.writePlaceInfoToFile(bw, currentActiveID, globalPlaceId);
                currentActiveID = sPlace.portal ? (currentActiveID += 13) : ++currentActiveID;
                ++globalPlaceId;
            }
            this.write(bw, "    </nodeclass>");
            int transNumber = this.transitions.size();
            this.write(bw, "    <nodeclass count=\"" + transNumber + "\" name=\"Transition\">");
            int globalTransId = 0;
            for (Transition t : this.transitions) {
                SnoopyWriterTransition sTransition = new SnoopyWriterTransition(t);
                this.snoopyWriterTransitions.add(sTransition);
                this.holmesTransitionsID.add(t.getID());
                currentActiveID = sTransition.writeTransitionInfoToFile(bw, currentActiveID, globalTransId);
                ++currentActiveID;
                ++globalTransId;
            }
            this.write(bw, "    </nodeclass>");
            boolean weAreInDeepShit = false;
            if (this.coarsePlaces.isEmpty()) {
                this.write(bw, "    <nodeclass count=\"0\" name=\"Coarse Place\"/>");
            } else {
                int coarsePnumber = this.coarsePlaces.size();
                this.write(bw, "    <nodeclass count=\"" + coarsePnumber + "\" name=\"Coarse Place\">");
                int globalCoarsePlaceId = 0;
                weAreInDeepShit = true;
                for (MetaNode m : this.coarsePlaces) {
                    SnoopyWriterCoarse sCoarseP = new SnoopyWriterCoarse(m);
                    this.snoopyWriterCoarsePlaces.add(sCoarseP);
                    this.holmesCoarsePlacesID.add(m.getID());
                    currentActiveID = sCoarseP.writeMetaNodeInfoToFile(bw, currentActiveID, globalCoarsePlaceId);
                    ++currentActiveID;
                    ++globalCoarsePlaceId;
                }
                this.write(bw, "    </nodeclass>");
            }
            if (this.coarseTransitions.isEmpty()) {
                this.write(bw, "    <nodeclass count=\"0\" name=\"Coarse Transition\"/>");
            } else {
                int coarseTnumber = this.coarseTransitions.size();
                this.write(bw, "    <nodeclass count=\"" + coarseTnumber + "\" name=\"Coarse Transition\">");
                int globalCoarseTransitionId = 0;
                weAreInDeepShit = true;
                for (MetaNode m : this.coarseTransitions) {
                    SnoopyWriterCoarse sCoarseT = new SnoopyWriterCoarse(m);
                    this.snoopyWriterCoarseTransitions.add(sCoarseT);
                    this.holmesCoarseTransitionsID.add(m.getID());
                    currentActiveID = sCoarseT.writeMetaNodeInfoToFile(bw, currentActiveID, globalCoarseTransitionId);
                    ++currentActiveID;
                    ++globalCoarseTransitionId;
                }
                this.write(bw, "    </nodeclass>");
            }
            this.write(bw, "  </nodeclasses>");
            SnoopyWriterArc arcWriter = new SnoopyWriterArc(this.places, this.transitions, this.metanodes, this.arcs, this.coarsePlaces, this.coarseTransitions, this.snoopyWriterPlaces, this.holmesPlacesID, this.snoopyWriterTransitions, this.holmesTransitionsID, this.snoopyWriterCoarsePlaces, this.holmesCoarsePlacesID, this.snoopyWriterCoarseTransitions, this.holmesCoarseTransitionsID);
            this.write(bw, "  <edgeclasses count=\"5\">");
            ArrayList<Integer> arcClasses = Check.getArcClassCount();
            if (arcClasses.get(0) == 0) {
                this.write(bw, "    <edgeclass count=\"0\" name=\"Edge\"/>");
            } else {
                this.write(bw, "    <edgeclass count=\"" + String.valueOf(arcClasses.get(0)) + "\" name=\"Edge\">");
                currentActiveID = weAreInDeepShit ? arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, true, new Object[]{Arc.TypeOfArc.NORMAL, arcClasses.get(0)}) : arcWriter.addArcsInfoExtended(bw, currentActiveID, Arc.TypeOfArc.NORMAL, arcClasses.get(0));
                this.write(bw, "    </edgeclass>");
            }
            if (arcClasses.get(1) == 0) {
                this.write(bw, "    <edgeclass count=\"0\" name=\"Read Edge\"/>");
            } else {
                this.write(bw, "    <edgeclass count=\"" + String.valueOf(arcClasses.get(1)) + "\" name=\"Read Edge\">");
                currentActiveID = weAreInDeepShit ? arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, true, new Object[]{Arc.TypeOfArc.READARC, arcClasses.get(1)}) : arcWriter.addArcsInfoExtended(bw, currentActiveID, Arc.TypeOfArc.READARC, arcClasses.get(1));
                this.write(bw, "    </edgeclass>");
            }
            if (arcClasses.get(2) == 0) {
                this.write(bw, "    <edgeclass count=\"0\" name=\"Inhibitor Edge\"/>");
            } else {
                this.write(bw, "    <edgeclass count=\"" + String.valueOf(arcClasses.get(2)) + "\" name=\"Inhibitor Edge\">");
                currentActiveID = weAreInDeepShit ? arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, true, new Object[]{Arc.TypeOfArc.INHIBITOR, arcClasses.get(2)}) : arcWriter.addArcsInfoExtended(bw, currentActiveID, Arc.TypeOfArc.INHIBITOR, arcClasses.get(2));
                this.write(bw, "    </edgeclass>");
            }
            if (arcClasses.get(3) == 0) {
                this.write(bw, "    <edgeclass count=\"0\" name=\"Reset Edge\"/>");
            } else {
                this.write(bw, "    <edgeclass count=\"" + String.valueOf(arcClasses.get(3)) + "\" name=\"Reset Edge\">");
                currentActiveID = weAreInDeepShit ? arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, true, new Object[]{Arc.TypeOfArc.RESET, arcClasses.get(3)}) : arcWriter.addArcsInfoExtended(bw, currentActiveID, Arc.TypeOfArc.RESET, arcClasses.get(3));
                this.write(bw, "    </edgeclass>");
            }
            if (arcClasses.get(4) == 0) {
                this.write(bw, "    <edgeclass count=\"0\" name=\"Equal Edge\"/>");
            } else {
                this.write(bw, "    <edgeclass count=\"" + String.valueOf(arcClasses.get(4)) + "\" name=\"Equal Edge\">");
                currentActiveID = weAreInDeepShit ? arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, true, new Object[]{Arc.TypeOfArc.EQUAL, arcClasses.get(4)}) : arcWriter.addArcsInfoExtended(bw, currentActiveID, Arc.TypeOfArc.EQUAL, arcClasses.get(4));
                this.write(bw, "    </edgeclass>");
            }
            this.write(bw, "  </edgeclasses>");
            this.writeEnding(bw);
            bw.write("</Snoopy>\n");
            bw.close();
            overlord.log(lang.getText("SW_entry004") + " " + filePath, "text", true);
            overlord.markNetSaved();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00114exception") + " " + filePath, "error", true);
            overlord.log(e.getMessage(), "error", false);
            return false;
        }
    }

    public boolean writeSPTPT(String filePath) {
        boolean status = SnoopyWriter.overlord.subnetsHQ.checkSnoopyCompatibility();
        if (!status) {
            JOptionPane.showMessageDialog(null, lang.getText("SW_entry005"), lang.getText("problem"), 0);
            return false;
        }
        int currentActiveID = 226;
        int arcsNumber = 0;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));
            this.write(bw, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.write(bw, "<?xml-stylesheet type=\"text/xsl\" href=\"/xsl/spped2svg.xsl\"?>");
            this.write(bw, "<Snoopy version=\"2\" revision=\"1.13\">");
            this.write(bw, "  <netclass name=\"Time Petri Net\"/>");
            this.write(bw, "  <nodeclasses count=\"4\">");
            int placesNumber = this.places.size();
            this.write(bw, "    <nodeclass count=\"" + placesNumber + "\" name=\"Place\">");
            int globalPlaceId = 0;
            for (Place p : this.places) {
                SnoopyWriterPlace sPlace = new SnoopyWriterPlace(p);
                this.snoopyWriterPlaces.add(sPlace);
                this.holmesPlacesID.add(p.getID());
                ArrayList<ElementLocation> clones = p.getElementLocations();
                for (ElementLocation el : clones) {
                    arcsNumber += el.getOutArcs().size();
                }
                currentActiveID = sPlace.writePlaceInfoToFile(bw, currentActiveID, globalPlaceId);
                currentActiveID = sPlace.portal ? (currentActiveID += 13) : ++currentActiveID;
                ++globalPlaceId;
            }
            this.write(bw, "    </nodeclass>");
            int transNumber = this.transitions.size();
            this.write(bw, "    <nodeclass count=\"" + transNumber + "\" name=\"Transition\">");
            int globalTransId = 0;
            for (Transition t : this.transitions) {
                SnoopyWriterTimeTransition sTransition = new SnoopyWriterTimeTransition(t);
                this.snoopyWriterTransitions.add(sTransition);
                this.holmesTransitionsID.add(t.getID());
                ArrayList<ElementLocation> clones = t.getElementLocations();
                for (ElementLocation el : clones) {
                    arcsNumber += el.getOutArcs().size();
                }
                currentActiveID = sTransition.writeTransitionInfoToFile(bw, currentActiveID, globalTransId);
                ++currentActiveID;
                ++globalTransId;
            }
            this.write(bw, "    </nodeclass>");
            boolean weAreInDeepShit = false;
            if (this.coarsePlaces.isEmpty()) {
                this.write(bw, "    <nodeclass count=\"0\" name=\"Coarse Place\"/>");
            } else {
                int coarsePnumber = this.coarsePlaces.size();
                this.write(bw, "    <nodeclass count=\"" + coarsePnumber + "\" name=\"Coarse Place\">");
                int globalCoarsePlaceId = 0;
                weAreInDeepShit = true;
                for (MetaNode m : this.coarsePlaces) {
                    SnoopyWriterCoarse sCoarseP = new SnoopyWriterCoarse(m);
                    this.snoopyWriterCoarsePlaces.add(sCoarseP);
                    this.holmesCoarsePlacesID.add(m.getID());
                    currentActiveID = sCoarseP.writeMetaNodeInfoToFile(bw, currentActiveID, globalCoarsePlaceId);
                    ++currentActiveID;
                    ++globalCoarsePlaceId;
                }
                this.write(bw, "    </nodeclass>");
            }
            if (this.coarseTransitions.isEmpty()) {
                this.write(bw, "    <nodeclass count=\"0\" name=\"Coarse Transition\"/>");
            } else {
                int coarseTnumber = this.coarseTransitions.size();
                this.write(bw, "    <nodeclass count=\"" + coarseTnumber + "\" name=\"Coarse Transition\">");
                int globalCoarseTransitionId = 0;
                weAreInDeepShit = true;
                for (MetaNode m : this.coarseTransitions) {
                    SnoopyWriterCoarse sCoarseT = new SnoopyWriterCoarse(m);
                    this.snoopyWriterCoarseTransitions.add(sCoarseT);
                    this.holmesCoarseTransitionsID.add(m.getID());
                    currentActiveID = sCoarseT.writeMetaNodeInfoToFile(bw, currentActiveID, globalCoarseTransitionId);
                    ++currentActiveID;
                    ++globalCoarseTransitionId;
                }
                this.write(bw, "    </nodeclass>");
            }
            this.write(bw, "  </nodeclasses>");
            SnoopyWriterArc arcWriter = new SnoopyWriterArc(this.places, this.transitions, this.metanodes, this.arcs, this.coarsePlaces, this.coarseTransitions, this.snoopyWriterPlaces, this.holmesPlacesID, this.snoopyWriterTransitions, this.holmesTransitionsID, this.snoopyWriterCoarsePlaces, this.holmesCoarsePlacesID, this.snoopyWriterCoarseTransitions, this.holmesCoarseTransitionsID);
            this.write(bw, "  <edgeclasses count=\"1\">");
            this.write(bw, "    <edgeclass count=\"" + arcsNumber + "\" name=\"Edge\">");
            if (weAreInDeepShit) {
                arcWriter.addArcsAndCoarseToFile(bw, currentActiveID, false, new Object[0]);
            } else {
                arcWriter.addArcsToFile(bw, currentActiveID);
            }
            this.write(bw, "    </edgeclass>");
            this.write(bw, "  </edgeclasses>");
            this.writeEnding(bw);
            bw.write("</Snoopy>\n");
            bw.close();
            overlord.log(lang.getText("SW_entry006") + " " + filePath, "text", true);
            overlord.markNetSaved();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00115exception") + " " + filePath, "error", true);
            overlord.log(e.getMessage(), "error", false);
            return false;
        }
    }

    private void write(BufferedWriter bw, String text) {
        try {
            bw.write(text + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeEnding(BufferedWriter bw) {
        SimpleDateFormat writeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String dateAndTime = writeFormat.format(date);
        try {
            this.write(bw, "  <metadataclasses count=\"3\">");
            this.write(bw, "    <metadataclass count=\"1\" name=\"General\">");
            this.write(bw, "      <metadata id=\"212\" net=\"1\">");
            this.write(bw, "        <attribute name=\"Name\" id=\"213\" net=\"1\">");
            this.write(bw, "          <![CDATA[]]>");
            this.write(bw, "          <graphics count=\"1\">");
            this.write(bw, "            <graphic xoff=\"3.00\" x=\"20.00\" y=\"20.00\" id=\"214\" net=\"1\" show=\"1\" grparent=\"225\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
            this.write(bw, "        <attribute name=\"Created\" id=\"215\" net=\"1\">");
            this.write(bw, "          <![CDATA[" + dateAndTime + "]]>");
            this.write(bw, "          <graphics count=\"1\">");
            this.write(bw, "            <graphic xoff=\"25.00\" yoff=\"20.00\" x=\"42.00\" y=\"40.00\" id=\"216\" net=\"1\" show=\"0\" grparent=\"225\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
            this.write(bw, "        <attribute name=\"Authors\" id=\"217\" net=\"1\">");
            this.write(bw, "          <![CDATA[]]>");
            this.write(bw, "          <graphics count=\"1\">");
            this.write(bw, "            <graphic xoff=\"25.00\" yoff=\"40.00\" x=\"42.00\" y=\"60.00\" id=\"218\" net=\"1\" show=\"1\" grparent=\"225\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
            this.write(bw, "        <attribute name=\"Keywords\" id=\"219\" net=\"1\">");
            this.write(bw, "          <![CDATA[]]>");
            this.write(bw, "          <graphics count=\"1\">");
            this.write(bw, "            <graphic xoff=\"40.00\" yoff=\"25.00\" x=\"57.00\" y=\"45.00\" id=\"220\" net=\"1\" show=\"1\" grparent=\"225\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
            this.write(bw, "        <attribute name=\"Description\" id=\"221\" net=\"1\">");
            this.write(bw, "          <![CDATA[]]>");
            this.write(bw, "          <graphics count=\"1\">");
            this.write(bw, "            <graphic xoff=\"25.00\" yoff=\"40.00\" x=\"42.00\" y=\"60.00\" id=\"222\" net=\"1\" show=\"1\" grparent=\"225\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
            this.write(bw, "        <attribute name=\"References\" id=\"223\" net=\"1\">");
            this.write(bw, "          <![CDATA[]]>");
            this.write(bw, "          <graphics count=\"1\">");
            this.write(bw, "            <graphic xoff=\"25.00\" yoff=\"40.00\" x=\"42.00\" y=\"60.00\" id=\"224\" net=\"1\" show=\"1\" grparent=\"225\" state=\"1\" pen=\"0,0,0\" brush=\"255,255,255\"/>");
            this.write(bw, "          </graphics>");
            this.write(bw, "        </attribute>");
            this.write(bw, "        <graphics count=\"1\">");
            this.write(bw, "          <graphic x=\"17.00\" y=\"20.00\" id=\"225\" net=\"1\" show=\"1\" w=\"15.00\" h=\"24.00\" state=\"1\" pen=\"255,255,255\" brush=\"255,255,255\"/>");
            this.write(bw, "        </graphics>");
            this.write(bw, "      </metadata>");
            this.write(bw, "    </metadataclass>");
            this.write(bw, "    <metadataclass count=\"0\" name=\"Comment\"/>");
            this.write(bw, "    <metadataclass count=\"0\" name=\"Constant Class\"/>");
            this.write(bw, "  </metadataclasses>");
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00116exception") + "\n" + e.getMessage(), "error", true);
        }
    }
}

