/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import holmes.adam.mct.Runner;
import holmes.analyse.MCTCalculator;
import holmes.clusters.ClusteringExtended;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.snoopy.SnoopyWriter;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class TexExporter {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    String newline = "\n";

    public void writePlacesTransitions() {
        FileFilter[] filters;
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        if (places.isEmpty() || transitions.isEmpty()) {
            JOptionPane.showMessageDialog(overlord, lang.getText("TEX_entry001"), lang.getText("TEX_entry001t"), 2);
            return;
        }
        String lastPath = overlord.getLastPath();
        Object selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("Normal Text File (.txt)", new String[]{"TXT"})}, lang.getText("save"), "", "");
        if (((String)selectedFile).isEmpty()) {
            return;
        }
        if (!((String)selectedFile).contains(".txt")) {
            selectedFile = (String)selectedFile + ".txt";
        }
        try {
            int i;
            int i2;
            BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
            ArrayList<CallSite> places1Col = new ArrayList<CallSite>();
            ArrayList<Object> places2Col = new ArrayList<Object>();
            if (places.size() == 1) {
                places1Col.add((CallSite)((Object)("$p_{0}$ & " + places.get(0).getName())));
                places2Col.add(" &  & \\\\ \\hline");
            } else {
                int i3;
                for (i3 = 0; i3 < (places.size() + 1) / 2; ++i3) {
                    places1Col.add((CallSite)((Object)("$p_{" + i3 + "}$ & " + places.get(i3).getName().replace("_", " "))));
                }
                for (i3 = (places.size() + 1) / 2; i3 < places.size(); ++i3) {
                    places2Col.add(" & $p_{" + i3 + "}$ & " + places.get(i3).getName().replace("_", " ") + "\\\\  \\hline");
                }
                if (places1Col.size() != places2Col.size()) {
                    places2Col.add(" &  & \\\\ \\hline");
                }
            }
            ArrayList<CallSite> trans1Col = new ArrayList<CallSite>();
            ArrayList<Object> trans2Col = new ArrayList<Object>();
            if (transitions.size() == 1) {
                trans1Col.add((CallSite)((Object)("$t_{0}$ & " + transitions.get(0).getName())));
                trans2Col.add(" &  & \\\\ \\hline");
            } else {
                for (i2 = 0; i2 < (transitions.size() + 1) / 2; ++i2) {
                    trans1Col.add((CallSite)((Object)("$t_{" + i2 + "}$ & " + transitions.get(i2).getName().replace("_", " "))));
                }
                for (i2 = (transitions.size() + 1) / 2; i2 < transitions.size(); ++i2) {
                    trans2Col.add(" & $t_{" + i2 + "}$ & " + transitions.get(i2).getName().replace("_", " ") + "\\\\  \\hline");
                }
                if (trans1Col.size() != trans2Col.size()) {
                    trans2Col.add(" &  & \\\\ \\hline");
                }
            }
            bw.write("{\\footnotesize" + this.newline);
            bw.write("\\begin{longtable}{| p{1.1cm} | p{6cm} | p{1.1cm} |  p{6cm} |}" + this.newline);
            bw.write("\\caption{List of places}\\label{tab:places}" + this.newline);
            bw.write("\\endfirsthead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Place & \\bf Biological meaning & \\bf Place & \\bf Biological meaning \\\\ \\hline" + this.newline);
            bw.write("\\endhead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Place & \\bf Biological meaning & \\bf Place & \\bf Biological meaning \\\\ \\hline" + this.newline);
            for (i2 = 0; i2 < places1Col.size(); ++i2) {
                bw.write((String)places1Col.get(i2) + (String)places2Col.get(i2) + this.newline);
            }
            bw.write("\\end{longtable}" + this.newline);
            bw.write("}" + this.newline);
            bw.write(this.newline);
            bw.write(this.newline);
            bw.write("{\\footnotesize" + this.newline);
            bw.write("\\begin{longtable}{| p{1.1cm} | p{6cm} | p{1.1cm} |  p{6cm} |}" + this.newline);
            bw.write("\\caption{List of transitions}\\label{tab:transitions}" + this.newline);
            bw.write("\\endfirsthead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Transition & \\bf Biological meaning & \\bf Transition & \\bf Biological meaning \\\\ \\hline" + this.newline);
            bw.write("\\endhead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Transition & \\bf Biological meaning & \\bf Transition & \\bf Biological meaning \\\\ \\hline" + this.newline);
            for (i2 = 0; i2 < trans1Col.size(); ++i2) {
                bw.write((String)trans1Col.get(i2) + (String)trans2Col.get(i2) + this.newline);
            }
            bw.write("\\end{longtable}" + this.newline);
            bw.write("}" + this.newline);
            bw.write(this.newline);
            bw.close();
            ArrayList<String> placesNames = new ArrayList<String>();
            for (int i4 = 0; i4 < places.size(); ++i4) {
                placesNames.add(places.get(i4).getName());
                places.get(i4).setName("p" + i4);
            }
            ArrayList<String> transitionsNames = new ArrayList<String>();
            for (int i5 = 0; i5 < transitions.size(); ++i5) {
                transitionsNames.add(transitions.get(i5).getName());
                transitions.get(i5).setName("t" + i5);
            }
            SnoopyWriter sw = new SnoopyWriter();
            String path = Tools.getFilePath(new File((String)selectedFile));
            sw.writeSPPED(path + "net.spped");
            for (i = 0; i < places.size(); ++i) {
                places.get(i).setName((String)placesNames.get(i));
            }
            for (i = 0; i < transitions.size(); ++i) {
                transitions.get(i).setName((String)transitionsNames.get(i));
            }
        }
        catch (Exception e) {
            Object msg = lang.getText("LOGentry00211exception") + " " + (String)selectedFile;
            overlord.log((String)msg, "error", true);
            msg = ((String)msg).replace(": ", ":\n");
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry002"), 0);
        }
    }

    public void writeInvariants() {
        String mctFile = this.invMCTSubroutines();
        if (mctFile == null) {
            String msg = lang.getText("LOGentry00212");
            overlord.log(msg, "error", true);
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry003"), 0);
            return;
        }
        ArrayList invariantsTable = new ArrayList();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(mctFile));
            while ((line = br.readLine()) != null && !line.contains("Invariants[IN MCT]")) {
            }
            line = br.readLine();
            while ((line = br.readLine()) != null && !line.isEmpty()) {
                ArrayList<Object> invTableRow = new ArrayList<Object>();
                line = line.replace(" ", "");
                String[] cells = line.split("[;\\t]");
                invTableRow.add("$x_{" + cells[0].replace(".", "") + "}$");
                if (cells[1].length() > 2) {
                    String[] mctSet = cells[1].replace("]", "").replace("[", "").split(",");
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int mct = 0; mct < mctSet.length; ++mct) {
                        stringBuilder.append("$m_{");
                        stringBuilder.append(mctSet[mct].replace("m", ""));
                        stringBuilder.append("}$");
                        if (mct + 1 >= mctSet.length) continue;
                        stringBuilder.append(",");
                    }
                    invTableRow.add(stringBuilder.toString());
                } else {
                    invTableRow.add("");
                }
                if (cells[2].length() > 2) {
                    String[] transSet = cells[2].split(",");
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int tr = 0; tr < transSet.length; ++tr) {
                        stringBuilder.append("$t_{");
                        stringBuilder.append(transSet[tr].replace("t", ""));
                        stringBuilder.append("}$");
                        if (tr + 1 >= transSet.length) continue;
                        stringBuilder.append(", ");
                    }
                    invTableRow.add(String.valueOf(stringBuilder) + " \\\\ \\hline");
                } else {
                    invTableRow.add(" \\\\ \\hline");
                }
                invariantsTable.add(invTableRow);
            }
            br.close();
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00213exception") + " " + mctFile, "error", true);
        }
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Normal Text File (.txt)", new String[]{"TXT"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("save"), "", "");
        if (((String)selectedFile).isEmpty()) {
            return;
        }
        if (!((String)selectedFile).contains(".txt")) {
            selectedFile = (String)selectedFile + ".txt";
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
            bw.write("{\\footnotesize" + this.newline);
            bw.write("\\begin{longtable}{| p{1.2cm} | p{4.5cm} | p{5cm}|}" + this.newline);
            bw.write("\\caption{List of invariants} \\label{tab:invariants} \\\\" + this.newline);
            bw.write("\\endfirsthead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Invariant & \\bf MCT & \\bf Contained transitions \\\\  \\hline " + this.newline);
            bw.write("\\endhead" + this.newline);
            bw.write("\\hline " + this.newline);
            bw.write("\\bf Invariant & \\bf MCT & \\bf Contained transitions  \\\\  \\hline " + this.newline);
            for (ArrayList arrayList : invariantsTable) {
                bw.write((String)arrayList.get(0) + " & " + (String)arrayList.get(1) + " & " + (String)arrayList.get(2) + this.newline);
            }
            bw.write("\\end{longtable}" + this.newline);
            bw.write("}" + this.newline);
            bw.write(this.newline);
            bw.close();
        }
        catch (Exception e) {
            Object msg = lang.getText("LOGentry00214") + " " + (String)selectedFile;
            overlord.log((String)msg, "error", true);
            msg = ((String)msg).replace(": ", ":\n");
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry002"), 0);
        }
    }

    private String invMCTSubroutines() {
        String filePath = overlord.getTmpPath() + "input.csv";
        int result = overlord.getWorkspace().getProject().saveInvariantsToCSV(filePath, true, true);
        if (result == -1) {
            String msg = lang.getText("LOGentry00215");
            overlord.log(msg, "error", true);
            return null;
        }
        try {
            overlord.log(lang.getText("LOGentry00216"), "text", true);
            Runner mctRunner = new Runner();
            String[] args = new String[]{filePath};
            mctRunner.activate(args);
            File csvFile = new File(filePath);
            String path = Tools.getFilePath(csvFile);
            csvFile.delete();
            overlord.log(lang.getText("LOGentry00217") + " " + path + "input.csv.analysed.txt", "text", true);
            return path + "input.csv.analysed.txt";
        }
        catch (IOException e) {
            overlord.log(lang.getText("LOGentry00218exception") + "\n" + e.getMessage(), "error", true);
            return null;
        }
    }

    public void writeMCT() {
        int i;
        MCTCalculator analyzer = overlord.getWorkspace().getProject().getMCTanalyzer();
        ArrayList<ArrayList<Transition>> mctSet = analyzer.generateMCT();
        if (mctSet == null) {
            overlord.log(lang.getText("LOGentry00219"), "error", true);
            return;
        }
        if (mctSet.isEmpty()) {
            String msg = lang.getText("LOGentry00220");
            overlord.log(msg, "error", true);
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry004"), 0);
            return;
        }
        for (i = 0; i < mctSet.size(); ++i) {
            ArrayList<Transition> arrayList = mctSet.get(i);
            if (arrayList.size() != 1) continue;
            mctSet.set(i, null);
        }
        for (i = 0; i < mctSet.size(); ++i) {
            ArrayList<Transition> arrayList = mctSet.get(i);
            if (arrayList != null) continue;
            mctSet.remove(i);
            --i;
        }
        Object[] temp = mctSet.toArray();
        Arrays.sort(temp, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                ArrayList temp1 = (ArrayList)o1;
                ArrayList temp2 = (ArrayList)o2;
                if (temp1.size() > temp2.size()) {
                    return -1;
                }
                if (temp1.size() == temp2.size()) {
                    return 0;
                }
                return 1;
            }
        });
        mctSet.clear();
        for (Object o : temp) {
            mctSet.add((ArrayList)o);
        }
        String string = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Normal Text File (.txt)", new String[]{"TXT"})};
        Object selectedFile = Tools.selectFileDialog(string, filters, lang.getText("save"), "", "");
        if (((String)selectedFile).isEmpty()) {
            return;
        }
        if (!((String)selectedFile).contains(".txt")) {
            selectedFile = (String)selectedFile + ".txt";
        }
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
            bw.write("{\\footnotesize" + this.newline);
            bw.write("\\begin{longtable}{| p{1.2cm} | p{5.2cm} | p{7.5cm} |}" + this.newline);
            bw.write("\\caption{List of non-trivial MCT sets} \\label{tab:mct} \\\\" + this.newline);
            bw.write("\\endfirsthead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf MCT-set & \\bf Contained transitions & \\bf Biological interpretation  \\\\  \\hline " + this.newline);
            bw.write("\\endhead" + this.newline);
            bw.write("\\hline " + this.newline);
            bw.write("\\bf MCT-set & \\bf Contained transitions & \\bf Biological meaning  \\\\  \\hline " + this.newline);
            for (int i2 = 0; i2 < mctSet.size(); ++i2) {
                String mctNo = "$m_{" + (i2 + 1) + "}$";
                StringBuilder transLine = new StringBuilder();
                for (int t = 0; t < mctSet.get(i2).size(); ++t) {
                    transLine.append(" $t_{");
                    Transition trNumber = mctSet.get(i2).get(t);
                    int trID = transitions.lastIndexOf(trNumber);
                    transLine.append(trID);
                    transLine.append("}$");
                    if (t + 1 >= mctSet.get(i2).size()) continue;
                    transLine.append(",");
                }
                bw.write(mctNo + " & " + String.valueOf(transLine) + " & \\\\ \\hline " + this.newline);
            }
            bw.write("\\end{longtable}" + this.newline);
            bw.write("}" + this.newline);
            bw.write(this.newline);
            bw.close();
        }
        catch (Exception e) {
            Object msg = lang.getText("LOGentry00221") + " " + (String)selectedFile;
            overlord.log((String)msg, "error", true);
            msg = ((String)msg).replace(": ", ":\n");
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry002"), 0);
        }
    }

    public void writeCluster(ClusteringExtended data) {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Normal Text File (.txt)", new String[]{"TXT"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("save"), "", "");
        if (((String)selectedFile).isEmpty()) {
            return;
        }
        if (!((String)selectedFile).contains(".txt")) {
            selectedFile = (String)selectedFile + ".txt";
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
            bw.write("{\\footnotesize" + this.newline);
            bw.write("\\begin{longtable}{| p{0.8cm} | p{1.2cm} |  p{4.8cm} | p{8.0cm} |}" + this.newline);
            bw.write("\\caption{Clusters composition} \\label{tab:clusterExt} \\\\" + this.newline);
            bw.write("\\endfirsthead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Clust. & \\bf Invariant & \\bf MCTs: & \\bf No-MCT Transitions:  \\\\  \\hline " + this.newline);
            bw.write("\\endhead" + this.newline);
            bw.write("\\hline " + this.newline);
            bw.write("\\bf Clust. & \\bf Invariant & \\bf MCTs: & \\bf No-MCT Transitions:  \\\\  \\hline " + this.newline);
            for (int cl = 0; cl < data.metaData.clusterNumber; ++cl) {
                String clCell = "$c_{" + (cl + 1) + "}$ & ";
                StringBuilder line = new StringBuilder();
                for (int inv = 0; inv < data.clustersInv.get(cl).size(); ++inv) {
                    line = new StringBuilder();
                    int invNumber = data.clustersInv.get(cl).get(inv);
                    ArrayList<String> invArray = data.getNormalizedInvariant(invNumber, true);
                    line.append("$x_{").append(invNumber + 1).append("}$ & ");
                    String mctLine = invArray.get(1);
                    mctLine = mctLine.replace("[", "");
                    mctLine = mctLine.replace("]", "");
                    if (!mctLine.isEmpty()) {
                        String[] mctVector;
                        for (String mctTmp : mctVector = mctLine.split(",")) {
                            line.append("$m_{").append(mctTmp).append("}$,");
                        }
                    }
                    line.append("&");
                    line = new StringBuilder(line.toString().replace(",&", " & "));
                    for (int i = 2; i < invArray.size(); ++i) {
                        String t = invArray.get(i);
                        line.append("$t_{").append(t).append("}$, ");
                    }
                    line.append("\\\\ \\hline ");
                    line = new StringBuilder(line.toString().replace(", \\\\", " \\\\"));
                    if (inv == 0) {
                        bw.write(clCell + String.valueOf(line) + this.newline);
                        continue;
                    }
                    bw.write("      & " + String.valueOf(line) + this.newline);
                }
            }
            bw.write("\\end{longtable}" + this.newline);
            bw.write("}" + this.newline);
            bw.write(this.newline);
            bw.close();
        }
        catch (Exception e) {
            Object msg = lang.getText("LOGentry00222") + " " + (String)selectedFile;
            overlord.log((String)msg, "error", true);
            msg = ((String)msg).replace(": ", ":\n");
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry002"), 0);
        }
    }

    public void writeClusterExt(ClusteringExtended data) {
        ArrayList clustersMCT = new ArrayList();
        ArrayList clustersTransitions = new ArrayList();
        for (int cl = 0; cl < data.metaData.clusterNumber; ++cl) {
            int tmp;
            ArrayList<Integer> mctRow = new ArrayList<Integer>();
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (tmp = 0; tmp < data.mctSets.size(); ++tmp) {
                mctRow.add(0);
            }
            for (tmp = 0; tmp < data.transNames.length - 1; ++tmp) {
                transRow.add(0);
            }
            for (int inv = 0; inv < data.clustersInv.get(cl).size(); ++inv) {
                int invNo = data.clustersInv.get(cl).get(inv);
                ArrayList<String> invArray = data.getNormalizedInvariant(invNo, true);
                String mctLine = invArray.get(1);
                mctLine = mctLine.replace("[", "");
                if (!(mctLine = mctLine.replace("]", "")).isEmpty()) {
                    String[] mctVector;
                    for (String s : mctVector = mctLine.split(",")) {
                        try {
                            int mctNumber = Integer.parseInt(s);
                            int oldValue = (Integer)mctRow.get(mctNumber);
                            mctRow.set(mctNumber, ++oldValue);
                        }
                        catch (Exception ex) {
                            overlord.log(lang.getText("LOGentry00223exception") + "\n" + ex.getMessage(), "error", true);
                        }
                    }
                }
                for (int i = 2; i < invArray.size(); ++i) {
                    try {
                        int tranNumber = Integer.parseInt(invArray.get(i));
                        int oldValue = (Integer)mctRow.get(tranNumber);
                        transRow.set(tranNumber, ++oldValue);
                        continue;
                    }
                    catch (Exception ex) {
                        overlord.log(lang.getText("LOGentry00224exception") + "\n" + ex.getMessage(), "error", true);
                    }
                }
            }
            clustersMCT.add(mctRow);
            clustersTransitions.add(transRow);
        }
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Normal Text File (.txt)", new String[]{"TXT"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("save"), "", "");
        if (((String)selectedFile).isEmpty()) {
            return;
        }
        if (!((String)selectedFile).contains(".txt")) {
            selectedFile = (String)selectedFile + ".txt";
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
            bw.write("{\\footnotesize" + this.newline);
            bw.write("\\begin{longtable}{| p{1.2cm} | p{4.2cm} | p{7.5cm} |}" + this.newline);
            bw.write("\\caption{Clusters composition} \\label{tab:clusterExt} \\\\" + this.newline);
            bw.write("\\endfirsthead" + this.newline);
            bw.write("\\hline" + this.newline);
            bw.write("\\bf Cluster no & \\bf Contained MCT & \\bf Contained transitions  \\\\  \\hline " + this.newline);
            bw.write("\\endhead" + this.newline);
            bw.write("\\hline " + this.newline);
            bw.write("\\bf Cluster no & \\bf Contained MCT & \\bf Contained transitions  \\\\  \\hline " + this.newline);
            for (int cl = 0; cl < data.metaData.clusterNumber; ++cl) {
                StringBuilder line = new StringBuilder("$c_{" + (cl + 1) + "$ & ");
                for (int mct = 0; mct < ((ArrayList)clustersMCT.get(cl)).size(); ++mct) {
                    int number = (Integer)((ArrayList)clustersMCT.get(cl)).get(mct);
                    if (number <= 0) continue;
                    line.append("$m_{").append(mct + 1).append("$, ");
                }
                line.append("&");
                line = new StringBuilder(line.toString().replace(", &", " &"));
            }
            bw.write("\\end{longtable}" + this.newline);
            bw.write("}" + this.newline);
            bw.write(this.newline);
            bw.close();
        }
        catch (Exception e) {
            Object msg = lang.getText("LOGentry00225") + " " + (String)selectedFile;
            overlord.log((String)msg, "error", true);
            msg = ((String)msg).replace(": ", ":\n");
            JOptionPane.showMessageDialog(overlord, msg, lang.getText("TEX_entry002"), 0);
        }
    }
}

