/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNdataVector;
import holmes.petrinet.data.SPNtransitionData;
import holmes.petrinet.data.SSAplacesVector;
import holmes.petrinet.data.StatePlacesVector;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.functions.FunctionContainer;
import holmes.utilities.Tools;
import holmes.varia.Check;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ProjectWriter {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private final PetriNet projectCore = overlord.getWorkspace().getProject();
    private final ArrayList<Place> places = this.projectCore.getPlaces();
    private final ArrayList<Transition> transitions = this.projectCore.getTransitions();
    private final ArrayList<MetaNode> metaNodes = this.projectCore.getMetaNodes();
    private final ArrayList<Arc> arcs = this.projectCore.getArcs();
    private final ArrayList<ArrayList<Integer>> t_invariantsMatrix = this.projectCore.getT_InvMatrix();
    private final ArrayList<String> t_invariantsNames = this.projectCore.accessT_InvDescriptions();
    private final ArrayList<ArrayList<Integer>> p_invariantsMatrix = this.projectCore.getP_InvMatrix();
    private final ArrayList<String> p_invariantsNames = this.projectCore.accessP_InvDescriptions();
    private final ArrayList<ArrayList<Transition>> mctData = this.projectCore.getMCTMatrix();
    private final ArrayList<String> mctNames = this.projectCore.accessMCTnames();
    private final ArrayList<StatePlacesVector> statesMatrix = this.projectCore.accessStatesManager().accessStateMatrix();
    private final ArrayList<MultisetM> statesMatrixXTPN = this.projectCore.accessStatesManager().accessStateMatrixXTPN();
    private final ArrayList<SPNdataVector> firingRatesMatrix = this.projectCore.accessFiringRatesManager().accessSPNmatrix();
    private final ArrayList<SSAplacesVector> ssaMatrix = this.projectCore.accessSSAmanager().accessSSAmatrix();
    private final String newline = "\n";
    private boolean XTPNdataMode = false;

    public boolean writeProject(String filepath) {
        for (Transition trans : this.transitions) {
            trans.fpnExtension.checkFunctions(this.arcs, this.places);
        }
        try {
            if (this.projectCore.getProjectType() == PetriNet.GlobalNetType.XTPN) {
                this.XTPNdataMode = true;
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(filepath));
            String projName = this.projectCore.getName();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            bw.write("Project name: " + projName + "\n");
            bw.write("Date: " + dateFormat.format(date) + "\n");
            bw.write("Net type: " + String.valueOf((Object)this.projectCore.getProjectType()) + "\n");
            bw.write("<Project blocks>\n");
            bw.write("  <Subnets>\n");
            bw.write("  <InvariantsData>\n");
            bw.write("  <PlaceInvData>\n");
            bw.write("  <MCT data>\n");
            bw.write("  <StatesMatrix>\n");
            if (this.XTPNdataMode) {
                bw.write("  <StatesXTPNMatrix>\n");
            }
            bw.write("  <FunctionsData>\n");
            bw.write("  <FiringRatesData>\n");
            bw.write("  <SSAmatrix>\n");
            bw.write("</Project blocks>\n");
            bw.write("<Net data>\n");
            bw.write("<ID generator state:" + IdGenerator.getCurrentValues() + ">\n");
            boolean statusNet = this.saveNetwork(bw);
            bw.write("<Net data end>\n");
            bw.write("<Invariants data>\n");
            boolean statusInv = this.saveT_Invariants(bw);
            bw.write("<Invariants data end>\n");
            bw.write("<PlaceInv data>\n");
            boolean statusPInv = this.saveP_Invariants(bw);
            bw.write("<PlaceInv data end>\n");
            bw.write("<MCT data>\n");
            boolean statusMCT = this.saveMCT(bw);
            bw.write("<MCT data end>\n");
            bw.write("<States data>\n");
            boolean statusStates = this.saveStates(bw);
            bw.write("<States data end>\n");
            boolean statusXTPNStates = false;
            if (this.XTPNdataMode) {
                bw.write("<States XTPN data>\n");
                statusXTPNStates = this.saveStatesXTPN(bw);
                bw.write("<States XTPN data end>\n");
            }
            bw.write("<Firing rates data>\n");
            boolean statusFR = this.saveFiringRates(bw);
            bw.write("<Firing rates data end>\n");
            bw.write("<SSA vectors data>\n");
            boolean statusSSA = this.saveSSAvectors(bw);
            bw.write("<SSA vectors data end>\n");
            overlord.log("*******************************************************", "text", true);
            overlord.log(lang.getText("PW_entry001") + " " + statusNet, "text", true);
            overlord.log(lang.getText("PW_entry002") + " " + statusInv, "text", true);
            overlord.log(lang.getText("PW_entry003") + " " + statusPInv, "text", true);
            overlord.log(lang.getText("PW_entry004") + " " + statusMCT, "text", true);
            overlord.log(lang.getText("PW_entry005") + " " + statusStates, "text", true);
            overlord.log(lang.getText("PW_entry006") + " " + statusXTPNStates, "text", true);
            overlord.log(lang.getText("PW_entry007") + " " + statusFR, "text", true);
            overlord.log(lang.getText("PW_entry008") + " " + statusSSA, "text", true);
            overlord.log("*******************************************************", "text", true);
            bw.close();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00226exception") + "\n" + e.getMessage(), "text", true);
            return false;
        }
    }

    private boolean saveNetwork(BufferedWriter bw) {
        try {
            Place endPlace;
            MetaNode endMetanode;
            String coloredWeights;
            boolean isColored;
            StringBuilder brokenLine;
            int weight;
            String endLoc;
            int endNodeLocationIndex;
            ElementLocation endNodeLocation;
            int endNodeIndex;
            Transition endTransition;
            String startLoc;
            Node endNode;
            Object arcType;
            int sp = 2;
            int placesNumber = this.places.size();
            bw.write(this.spaces(sp) + "<Places: " + placesNumber + ">\n");
            for (int p = 0; p < placesNumber; ++p) {
                sp = 4;
                Place place = this.places.get(p);
                bw.write(this.spaces(sp) + "<Place: " + p + ">\n");
                sp = 6;
                bw.write(this.spaces(sp) + "<Place gID:" + place.getID() + ">\n");
                bw.write(this.spaces(sp) + "<Place name:" + place.getName() + ">\n");
                bw.write(this.spaces(sp) + "<Place comment:" + Tools.convertToCode(place.getComment()) + ">\n");
                bw.write(this.spaces(sp) + "<Place tokens:" + place.getTokensNumber() + ">\n");
                bw.write(this.spaces(sp) + "<Place SSAvalue:" + place.getSSAvalue() + ">\n");
                bw.write(this.spaces(sp) + "<Place SSAconcStatus:" + place.isSSAconcentration() + ">\n");
                if (this.XTPNdataMode) {
                    bw.write(this.spaces(sp) + "<Place XTPN gammaMode:" + ((PlaceXTPN)place).isGammaModeActive() + ">\n");
                    bw.write(this.spaces(sp) + "<Place XTPN gammaVisible:" + ((PlaceXTPN)place).isGammaRangeVisible() + ">\n");
                    bw.write(this.spaces(sp) + "<Place XTPN gammaMin:" + ((PlaceXTPN)place).getGammaMinValue() + ">\n");
                    bw.write(this.spaces(sp) + "<Place XTPN gammaMax:" + ((PlaceXTPN)place).getGammaMaxValue() + ">\n");
                    bw.write(this.spaces(sp) + "<Place XTPN fractionSize:" + ((PlaceXTPN)place).getFractionForPlaceXTPN() + ">\n");
                    bw.write(this.spaces(sp) + "<Place XTPN multiset");
                    for (int token = 0; token < ((PlaceXTPN)place).accessMultiset().size(); ++token) {
                        bw.write(":" + String.valueOf(((PlaceXTPN)place).accessMultiset().get(token)));
                    }
                    bw.write(">\n");
                }
                bw.write(this.spaces(sp) + "<Place colored:" + place.isColored + ">\n");
                if (place instanceof PlaceColored) {
                    bw.write(this.spaces(sp) + "<Place colors:" + ((PlaceColored)place).getColorTokensNumber(0) + ";" + ((PlaceColored)place).getColorTokensNumber(1) + ";" + ((PlaceColored)place).getColorTokensNumber(2) + ";" + ((PlaceColored)place).getColorTokensNumber(3) + ";" + ((PlaceColored)place).getColorTokensNumber(4) + ";" + ((PlaceColored)place).getColorTokensNumber(5) + ">\n");
                }
                bw.write(this.spaces(sp) + "<Location data>\n");
                sp = 8;
                bw.write(this.spaces(sp) + "<Place portal status:" + place.isPortal() + ">\n");
                int elLocations = place.getElementLocations().size();
                bw.write(this.spaces(sp) + "<Place locations:" + elLocations + ">\n");
                for (int e = 0; e < elLocations; ++e) {
                    sp = 10;
                    ElementLocation eLoc = place.getElementLocations().get(e);
                    int sheetId = eLoc.getSheetID();
                    int pointX = eLoc.getPosition().x;
                    int pointY = eLoc.getPosition().y;
                    bw.write(this.spaces(sp) + "<Place location data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    ElementLocation nameLoc = place.getTextsLocations(GUIManager.locationMoveType.NAME).get(e);
                    sheetId = nameLoc.getSheetID();
                    pointX = nameLoc.getPosition().x;
                    pointY = nameLoc.getPosition().y;
                    bw.write(this.spaces(sp) + "<Place name offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    if (!this.XTPNdataMode) continue;
                    try {
                        ElementLocation gammaLoc = place.getTextsLocations(GUIManager.locationMoveType.GAMMA).get(e);
                        sheetId = gammaLoc.getSheetID();
                        pointX = gammaLoc.getPosition().x;
                        pointY = gammaLoc.getPosition().y;
                        bw.write(this.spaces(sp) + "<Place gamma offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                        continue;
                    }
                    catch (Exception exc) {
                        overlord.log(lang.getText("LOGentry00227exception_1") + " " + place.getName() + " " + lang.getText("LOGentry00227exception_2"), "error", true);
                    }
                }
                sp = 6;
                bw.write(this.spaces(sp) + "<Location data block end>\n");
                sp = 4;
                bw.write(this.spaces(sp) + "<EOP>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<Places data block end>\n");
            int transNumber = this.transitions.size();
            bw.write(this.spaces(sp) + "<Transitions: " + transNumber + ">\n");
            for (int t = 0; t < transNumber; ++t) {
                sp = 4;
                Transition trans = this.transitions.get(t);
                bw.write(this.spaces(sp) + "<Transition: " + t + ">\n");
                sp = 6;
                bw.write(this.spaces(sp) + "<Transition gID:" + trans.getID() + ">\n");
                bw.write(this.spaces(sp) + "<Transition type:" + String.valueOf((Object)trans.getTransType()) + ">\n");
                bw.write(this.spaces(sp) + "<Transition name:" + trans.getName() + ">\n");
                bw.write(this.spaces(sp) + "<Transition comment:" + Tools.convertToCode(trans.getComment()) + ">\n");
                bw.write(this.spaces(sp) + "<Transition eft:" + trans.timeExtension.getEFT() + ">\n");
                bw.write(this.spaces(sp) + "<Transition lft:" + trans.timeExtension.getLFT() + ">\n");
                bw.write(this.spaces(sp) + "<Transition duration:" + trans.timeExtension.getDPNduration() + ">\n");
                bw.write(this.spaces(sp) + "<Transition TPN status:" + trans.timeExtension.isTPN() + ">\n");
                bw.write(this.spaces(sp) + "<Transition DPN status:" + trans.timeExtension.isDPN() + ">\n");
                bw.write(this.spaces(sp) + "<Transition function flag:" + trans.fpnExtension.isFunctional() + ">\n");
                if (this.XTPNdataMode) {
                    bw.write(this.spaces(sp) + "<Transition XTPN alphaMode:" + ((TransitionXTPN)trans).isAlphaModeActive() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN alphaVisible:" + ((TransitionXTPN)trans).isAlphaRangeVisible() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN alphaMin:" + ((TransitionXTPN)trans).getAlphaMinValue() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN alphaMax:" + ((TransitionXTPN)trans).getAlphaMaxValue() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN betaMode:" + ((TransitionXTPN)trans).isBetaModeActive() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN betaVisible:" + ((TransitionXTPN)trans).isBetaRangeVisible() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN betaMin:" + ((TransitionXTPN)trans).getBetaMinValue() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN betaMax:" + ((TransitionXTPN)trans).getBetaMaxValue() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN tauVisible:" + ((TransitionXTPN)trans).isTauTimerVisible() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN massAction:" + ((TransitionXTPN)trans).isMassActionKineticsActiveXTPN() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN fractionSize:" + ((TransitionXTPN)trans).getFraction_xTPN() + ">\n");
                    bw.write(this.spaces(sp) + "<Transition XTPN immediate:" + ((TransitionXTPN)trans).isImmediateXTPN() + ">\n");
                }
                bw.write(this.spaces(sp) + "<Transition colored:" + trans.isColored() + ">\n");
                if (trans instanceof TransitionColored) {
                    bw.write(this.spaces(sp) + "<Transition colors threshold:" + ((TransitionColored)trans).getRequiredColoredTokens(0) + ";" + ((TransitionColored)trans).getRequiredColoredTokens(1) + ";" + ((TransitionColored)trans).getRequiredColoredTokens(2) + ";" + ((TransitionColored)trans).getRequiredColoredTokens(3) + ";" + ((TransitionColored)trans).getRequiredColoredTokens(4) + ";" + ((TransitionColored)trans).getRequiredColoredTokens(5) + ">\n");
                }
                bw.write(this.spaces(sp) + "<Location data>\n");
                sp = 8;
                bw.write(this.spaces(sp) + "<Transition portal status:" + trans.isPortal() + ">\n");
                int elLocations = trans.getElementLocations().size();
                bw.write(this.spaces(sp) + "<Transition locations:" + elLocations + ">\n");
                for (int e = 0; e < elLocations; ++e) {
                    ElementLocation betaLoc;
                    sp = 10;
                    ElementLocation eLoc = trans.getElementLocations().get(e);
                    int sheetId = eLoc.getSheetID();
                    int pointX = eLoc.getPosition().x;
                    int pointY = eLoc.getPosition().y;
                    bw.write(this.spaces(sp) + "<Transition location data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    ElementLocation nameLoc = trans.getTextsLocations(GUIManager.locationMoveType.NAME).get(e);
                    sheetId = nameLoc.getSheetID();
                    pointX = nameLoc.getPosition().x;
                    pointY = nameLoc.getPosition().y;
                    bw.write(this.spaces(sp) + "<Transition name offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    if (!this.XTPNdataMode) continue;
                    try {
                        ElementLocation alphaLoc = trans.getTextsLocations(GUIManager.locationMoveType.ALPHA).get(e);
                        sheetId = alphaLoc.getSheetID();
                        pointX = alphaLoc.getPosition().x;
                        pointY = alphaLoc.getPosition().y;
                        bw.write(this.spaces(sp) + "<Transition alpha offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    }
                    catch (Exception exc) {
                        overlord.log(lang.getText("LOGentry00228exception_1") + " " + trans.getName() + " " + lang.getText("LOGentry00228exception_2"), "error", true);
                    }
                    try {
                        betaLoc = trans.getTextsLocations(GUIManager.locationMoveType.BETA).get(e);
                        sheetId = betaLoc.getSheetID();
                        pointX = betaLoc.getPosition().x;
                        pointY = betaLoc.getPosition().y;
                        bw.write(this.spaces(sp) + "<Transition beta offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    }
                    catch (Exception exc) {
                        overlord.log(lang.getText("LOGentry00229exception_1") + " " + trans.getName() + lang.getText("LOGentry00229exception_2"), "error", true);
                    }
                    try {
                        betaLoc = trans.getTextsLocations(GUIManager.locationMoveType.TAU).get(e);
                        sheetId = betaLoc.getSheetID();
                        pointX = betaLoc.getPosition().x;
                        pointY = betaLoc.getPosition().y;
                        bw.write(this.spaces(sp) + "<Transition tau offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                        continue;
                    }
                    catch (Exception exc) {
                        overlord.log(lang.getText("LOGentry00230exception_1") + " " + trans.getName() + " " + lang.getText("LOGentry00230exception_2"), "error", true);
                    }
                }
                sp = 6;
                bw.write(this.spaces(sp) + "<Location data block end>\n");
                sp = 4;
                bw.write(this.spaces(sp) + "<EOT>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<Transitions data block end>\n");
            int metaNumber = this.metaNodes.size();
            bw.write(this.spaces(sp) + "<MetaNodes: " + metaNumber + ">\n");
            for (int t = 0; t < metaNumber; ++t) {
                sp = 4;
                MetaNode metanode = this.metaNodes.get(t);
                bw.write(this.spaces(sp) + "<MetaNode: " + t + ">\n");
                sp = 6;
                bw.write(this.spaces(sp) + "<MetaNode gID:" + metanode.getID() + ">\n");
                bw.write(this.spaces(sp) + "<MetaNode type:" + String.valueOf((Object)metanode.getMetaType()) + ">\n");
                bw.write(this.spaces(sp) + "<MetaNode name:" + metanode.getName() + ">\n");
                bw.write(this.spaces(sp) + "<MetaNode comment:" + Tools.convertToCode(metanode.getComment()) + ">\n");
                bw.write(this.spaces(sp) + "<MetaNode representedSheet:" + metanode.getRepresentedSheetID() + ">\n");
                bw.write(this.spaces(sp) + "<Location data>\n");
                sp = 8;
                int elLocations = metanode.getElementLocations().size();
                bw.write(this.spaces(sp) + "<MetaNode locations:" + elLocations + ">\n");
                for (int e = 0; e < elLocations; ++e) {
                    sp = 10;
                    ElementLocation eLoc = metanode.getElementLocations().get(e);
                    int sheetId = eLoc.getSheetID();
                    int pointX = eLoc.getPosition().x;
                    int pointY = eLoc.getPosition().y;
                    bw.write(this.spaces(sp) + "<MetaNode location data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                    ElementLocation nameLoc = metanode.getTextsLocations(GUIManager.locationMoveType.NAME).get(e);
                    sheetId = nameLoc.getSheetID();
                    pointX = nameLoc.getPosition().x;
                    pointY = nameLoc.getPosition().y;
                    bw.write(this.spaces(sp) + "<MetaNode name offset data sheet/x/y/elIndex:" + sheetId + ";" + pointX + ";" + pointY + ";" + e + ">\n");
                }
                sp = 6;
                bw.write(this.spaces(sp) + "<Location data block end>\n");
                sp = 4;
                bw.write(this.spaces(sp) + "<EOT>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<MetaNodes data block end>\n");
            int savedArcs = 0;
            bw.write(this.spaces(sp) + "<Arcs data block>\n");
            sp = 4;
            for (int p = 0; p < placesNumber; ++p) {
                Place place = this.places.get(p);
                int elLocations = place.getElementLocations().size();
                for (int e = 0; e < elLocations; ++e) {
                    ElementLocation eLoc = place.getElementLocations().get(e);
                    ArrayList<Arc> tmp_outgoingArcs = new ArrayList<Arc>(eLoc.getOutArcs());
                    ArrayList<Arc> metaOutArcs = eLoc.accessMetaOutArcs();
                    tmp_outgoingArcs.addAll(metaOutArcs);
                    for (Arc arc : tmp_outgoingArcs) {
                        arcType = String.valueOf((Object)arc.getArcType());
                        if (arc.arcXTPNbox.isXTPN()) {
                            arcType = "XTPN";
                        }
                        if (arc.arcXTPNbox.isXTPNinhibitor()) {
                            arcType = "XINH";
                        }
                        if ((endNode = arc.getEndNode()) instanceof Transition) {
                            startLoc = "P" + p + "(" + e + ")";
                            endTransition = (Transition)endNode;
                            endNodeIndex = this.transitions.indexOf(endTransition);
                            endNodeLocation = arc.getEndLocation();
                            endNodeLocationIndex = -1;
                            for (int e2 = 0; e2 < endTransition.getElementLocations().size(); ++e2) {
                                if (endNodeLocation != endTransition.getElementLocations().get(e2)) continue;
                                endNodeLocationIndex = e2;
                                break;
                            }
                            endLoc = "T" + endNodeIndex + "(" + endNodeLocationIndex + ")";
                            weight = arc.getWeight();
                            brokenLine = new StringBuilder();
                            if (!arc.accessBreaks().isEmpty()) {
                                brokenLine.append(";");
                                for (Point point : arc.accessBreaks()) {
                                    brokenLine.append(point.x);
                                    brokenLine.append("-");
                                    brokenLine.append(point.y);
                                    brokenLine.append("x");
                                }
                                brokenLine = new StringBuilder(brokenLine.substring(0, brokenLine.length() - 1));
                            } else {
                                brokenLine.append(";99999-11111");
                            }
                            isColored = arc.getArcType() == Arc.TypeOfArc.COLOR;
                            coloredWeights = arc.getColorWeight(0) + ":" + arc.getColorWeight(1) + ":" + arc.getColorWeight(2) + ":" + arc.getColorWeight(3) + ":" + arc.getColorWeight(4) + ":" + arc.getColorWeight(5);
                            if (isColored) {
                                bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">" + String.valueOf(brokenLine) + ";" + isColored + ";" + coloredWeights + "\n");
                            } else {
                                bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">" + String.valueOf(brokenLine) + "\n");
                            }
                            ++savedArcs;
                            continue;
                        }
                        if (!(endNode instanceof MetaNode)) continue;
                        startLoc = "P" + p + "(" + e + ")";
                        endMetanode = (MetaNode)endNode;
                        endNodeIndex = this.metaNodes.indexOf(endMetanode);
                        endNodeLocation = arc.getEndLocation();
                        endNodeLocationIndex = -1;
                        for (int e2 = 0; e2 < endMetanode.getElementLocations().size(); ++e2) {
                            if (endNodeLocation != endMetanode.getElementLocations().get(e2)) continue;
                            endNodeLocationIndex = e2;
                            break;
                        }
                        endLoc = "M" + endNodeIndex + "(" + endNodeLocationIndex + ")";
                        weight = arc.getWeight();
                        bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">\n");
                        ++savedArcs;
                    }
                }
            }
            for (int t = 0; t < transNumber; ++t) {
                Transition trans = this.transitions.get(t);
                int elLocations = trans.getElementLocations().size();
                for (int e = 0; e < elLocations; ++e) {
                    ElementLocation eLoc = trans.getElementLocations().get(e);
                    ArrayList<Arc> tmp_outgoingArcs = new ArrayList<Arc>(eLoc.getOutArcs());
                    ArrayList<Arc> metaOutArcs = eLoc.accessMetaOutArcs();
                    tmp_outgoingArcs.addAll(metaOutArcs);
                    for (Arc arc : tmp_outgoingArcs) {
                        arcType = String.valueOf((Object)arc.getArcType());
                        if (arc.arcXTPNbox.isXTPN()) {
                            arcType = "XTPN";
                        }
                        if ((endNode = arc.getEndNode()) instanceof Place) {
                            startLoc = "T" + t + "(" + e + ")";
                            endPlace = (Place)endNode;
                            endNodeIndex = this.places.indexOf(endPlace);
                            endNodeLocation = arc.getEndLocation();
                            endNodeLocationIndex = -1;
                            for (int e2 = 0; e2 < endPlace.getElementLocations().size(); ++e2) {
                                if (endNodeLocation != endPlace.getElementLocations().get(e2)) continue;
                                endNodeLocationIndex = e2;
                                break;
                            }
                            endLoc = "P" + endNodeIndex + "(" + endNodeLocationIndex + ")";
                            weight = arc.getWeight();
                            brokenLine = new StringBuilder();
                            if (!arc.accessBreaks().isEmpty()) {
                                brokenLine.append(";");
                                for (Point point : arc.accessBreaks()) {
                                    brokenLine.append(point.x);
                                    brokenLine.append("-");
                                    brokenLine.append(point.y);
                                    brokenLine.append("x");
                                }
                                brokenLine = new StringBuilder(brokenLine.substring(0, brokenLine.length() - 1));
                            } else {
                                brokenLine.append(";99999-11111");
                            }
                            isColored = arc.getArcType() == Arc.TypeOfArc.COLOR;
                            coloredWeights = arc.getColorWeight(0) + ":" + arc.getColorWeight(1) + ":" + arc.getColorWeight(2) + ":" + arc.getColorWeight(3) + ":" + arc.getColorWeight(4) + ":" + arc.getColorWeight(5);
                            if (isColored) {
                                bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">" + String.valueOf(brokenLine) + ";" + isColored + ";" + coloredWeights + "\n");
                            } else {
                                bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">" + String.valueOf(brokenLine) + "\n");
                            }
                            ++savedArcs;
                            continue;
                        }
                        if (!(endNode instanceof MetaNode)) continue;
                        startLoc = "T" + t + "(" + e + ")";
                        endMetanode = (MetaNode)endNode;
                        endNodeIndex = this.metaNodes.indexOf(endMetanode);
                        endNodeLocation = arc.getEndLocation();
                        endNodeLocationIndex = -1;
                        for (int e2 = 0; e2 < endMetanode.getElementLocations().size(); ++e2) {
                            if (endNodeLocation != endMetanode.getElementLocations().get(e2)) continue;
                            endNodeLocationIndex = e2;
                            break;
                        }
                        endLoc = "M" + endNodeIndex + "(" + endNodeLocationIndex + ")";
                        weight = arc.getWeight();
                        bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">\n");
                        ++savedArcs;
                    }
                }
            }
            for (int m = 0; m < metaNumber; ++m) {
                MetaNode metaNode = this.metaNodes.get(m);
                int elLocations = metaNode.getElementLocations().size();
                for (int e = 0; e < elLocations; ++e) {
                    ElementLocation eLoc = metaNode.getElementLocations().get(e);
                    ArrayList<Arc> tmp_outgoingArcs = new ArrayList<Arc>(eLoc.getOutArcs());
                    ArrayList<Arc> metaOutArcs = eLoc.accessMetaOutArcs();
                    tmp_outgoingArcs.addAll(metaOutArcs);
                    for (Arc arc : tmp_outgoingArcs) {
                        arcType = String.valueOf((Object)arc.getArcType());
                        endNode = arc.getEndNode();
                        if (endNode instanceof Place) {
                            startLoc = "M" + m + "(" + e + ")";
                            endPlace = (Place)endNode;
                            endNodeIndex = this.places.indexOf(endPlace);
                            endNodeLocation = arc.getEndLocation();
                            endNodeLocationIndex = -1;
                            for (int e2 = 0; e2 < endPlace.getElementLocations().size(); ++e2) {
                                if (endNodeLocation != endPlace.getElementLocations().get(e2)) continue;
                                endNodeLocationIndex = e2;
                                break;
                            }
                            endLoc = "P" + endNodeIndex + "(" + endNodeLocationIndex + ")";
                            weight = arc.getWeight();
                            bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">\n");
                            ++savedArcs;
                            continue;
                        }
                        if (!(endNode instanceof Transition)) continue;
                        startLoc = "M" + m + "(" + e + ")";
                        endTransition = (Transition)endNode;
                        endNodeIndex = this.transitions.indexOf(endTransition);
                        endNodeLocation = arc.getEndLocation();
                        endNodeLocationIndex = -1;
                        for (int e2 = 0; e2 < endTransition.getElementLocations().size(); ++e2) {
                            if (endNodeLocation != endTransition.getElementLocations().get(e2)) continue;
                            endNodeLocationIndex = e2;
                            break;
                        }
                        endLoc = "T" + endNodeIndex + "(" + endNodeLocationIndex + ")";
                        weight = arc.getWeight();
                        bw.write(this.spaces(sp) + "<Arc: " + (String)arcType + "; " + startLoc + " -> " + endLoc + "; " + weight + ">\n");
                        ++savedArcs;
                    }
                }
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<Arcs data block end>\n");
            ArrayList<Integer> arcClasses = Check.getArcClassCount();
            int readArcs = arcClasses.get(1) / 2;
            int doubleArc = arcClasses.get(5) / 2;
            int totalArcs = this.arcs.size();
            if (savedArcs != totalArcs) {
                overlord.log(lang.getText("LOGentry00231a") + " " + savedArcs + " " + lang.getText("LOGentry00231b") + " " + totalArcs + " " + lang.getText("LOGentry00231c"), "error", true);
            }
            bw.write(this.spaces(sp) + "<Functions data block>\n");
            sp = 4;
            for (int t = 0; t < this.transitions.size(); ++t) {
                Transition transition = this.transitions.get(t);
                ArrayList<FunctionContainer> fVector = transition.fpnExtension.accessFunctionsList();
                for (FunctionContainer fc : fVector) {
                    if (fc.simpleExpression.isEmpty()) continue;
                    bw.write(this.spaces(sp) + "<T" + t + ";" + fc.fID + ";" + fc.simpleExpression + ";" + fc.correct + ";" + fc.enabled + ">\n");
                }
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<Functions data block end>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00232exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveT_Invariants(BufferedWriter bw) {
        try {
            int i;
            if (this.t_invariantsMatrix == null) {
                bw.write(this.spaces(2) + "<Invariants: 0>\n");
                bw.write(this.spaces(2) + "<EOI>\n");
                return false;
            }
            int sp = 2;
            int invNumber = this.t_invariantsMatrix.size();
            if (invNumber == 0) {
                bw.write(this.spaces(2) + "<Invariants: 0>\n");
                bw.write(this.spaces(2) + "<EOI>\n");
                return false;
            }
            bw.write(this.spaces(sp) + "<Invariants: " + invNumber + ">\n");
            int invSize = this.t_invariantsMatrix.get(0).size();
            for (i = 0; i < invNumber; ++i) {
                sp = 4;
                ArrayList<Integer> invariant = this.t_invariantsMatrix.get(i);
                StringBuilder line = new StringBuilder(i + ";");
                for (int it = 0; it < invSize; ++it) {
                    line.append(invariant.get(it)).append(";");
                }
                line = new StringBuilder(line.substring(0, line.length() - 1));
                bw.write(this.spaces(sp) + String.valueOf(line) + "\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOI>\n");
            bw.write(this.spaces(sp) + "<Invariants names>\n");
            for (i = 0; i < invNumber; ++i) {
                sp = 4;
                bw.write(this.spaces(sp) + Tools.convertToCode(this.t_invariantsNames.get(i)) + "\n");
            }
            bw.write(this.spaces(2) + "<EOIN>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00233exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveP_Invariants(BufferedWriter bw) {
        try {
            int i;
            if (this.p_invariantsMatrix == null) {
                bw.write(this.spaces(2) + "<PInvariants: 0>\n");
                bw.write(this.spaces(2) + "<EOPI>\n");
                return false;
            }
            int sp = 2;
            int invNumber = this.p_invariantsMatrix.size();
            if (invNumber == 0) {
                bw.write(this.spaces(2) + "<PInvariants: 0>\n");
                bw.write(this.spaces(2) + "<EOPI>\n");
                return false;
            }
            bw.write(this.spaces(sp) + "<PInvariants: " + invNumber + ">\n");
            int invSize = this.p_invariantsMatrix.get(0).size();
            for (i = 0; i < invNumber; ++i) {
                sp = 4;
                ArrayList<Integer> invariant = this.p_invariantsMatrix.get(i);
                StringBuilder line = new StringBuilder(i + ";");
                for (int it = 0; it < invSize; ++it) {
                    line.append(invariant.get(it)).append(";");
                }
                line = new StringBuilder(line.substring(0, line.length() - 1));
                bw.write(this.spaces(sp) + String.valueOf(line) + "\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOPI>\n");
            bw.write(this.spaces(sp) + "<PInvariants names>\n");
            for (i = 0; i < invNumber; ++i) {
                sp = 4;
                bw.write(this.spaces(sp) + Tools.convertToCode(this.p_invariantsNames.get(i)) + "\n");
            }
            bw.write(this.spaces(2) + "<EOPIN>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00234exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveMCT(BufferedWriter bw) {
        try {
            if (this.mctData == null) {
                bw.write(this.spaces(2) + "<MCT: 0>\n");
                bw.write(this.spaces(2) + "<EOM>\n");
                return false;
            }
            int sp = 2;
            int mctNumber = this.mctData.size();
            if (mctNumber == 0) {
                bw.write(this.spaces(2) + "<MCT: 0>\n");
                bw.write(this.spaces(2) + "<EOM>\n");
                return false;
            }
            bw.write(this.spaces(sp) + "<MCT: " + mctNumber + ">\n");
            for (ArrayList<Transition> mctDatum : this.mctData) {
                sp = 4;
                if (mctDatum.isEmpty()) {
                    bw.write(";\n");
                    continue;
                }
                StringBuilder mctLine = new StringBuilder();
                for (Transition trans : mctDatum) {
                    mctLine.append(this.transitions.indexOf(trans)).append(";");
                }
                mctLine = new StringBuilder(mctLine.substring(0, mctLine.length() - 1));
                bw.write(this.spaces(sp) + String.valueOf(mctLine) + "\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOM>\n");
            bw.write(this.spaces(sp) + "<MCT names>\n");
            for (int i = 0; i < mctNumber; ++i) {
                sp = 4;
                bw.write(this.spaces(sp) + Tools.convertToCode(this.mctNames.get(i)) + "\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOMn>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00235exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveStates(BufferedWriter bw) {
        try {
            int sp = 2;
            int statesNumber = this.statesMatrix.size();
            if (!this.places.isEmpty()) {
                bw.write(this.spaces(sp) + "<States: " + statesNumber + ">\n");
                for (StatePlacesVector vector : this.statesMatrix) {
                    sp = 4;
                    StringBuilder stateLine = new StringBuilder();
                    for (Double value : vector.accessVector()) {
                        stateLine.append(value).append(";");
                    }
                    stateLine = new StringBuilder(stateLine.substring(0, stateLine.length() - 1));
                    bw.write(this.spaces(sp) + String.valueOf(stateLine) + "\n");
                    String type = vector.getStateType();
                    bw.write(this.spaces(sp) + type + ";\n");
                    bw.write(this.spaces(sp) + Tools.convertToCode(vector.getDescription()) + "\n");
                }
            } else {
                bw.write(this.spaces(sp) + "<States: 0>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOSt>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00236exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveStatesXTPN(BufferedWriter bw) {
        try {
            int sp = 2;
            int statesNumber = this.statesMatrixXTPN.size();
            if (!this.places.isEmpty()) {
                bw.write(this.spaces(sp) + "<States: " + statesNumber + ">\n");
                StringBuilder stateLine = new StringBuilder();
                int placeIndex = -1;
                int stateProcessed = -1;
                for (MultisetM multisetMobject : this.statesMatrixXTPN) {
                    ++stateProcessed;
                    stateLine.setLength(0);
                    String type = multisetMobject.getStateType();
                    String description = multisetMobject.getDescription();
                    sp = 4;
                    for (ArrayList<Double> multisetK : multisetMobject.accessArrayListSOfMultiset_M()) {
                        if (++placeIndex + 1 > this.places.size()) {
                            overlord.log(lang.getText("LOGentry00237a") + stateProcessed + lang.getText("LOGentry00237b"), "error", true);
                            int placeError = 0;
                            for (ArrayList<Double> multisetKK : multisetMobject.accessArrayListSOfMultiset_M()) {
                                Object mTxt = "";
                                for (double d : multisetKK) {
                                    mTxt = (String)mTxt + d + " | ";
                                }
                                overlord.log("p_" + placeError + ":=  (" + (String)mTxt + ")", "error", true);
                            }
                            break;
                        }
                        boolean isXTPNplace = multisetMobject.isPlaceStoredAsGammaActive(placeIndex);
                        if (isXTPNplace) {
                            if (multisetK.isEmpty()) {
                                stateLine.append("-1.0;");
                                continue;
                            }
                            int counter = 0;
                            for (Double token : multisetK) {
                                if (++counter == multisetK.size()) {
                                    stateLine.append(token).append(";");
                                    continue;
                                }
                                stateLine.append(token).append(":");
                            }
                            continue;
                        }
                        double classTokens = multisetK.get(0);
                        stateLine.append((int)classTokens).append("(C);");
                    }
                    stateLine = new StringBuilder(stateLine.substring(0, stateLine.length() - 1));
                    bw.write(this.spaces(sp) + String.valueOf(stateLine) + "\n");
                    bw.write(this.spaces(sp) + type + ";\n");
                    bw.write(this.spaces(sp) + Tools.convertToCode(description) + "\n");
                    placeIndex = -1;
                }
            } else {
                bw.write(this.spaces(sp) + "<States: 0>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOSt>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00238exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveFiringRates(BufferedWriter bw) {
        try {
            int sp = 2;
            int frNumber = this.firingRatesMatrix.size();
            if (!this.transitions.isEmpty()) {
                bw.write(this.spaces(sp) + "<FRvectors: " + frNumber + ">\n");
                for (SPNdataVector ratesMatrix : this.firingRatesMatrix) {
                    sp = 4;
                    StringBuilder dataLine = new StringBuilder("version101:");
                    for (SPNtransitionData frc : ratesMatrix.accessVector()) {
                        dataLine.append(frc.returnSaveVector()).append(";");
                    }
                    dataLine = new StringBuilder(dataLine.substring(0, dataLine.length() - 1));
                    bw.write(this.spaces(sp) + String.valueOf(dataLine) + "\n");
                    bw.write(this.spaces(sp) + String.valueOf((Object)ratesMatrix.getSPNtype()) + ";\n");
                    bw.write(this.spaces(sp) + Tools.convertToCode(ratesMatrix.getDescription()) + "\n");
                }
            } else {
                bw.write(this.spaces(sp) + "<FRvectors: 0>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOFRv>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00239exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean saveSSAvectors(BufferedWriter bw) {
        try {
            int sp = 2;
            int ssaNumber = this.ssaMatrix.size();
            if (!this.places.isEmpty()) {
                bw.write(this.spaces(sp) + "<SSA vectors: " + ssaNumber + ">\n");
                for (SSAplacesVector matrix : this.ssaMatrix) {
                    sp = 4;
                    StringBuilder stateLine = new StringBuilder();
                    for (Double value : matrix.accessVector()) {
                        stateLine.append(value).append(";");
                    }
                    stateLine = new StringBuilder(stateLine.substring(0, stateLine.length() - 1));
                    bw.write(this.spaces(sp) + String.valueOf(stateLine) + "\n");
                    String ssaType = matrix.getType().toString();
                    double ssaVolume = matrix.getVolume();
                    bw.write(this.spaces(sp) + ssaType + ";" + ssaVolume + "\n");
                    bw.write(this.spaces(sp) + Tools.convertToCode(matrix.getDescription()) + "\n");
                }
            } else {
                bw.write(this.spaces(sp) + "<SSA vectors: 0>\n");
            }
            sp = 2;
            bw.write(this.spaces(sp) + "<EOSSA>\n");
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00240exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private String spaces(int howMany) {
        return " ".repeat(Math.max(0, howMany));
    }
}

