/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.data.P_StateManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNdataVector;
import holmes.petrinet.data.SPNdataVectorManager;
import holmes.petrinet.data.SPNtransitionData;
import holmes.petrinet.data.SSAplacesManager;
import holmes.petrinet.data.SSAplacesVector;
import holmes.petrinet.data.StatePlacesVector;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.petrinet.functions.FunctionsTools;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;

public class ProjectReader {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private final PetriNet projectCore;
    private final ArrayList<Node> nodes;
    private ArrayList<MetaNode> metanodes = null;
    private final ArrayList<Arc> arcs;
    private ArrayList<ArrayList<Integer>> t_invariantsMatrix = null;
    private ArrayList<String> t_invariantsNames = null;
    private ArrayList<ArrayList<Integer>> p_invariantsMatrix = null;
    private ArrayList<String> p_invariantsNames = null;
    private ArrayList<ArrayList<Transition>> mctData = null;
    private ArrayList<String> mctNames = null;
    private int placesProcessed = 0;
    private int transitionsProcessed = 0;
    private int metanodesProcessed = 0;
    private int arcsProcessed = 0;
    private int t_invariantsProcessed = 0;
    private int p_invariantsProcessed = 0;
    private int mctProcessed = 0;
    private int globalMaxHeight = 0;
    private int globalMaxWidth = 0;
    private boolean subnets = false;
    private boolean states = false;
    private boolean statesXTPN = false;
    private boolean functions = false;
    private boolean firingRates = false;
    private boolean pInvariants = false;
    private boolean ssaData = false;
    private boolean isPlaceColored = false;
    private boolean isTransitionColored = false;
    private String[] tabPlaceTokens = null;
    private String[] tabTransReqTokens = null;
    private boolean XTPNdataMode = false;

    public ProjectReader() {
        this.projectCore = overlord.getWorkspace().getProject();
        this.projectCore.setProjectType(PetriNet.GlobalNetType.PN);
        this.nodes = this.projectCore.getNodes();
        this.metanodes = this.projectCore.getMetaNodes();
        this.arcs = this.projectCore.getArcs();
        this.t_invariantsMatrix = this.projectCore.getT_InvMatrix();
        this.t_invariantsNames = this.projectCore.accessT_InvDescriptions();
        this.p_invariantsMatrix = this.projectCore.getP_InvMatrix();
        this.p_invariantsNames = this.projectCore.accessP_InvDescriptions();
        this.mctData = this.projectCore.getMCTMatrix();
        this.mctNames = this.projectCore.accessMCTnames();
    }

    public ProjectReader(boolean isLabelCompariso) {
        this.projectCore = new PetriNet(null, "test");
        this.projectCore.setProjectType(PetriNet.GlobalNetType.PN);
        this.nodes = new ArrayList();
        this.arcs = new ArrayList();
    }

    public boolean readProjectForLabelComparison(String filepath) {
        boolean status = true;
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(filepath));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
            overlord.log(lang.getText("LOGentry00241") + " " + filepath, "text", true);
            status = this.readProjectHeader(buffer);
            if (!status) {
                overlord.log(lang.getText("LOGentry00242"), "error", true);
                buffer.close();
                return false;
            }
            status = this.readNetwork(buffer, true);
            if (!status) {
                overlord.log(lang.getText("LOGentry00243"), "error", true);
                buffer.close();
                return false;
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00244exception") + "\n" + e.getMessage(), "error", true);
        }
        return status;
    }

    public boolean readProject(String filepath) {
        boolean status = ProjectReader.overlord.reset.newProjectInitiated();
        if (!status) {
            return false;
        }
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(filepath));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
            overlord.log(lang.getText("LOGentry00241") + " " + filepath, "text", true);
            status = this.readProjectHeader(buffer);
            if (!status) {
                overlord.log(lang.getText("LOGentry00242"), "error", true);
                buffer.close();
                return false;
            }
            try {
                status = this.readNetwork(buffer, false);
                if (!status) {
                    overlord.log(lang.getText("LOGentry00243"), "error", true);
                    buffer.close();
                    return false;
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00245exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                status = this.readTInvariants(buffer);
                if (!status) {
                    this.projectCore.setT_InvMatrix(null, false);
                } else {
                    try {
                        overlord.getT_invBox().showT_invBoxWindow(this.projectCore.getT_InvMatrix());
                        ProjectReader.overlord.reset.setT_invariantsStatus(true);
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentry00246exception") + "\n" + e.getMessage(), "error", true);
                    }
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00247exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                if (this.pInvariants) {
                    status = this.readPInvariants(buffer);
                    if (!status) {
                        this.projectCore.setP_InvMatrix(null);
                    } else {
                        try {
                            overlord.getP_invBox().showP_invBoxWindow(this.projectCore.getP_InvMatrix());
                        }
                        catch (Exception e) {
                            overlord.log(lang.getText("LOGentry00248exception") + "\n" + e.getMessage(), "error", true);
                        }
                    }
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00249exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                status = this.readMCT(buffer);
                if (!status) {
                    this.projectCore.setMCTMatrix(null, false);
                } else {
                    try {
                        overlord.getMctBox().showMCT(this.projectCore.getMCTMatrix());
                        ProjectReader.overlord.reset.setMCTStatus(true);
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentry00250exception") + "\n" + e.getMessage(), "error", true);
                    }
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00251exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                if (this.states) {
                    status = this.readStates(buffer);
                    if (!status) {
                        this.projectCore.accessStatesManager().createCleanStatePN();
                    }
                } else {
                    this.projectCore.accessStatesManager().createCleanStatePN();
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00252exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                if (this.statesXTPN) {
                    status = this.readStatesXTPN(buffer);
                    if (!status) {
                        this.projectCore.accessStatesManager().createFirstMultiset_M();
                    }
                } else if (this.XTPNdataMode) {
                    this.projectCore.accessStatesManager().createFirstMultiset_M();
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00253exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                if (this.firingRates) {
                    status = this.readFiringRates(buffer);
                    if (!status) {
                        this.projectCore.accessFiringRatesManager().createCleanSPNdataVector();
                    }
                } else {
                    this.projectCore.accessFiringRatesManager().createCleanSPNdataVector();
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00254exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            try {
                if (this.ssaData) {
                    status = this.readSSAvectors(buffer);
                    if (!status) {
                        this.projectCore.accessSSAmanager().createCleanSSAvector();
                    }
                } else {
                    this.projectCore.accessSSAmanager().createCleanSSAvector();
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00255exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
            ProjectReader.overlord.subnetsGraphics.addRequiredSheets();
            buffer.close();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00256exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readProjectHeader(BufferedReader buffer) {
        try {
            String line;
            while (!(line = buffer.readLine()).contains("<Project blocks>")) {
                this.parseHeaderLine(line);
            }
            if (line.contains("<Project blocks>")) {
                while (!(line = buffer.readLine()).contains("</Project blocks>")) {
                    this.parseNetblocksLine(line);
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00257exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private void parseHeaderLine(String line) {
        String backup = line;
        try {
            String query = "Project name";
            if (line.contains(query)) {
                line = line.substring(line.indexOf("name:") + 6);
                this.projectCore.setName(line);
                return;
            }
            query = "Date:";
            if (line.contains(query)) {
                return;
            }
            query = "Net type:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf("type:") + 6);
                this.projectCore.setProjectType(this.projectCore.getNetTypeByName(line));
                if (this.projectCore.getProjectType() == PetriNet.GlobalNetType.XTPN) {
                    this.projectCore.selectProperSimulatorBox(true);
                    this.XTPNdataMode = true;
                }
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00258exception_1") + " " + backup + " " + lang.getText("LOGentry00258exception_2") + " " + this.transitionsProcessed, "error", true);
        }
    }

    private void parseNetblocksLine(String line) {
        try {
            if (line.toLowerCase().contains("subnets")) {
                this.subnets = true;
            } else if (line.toLowerCase().contains("statesmatrix")) {
                this.states = true;
            } else if (line.toLowerCase().contains("statesxtpnmatrix")) {
                this.statesXTPN = true;
            } else if (line.toLowerCase().contains("functions")) {
                this.functions = true;
            } else if (line.toLowerCase().contains("firingratesdata")) {
                this.firingRates = true;
            } else if (line.toLowerCase().contains("placeinvdata")) {
                this.pInvariants = true;
            } else if (line.toLowerCase().contains("ssamatrix")) {
                this.ssaData = true;
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00259exception") + " " + line, "error", true);
        }
    }

    private boolean readNetwork(BufferedReader buffer, boolean isLabelComparison) {
        boolean status;
        try {
            ArrayList transitions;
            ArrayList places;
            Node impostor;
            boolean go;
            while (!buffer.readLine().contains("ID generator")) {
            }
            String line = buffer.readLine();
            if (!line.contains("<Places: 0>")) {
                buffer.readLine();
                go = true;
                while (go) {
                    if (this.XTPNdataMode) {
                        PlaceXTPN place = new PlaceXTPN(IdGenerator.getNextId(), 0, new Point(20, 20));
                        while (!(line = buffer.readLine()).contains("<EOP>")) {
                            this.parsePlaceLine(line, place);
                        }
                        line = buffer.readLine();
                        if (line.contains("<Places data block end>")) {
                            go = false;
                        }
                        ++this.placesProcessed;
                        this.nodes.add(place);
                        continue;
                    }
                    int nextID = IdGenerator.getNextId();
                    Place place = new Place(nextID, 0, new Point(20, 20));
                    while (!(line = buffer.readLine()).contains("<EOP>")) {
                        this.parsePlaceLine(line, place);
                    }
                    line = buffer.readLine();
                    if (line.contains("<Places data block end>")) {
                        go = false;
                    }
                    if (this.isPlaceColored) {
                        impostor = this.resurrectAsColoredPlace(place, nextID);
                        this.isPlaceColored = false;
                        this.tabPlaceTokens = null;
                        this.nodes.add(impostor);
                    } else {
                        this.nodes.add(place);
                    }
                    ++this.placesProcessed;
                }
            }
            while (!(line = buffer.readLine()).contains("<Transitions: ")) {
            }
            if (!line.contains("<Transitions: 0>")) {
                buffer.readLine();
                go = true;
                while (go) {
                    if (this.XTPNdataMode) {
                        TransitionXTPN transition = new TransitionXTPN(IdGenerator.getNextId(), 0, new Point(20, 20));
                        while (!(line = buffer.readLine()).contains("<EOT>")) {
                            this.parseTransitionLine(line, transition);
                        }
                        line = buffer.readLine();
                        if (line.contains("<Transitions data block end>")) {
                            go = false;
                        }
                        ++this.transitionsProcessed;
                        this.nodes.add(transition);
                        continue;
                    }
                    int nextID = IdGenerator.getNextId();
                    Transition transition = new Transition(nextID, 0, new Point(20, 20));
                    while (!(line = buffer.readLine()).contains("<EOT>")) {
                        this.parseTransitionLine(line, transition);
                    }
                    line = buffer.readLine();
                    if (line.contains("<Transitions data block end>")) {
                        go = false;
                    }
                    if (this.isTransitionColored) {
                        impostor = this.resurrectAsColoredTransition(transition, nextID);
                        this.isTransitionColored = false;
                        this.tabTransReqTokens = null;
                        this.nodes.add(impostor);
                    } else {
                        this.nodes.add(transition);
                    }
                    ++this.transitionsProcessed;
                }
            }
            if (this.subnets) {
                while (!(line = buffer.readLine()).contains("<MetaNodes: ")) {
                }
                if (!line.contains("<MetaNodes: 0>")) {
                    buffer.readLine();
                    go = true;
                    while (go) {
                        MetaNode metanode = new MetaNode(0, IdGenerator.getNextId(), new Point(20, 20), MetaNode.MetaType.SUBNET);
                        while (!(line = buffer.readLine()).contains("<EOT>")) {
                            this.parseMetaNodesLine(line, metanode);
                        }
                        line = buffer.readLine();
                        if (line.contains("<MetaNodes data block end>")) {
                            go = false;
                        }
                        ++this.metanodesProcessed;
                        this.metanodes.add(metanode);
                        this.nodes.add(metanode);
                    }
                }
            }
            if (isLabelComparison) {
                places = this.nodes.stream().filter(x -> x.getType() == PetriNetElement.PetriNetElementType.PLACE).map(obj -> (Place)obj).collect(Collectors.toCollection(ArrayList::new));
                transitions = this.nodes.stream().filter(x -> x.getType() == PetriNetElement.PetriNetElementType.TRANSITION).map(obj -> (Transition)obj).collect(Collectors.toCollection(ArrayList::new));
            } else {
                places = overlord.getWorkspace().getProject().getPlaces();
                transitions = overlord.getWorkspace().getProject().getTransitions();
            }
            while (!buffer.readLine().contains("<Arcs data block>")) {
            }
            while (!(line = buffer.readLine()).contains("Arcs data block end")) {
                Arc newArc = this.parseArcLine(line, places, transitions, this.metanodes);
                if (newArc == null) continue;
                ++this.arcsProcessed;
                this.arcs.add(newArc);
            }
            for (Transition transition : transitions) {
                transition.fpnExtension.checkFunctions(this.arcs, places);
            }
            int functionsRead = 0;
            int functionsFailed = 0;
            if (this.functions) {
                while (!buffer.readLine().contains("<Functions data block>")) {
                }
                while (!(line = buffer.readLine()).contains("<Functions data block end>")) {
                    boolean fReadStatus = this.parseFunction(line, transitions);
                    if (fReadStatus) {
                        ++functionsRead;
                        continue;
                    }
                    ++functionsFailed;
                }
            }
            HolmesNotepad notepad = new HolmesNotepad(640, 480);
            notepad.setVisible(true);
            boolean errStatus = FunctionsTools.validateFunctionNet(notepad, places);
            if (errStatus) {
                notepad.setVisible(true);
            } else {
                notepad.dispose();
            }
            overlord.log(lang.getText("LOGentry00260a") + " " + this.placesProcessed + " " + lang.getText("LOGentry00260b") + " " + this.transitionsProcessed + " " + lang.getText("LOGentry00260c") + " " + this.arcsProcessed + " " + lang.getText("LOGentry00260d") + " " + functionsRead + " " + lang.getText("LOGentry00260e"), "text", true);
            if (functionsFailed > 0) {
                overlord.log(lang.getText("LOGentry00261a") + " " + functionsFailed + " " + lang.getText("LOGentry00261b"), "error", true);
            }
            status = true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00262"), "error", true);
            overlord.log(lang.getText("LOGentry00263a") + " " + this.placesProcessed + " " + lang.getText("LOGentry00263b") + " " + this.transitionsProcessed + " " + lang.getText("LOGentry00263c") + " " + this.arcsProcessed + " " + lang.getText("LOGentry00263d"), "error", false);
            overlord.log(lang.getText("LOGentry00263exception") + "\n" + e.getMessage(), "error", false);
            status = false;
        }
        return status;
    }

    private boolean parseFunction(String functionLine, ArrayList<Transition> transitions) {
        try {
            String[] table = functionLine.split(";");
            String transNumber = table[0].replace("<T", "");
            int transIndex = Integer.parseInt(transNumber.trim());
            Transition transition = transitions.get(transIndex);
            boolean correct = false;
            boolean enabled = false;
            if (table[3].contains("true")) {
                correct = true;
            }
            if (table[4].contains("true")) {
                enabled = true;
            }
            return transition.fpnExtension.updateFunctionString(table[1], table[2], correct, enabled);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00264exception") + " " + functionLine, "warning", true);
            overlord.log(lang.getText("LOGentry00264exception") + "\n" + e.getMessage(), "warning", false);
            return false;
        }
    }

    private void parsePlaceLine(String line, Place place) {
        String backup = line;
        try {
            String query = "Place gID:";
            if (line.contains(query)) {
                return;
            }
            query = "Place name:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                place.setName(line);
                return;
            }
            query = "Place comment:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                line = Tools.decodeString(line);
                place.setComment(line);
                return;
            }
            query = "Place tokens:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    int tokens = Integer.parseInt(line);
                    place.setTokensNumber(tokens);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00265exception") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                    place.setTokensNumber(0);
                }
                return;
            }
            query = "Place SSAvalue:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double ssaValue = Double.parseDouble(line);
                    place.setSSAvalue(ssaValue);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00266exception") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                    place.setTokensNumber(0);
                }
                return;
            }
            query = "Place SSAconcStatus:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    boolean isConc = Boolean.parseBoolean(line);
                    place.setSSAconcentrationStatus(isConc);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00267exception") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                    place.setTokensNumber(0);
                }
                return;
            }
            query = "Place XTPN status:";
            if (line.contains(query) && this.XTPNdataMode) {
                return;
            }
            query = "Place XTPN gammaMode:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((PlaceXTPN)place).setGammaModeStatus(true);
                } else if (line.contains("false")) {
                    ((PlaceXTPN)place).setGammaModeStatus(false);
                } else {
                    overlord.log(lang.getText("LOGentry00268") + " " + this.placesProcessed, "error", true);
                    ((PlaceXTPN)place).setGammaModeStatus(true);
                }
                return;
            }
            query = "Place XTPN gammaVisible:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((PlaceXTPN)place).setGammaRangeVisibility(true);
                } else if (line.contains("false")) {
                    ((PlaceXTPN)place).setGammaRangeVisibility(false);
                } else {
                    overlord.log(lang.getText("LOGentry00269") + " " + this.placesProcessed, "error", true);
                    ((PlaceXTPN)place).setGammaRangeVisibility(true);
                }
                return;
            }
            query = "Place XTPN gammaMin:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double gammaMin = Double.parseDouble(line);
                    ((PlaceXTPN)place).setGammaMinValue(gammaMin, true);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00270") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                    ((PlaceXTPN)place).setGammaMinValue(0.0, true);
                }
                return;
            }
            query = "Place XTPN gammaMax:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double gammaMax = Double.parseDouble(line);
                    ((PlaceXTPN)place).setGammaMaxValue(gammaMax, true);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00271") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                    if (((PlaceXTPN)place).getGammaMinValue() > 0.0) {
                        ((PlaceXTPN)place).setGammaMaxValue(((PlaceXTPN)place).getGammaMinValue(), true);
                    }
                    ((PlaceXTPN)place).setGammaMaxValue(0.0, true);
                }
                return;
            }
            query = "Place XTPN fractionSize:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    int fractionSize = Integer.parseInt(line);
                    ((PlaceXTPN)place).setFractionForPlaceXTPN(fractionSize);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00272") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                    ((PlaceXTPN)place).setFractionForPlaceXTPN(6);
                }
                return;
            }
            query = "Place XTPN multiset:";
            if (line.contains(query) && this.XTPNdataMode) {
                String[] tab;
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                for (String s : tab = line.split(":")) {
                    try {
                        double token = Double.parseDouble(s);
                        ((PlaceXTPN)place).accessMultiset().add(token);
                    }
                    catch (Exception exc) {
                        overlord.log(lang.getText("LOGentry00273") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                        ((PlaceXTPN)place).addTokens_XTPN(1, 0.0);
                    }
                }
                return;
            }
            query = "Place portal status:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    place.setPortal(true);
                } else if (line.contains("false")) {
                    place.setPortal(false);
                } else {
                    overlord.log(lang.getText("LOGentry00274") + " " + this.placesProcessed, "error", true);
                    place.setPortal(false);
                }
                return;
            }
            query = "Place locations:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    int elLocSize = Integer.parseInt(line);
                    for (int e = 0; e < elLocSize - 1; ++e) {
                        place.getElementLocations().add(new ElementLocation(0, new Point(20, 20), place));
                        place.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(0, new Point(0, 0), place));
                        if (place.getPlaceType() != Place.PlaceType.XTPN) continue;
                        place.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(new ElementLocation(0, new Point(0, 0), place));
                    }
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00275exception") + " " + this.placesProcessed + "\n" + exc.getMessage(), "error", true);
                }
                return;
            }
            query = "Place location data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                place.getElementLocations().get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                place.getElementLocations().get(eLocIndex).forceSetPosition(newP);
                place.getElementLocations().get(eLocIndex).setNotSnappedPosition(newP);
                this.setGlobalXY(pointX, pointY);
                return;
            }
            query = "Place name offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                place.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                place.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).forceSetPosition(newP);
                place.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).setNotSnappedPosition(newP);
                return;
            }
            query = "Place gamma offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                place.getTextsLocations(GUIManager.locationMoveType.GAMMA).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                place.getTextsLocations(GUIManager.locationMoveType.GAMMA).get(eLocIndex).forceSetPosition(newP);
                place.getTextsLocations(GUIManager.locationMoveType.GAMMA).get(eLocIndex).setNotSnappedPosition(newP);
                return;
            }
            query = "Place colored:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    this.isPlaceColored = true;
                }
                return;
            }
            query = "Place colors:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                this.tabPlaceTokens = line.split(";");
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00276exception_1") + " " + backup + " " + lang.getText("LOGentry00276exception_2") + " " + this.placesProcessed + "\n" + e.getMessage(), "error", true);
        }
    }

    private void parseTransitionLine(String line, Transition transition) {
        String backup = line;
        try {
            String query = "Transition gID:";
            if (line.contains(query)) {
                return;
            }
            query = "Transition type:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                switch (line = line.replace(">", "")) {
                    case "PN": {
                        transition.setTransType(Transition.TransitionType.PN);
                        break;
                    }
                    case "TPN": {
                        transition.setTransType(Transition.TransitionType.TPN);
                        break;
                    }
                    case "SPN": {
                        transition.setTransType(Transition.TransitionType.SPN);
                        break;
                    }
                    case "CPN": {
                        transition.setTransType(Transition.TransitionType.CPN);
                        break;
                    }
                    case "XTPN": {
                        transition.setTransType(Transition.TransitionType.XTPN);
                    }
                }
                return;
            }
            query = "Transition name:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                transition.setName(line);
                return;
            }
            query = "Transition comment:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                line = Tools.decodeString(line);
                transition.setComment(line);
                return;
            }
            query = "Transition eft:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                double eft = Double.parseDouble(line);
                transition.timeExtension.forceSetEFT(eft);
                return;
            }
            query = "Transition lft:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                double lft = Double.parseDouble(line);
                transition.timeExtension.setLFT(lft);
                return;
            }
            query = "Transition duration:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                double duration = Double.parseDouble(line);
                transition.timeExtension.setDPNduration(duration);
                return;
            }
            query = "Transition TPN status:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                transition.timeExtension.setTPNstatus(line.contains("true"));
                return;
            }
            query = "Transition DPN status:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                transition.timeExtension.setDPNstatus(line.contains("true"));
                return;
            }
            query = "Transition function flag:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                transition.fpnExtension.setFunctional(line.contains("true"));
                return;
            }
            query = "Transition portal status:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    transition.setPortal(true);
                }
                return;
            }
            query = "Transition XTPN status:";
            if (line.contains(query) && this.XTPNdataMode) {
                return;
            }
            query = "Transition XTPN alphaMode:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setAlphaModeStatus(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setAlphaModeStatus(false);
                } else {
                    overlord.log(lang.getText("LOGentry00277") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setAlphaModeStatus(true);
                }
                return;
            }
            query = "Transition XTPN alphaVisible:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setAlphaRangeVisibility(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setAlphaRangeVisibility(false);
                } else {
                    overlord.log(lang.getText("LOGentry00278") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setAlphaRangeVisibility(true);
                }
                return;
            }
            query = "Transition XTPN alphaMin:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double gammaMin = Double.parseDouble(line);
                    ((TransitionXTPN)transition).setAlphaMinValue(gammaMin, true);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00279") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setAlphaMinValue(0.0, true);
                }
                return;
            }
            query = "Transition XTPN alphaMax:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double gammaMax = Double.parseDouble(line);
                    ((TransitionXTPN)transition).setAlphaMaxValue(gammaMax, true);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00280exception") + " " + this.transitionsProcessed + "\n" + exc.getMessage(), "error", true);
                    if (((TransitionXTPN)transition).getAlphaMinValue() > 0.0) {
                        ((TransitionXTPN)transition).setAlphaMaxValue(((TransitionXTPN)transition).getAlphaMinValue(), true);
                    }
                    ((TransitionXTPN)transition).setAlphaMaxValue(0.0, true);
                }
                return;
            }
            query = "Transition XTPN betaMode:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setBetaModeStatus(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setBetaModeStatus(false);
                } else {
                    overlord.log(lang.getText("LOGentry00281") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setBetaModeStatus(true);
                }
                return;
            }
            query = "Transition XTPN betaVisible:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setBetaRangeVisibility(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setBetaRangeVisibility(false);
                } else {
                    overlord.log(lang.getText("LOGentry00282") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setBetaRangeVisibility(true);
                }
                return;
            }
            query = "Transition XTPN betaMin:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double gammaMin = Double.parseDouble(line);
                    ((TransitionXTPN)transition).setBetaMinValue(gammaMin, true);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00283exception") + " " + this.transitionsProcessed + "\n" + exc.getMessage(), "error", true);
                    ((TransitionXTPN)transition).setBetaMinValue(0.0, true);
                }
                return;
            }
            query = "Transition XTPN betaMax:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    double gammaMax = Double.parseDouble(line);
                    ((TransitionXTPN)transition).setBetaMaxValue(gammaMax, true);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00284exception") + " " + this.transitionsProcessed + "\n" + exc.getMessage(), "error", true);
                    if (((TransitionXTPN)transition).getBetaMinValue() > 0.0) {
                        ((TransitionXTPN)transition).setBetaMaxValue(((TransitionXTPN)transition).getBetaMinValue(), true);
                    }
                    ((TransitionXTPN)transition).setBetaMaxValue(0.0, true);
                }
                return;
            }
            query = "Transition XTPN tauVisible:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setTauTimersVisibility(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setTauTimersVisibility(false);
                } else {
                    overlord.log(lang.getText("LOGentry00285") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setTauTimersVisibility(true);
                }
                return;
            }
            query = "Transition XTPN massAction:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setMassActionKineticsXTPNstatus(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setMassActionKineticsXTPNstatus(false);
                } else {
                    overlord.log(lang.getText("LOGentry00286") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setMassActionKineticsXTPNstatus(false);
                }
                return;
            }
            query = "Transition XTPN fractionSize:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                try {
                    int fractionSize = Integer.parseInt(line);
                    ((TransitionXTPN)transition).setFraction_xTPN(fractionSize);
                }
                catch (Exception exc) {
                    overlord.log(lang.getText("LOGentry00287exception") + " " + this.transitionsProcessed + "\n" + exc.getMessage(), "error", true);
                    ((TransitionXTPN)transition).setFraction_xTPN(6);
                }
                return;
            }
            query = "Transition XTPN immediate:";
            if (line.contains(query) && this.XTPNdataMode) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    ((TransitionXTPN)transition).setImmediateStatusXTPN(true);
                } else if (line.contains("false")) {
                    ((TransitionXTPN)transition).setImmediateStatusXTPN(false);
                } else {
                    overlord.log(lang.getText("LOGentry00288") + " " + this.transitionsProcessed, "error", true);
                    ((TransitionXTPN)transition).setImmediateStatusXTPN(false);
                }
                return;
            }
            query = "Transition locations:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                int elLocSize = Integer.parseInt(line);
                for (int e = 0; e < elLocSize - 1; ++e) {
                    transition.getElementLocations().add(new ElementLocation(0, new Point(20, 20), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(0, new Point(0, 0), transition));
                    if (transition.getTransType() != Transition.TransitionType.XTPN) continue;
                    transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(new ElementLocation(0, new Point(0, 0), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.BETA).add(new ElementLocation(0, new Point(0, 0), transition));
                    transition.getTextsLocations(GUIManager.locationMoveType.TAU).add(new ElementLocation(0, new Point(0, 0), transition));
                }
                return;
            }
            query = "Transition location data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                transition.getElementLocations().get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                transition.getElementLocations().get(eLocIndex).forceSetPosition(newP);
                transition.getElementLocations().get(eLocIndex).setNotSnappedPosition(newP);
                this.setGlobalXY(pointX, pointY);
                return;
            }
            query = "Transition name offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                transition.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                transition.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).forceSetPosition(newP);
                transition.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).setNotSnappedPosition(newP);
                return;
            }
            query = "Transition alpha offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).get(eLocIndex).forceSetPosition(newP);
                transition.getTextsLocations(GUIManager.locationMoveType.ALPHA).get(eLocIndex).setNotSnappedPosition(newP);
                return;
            }
            query = "Transition beta offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                transition.getTextsLocations(GUIManager.locationMoveType.BETA).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                transition.getTextsLocations(GUIManager.locationMoveType.BETA).get(eLocIndex).forceSetPosition(newP);
                transition.getTextsLocations(GUIManager.locationMoveType.BETA).get(eLocIndex).setNotSnappedPosition(newP);
                return;
            }
            query = "Transition tau offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                transition.getTextsLocations(GUIManager.locationMoveType.TAU).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                transition.getTextsLocations(GUIManager.locationMoveType.TAU).get(eLocIndex).forceSetPosition(newP);
                transition.getTextsLocations(GUIManager.locationMoveType.TAU).get(eLocIndex).setNotSnappedPosition(newP);
                return;
            }
            query = "Transition colored:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                if ((line = line.replace(">", "")).contains("true")) {
                    this.isTransitionColored = true;
                }
                return;
            }
            query = "Transition colors threshold:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                this.tabTransReqTokens = line.split(";");
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00289exception_1") + " " + backup + " " + lang.getText("LOGentry00289exception_2") + " " + this.transitionsProcessed + "\n" + e.getMessage(), "error", true);
        }
    }

    private void parseMetaNodesLine(String line, MetaNode metanode) {
        String backup = line;
        try {
            String query = "MetaNode gID:";
            if (line.contains(query)) {
                return;
            }
            query = "MetaNode type:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                switch (line = line.replace(">", "")) {
                    case "SUBNETTRANS": {
                        metanode.setMetaType(MetaNode.MetaType.SUBNETTRANS);
                        break;
                    }
                    case "SUBNETPLACE": {
                        metanode.setMetaType(MetaNode.MetaType.SUBNETPLACE);
                        break;
                    }
                    case "SUBNET": {
                        metanode.setMetaType(MetaNode.MetaType.SUBNET);
                        break;
                    }
                    default: {
                        metanode.setMetaType(MetaNode.MetaType.UNKNOWN);
                    }
                }
                return;
            }
            query = "MetaNode name:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                metanode.setName(line);
                return;
            }
            query = "MetaNode comment:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                line = Tools.decodeString(line);
                metanode.setComment(line);
                return;
            }
            query = "MetaNode representedSheet:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                int sheetR = Integer.parseInt(line);
                metanode.setRepresentedSheetID(sheetR);
                return;
            }
            query = "MetaNode locations:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                int elLocSize = Integer.parseInt(line);
                for (int e = 0; e < elLocSize - 1; ++e) {
                    metanode.getElementLocations().add(new ElementLocation(0, new Point(20, 20), metanode));
                    metanode.getTextsLocations(GUIManager.locationMoveType.NAME).add(new ElementLocation(0, new Point(0, 0), metanode));
                }
                return;
            }
            query = "MetaNode location data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                metanode.getElementLocations().get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                metanode.getElementLocations().get(eLocIndex).forceSetPosition(newP);
                metanode.getElementLocations().get(eLocIndex).setNotSnappedPosition(newP);
                this.setGlobalXY(pointX, pointY);
                return;
            }
            query = "MetaNode name offset data sheet/x/y/elIndex:";
            if (line.contains(query)) {
                line = line.substring(line.indexOf(query) + query.length());
                line = line.replace(">", "");
                String[] tab = line.split(";");
                int sheetID = Integer.parseInt(tab[0]);
                int pointX = Integer.parseInt(tab[1]);
                int pointY = Integer.parseInt(tab[2]);
                int eLocIndex = Integer.parseInt(tab[3]);
                metanode.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).setSheetID(sheetID);
                Point newP = new Point(pointX, pointY);
                metanode.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).forceSetPosition(newP);
                metanode.getTextsLocations(GUIManager.locationMoveType.NAME).get(eLocIndex).setNotSnappedPosition(newP);
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00290exception_1") + " " + backup + " " + lang.getText("LOGentry00290exception_2") + " " + this.metanodesProcessed + "\n" + e.getMessage(), "error", true);
        }
    }

    private Arc parseArcLine(String line, ArrayList<Place> places, ArrayList<Transition> transitions, ArrayList<MetaNode> metanodes) {
        String backup = line;
        boolean XTPNarc = false;
        boolean XTPNinh = false;
        try {
            line = line.replace(" ", "");
            String[] tab = line.split(";");
            String typeLine = tab[0];
            Arc.TypeOfArc arcType = Arc.TypeOfArc.NORMAL;
            if (typeLine.contains("READARC")) {
                arcType = Arc.TypeOfArc.READARC;
            } else if (typeLine.contains("INHIBITOR")) {
                arcType = Arc.TypeOfArc.INHIBITOR;
            } else if (typeLine.contains("RESET")) {
                arcType = Arc.TypeOfArc.RESET;
            } else if (typeLine.contains("EQUAL")) {
                arcType = Arc.TypeOfArc.EQUAL;
            } else if (typeLine.contains("META_ARC")) {
                arcType = Arc.TypeOfArc.META_ARC;
            } else if (typeLine.contains("XTPN")) {
                XTPNarc = true;
            } else if (typeLine.contains("XINH")) {
                arcType = Arc.TypeOfArc.INHIBITOR;
                XTPNinh = true;
            } else if (this.XTPNdataMode && typeLine.contains("NORMAL")) {
                XTPNarc = true;
            }
            tab[2] = tab[2].replace(">", "");
            int weight = Integer.parseInt(tab[2]);
            String arcData = tab[1];
            boolean placeFirst = false;
            boolean metaFirst = false;
            boolean metaSecond = false;
            boolean isThereTransition = false;
            if (arcData.indexOf("P") == 0) {
                placeFirst = true;
            }
            if (arcData.indexOf("M") > 0) {
                metaSecond = true;
            }
            if (arcData.indexOf("M") == 0) {
                metaFirst = true;
                metaSecond = false;
            }
            if (arcData.contains("T")) {
                isThereTransition = true;
            }
            arcData = arcData.replace("P", "");
            arcData = arcData.replace("T", "");
            arcData = arcData.replace("M", "");
            arcData = arcData.replace(")->", " ");
            arcData = arcData.replace(")", "");
            arcData = arcData.replace("(", " ");
            String[] arcDataTable = arcData.split(" ");
            boolean colorReadOk = false;
            boolean colorStatus = false;
            String[] colorsWeights = null;
            try {
                int len = tab.length;
                if (len > 4) {
                    if (tab[3].contains("true") || tab[3].contains("false")) {
                        if (tab[3].equals("true")) {
                            colorStatus = true;
                        }
                        colorsWeights = tab[4].split(":");
                        colorReadOk = true;
                    } else {
                        if (tab[4].equals("true")) {
                            colorStatus = true;
                        }
                        colorsWeights = tab[5].split(":");
                        colorReadOk = true;
                    }
                }
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00291exception") + "\n" + ex.getMessage(), "error", true);
            }
            if (placeFirst) {
                if (!metaSecond) {
                    int placeIndex = Integer.parseInt(arcDataTable[0]);
                    int placeElLoc = Integer.parseInt(arcDataTable[1]);
                    int transIndex = Integer.parseInt(arcDataTable[2]);
                    int transElLoc = Integer.parseInt(arcDataTable[3]);
                    ElementLocation pEL = places.get(placeIndex).getElementLocations().get(placeElLoc);
                    ElementLocation tEL = transitions.get(transIndex).getElementLocations().get(transElLoc);
                    Arc newArc = new Arc(pEL, tEL, "", weight, arcType);
                    if (XTPNarc) {
                        newArc.arcXTPNbox.setXTPNstatus(true);
                    }
                    if (XTPNinh) {
                        newArc.arcXTPNbox.setXTPNinhibitorStatus(true);
                    }
                    newArc.clearBreakPoints();
                    if (tab.length > 3) {
                        this.addBroken(newArc, tab[3]);
                    }
                    if (colorReadOk) {
                        this.addColorsToArc(newArc, colorStatus, colorsWeights);
                    }
                    return newArc;
                }
                int placeIndex = Integer.parseInt(arcDataTable[0]);
                int placeElLoc = Integer.parseInt(arcDataTable[1]);
                int metaIndex = Integer.parseInt(arcDataTable[2]);
                int metaElLoc = Integer.parseInt(arcDataTable[3]);
                ElementLocation pEL = places.get(placeIndex).getElementLocations().get(placeElLoc);
                ElementLocation mEL = metanodes.get(metaIndex).getElementLocations().get(metaElLoc);
                Arc newArc = new Arc(pEL, mEL, "", weight, arcType);
                if (XTPNarc) {
                    newArc.arcXTPNbox.setXTPNstatus(true);
                }
                if (XTPNinh) {
                    newArc.arcXTPNbox.setXTPNinhibitorStatus(true);
                }
                newArc.clearBreakPoints();
                if (tab.length > 3) {
                    this.addBroken(newArc, tab[3]);
                }
                return newArc;
            }
            if (metaFirst) {
                if (isThereTransition) {
                    int metaIndex = Integer.parseInt(arcDataTable[0]);
                    int metaElLoc = Integer.parseInt(arcDataTable[1]);
                    int transIndex = Integer.parseInt(arcDataTable[2]);
                    int transElLoc = Integer.parseInt(arcDataTable[3]);
                    ElementLocation mEL = metanodes.get(metaIndex).getElementLocations().get(metaElLoc);
                    ElementLocation tEL = transitions.get(transIndex).getElementLocations().get(transElLoc);
                    Arc newArc = new Arc(mEL, tEL, "", weight, arcType);
                    if (XTPNarc) {
                        newArc.arcXTPNbox.setXTPNstatus(true);
                    }
                    if (XTPNinh) {
                        newArc.arcXTPNbox.setXTPNinhibitorStatus(true);
                    }
                    newArc.clearBreakPoints();
                    if (tab.length > 3) {
                        this.addBroken(newArc, tab[3]);
                    }
                    return newArc;
                }
                int metaIndex = Integer.parseInt(arcDataTable[0]);
                int metaElLoc = Integer.parseInt(arcDataTable[1]);
                int placeIndex = Integer.parseInt(arcDataTable[2]);
                int placeElLoc = Integer.parseInt(arcDataTable[3]);
                ElementLocation mEL = metanodes.get(metaIndex).getElementLocations().get(metaElLoc);
                ElementLocation pEL = places.get(placeIndex).getElementLocations().get(placeElLoc);
                Arc newArc = new Arc(mEL, pEL, "", weight, arcType);
                if (XTPNarc) {
                    newArc.arcXTPNbox.setXTPNstatus(true);
                }
                if (XTPNinh) {
                    newArc.arcXTPNbox.setXTPNinhibitorStatus(true);
                }
                newArc.clearBreakPoints();
                if (tab.length > 3) {
                    this.addBroken(newArc, tab[3]);
                }
                if (colorReadOk) {
                    this.addColorsToArc(newArc, colorStatus, colorsWeights);
                }
                return newArc;
            }
            if (metaSecond) {
                int transIndex = Integer.parseInt(arcDataTable[0]);
                int transElLoc = Integer.parseInt(arcDataTable[1]);
                int metaIndex = Integer.parseInt(arcDataTable[2]);
                int metaElLoc = Integer.parseInt(arcDataTable[3]);
                ElementLocation tEL = transitions.get(transIndex).getElementLocations().get(transElLoc);
                ElementLocation mEL = metanodes.get(metaIndex).getElementLocations().get(metaElLoc);
                Arc newArc = new Arc(tEL, mEL, "", weight, arcType);
                if (XTPNarc) {
                    newArc.arcXTPNbox.setXTPNstatus(true);
                }
                if (XTPNinh) {
                    newArc.arcXTPNbox.setXTPNinhibitorStatus(true);
                }
                newArc.clearBreakPoints();
                if (tab.length > 3) {
                    this.addBroken(newArc, tab[3]);
                }
                if (colorReadOk) {
                    this.addColorsToArc(newArc, colorStatus, colorsWeights);
                }
                return newArc;
            }
            int transIndex = Integer.parseInt(arcDataTable[0]);
            int transElLoc = Integer.parseInt(arcDataTable[1]);
            int placeIndex = Integer.parseInt(arcDataTable[2]);
            int placeElLoc = Integer.parseInt(arcDataTable[3]);
            ElementLocation tEL = transitions.get(transIndex).getElementLocations().get(transElLoc);
            ElementLocation pEL = places.get(placeIndex).getElementLocations().get(placeElLoc);
            Arc newArc = new Arc(tEL, pEL, "", weight, arcType);
            if (XTPNarc) {
                newArc.arcXTPNbox.setXTPNstatus(true);
            }
            if (XTPNinh) {
                newArc.arcXTPNbox.setXTPNinhibitorStatus(true);
            }
            newArc.clearBreakPoints();
            if (tab.length > 3) {
                this.addBroken(newArc, tab[3]);
            }
            if (colorReadOk) {
                this.addColorsToArc(newArc, colorStatus, colorsWeights);
            }
            return newArc;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00292exception") + " " + backup + "\n" + e.getMessage(), "error", true);
            return null;
        }
    }

    private void addColorsToArc(Arc newArc, boolean colorStatus, String[] colorsWeights) {
        try {
            if (colorStatus) {
                newArc.setArcType(Arc.TypeOfArc.COLOR);
            }
            newArc.setColorWeight(Integer.parseInt(colorsWeights[0]), 0);
            newArc.setColorWeight(Integer.parseInt(colorsWeights[1]), 1);
            newArc.setColorWeight(Integer.parseInt(colorsWeights[2]), 2);
            newArc.setColorWeight(Integer.parseInt(colorsWeights[3]), 3);
            newArc.setColorWeight(Integer.parseInt(colorsWeights[4]), 4);
            newArc.setColorWeight(Integer.parseInt(colorsWeights[5]), 5);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00293exception") + " " + newArc.toString() + "\n" + e.getMessage(), "error", true);
        }
    }

    private void addBroken(Arc newArc, String brokenLine) {
        String[] tab;
        if (!brokenLine.contains("-")) {
            return;
        }
        for (String s : tab = brokenLine.split("x")) {
            try {
                String[] coords = s.split("-");
                int x = Integer.parseInt(coords[0]);
                int y = Integer.parseInt(coords[1]);
                if (x == 99999 && y == 11111) {
                    return;
                }
                newArc.addBreakPoint(new Point(x, y));
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00294exception") + "\n" + ex.getMessage(), "error", true);
            }
        }
    }

    private boolean readTInvariants(BufferedReader buffer) {
        try {
            while (!buffer.readLine().contains("<Invariants data>")) {
            }
            String line = buffer.readLine();
            int transNumber = this.projectCore.getTransitions().size();
            StringBuilder problemWithInv = new StringBuilder();
            int problems = 0;
            int readedLine = -1;
            if (!line.contains("<Invariants: 0>")) {
                boolean go = true;
                this.t_invariantsMatrix = new ArrayList();
                line = buffer.readLine();
                while (go) {
                    ++readedLine;
                    ArrayList<Integer> invariant = new ArrayList<Integer>();
                    line = line.replace(" ", "");
                    String[] tab = line.split(";");
                    for (int i = 1; i < tab.length; ++i) {
                        invariant.add(Integer.parseInt(tab[i]));
                    }
                    line = buffer.readLine();
                    if (line.contains("<EOI>")) {
                        go = false;
                    }
                    if (invariant.size() == transNumber) {
                        this.t_invariantsMatrix.add(invariant);
                        ++this.t_invariantsProcessed;
                        continue;
                    }
                    ++problems;
                    problemWithInv.append(readedLine).append(",");
                }
                this.projectCore.setT_InvMatrix(this.t_invariantsMatrix, false);
                if (problems == 0) {
                    while (!buffer.readLine().contains("<Invariants names>")) {
                    }
                    this.t_invariantsNames = new ArrayList();
                    line = buffer.readLine();
                    int readLines = 1;
                    go = true;
                    while (go) {
                        line = line.trim();
                        line = Tools.decodeString(line);
                        this.t_invariantsNames.add(line);
                        line = buffer.readLine();
                        if (line.contains("<EOIN>")) {
                            go = false;
                            continue;
                        }
                        ++readLines;
                    }
                    this.projectCore.setT_InvDescriptions(this.t_invariantsNames);
                    if (readLines != this.t_invariantsMatrix.size()) {
                        overlord.log(lang.getText("LOGentry00295a") + this.t_invariantsMatrix.size() + lang.getText("LOGentry00295b") + readLines + lang.getText("LOGentry00295c"), "error", true);
                        return false;
                    }
                } else {
                    overlord.log(lang.getText("LOGentry00296") + " " + String.valueOf(problemWithInv), "error", true);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00297exception") + " " + this.t_invariantsProcessed + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readPInvariants(BufferedReader buffer) {
        try {
            while (!buffer.readLine().contains("<PlaceInv data>")) {
            }
            String line = buffer.readLine();
            int placeNumber = this.projectCore.getPlaces().size();
            StringBuilder problemWithInv = new StringBuilder();
            int problems = 0;
            int readedLine = -1;
            if (!line.contains("<PInvariants: 0>")) {
                boolean go = true;
                this.p_invariantsMatrix = new ArrayList();
                line = buffer.readLine();
                while (go) {
                    ++readedLine;
                    ArrayList<Integer> invariant = new ArrayList<Integer>();
                    line = line.replace(" ", "");
                    String[] tab = line.split(";");
                    for (int i = 1; i < tab.length; ++i) {
                        invariant.add(Integer.parseInt(tab[i]));
                    }
                    line = buffer.readLine();
                    if (line.contains("<EOPI>")) {
                        go = false;
                    }
                    if (invariant.size() == placeNumber) {
                        this.p_invariantsMatrix.add(invariant);
                        ++this.p_invariantsProcessed;
                        continue;
                    }
                    ++problems;
                    problemWithInv.append(readedLine).append(",");
                }
                this.projectCore.setP_InvMatrix(this.p_invariantsMatrix);
                if (problems == 0) {
                    while (!buffer.readLine().contains("<PInvariants names>")) {
                    }
                    this.p_invariantsNames = new ArrayList();
                    line = buffer.readLine();
                    int readLines = 1;
                    go = true;
                    while (go) {
                        line = line.trim();
                        line = Tools.decodeString(line);
                        this.p_invariantsNames.add(line);
                        line = buffer.readLine();
                        if (line.contains("<EOPIN>")) {
                            go = false;
                            continue;
                        }
                        ++readLines;
                    }
                    this.projectCore.setP_InvDescriptions(this.p_invariantsNames);
                    if (readLines != this.p_invariantsMatrix.size()) {
                        overlord.log(lang.getText("LOGentry00298a") + this.p_invariantsMatrix.size() + lang.getText("LOGentry00298b") + readLines + lang.getText("LOGentry00298c"), "error", true);
                        return false;
                    }
                } else {
                    overlord.log(lang.getText("LOGentry00299") + " " + String.valueOf(problemWithInv), "error", true);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00300exception") + " " + this.p_invariantsProcessed + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readMCT(BufferedReader buffer) {
        try {
            while (!buffer.readLine().contains("<MCT data>")) {
            }
            String line = buffer.readLine();
            ArrayList<Transition> transitions = this.projectCore.getTransitions();
            int transNumber = transitions.size();
            StringBuilder problemWithMCTLines = new StringBuilder();
            int problems = 0;
            int readedLine = -1;
            if (!line.contains("<MCT: 0>")) {
                boolean go = true;
                this.mctData = new ArrayList();
                line = buffer.readLine();
                while (go) {
                    String[] tab;
                    ++readedLine;
                    ArrayList<Transition> mct = new ArrayList<Transition>();
                    line = line.replace(" ", "");
                    for (String s : tab = line.split(";")) {
                        int mctNumber = Integer.parseInt(s);
                        if (mctNumber < transNumber) {
                            mct.add(transitions.get(mctNumber));
                            continue;
                        }
                        ++problems;
                        problemWithMCTLines.append(readedLine).append(",");
                    }
                    line = buffer.readLine();
                    if (line.contains("<EOM>")) {
                        go = false;
                    }
                    this.mctData.add(mct);
                    ++this.mctProcessed;
                }
                this.projectCore.setMCTMatrix(this.mctData, false);
                if (problems == 0) {
                    while (!buffer.readLine().contains("<MCT names>")) {
                    }
                    this.mctNames = new ArrayList();
                    line = buffer.readLine();
                    int readLines = 1;
                    go = true;
                    while (go) {
                        line = line.trim();
                        line = Tools.decodeString(line);
                        this.mctNames.add(line);
                        line = buffer.readLine();
                        if (line.contains("<EOIMn>") || line.contains("<EOMn>")) {
                            go = false;
                            continue;
                        }
                        ++readLines;
                    }
                    this.projectCore.setMCTNames(this.mctNames);
                    if (readLines != this.mctData.size()) {
                        overlord.log(lang.getText("LOGentry00301a") + this.mctData.size() + lang.getText("LOGentry00301b") + readLines + lang.getText("LOGentry00301c"), "error", true);
                        return false;
                    }
                } else {
                    overlord.log(lang.getText("LOGentry00302") + " " + String.valueOf(problemWithMCTLines), "error", true);
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00303exception") + " " + this.t_invariantsProcessed + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readStates(BufferedReader buffer) {
        try {
            while (!buffer.readLine().contains("<States data>")) {
            }
            String line = buffer.readLine();
            int readedLine = 0;
            if (line.contains("States: 0")) {
                return false;
            }
            boolean go = true;
            P_StateManager statesMngr = this.projectCore.accessStatesManager();
            statesMngr.resetPN(false);
            line = buffer.readLine();
            try {
                while (go) {
                    String[] tab;
                    ++readedLine;
                    StatePlacesVector pVector = new StatePlacesVector();
                    line = line.replace(" ", "");
                    for (String s : tab = line.split(";")) {
                        pVector.accessVector().add(Double.parseDouble(s));
                    }
                    line = buffer.readLine();
                    line = line.trim();
                    tab = line.split(";");
                    pVector.setStateType(tab[0]);
                    line = buffer.readLine();
                    line = line.trim();
                    line = Tools.decodeString(line);
                    pVector.setDescription(line);
                    line = buffer.readLine();
                    if (line.contains("<EOSt>")) {
                        go = false;
                    }
                    statesMngr.accessStateMatrix().add(pVector);
                }
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00304exception") + "\n" + ex.getMessage(), "error", true);
            }
            if (readedLine / 3 > statesMngr.accessStateMatrix().size()) {
                overlord.log(lang.getText("LOGentry00305") + " " + readedLine, "error", true);
                if (statesMngr.accessStateMatrix().isEmpty()) {
                    statesMngr.createCleanStatePN();
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00306exception") + " " + this.t_invariantsProcessed + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readStatesXTPN(BufferedReader buffer) {
        try {
            while (!buffer.readLine().contains("<States XTPN data>")) {
            }
            String line = buffer.readLine();
            int readedLine = 0;
            if (line.contains("States: 0")) {
                return false;
            }
            boolean go = true;
            P_StateManager statesMngr = this.projectCore.accessStatesManager();
            statesMngr.removeAllMultisets_M(false);
            line = buffer.readLine();
            try {
                int statesProcessed = 0;
                while (go) {
                    ++readedLine;
                    MultisetM pVector = new MultisetM();
                    line = line.replace(" ", "");
                    String[] stateTable = line.split(";");
                    int placesRead = 0;
                    for (String multisetString : stateTable) {
                        if (++placesRead > this.placesProcessed) {
                            overlord.log(lang.getText("LOGentry00307a") + statesProcessed + lang.getText("LOGentry00307b") + " " + lang.getText("LOGentry00307c") + this.placesProcessed + ").", "error", true);
                            break;
                        }
                        String[] multisetTab = multisetString.split(":");
                        ArrayList<Double> multisetK = new ArrayList<Double>();
                        int isXTPNplace = 1;
                        for (String token : multisetTab) {
                            double tokenValue;
                            if (token.contains("(C)")) {
                                token = token.replace("(C)", "");
                                tokenValue = Double.parseDouble(token);
                                multisetK.add(tokenValue);
                                isXTPNplace = 0;
                                break;
                            }
                            tokenValue = Double.parseDouble(token);
                            if (!(tokenValue > -1.0)) continue;
                            multisetK.add(tokenValue);
                        }
                        Collections.sort(multisetK);
                        Collections.reverse(multisetK);
                        pVector.addMultiset_K_toMultiset_M(multisetK, isXTPNplace);
                    }
                    ++statesProcessed;
                    if (placesRead < this.placesProcessed) {
                        for (int i = 0; i < this.placesProcessed - placesRead; ++i) {
                            pVector.addMultiset_K_toMultiset_M(new ArrayList<Double>(), 1);
                        }
                        overlord.log(lang.getText("LOGentry00308a") + statesProcessed + lang.getText("LOGentry00308b") + " " + placesRead + " " + lang.getText("LOGentry00308c") + " " + this.placesProcessed + " " + lang.getText("LOGentry00308d"), "error", true);
                    }
                    line = buffer.readLine();
                    line = line.trim();
                    stateTable = line.split(";");
                    pVector.setStateType(stateTable[0]);
                    line = buffer.readLine();
                    line = line.trim();
                    line = Tools.decodeString(line);
                    pVector.setDescription(line);
                    line = buffer.readLine();
                    if (line.contains("<EOSt>")) {
                        go = false;
                    }
                    statesMngr.accessStateMatrixXTPN().add(pVector);
                }
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00309exception") + " " + this.t_invariantsProcessed + "\n" + ex.getMessage(), "error", true);
            }
            if (readedLine / 3 > statesMngr.accessStateMatrix().size()) {
                overlord.log(lang.getText("LOGentry00310") + " " + readedLine, "error", true);
                if (statesMngr.accessStateMatrix().isEmpty()) {
                    statesMngr.createCleanStatePN();
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00311exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readFiringRates(BufferedReader buffer) {
        try {
            boolean readProtocol;
            SPNdataVectorManager frateMngr;
            int readedLine;
            block31: {
                while (!buffer.readLine().contains("<Firing rates data>")) {
                }
                String line = buffer.readLine();
                readedLine = 0;
                if (line.contains("<FRvectors: 0>")) {
                    return false;
                }
                boolean go = true;
                frateMngr = this.projectCore.accessFiringRatesManager();
                frateMngr.reset(true);
                line = buffer.readLine();
                ++readedLine;
                readProtocol = false;
                try {
                    while (go) {
                        SPNdataVector frVector = new SPNdataVector();
                        String[] dataVectorTable = (line = line.replace(" ", "")).split(";");
                        if (dataVectorTable.length < this.transitionsProcessed + 3) {
                            readProtocol = false;
                            line = buffer.readLine();
                            ++readedLine;
                            line = line.replace(" ", "");
                            String[] tabType = line.split(";");
                            ArrayList<SPNtransitionData> dataVector = new ArrayList<SPNtransitionData>();
                            for (int i = 0; i < dataVectorTable.length; ++i) {
                                TransitionSPNExtension.StochaticsType subType = switch (tabType[i]) {
                                    case "DT" -> TransitionSPNExtension.StochaticsType.DT;
                                    case "IM" -> TransitionSPNExtension.StochaticsType.IM;
                                    case "SchT" -> TransitionSPNExtension.StochaticsType.SchT;
                                    default -> TransitionSPNExtension.StochaticsType.ST;
                                };
                                SPNtransitionData frc = frVector.newContainer(dataVectorTable[i], subType);
                                dataVector.add(frc);
                            }
                            frVector.accessVector().addAll(dataVector);
                        } else {
                            readProtocol = true;
                            frVector.setSPNtype(SPNdataVector.SPNvectorSuperType.SPN);
                            frVector.setDescription("Read errors");
                            ArrayList<SPNtransitionData> dataVector = this.parseSPNdataVector(dataVectorTable, frVector);
                            frVector.accessVector().addAll(dataVector);
                        }
                        line = buffer.readLine();
                        ++readedLine;
                        line = line.trim();
                        dataVectorTable = line.split(";");
                        if (dataVectorTable[0].equals("SSA")) {
                            frVector.setSPNtype(SPNdataVector.SPNvectorSuperType.SSA);
                        } else {
                            frVector.setSPNtype(SPNdataVector.SPNvectorSuperType.SPN);
                        }
                        line = buffer.readLine();
                        ++readedLine;
                        line = line.trim();
                        line = Tools.decodeString(line);
                        frVector.setDescription(line);
                        line = buffer.readLine();
                        ++readedLine;
                        if (line.contains("<EOFRv>")) {
                            go = false;
                            --readedLine;
                        }
                        frateMngr.accessSPNmatrix().add(frVector);
                    }
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00312exception") + " " + readedLine + "\n" + e.getMessage(), "error", true);
                    if (!frateMngr.accessSPNmatrix().isEmpty()) break block31;
                    frateMngr.createCleanSPNdataVector();
                }
            }
            if (!readProtocol) {
                if (readedLine / 4 > frateMngr.accessSPNmatrix().size()) {
                    overlord.log(lang.getText("LOGentry00313"), "error", true);
                    if (frateMngr.accessSPNmatrix().isEmpty()) {
                        frateMngr.createCleanSPNdataVector();
                    } else {
                        frateMngr.reset(false);
                        frateMngr.createCleanSPNdataVector();
                    }
                }
            } else if (readedLine / 3 > frateMngr.accessSPNmatrix().size()) {
                if (frateMngr.accessSPNmatrix().isEmpty()) {
                    frateMngr.createCleanSPNdataVector();
                    overlord.log(lang.getText("LOGentry00313"), "error", true);
                } else {
                    overlord.log(lang.getText("LOGentry00314"), "error", true);
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00315exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private ArrayList<SPNtransitionData> parseSPNdataVector(String[] dataVectorTable, SPNdataVector frVector) {
        ArrayList<SPNtransitionData> spnVector = new ArrayList<SPNtransitionData>();
        if (dataVectorTable[0].contains("version101:")) {
            dataVectorTable[0] = dataVectorTable[0].replace("version101:", "");
            for (int i = 0; i < this.transitionsProcessed; ++i) {
                SPNtransitionData box = frVector.newContainer();
                box.ST_function = dataVectorTable[i * 7];
                try {
                    box.IM_priority = Integer.parseInt(dataVectorTable[i * 7 + 1]);
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00316exception") + "\n" + ex.getMessage(), "error", true);
                }
                try {
                    box.DET_delay = Integer.parseInt(dataVectorTable[i * 7 + 2]);
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00317exception") + "\n" + ex.getMessage(), "error", true);
                }
                box.SCH_start = dataVectorTable[i * 7 + 3];
                try {
                    box.SCH_rep = Integer.parseInt(dataVectorTable[i * 7 + 4]);
                }
                catch (Exception ex) {
                    overlord.log(lang.getText("LOGentry00318exception") + "\n" + ex.getMessage(), "error", true);
                }
                box.SCH_end = dataVectorTable[i * 7 + 5];
                switch (dataVectorTable[i * 7 + 6]) {
                    case "IM": {
                        box.sType = TransitionSPNExtension.StochaticsType.IM;
                        break;
                    }
                    case "DT": {
                        box.sType = TransitionSPNExtension.StochaticsType.DT;
                        break;
                    }
                    case "SchT": {
                        box.sType = TransitionSPNExtension.StochaticsType.SchT;
                        break;
                    }
                    default: {
                        box.sType = TransitionSPNExtension.StochaticsType.ST;
                    }
                }
                spnVector.add(box);
            }
        }
        return spnVector;
    }

    private boolean readSSAvectors(BufferedReader buffer) {
        try {
            while (!buffer.readLine().contains("<SSA vectors data>")) {
            }
            String line = buffer.readLine();
            int readedLine = 0;
            if (line.contains("<SSA vectors: 0>")) {
                return false;
            }
            boolean go = true;
            SSAplacesManager ssaMngr = this.projectCore.accessSSAmanager();
            ssaMngr.reset(true);
            line = buffer.readLine();
            try {
                while (go) {
                    String[] tab;
                    ++readedLine;
                    SSAplacesVector pVector = new SSAplacesVector();
                    line = line.replace(" ", "");
                    for (String s : tab = line.split(";")) {
                        pVector.accessVector().add(Double.parseDouble(s));
                    }
                    line = buffer.readLine();
                    tab = (line = line.trim()).split(";");
                    if (tab[0].equals("CAPACITY") || tab[0].equals("MOLECULES")) {
                        pVector.setType(SSAplacesVector.SSAdataType.MOLECULES);
                    } else {
                        pVector.setType(SSAplacesVector.SSAdataType.CONCENTRATION);
                    }
                    double volume = Double.parseDouble(tab[1]);
                    pVector.setVolume(volume);
                    line = buffer.readLine();
                    line = line.trim();
                    line = Tools.decodeString(line);
                    pVector.setDescription(line);
                    line = buffer.readLine();
                    if (line.contains("<EOSSA>")) {
                        go = false;
                    }
                    ssaMngr.accessSSAmatrix().add(pVector);
                }
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00319exception") + "\n" + ex.getMessage(), "error", true);
            }
            if (readedLine / 3 > ssaMngr.accessSSAmatrix().size()) {
                overlord.log(lang.getText("LOGentry00320") + " " + readedLine, "error", true);
                if (ssaMngr.accessSSAmatrix().isEmpty()) {
                    ssaMngr.createCleanSSAvector();
                }
            }
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00321exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private void setGlobalXY(int x, int y) {
        if (x > this.globalMaxWidth) {
            this.globalMaxWidth = x;
        }
        if (y > this.globalMaxHeight) {
            this.globalMaxHeight = y;
        }
    }

    private void setGraphPanelSize() {
        int nodeSID = overlord.getWorkspace().getSheets().size() - 1;
        int SIN = overlord.IDtoIndex(nodeSID);
        GraphPanel graphPanel = overlord.getWorkspace().getSheets().get(SIN).getGraphPanel();
        graphPanel.setSize(new Dimension(this.globalMaxWidth + 300, this.globalMaxHeight + 200));
        graphPanel.setOriginSize(graphPanel.getSize());
        graphPanel.repaint();
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public ArrayList<Arc> getArcs() {
        return this.arcs;
    }

    private PlaceColored resurrectAsColoredPlace(Place place, int pID) {
        PlaceColored rise = new PlaceColored(pID, 0, new Point(20, 20));
        rise.setPlaceType(Place.PlaceType.CPN);
        rise.setName(place.getName());
        rise.setComment(place.getComment());
        rise.setTokensNumber(place.getTokensNumber());
        rise.setPortal(place.isPortal());
        rise.getElementLocations().clear();
        for (ElementLocation elementLocation : place.getElementLocations()) {
            rise.getElementLocations().add(elementLocation);
        }
        rise.getTextsLocations(GUIManager.locationMoveType.NAME).clear();
        for (ElementLocation elementLocation : place.getTextsLocations(GUIManager.locationMoveType.NAME)) {
            rise.getTextsLocations(GUIManager.locationMoveType.NAME).add(elementLocation);
        }
        rise.getTextsLocations(GUIManager.locationMoveType.GAMMA).clear();
        for (ElementLocation elementLocation : place.getTextsLocations(GUIManager.locationMoveType.GAMMA)) {
            rise.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(elementLocation);
        }
        rise.isColored = true;
        if (this.tabPlaceTokens != null) {
            rise.setColorTokensNumber(Integer.parseInt(this.tabPlaceTokens[0]), 0);
            rise.setColorTokensNumber(Integer.parseInt(this.tabPlaceTokens[1]), 1);
            rise.setColorTokensNumber(Integer.parseInt(this.tabPlaceTokens[2]), 2);
            rise.setColorTokensNumber(Integer.parseInt(this.tabPlaceTokens[3]), 3);
            rise.setColorTokensNumber(Integer.parseInt(this.tabPlaceTokens[4]), 4);
            rise.setColorTokensNumber(Integer.parseInt(this.tabPlaceTokens[5]), 5);
        } else {
            rise.setColorTokensNumber(0, 0);
            rise.setColorTokensNumber(0, 1);
            rise.setColorTokensNumber(0, 2);
            rise.setColorTokensNumber(0, 3);
            rise.setColorTokensNumber(0, 4);
            rise.setColorTokensNumber(0, 5);
        }
        return rise;
    }

    private TransitionColored resurrectAsColoredTransition(Transition transition, int tID) {
        TransitionColored rise = new TransitionColored(tID, 0, new Point(20, 20));
        rise.setTransType(Transition.TransitionType.CPN);
        rise.setName(transition.getName());
        rise.setComment(transition.getComment());
        rise.timeExtension.forceSetEFT(transition.timeExtension.getEFT());
        rise.timeExtension.setLFT(transition.timeExtension.getLFT());
        rise.timeExtension.setDPNduration(transition.timeExtension.getDPNduration());
        rise.timeExtension.setTPNstatus(transition.timeExtension.isTPN());
        rise.timeExtension.setDPNstatus(transition.timeExtension.isDPN());
        rise.fpnExtension.setFunctional(transition.fpnExtension.isFunctional());
        rise.setPortal(transition.isPortal());
        rise.getElementLocations().clear();
        for (ElementLocation elementLocation : transition.getElementLocations()) {
            rise.getElementLocations().add(elementLocation);
        }
        rise.getTextsLocations(GUIManager.locationMoveType.NAME).clear();
        for (ElementLocation elementLocation : transition.getTextsLocations(GUIManager.locationMoveType.NAME)) {
            rise.getTextsLocations(GUIManager.locationMoveType.NAME).add(elementLocation);
        }
        rise.getTextsLocations(GUIManager.locationMoveType.ALPHA).clear();
        for (ElementLocation elementLocation : transition.getTextsLocations(GUIManager.locationMoveType.ALPHA)) {
            rise.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(elementLocation);
        }
        rise.getTextsLocations(GUIManager.locationMoveType.BETA).clear();
        for (ElementLocation elementLocation : transition.getTextsLocations(GUIManager.locationMoveType.BETA)) {
            rise.getTextsLocations(GUIManager.locationMoveType.BETA).add(elementLocation);
        }
        if (this.tabTransReqTokens != null) {
            rise.setRequiredColoredTokens(Integer.parseInt(this.tabTransReqTokens[0]), 0);
            rise.setRequiredColoredTokens(Integer.parseInt(this.tabTransReqTokens[1]), 1);
            rise.setRequiredColoredTokens(Integer.parseInt(this.tabTransReqTokens[2]), 2);
            rise.setRequiredColoredTokens(Integer.parseInt(this.tabTransReqTokens[3]), 3);
            rise.setRequiredColoredTokens(Integer.parseInt(this.tabTransReqTokens[4]), 4);
            rise.setRequiredColoredTokens(Integer.parseInt(this.tabTransReqTokens[5]), 5);
        } else {
            rise.setRequiredColoredTokens(1, 0);
            rise.setRequiredColoredTokens(1, 1);
            rise.setRequiredColoredTokens(1, 2);
            rise.setRequiredColoredTokens(1, 3);
            rise.setRequiredColoredTokens(1, 4);
            rise.setRequiredColoredTokens(1, 5);
        }
        return rise;
    }
}

