/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class MCSoperations {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public static boolean saveSingleMCS(MCSDataMatrix data, int pos, String name) {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("ObjR single MCS data file (.objR)", new String[]{"OBJR"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("MCS_entry001a"), lang.getText("MCS_entry001b"), "");
        if (!((String)selectedFile).isEmpty()) {
            String extension = ".objR";
            if (!((String)selectedFile).contains(extension)) {
                selectedFile = (String)selectedFile + extension;
            }
            try {
                PrintWriter pw = new PrintWriter((String)selectedFile);
                pw.write("Objective reaction: " + name + "\n");
                pw.write("Location:" + pos + "\n");
                Object buffer = "";
                ArrayList<ArrayList<Integer>> dataMatrix = data.getMCSlist(pos);
                ArrayList<ArrayList<Integer>> infoMatrix = data.getMCSlistInfo(pos);
                int currentProcessed = 0;
                for (ArrayList<Integer> set : dataMatrix) {
                    buffer = "[";
                    for (int el : set) {
                        buffer = (String)buffer + el + ",";
                    }
                    buffer = (String)buffer + "]";
                    buffer = ((String)buffer).replace(",]", "]");
                    ArrayList<Integer> infoSet = infoMatrix.get(currentProcessed);
                    buffer = (String)buffer + " info: [";
                    for (int el : infoSet) {
                        buffer = (String)buffer + el + ",";
                    }
                    buffer = (String)buffer + "]";
                    buffer = ((String)buffer).replace(",]", "]\n");
                    ++currentProcessed;
                    pw.write((String)buffer);
                }
                pw.close();
                return true;
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00205exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
        }
        JOptionPane.showMessageDialog(null, lang.getText("MCS_entry002"), lang.getText("MCS_entry003"), 0);
        return false;
    }

    public static boolean saveAllMCS(MCSDataMatrix data) {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("MCS full data file (.mcs)", new String[]{"MCS"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("MCS_entry004a"), lang.getText("MCS_entry004b"), "");
        if (!((String)selectedFile).isEmpty()) {
            String extension = ".mcs";
            if (!((String)selectedFile).contains(extension)) {
                selectedFile = (String)selectedFile + extension;
            }
            try {
                PrintWriter pw = new PrintWriter((String)selectedFile);
                int dataSize = data.accessMCStransitions().size();
                pw.write("MCS list size:" + dataSize + "\n");
                for (int i = 0; i < dataSize; ++i) {
                    Object buffer = "";
                    pw.write("[[" + data.accessMCStransitions().get(i) + "]]\n");
                    ArrayList<ArrayList<Integer>> dataMatrix = data.accessMCSdata().get(i);
                    ArrayList<ArrayList<Integer>> infoMatrix = data.accessMCSinfo().get(i);
                    int currentProcessed = 0;
                    for (ArrayList<Integer> set : dataMatrix) {
                        buffer = "--[";
                        for (int el : set) {
                            buffer = (String)buffer + el + ",";
                        }
                        buffer = (String)buffer + "]";
                        buffer = ((String)buffer).replace(",]", "]");
                        ArrayList<Integer> infoSet = infoMatrix.get(currentProcessed);
                        buffer = (String)buffer + " info: [";
                        for (int el : infoSet) {
                            buffer = (String)buffer + el + ",";
                        }
                        buffer = (String)buffer + "]";
                        buffer = ((String)buffer).replace(",]", "]\n");
                        ++currentProcessed;
                        pw.write((String)buffer);
                    }
                }
                pw.close();
                return true;
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00206exception") + "\n" + e.getMessage(), "error", true);
                return false;
            }
        }
        return false;
    }

    public static boolean loadSingleMCS() {
        FileFilter[] filters;
        String lastPath = overlord.getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("ObjR single MCS data file (.objr)", new String[]{"OBJR"})}, lang.getText("MCS_entry005a"), lang.getText("MCS_entry005b"), "");
        if (selectedFile.isEmpty()) {
            JOptionPane.showMessageDialog(null, lang.getText("MCS_entry006"), lang.getText("MCS_entry006"), 0);
            return false;
        }
        MCSDataMatrix dataCore = overlord.getWorkspace().getProject().getMCSdataCore();
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(selectedFile));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
            String line = "";
            line = buffer.readLine();
            line = line.substring(line.indexOf(":") + 1);
            overlord.accessMCSWindow().accessLogField().append("Read line:" + line + "\n");
            line = buffer.readLine();
            int index = line.indexOf(":");
            line = line.substring(index + 1);
            int insertPos = Integer.parseInt(line);
            int transSize = overlord.getWorkspace().getProject().getTransitions().size();
            int dataSize = dataCore.getSize();
            if (dataSize == 0) {
                dataCore.initiateMCS();
                dataSize = dataCore.getSize();
            }
            if (insertPos >= dataSize) {
                JOptionPane.showMessageDialog(null, lang.getText("MCS_entry008"), lang.getText("MCS_entry007"), 0);
                buffer.close();
                return false;
            }
            overlord.accessMCSWindow().accessLogField().append(lang.getText("MCS_entry009") + " " + overlord.getWorkspace().getProject().getTransitions().get(insertPos).getName() + "\n");
            ArrayList<ArrayList<Integer>> dataMatrix = new ArrayList<ArrayList<Integer>>();
            ArrayList<ArrayList<Integer>> infoMatrix = new ArrayList<ArrayList<Integer>>();
            line = buffer.readLine();
            while (line != null && line.contains("[")) {
                int separator = line.indexOf("info");
                String secondLine = line.substring(separator + 5);
                line = line.substring(0, separator - 1);
                line = line.substring(line.indexOf("[") + 1);
                line = line.substring(0, line.length() - 1);
                String[] numberOfSet = (line = line.trim()).split(",");
                if (numberOfSet.length == 0) {
                    line = buffer.readLine();
                    continue;
                }
                ArrayList<Integer> set = new ArrayList<Integer>();
                for (String element : numberOfSet) {
                    int t = Integer.parseInt(element);
                    if (t >= transSize) {
                        JOptionPane.showMessageDialog(null, lang.getText("MCS_entry010"), lang.getText("MCS_entry007"), 0);
                        buffer.close();
                        overlord.accessMCSWindow().accessLogField().append(lang.getText("LOGentry00207"));
                        return false;
                    }
                    set.add(t);
                }
                dataMatrix.add(set);
                secondLine = secondLine.substring(secondLine.indexOf("[") + 1);
                secondLine = secondLine.substring(0, secondLine.length() - 1);
                secondLine = secondLine.trim();
                String[] secondInfoSet = secondLine.split(",");
                if (secondInfoSet.length == 0) {
                    line = buffer.readLine();
                    continue;
                }
                ArrayList<Integer> infoSet = new ArrayList<Integer>();
                for (String element : secondInfoSet) {
                    int t = Integer.parseInt(element);
                    infoSet.add(t);
                }
                infoMatrix.add(infoSet);
                line = buffer.readLine();
            }
            dataCore.insertMCS(dataMatrix, infoMatrix, insertPos, true);
            overlord.accessMCSWindow().accessLogField().append(lang.getText("LOGentry00208"));
            buffer.close();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00209exception") + "\n" + e.getMessage(), "error", true);
            overlord.accessMCSWindow().accessLogField().append(lang.getText("LOGentry00209exception") + "\n" + e.getMessage() + "\n");
            return false;
        }
    }

    public static boolean loadAllMCS() {
        FileFilter[] filters;
        String lastPath = overlord.getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("MCS full data file (.mcs)", new String[]{"MCS"})}, lang.getText("MCS_entry011a"), lang.getText("MCS_entry011b"), "");
        if (selectedFile.isEmpty()) {
            JOptionPane.showMessageDialog(null, lang.getText("MCSC_entry012"), lang.getText("MCSC_entry007"), 0);
            return false;
        }
        MCSDataMatrix dataCore = overlord.getWorkspace().getProject().getMCSdataCore();
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(selectedFile));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
            String line = "";
            line = buffer.readLine();
            int index = line.indexOf(":");
            line = line.substring(index + 1);
            int dataSize = Integer.parseInt(line);
            int transSize = overlord.getWorkspace().getProject().getTransitions().size();
            if (dataSize != transSize) {
                JOptionPane.showMessageDialog(null, lang.getText("MCSC_entry013"), lang.getText("MCSC_entry007"), 0);
                buffer.close();
                return false;
            }
            if (!dataCore.checkDataReplacing()) {
                buffer.close();
                return false;
            }
            dataCore.initiateMCS();
            line = buffer.readLine();
            int readData = 0;
            while (line != null && line.contains("[[")) {
                ++readData;
                line = buffer.readLine();
                if (line == null) break;
                if (line.contains("[[")) continue;
                ArrayList<ArrayList<Integer>> dataVector = new ArrayList<ArrayList<Integer>>();
                ArrayList<ArrayList<Integer>> infoMatrix = new ArrayList<ArrayList<Integer>>();
                while (line.contains("--")) {
                    int separator = line.indexOf("info");
                    String secondLine = line.substring(separator + 5);
                    line = line.substring(0, separator - 1);
                    line = line.substring(line.indexOf("[") + 1);
                    line = line.substring(0, line.length() - 1);
                    String[] numberOfSet = (line = line.trim()).split(",");
                    if (numberOfSet.length == 0) {
                        line = buffer.readLine();
                        continue;
                    }
                    ArrayList<Integer> set = new ArrayList<Integer>();
                    for (String element : numberOfSet) {
                        int t = Integer.parseInt(element);
                        set.add(t);
                    }
                    dataVector.add(set);
                    secondLine = secondLine.substring(secondLine.indexOf("[") + 1);
                    secondLine = secondLine.substring(0, secondLine.length() - 1);
                    secondLine = secondLine.trim();
                    String[] secondInfoSet = secondLine.split(",");
                    if (secondInfoSet.length == 0) {
                        line = buffer.readLine();
                        continue;
                    }
                    ArrayList<Integer> infoSet = new ArrayList<Integer>();
                    for (String element : secondInfoSet) {
                        int t = Integer.parseInt(element);
                        infoSet.add(t);
                    }
                    infoMatrix.add(infoSet);
                    line = buffer.readLine();
                    if (line != null) continue;
                    break;
                }
                dataCore.insertMCS(dataVector, infoMatrix, readData - 1, false);
            }
            if (transSize != readData) {
                JOptionPane.showMessageDialog(null, lang.getText("MCSC_entry014"), lang.getText("MCSC_entry015"), 2);
            }
            int dataMCSsize = dataCore.getCalculatedMCSnumber();
            overlord.accessMCSWindow().accessLogField().append(lang.getText("MCSC_entry016a") + " " + dataMCSsize + " " + lang.getText("MCSC_entry016b"));
            buffer.close();
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00210exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }
}

