/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import holmes.analyse.SubnetCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.windows.decompositions.HolmesBranchVerticesPrototype;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class IOprotocols {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<ArrayList<Integer>> invariantsList;
    private ArrayList<Integer> nodesList;
    private ArrayList<Node> nodeArray;
    private ArrayList<Arc> arcArray;
    private ArrayList<ElementLocation> elemArray;
    private int MatSiz;
    private String netName;
    private int globalPlaceNumber;
    private int stage;
    private int placeCount;
    private ArrayList<String[]> placeArcListPost;
    private ArrayList<ArrayList<Integer>> placeArcListPostWeight;
    private ArrayList<String[]> placeArcListPre;
    private ArrayList<ArrayList<Integer>> placeArcListPreWeight;

    public IOprotocols() {
        this.resetComponents();
    }

    public ArrayList<ArrayList<Integer>> getInvariantsList() {
        return this.invariantsList;
    }

    private void resetComponents() {
        this.invariantsList = new ArrayList();
        this.nodesList = new ArrayList();
        this.nodeArray = new ArrayList();
        this.arcArray = new ArrayList();
        this.elemArray = new ArrayList();
        this.MatSiz = 99999;
        this.netName = "";
        this.globalPlaceNumber = 0;
        this.stage = 1;
        this.placeCount = 0;
        this.placeArcListPost = new ArrayList();
        this.placeArcListPostWeight = new ArrayList();
        this.placeArcListPre = new ArrayList();
        this.placeArcListPreWeight = new ArrayList();
    }

    public boolean readT_invariants(String path) {
        try {
            String readLine;
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String backup = readLine = buffer.readLine();
            if (!readLine.contains("transition sub/sur/invariants for net")) {
                if (readLine.contains("List of all elementary modes")) {
                    buffer.close();
                    return this.readMonaLisaT_inv(path);
                }
                if (readLine.contains("minimal semipositive transition")) {
                    buffer.close();
                    return this.readCharlieT_inv(path);
                }
                Object[] options = new Object[]{lang.getText("IOP_entry001op1"), lang.getText("IOP_entry001op2"), lang.getText("IOP_entry001op3"), lang.getText("IOP_entry001op4")};
                int decision = JOptionPane.showOptionDialog(null, lang.getText("IOP_entry001msg"), lang.getText("IOP_entry001t"), 0, 2, null, options, options[0]);
                if (decision == 1) {
                    buffer.close();
                    return this.readMonaLisaT_inv(path);
                }
                if (decision == 2) {
                    buffer.close();
                    return this.readCharlieT_inv(path);
                }
                if (decision == 3) {
                    buffer.close();
                    return false;
                }
            }
            if (backup.contains("transition invariants basis")) {
                JOptionPane.showMessageDialog(null, lang.getText("IOP_entry002"), lang.getText("error"), 0);
                buffer.close();
                return false;
            }
            buffer.readLine();
            while (!readLine.contains("semipositive transition invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            this.nodesList.clear();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        this.nodesList.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        overlord.log(lang.getText("LOGentry00157exception") + "\n" + e.getMessage(), "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            this.invariantsList.clear();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != this.nodesList.size()) continue;
                this.invariantsList.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            overlord.log(lang.getText("LOGentry00157"), "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00158exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    public ArrayList<ArrayList<Integer>> readT_invariantsOut(String path) {
        try {
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String readLine = buffer.readLine();
            buffer.readLine();
            while (!readLine.contains("semipositive transition invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            ArrayList<Integer> nodesListTmp = new ArrayList<Integer>();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        nodesListTmp.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        overlord.log(lang.getText("LOGentry00159exception") + "\n" + e.getMessage(), "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            ArrayList<ArrayList<Integer>> invariantsListOut = new ArrayList<ArrayList<Integer>>();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != nodesListTmp.size()) continue;
                invariantsListOut.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            overlord.log(lang.getText("LOGentry00160"), "text", true);
            return invariantsListOut;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00161exception") + "\n" + e.getMessage(), "error", true);
            return new ArrayList<ArrayList<Integer>>();
        }
    }

    public ArrayList<ArrayList<Integer>> readP_invariantsOut(String path) {
        try {
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String readLine = buffer.readLine();
            buffer.readLine();
            while (!readLine.contains("semipositive place invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            ArrayList<Integer> nodesListTmp = new ArrayList<Integer>();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        nodesListTmp.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        overlord.log(lang.getText("LOGentry00162exception") + "\n" + e.getMessage(), "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            ArrayList<ArrayList<Integer>> invariantsListOut = new ArrayList<ArrayList<Integer>>();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != nodesListTmp.size()) continue;
                invariantsListOut.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            overlord.log(lang.getText("LOGentry00163"), "text", true);
            return invariantsListOut;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00164exception") + "\n" + e.getMessage(), "error", true);
            return new ArrayList<ArrayList<Integer>>();
        }
    }

    public boolean readP_invariants(String path) {
        try {
            String readLine;
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String backup = readLine = buffer.readLine();
            if (!readLine.contains("place sub/sur/invariants for net")) {
                if (readLine.contains("List of all place invariants")) {
                    buffer.close();
                    return this.readMonaLisaP_inv(path);
                }
                if (readLine.contains("minimal semipositive place")) {
                    buffer.close();
                    return this.readCharlieP_inv(path);
                }
                Object[] options = new Object[]{lang.getText("IOP_entry003op1"), lang.getText("IOP_entry003op2"), lang.getText("IOP_entry003op3"), lang.getText("IOP_entry003op4")};
                int decision = JOptionPane.showOptionDialog(null, lang.getText("IOP_entry003msg"), lang.getText("IOP_entry003t"), 0, 2, null, options, options[0]);
                if (decision == 1) {
                    buffer.close();
                    return this.readMonaLisaP_inv(path);
                }
                if (decision == 2) {
                    buffer.close();
                    return this.readCharlieP_inv(path);
                }
                if (decision == 3) {
                    buffer.close();
                    return false;
                }
            }
            if (backup.contains("transition invariants basis")) {
                JOptionPane.showMessageDialog(null, lang.getText("LOGentry00165"), lang.getText("error"), 0);
                buffer.close();
                return false;
            }
            buffer.readLine();
            while (!readLine.contains("semipositive place invariants =")) {
                readLine = buffer.readLine();
            }
            buffer.readLine();
            this.nodesList.clear();
            while (!(readLine = buffer.readLine()).endsWith("~~~~~~~~~~~") && !readLine.endsWith("~~~~~~~~~~~")) {
                String[] formattedLine;
                for (String s : formattedLine = readLine.split(" ")) {
                    if (s.isEmpty() || s.contains("Nr.")) continue;
                    try {
                        this.nodesList.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        overlord.log(lang.getText("LOGentry00166exception") + "\n" + e.getMessage(), "text", true);
                    }
                }
            }
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            this.invariantsList.clear();
            while ((readLine = buffer.readLine()) != null && !readLine.contains("@") && !readLine.isEmpty()) {
                String[] formattedLine = readLine.split("\\|");
                for (String s : formattedLine = formattedLine[1].split(" ")) {
                    if (s.isEmpty()) continue;
                    tmpInvariant.add(Integer.parseInt(s));
                }
                if (tmpInvariant.size() != this.nodesList.size()) continue;
                this.invariantsList.add(tmpInvariant);
                tmpInvariant = new ArrayList();
            }
            buffer.close();
            overlord.log(lang.getText("LOGentry00167"), "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00168exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    private boolean readCharlieT_inv(String path) {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String readLine = buffer.readLine();
            if (!readLine.contains("minimal semipositive transition")) {
                Object[] options = new Object[]{lang.getText("IOP_entry004op1"), lang.getText("IOP_entry004op2")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("IOP_entry004msg"), lang.getText("IOP_entry004t"), 0, 2, null, options, options[0]);
                if (n == 1) {
                    buffer.close();
                    return false;
                }
            }
            this.nodesList.clear();
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            boolean firstPass = true;
            ArrayList<Transition> namesCheck = overlord.getWorkspace().getProject().getTransitions();
            int transSetSize = namesCheck.size();
            for (int t = 0; t < transSetSize; ++t) {
                tmpInvariant.add(0);
            }
            readLine = buffer.readLine();
            while (readLine != null && !readLine.isEmpty()) {
                String orgName;
                String lineStart = readLine.substring(0, readLine.indexOf("|"));
                lineStart = lineStart.replace(" ", "");
                if (!(lineStart = lineStart.replace("\t", "")).isEmpty() && !firstPass) {
                    this.invariantsList.add(tmpInvariant);
                    tmpInvariant = new ArrayList();
                    for (int t = 0; t < transSetSize; ++t) {
                        tmpInvariant.add(0);
                    }
                }
                firstPass = false;
                readLine = readLine.substring(readLine.indexOf("|") + 1);
                readLine = readLine.replace(" ", "");
                readLine = readLine.replace("\t", "");
                String tmp = readLine.substring(0, readLine.indexOf("."));
                int transNumber = Integer.parseInt(tmp);
                String transName = (readLine = readLine.substring(readLine.indexOf(".") + 1)).substring(0, readLine.indexOf(":"));
                if (!transName.equals(orgName = namesCheck.get(transNumber).getName())) {
                    overlord.log(lang.getText("LOGentry00169a") + " " + transName + " " + lang.getText("LOGentry00169b") + transNumber + lang.getText("LOGentry00169c") + " " + orgName, "text", true);
                }
                readLine = readLine.substring(readLine.indexOf(":") + 1);
                readLine = readLine.replace(",", "");
                int transValue = Integer.parseInt(readLine);
                if (transNumber >= transSetSize) {
                    overlord.log(lang.getText("LOGentry00170"), "text", true);
                    buffer.close();
                    return false;
                }
                tmpInvariant.set(transNumber, transValue);
                readLine = buffer.readLine();
            }
            this.invariantsList.add(tmpInvariant);
            buffer.close();
            overlord.log(lang.getText("LOGentry00171"), "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00172exception") + "\n" + e.getMessage(), "text", true);
            return false;
        }
    }

    private boolean readCharlieP_inv(String path) {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String readLine = buffer.readLine();
            if (!readLine.contains("minimal semipositive place invariants")) {
                Object[] options = new Object[]{lang.getText("IOP_entry005op1"), lang.getText("IOP_entry005op2")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("IOP_entry005msg"), lang.getText("IOP_entry005t"), 0, 2, null, options, options[0]);
                if (n == 1) {
                    buffer.close();
                    return false;
                }
            }
            this.nodesList.clear();
            ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
            boolean firstPass = true;
            ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
            int placesSetSize = places.size();
            for (int p = 0; p < placesSetSize; ++p) {
                tmpInvariant.add(0);
            }
            readLine = buffer.readLine();
            while (readLine != null && !readLine.isEmpty()) {
                String orgName;
                String lineStart = readLine.substring(0, readLine.indexOf("|"));
                lineStart = lineStart.replace(" ", "");
                if (!(lineStart = lineStart.replace("\t", "")).isEmpty() && !firstPass) {
                    this.invariantsList.add(tmpInvariant);
                    tmpInvariant = new ArrayList();
                    for (int p = 0; p < placesSetSize; ++p) {
                        tmpInvariant.add(0);
                    }
                }
                firstPass = false;
                readLine = readLine.substring(readLine.indexOf("|") + 1);
                readLine = readLine.replace(" ", "");
                readLine = readLine.replace("\t", "");
                String tmp = readLine.substring(0, readLine.indexOf("."));
                int placeNumber = Integer.parseInt(tmp);
                String placeName = (readLine = readLine.substring(readLine.indexOf(".") + 1)).substring(0, readLine.indexOf(":"));
                if (!placeName.equals(orgName = places.get(placeNumber).getName())) {
                    overlord.log(lang.getText("IOP_entry006a") + " " + placeName + " " + lang.getText("IOP_entry006b") + placeNumber + lang.getText("IOP_entry006a") + " " + orgName, "text", true);
                }
                readLine = readLine.substring(readLine.indexOf(":") + 1);
                readLine = readLine.replace(",", "");
                int transValue = Integer.parseInt(readLine);
                if (placeNumber >= placesSetSize) {
                    overlord.log(lang.getText("LOGentry00173"), "text", true);
                    buffer.close();
                    return false;
                }
                tmpInvariant.set(placeNumber, transValue);
                readLine = buffer.readLine();
            }
            this.invariantsList.add(tmpInvariant);
            buffer.close();
            overlord.log(lang.getText("LOGentry00174"), "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00175exception") + "\n" + e.getMessage(), "text", true);
            return false;
        }
    }

    private boolean readMonaLisaT_inv(String path) {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String line = buffer.readLine();
            if (!line.contains("# List of all elementary modes")) {
                Object[] options = new Object[]{lang.getText("IOP_entry007op1"), lang.getText("IOP_entry007op2")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("IOP_entry007msg"), lang.getText("IOP_entry007t"), 0, 2, null, options, options[0]);
                if (n == 1) {
                    buffer.close();
                    return false;
                }
            }
            this.nodesList.clear();
            ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
            int transSetSize = transitions.size();
            line = buffer.readLine();
            while (line != null && line.contains("Elementary")) {
                ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
                for (int t = 0; t < transSetSize; ++t) {
                    tmpInvariant.add(0);
                }
                String lineNumber = line.substring(0, line.indexOf("."));
                try {
                    String[] tablica;
                    line = line.substring(line.indexOf(":") + 1);
                    line = line.trim();
                    for (String el : tablica = line.split(" ")) {
                        if (el.contains("*")) {
                            String valueS = el.substring(0, el.indexOf("*"));
                            int value = Integer.parseInt(valueS);
                            el = el.substring(el.indexOf("*") + 1);
                            int trans = Integer.parseInt(el);
                            tmpInvariant.set(--trans, value);
                            continue;
                        }
                        int trans = Integer.parseInt(el);
                        tmpInvariant.set(--trans, 1);
                    }
                    this.invariantsList.add(tmpInvariant);
                    line = buffer.readLine();
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00176exception") + " #" + lineNumber + "\n" + e.getMessage(), "error", true);
                    line = buffer.readLine();
                }
            }
            buffer.close();
            overlord.log(lang.getText("LOGentry00177"), "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00178exception") + "\n" + e.getMessage(), "text", true);
            return false;
        }
    }

    private boolean readMonaLisaP_inv(String path) {
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(path));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String line = buffer.readLine();
            if (!line.contains("# List of all place invariants")) {
                Object[] options = new Object[]{lang.getText("IOP_entry008op1"), lang.getText("IOP_entry008op2")};
                int n = JOptionPane.showOptionDialog(null, lang.getText("IOP_entry008msg"), lang.getText("IOP_entry008t"), 0, 2, null, options, options[0]);
                if (n == 1) {
                    buffer.close();
                    return false;
                }
            }
            this.nodesList.clear();
            ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
            int placesSetSize = places.size();
            line = buffer.readLine();
            while (line != null && line.contains("Place")) {
                ArrayList<Integer> tmpInvariant = new ArrayList<Integer>();
                for (int t = 0; t < placesSetSize; ++t) {
                    tmpInvariant.add(0);
                }
                String lineNumber = line.substring(0, line.indexOf("."));
                try {
                    String[] tablica;
                    line = line.substring(line.indexOf(":") + 1);
                    line = line.trim();
                    for (String el : tablica = line.split(" ")) {
                        if (el.contains("*")) {
                            String valueS = el.substring(0, el.indexOf("*"));
                            int value = Integer.parseInt(valueS);
                            el = el.substring(el.indexOf("*") + 1);
                            int place = Integer.parseInt(el);
                            tmpInvariant.set(--place, value);
                            continue;
                        }
                        int trans = Integer.parseInt(el);
                        tmpInvariant.set(--trans, 1);
                    }
                    this.invariantsList.add(tmpInvariant);
                    line = buffer.readLine();
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00179exception") + " #" + lineNumber + "\n" + e.getMessage(), "error", true);
                    line = buffer.readLine();
                }
            }
            buffer.close();
            overlord.log(lang.getText("LOGentry00180"), "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00181exception") + "\n" + e.getMessage(), "text", true);
            return false;
        }
    }

    public void writeT_invINA(String path, ArrayList<ArrayList<Integer>> invariants, ArrayList<Transition> transitions) {
        try {
            int i;
            String extension = "";
            if (!path.contains(".inv")) {
                extension = ".inv";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            pw.print("transition sub/sur/invariants for net 0.t\r\n");
            pw.print("\r\n");
            pw.print("semipositive transition invariants =\r\n");
            pw.print("\r\n");
            pw.print("Nr.      ");
            int delimiter = 13;
            if (transitions.size() < 100) {
                delimiter = 17;
            }
            int multipl = 1;
            int transNo = invariants.get(0).size();
            for (i = 0; i < transitions.size(); ++i) {
                if (transNo >= 100) {
                    pw.print(this.convertIntToStr(true, i));
                } else {
                    pw.print(this.convertIntToStr(false, i));
                }
                if (i != multipl * delimiter - 1) continue;
                pw.print("\r\n");
                pw.print("        ");
                ++multipl;
            }
            pw.print("\r\n");
            pw.print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            pw.print("\r\n");
            for (i = 0; i < invariants.size(); ++i) {
                if (transNo >= 100) {
                    pw.print(this.convertIntToStr(true, i) + " |   ");
                } else {
                    pw.print(this.convertIntToStr(false, i) + " |   ");
                }
                multipl = 1;
                for (int t = 0; t < invariants.get(i).size(); ++t) {
                    int tr = invariants.get(i).get(t);
                    if (transNo >= 100) {
                        pw.print(this.convertIntToStr(true, tr));
                    } else {
                        pw.print(this.convertIntToStr(false, tr));
                    }
                    if (t != multipl * delimiter - 1) continue;
                    pw.print("\r\n");
                    if (transNo >= 100) {
                        pw.print("      |   ");
                    } else {
                        pw.print("     |   ");
                    }
                    ++multipl;
                }
                pw.print("\r\n");
            }
            pw.print("\r\n");
            pw.print("@");
            pw.close();
            overlord.log(lang.getText("LOGentry00182") + " " + path, "text", true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, lang.getText("LOGentry00183exception") + "\n" + e.getMessage(), lang.getText("error"), 0);
            overlord.log(lang.getText("LOGentry00183exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void writeP_invINA(String path, ArrayList<ArrayList<Integer>> invariants, ArrayList<Place> places) {
        try {
            int i;
            String extension = "";
            if (!path.contains(".inv")) {
                extension = ".inv";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            pw.print("place sub/sur/invariants for net 0.net.pnt        :\r\n");
            pw.print("\r\n");
            pw.print("semipositive place invariants =\r\n");
            pw.print("\r\n");
            pw.print("Nr.      ");
            int delimiter = 13;
            if (places.size() < 100) {
                delimiter = 17;
            }
            int multipl = 1;
            int placesNo = invariants.get(0).size();
            for (i = 0; i < places.size(); ++i) {
                if (placesNo >= 100) {
                    pw.print(this.convertIntToStr(true, i));
                } else {
                    pw.print(this.convertIntToStr(false, i));
                }
                if (i != multipl * delimiter - 1) continue;
                pw.print("\r\n");
                pw.print("        ");
                ++multipl;
            }
            pw.print("\r\n");
            pw.print("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            pw.print("\r\n");
            for (i = 0; i < invariants.size(); ++i) {
                if (placesNo >= 100) {
                    pw.print(this.convertIntToStr(true, i) + " |   ");
                } else {
                    pw.print(this.convertIntToStr(false, i) + " |   ");
                }
                multipl = 1;
                for (int t = 0; t < invariants.get(i).size(); ++t) {
                    int tr = invariants.get(i).get(t);
                    if (placesNo >= 100) {
                        pw.print(this.convertIntToStr(true, tr));
                    } else {
                        pw.print(this.convertIntToStr(false, tr));
                    }
                    if (t != multipl * delimiter - 1) continue;
                    pw.print("\r\n");
                    if (placesNo >= 100) {
                        pw.print("      |   ");
                    } else {
                        pw.print("     |   ");
                    }
                    ++multipl;
                }
                pw.print("\r\n");
            }
            pw.print("\r\n");
            pw.print("@");
            pw.close();
            overlord.log(lang.getText("LOGentry00184") + " " + path, "text", true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, lang.getText("LOGentry00185exception") + "\n" + e.getMessage(), lang.getText("error"), 0);
            overlord.log(lang.getText("LOGentry00185exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    private String convertIntToStr(boolean large, int tr) {
        if (large) {
            if (tr < 10) {
                return "    " + tr;
            }
            if (tr < 100) {
                return "   " + tr;
            }
            if (tr < 1000) {
                return "  " + tr;
            }
            return " " + tr;
        }
        if (tr < 10) {
            return "   " + tr;
        }
        if (tr < 100) {
            return "  " + tr;
        }
        return " " + tr;
    }

    public String getFileName(String sciezka) {
        String[] tablica = sciezka.split("\\\\");
        return tablica[tablica.length - 1];
    }

    public ArrayList<Node> getNodeArray() {
        return this.nodeArray;
    }

    public ArrayList<Arc> getArcArray() {
        return this.arcArray;
    }

    public PetriNet serverReadPNT(String sciezka, int SID) {
        try {
            this.resetComponents();
            DataInputStream in = new DataInputStream(new FileInputStream(sciezka));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String wczytanaLinia = buffer.readLine();
            String[] tabWczytanaLinia = wczytanaLinia.split(":");
            this.netName = tabWczytanaLinia[1];
            int[][] trans = new int[this.MatSiz][2];
            int ID = 0;
            String[] wID = new String[this.MatSiz];
            int[] wMark = new int[this.MatSiz];
            ArrayList<Integer> wagiWej = new ArrayList<Integer>();
            ArrayList<Integer> wagiWyj = new ArrayList<Integer>();
            while ((wczytanaLinia = buffer.readLine()) != null) {
                if (wczytanaLinia.equals("@")) {
                    ++this.stage;
                }
                switch (this.stage) {
                    case 1: {
                        ArrayList<String> tmpStringWej = new ArrayList<String>();
                        ArrayList<String> tmpStringWyj = new ArrayList<String>();
                        wczytanaLinia = wczytanaLinia.replace(",", " , ");
                        wczytanaLinia = wczytanaLinia.replace(":", " : ");
                        String[] WczytanyString = wczytanaLinia.split(" ");
                        int poz = 0;
                        int poZap = 0;
                        block17: for (String s : WczytanyString) {
                            if (s.isEmpty() || Character.isWhitespace(s.charAt(0))) continue;
                            if (s.contains(",")) {
                                poZap = poz;
                                poz = 5;
                            }
                            if (s.contains(":")) {
                                poZap = poz;
                                poz = 4;
                            }
                            switch (poz) {
                                case 0: {
                                    wID[ID] = s;
                                    ++poz;
                                    continue block17;
                                }
                                case 1: {
                                    wMark[ID] = Integer.parseInt(s);
                                    ++ID;
                                    ++poz;
                                    continue block17;
                                }
                                case 2: {
                                    tmpStringWej.add(s);
                                    wagiWej.add(1);
                                    continue block17;
                                }
                                case 3: {
                                    tmpStringWyj.add(s);
                                    wagiWyj.add(1);
                                    continue block17;
                                }
                                case 4: {
                                    if (s.contains(":")) continue block17;
                                    if (poZap == 2) {
                                        wagiWej.remove(wagiWej.size() - 1);
                                        wagiWej.add(Integer.parseInt(s));
                                    } else {
                                        wagiWyj.remove(wagiWyj.size() - 1);
                                        wagiWyj.add(Integer.parseInt(s));
                                    }
                                    poz = poZap;
                                    continue block17;
                                }
                                case 5: {
                                    poz = poZap;
                                    ++poz;
                                }
                            }
                        }
                        String[] a = new String[tmpStringWej.size()];
                        this.placeArcListPre.add(tmpStringWej.toArray(a));
                        this.placeArcListPreWeight.add(wagiWej);
                        a = new String[tmpStringWyj.size()];
                        this.placeArcListPost.add(tmpStringWyj.toArray(a));
                        this.placeArcListPostWeight.add(wagiWyj);
                        break;
                    }
                    case 2: {
                        if (wczytanaLinia.contains("capacity") && wczytanaLinia.contains("time") && wczytanaLinia.contains("name") || wczytanaLinia.equals("@")) break;
                        tabWczytanaLinia = wczytanaLinia.split(": ");
                        int placeNumber = this.globalPlaceNumber++;
                        tabWczytanaLinia = tabWczytanaLinia[1].split(" ");
                        String placeName = tabWczytanaLinia[0];
                        Place tmpPlace = new Place(placeNumber, new ArrayList<ElementLocation>(), placeName, "", wMark[placeNumber]);
                        ArrayList<ElementLocation> namesLoc = new ArrayList<ElementLocation>();
                        namesLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(namesLoc, GUIManager.locationMoveType.NAME);
                        ArrayList<ElementLocation> alphaLoc = new ArrayList<ElementLocation>();
                        alphaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(alphaLoc, GUIManager.locationMoveType.ALPHA);
                        ArrayList<ElementLocation> betaLoc = new ArrayList<ElementLocation>();
                        betaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(betaLoc, GUIManager.locationMoveType.BETA);
                        ArrayList<ElementLocation> gammaLoc = new ArrayList<ElementLocation>();
                        gammaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(gammaLoc, GUIManager.locationMoveType.GAMMA);
                        ArrayList<ElementLocation> tauLoc = new ArrayList<ElementLocation>();
                        tauLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(tauLoc, GUIManager.locationMoveType.TAU);
                        this.nodeArray.add(tmpPlace);
                        break;
                    }
                    case 3: {
                        String[] tmp5;
                        if (wczytanaLinia.contains("priority") && wczytanaLinia.contains("time") && wczytanaLinia.contains("name") || wczytanaLinia.equals("@")) {
                            this.placeCount = this.globalPlaceNumber;
                            break;
                        }
                        tabWczytanaLinia = wczytanaLinia.split(": ");
                        for (String s : tmp5 = tabWczytanaLinia[0].split(" ")) {
                            if (s.isEmpty()) continue;
                            trans[Integer.parseInt((String)s)][0] = Integer.parseInt(s);
                            trans[Integer.parseInt((String)s)][1] = ++this.globalPlaceNumber;
                        }
                        int transNumber = this.globalPlaceNumber;
                        tabWczytanaLinia = tabWczytanaLinia[1].split(" ");
                        String transName = tabWczytanaLinia[0];
                        Transition tmpTrans = new Transition(transNumber, new ArrayList<ElementLocation>(), transName, "");
                        ArrayList<ElementLocation> namesLoc = new ArrayList<ElementLocation>();
                        namesLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(namesLoc, GUIManager.locationMoveType.NAME);
                        ArrayList<ElementLocation> alphaLoc = new ArrayList<ElementLocation>();
                        alphaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(alphaLoc, GUIManager.locationMoveType.ALPHA);
                        ArrayList<ElementLocation> betaLoc = new ArrayList<ElementLocation>();
                        betaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(betaLoc, GUIManager.locationMoveType.BETA);
                        ArrayList<ElementLocation> gammaLoc = new ArrayList<ElementLocation>();
                        gammaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(gammaLoc, GUIManager.locationMoveType.GAMMA);
                        ArrayList<ElementLocation> tauLoc = new ArrayList<ElementLocation>();
                        tauLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(tauLoc, GUIManager.locationMoveType.TAU);
                        this.nodeArray.add(tmpTrans);
                        break;
                    }
                    case 4: {
                        int k;
                        for (int j = 0; j < this.nodeArray.size(); ++j) {
                            ArrayList<ElementLocation> tempElementLocationArry;
                            if (this.nodeArray.get(j).getType() == PetriNetElement.PetriNetElementType.PLACE) {
                                this.elemArray.add(new ElementLocation(SID, new Point(80, 30 + j * 60), this.nodeArray.get(j)));
                                tempElementLocationArry = new ArrayList<ElementLocation>();
                                tempElementLocationArry.add(this.elemArray.get(j));
                                this.nodeArray.get(j).setElementLocations(tempElementLocationArry);
                            }
                            if (this.nodeArray.get(j).getType() != PetriNetElement.PetriNetElementType.TRANSITION) continue;
                            this.elemArray.add(new ElementLocation(SID, new Point(280, 30 + (j - this.placeCount) * 60), this.nodeArray.get(j)));
                            tempElementLocationArry = new ArrayList();
                            tempElementLocationArry.add(this.elemArray.get(j));
                            this.nodeArray.get(j).setElementLocations(tempElementLocationArry);
                        }
                        int pozycja_a = 0;
                        for (k = 0; k < this.placeArcListPre.size(); ++k) {
                            for (int j = 0; j < this.placeArcListPre.get(k).length; ++j) {
                                int t1 = trans[Integer.parseInt(this.placeArcListPre.get(k)[j])][1];
                                this.arcArray.add(new Arc(this.nodeArray.get(t1 - 1).getLastLocation(), this.nodeArray.get(k).getLastLocation(), "", this.placeArcListPreWeight.get(0).get(pozycja_a), Arc.TypeOfArc.NORMAL));
                                ++pozycja_a;
                            }
                        }
                        pozycja_a = 0;
                        for (k = 0; k < this.placeArcListPost.size(); ++k) {
                            for (int j = 0; j < this.placeArcListPost.get(k).length; ++j) {
                                int t2 = trans[Integer.parseInt(this.placeArcListPost.get(k)[j])][1];
                                this.arcArray.add(new Arc(this.nodeArray.get(k).getLastLocation(), this.nodeArray.get(t2 - 1).getLastLocation(), "", this.placeArcListPostWeight.get(0).get(pozycja_a), Arc.TypeOfArc.NORMAL));
                                ++pozycja_a;
                            }
                        }
                        break;
                    }
                }
            }
            in.close();
            overlord.log(lang.getText("LOGentry00186"), "text", true);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00187exception") + "\n" + e.getMessage(), "error", true);
        }
        return new PetriNet(this.nodeArray, this.arcArray);
    }

    public void readPNT(String sciezka) {
        try {
            this.resetComponents();
            int SID = overlord.getWorkspace().getProject().returnCleanSheetID();
            DataInputStream in = new DataInputStream(new FileInputStream(sciezka));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String readLine = buffer.readLine();
            String[] tabWczytanaLinia = readLine.split(":");
            this.netName = tabWczytanaLinia[1];
            int[][] trans = new int[this.MatSiz][2];
            int ID = 0;
            String[] wID = new String[this.MatSiz];
            int[] wMark = new int[this.MatSiz];
            ArrayList<Integer> wagiWej = new ArrayList<Integer>();
            ArrayList<Integer> wagiWyj = new ArrayList<Integer>();
            while ((readLine = buffer.readLine()) != null) {
                if (readLine.equals("@")) {
                    ++this.stage;
                }
                switch (this.stage) {
                    case 1: {
                        ArrayList<String> tmpStringWej = new ArrayList<String>();
                        ArrayList<String> tmpStringWyj = new ArrayList<String>();
                        readLine = readLine.replace(",", " , ");
                        readLine = readLine.replace(":", " : ");
                        String[] WczytanyString = readLine.split(" ");
                        int poz = 0;
                        int poZap = 0;
                        block17: for (String s : WczytanyString) {
                            if (s.isEmpty() || Character.isWhitespace(s.charAt(0))) continue;
                            if (s.contains(",")) {
                                poZap = poz;
                                poz = 5;
                            }
                            if (s.contains(":")) {
                                poZap = poz;
                                poz = 4;
                            }
                            switch (poz) {
                                case 0: {
                                    wID[ID] = s;
                                    ++poz;
                                    continue block17;
                                }
                                case 1: {
                                    wMark[ID] = Integer.parseInt(s);
                                    ++ID;
                                    ++poz;
                                    continue block17;
                                }
                                case 2: {
                                    tmpStringWej.add(s);
                                    wagiWej.add(1);
                                    continue block17;
                                }
                                case 3: {
                                    tmpStringWyj.add(s);
                                    wagiWyj.add(1);
                                    continue block17;
                                }
                                case 4: {
                                    if (s.contains(":")) continue block17;
                                    if (poZap == 2) {
                                        wagiWej.remove(wagiWej.size() - 1);
                                        wagiWej.add(Integer.parseInt(s));
                                    } else {
                                        wagiWyj.remove(wagiWyj.size() - 1);
                                        wagiWyj.add(Integer.parseInt(s));
                                    }
                                    poz = poZap;
                                    continue block17;
                                }
                                case 5: {
                                    poz = poZap;
                                    ++poz;
                                }
                            }
                        }
                        String[] a = new String[tmpStringWej.size()];
                        this.placeArcListPre.add(tmpStringWej.toArray(a));
                        this.placeArcListPreWeight.add(wagiWej);
                        a = new String[tmpStringWyj.size()];
                        this.placeArcListPost.add(tmpStringWyj.toArray(a));
                        this.placeArcListPostWeight.add(wagiWyj);
                        break;
                    }
                    case 2: {
                        if (readLine.contains("capacity") && readLine.contains("time") && readLine.contains("name") || readLine.equals("@")) break;
                        tabWczytanaLinia = readLine.split(": ");
                        int placeNumber = this.globalPlaceNumber++;
                        tabWczytanaLinia = tabWczytanaLinia[1].split(" ");
                        String placeName = tabWczytanaLinia[0];
                        Place tmpPlace = new Place(placeNumber, new ArrayList<ElementLocation>(), placeName, "", wMark[placeNumber]);
                        ArrayList<ElementLocation> namesLoc = new ArrayList<ElementLocation>();
                        namesLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(namesLoc, GUIManager.locationMoveType.NAME);
                        ArrayList<ElementLocation> alphaLoc = new ArrayList<ElementLocation>();
                        alphaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(alphaLoc, GUIManager.locationMoveType.ALPHA);
                        ArrayList<ElementLocation> betaLoc = new ArrayList<ElementLocation>();
                        betaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(betaLoc, GUIManager.locationMoveType.BETA);
                        ArrayList<ElementLocation> gammaLoc = new ArrayList<ElementLocation>();
                        gammaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(gammaLoc, GUIManager.locationMoveType.GAMMA);
                        ArrayList<ElementLocation> tauLoc = new ArrayList<ElementLocation>();
                        tauLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpPlace.setTextsLocations(tauLoc, GUIManager.locationMoveType.TAU);
                        this.nodeArray.add(tmpPlace);
                        break;
                    }
                    case 3: {
                        String[] tmp5;
                        if (readLine.contains("priority") && readLine.contains("time") && readLine.contains("name") || readLine.equals("@")) {
                            this.placeCount = this.globalPlaceNumber;
                            break;
                        }
                        tabWczytanaLinia = readLine.split(": ");
                        for (String s : tmp5 = tabWczytanaLinia[0].split(" ")) {
                            if (s.isEmpty()) continue;
                            trans[Integer.parseInt((String)s)][0] = Integer.parseInt(s);
                            trans[Integer.parseInt((String)s)][1] = ++this.globalPlaceNumber;
                        }
                        int transNumber = this.globalPlaceNumber;
                        tabWczytanaLinia = tabWczytanaLinia[1].split(" ");
                        String transName = tabWczytanaLinia[0];
                        Transition tmpTrans = new Transition(transNumber, new ArrayList<ElementLocation>(), transName, "");
                        ArrayList<ElementLocation> namesLoc = new ArrayList<ElementLocation>();
                        namesLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(namesLoc, GUIManager.locationMoveType.NAME);
                        ArrayList<ElementLocation> alphaLoc = new ArrayList<ElementLocation>();
                        alphaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(alphaLoc, GUIManager.locationMoveType.ALPHA);
                        ArrayList<ElementLocation> betaLoc = new ArrayList<ElementLocation>();
                        betaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(betaLoc, GUIManager.locationMoveType.BETA);
                        ArrayList<ElementLocation> gammaLoc = new ArrayList<ElementLocation>();
                        gammaLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(gammaLoc, GUIManager.locationMoveType.GAMMA);
                        ArrayList<ElementLocation> tauLoc = new ArrayList<ElementLocation>();
                        tauLoc.add(new ElementLocation(0, new Point(0, 0), null));
                        tmpTrans.setTextsLocations(tauLoc, GUIManager.locationMoveType.TAU);
                        this.nodeArray.add(tmpTrans);
                        break;
                    }
                    case 4: {
                        int k;
                        for (int j = 0; j < this.nodeArray.size(); ++j) {
                            ArrayList<ElementLocation> tempElementLocationArry;
                            if (this.nodeArray.get(j).getType() == PetriNetElement.PetriNetElementType.PLACE) {
                                this.elemArray.add(new ElementLocation(SID, new Point(80, 30 + j * 60), this.nodeArray.get(j)));
                                tempElementLocationArry = new ArrayList<ElementLocation>();
                                tempElementLocationArry.add(this.elemArray.get(j));
                                this.nodeArray.get(j).setElementLocations(tempElementLocationArry);
                            }
                            if (this.nodeArray.get(j).getType() != PetriNetElement.PetriNetElementType.TRANSITION) continue;
                            this.elemArray.add(new ElementLocation(SID, new Point(280, 30 + (j - this.placeCount) * 60), this.nodeArray.get(j)));
                            tempElementLocationArry = new ArrayList();
                            tempElementLocationArry.add(this.elemArray.get(j));
                            this.nodeArray.get(j).setElementLocations(tempElementLocationArry);
                        }
                        int pozycja_a = 0;
                        for (k = 0; k < this.placeArcListPre.size(); ++k) {
                            for (int j = 0; j < this.placeArcListPre.get(k).length; ++j) {
                                int t1 = trans[Integer.parseInt(this.placeArcListPre.get(k)[j])][1];
                                this.arcArray.add(new Arc(this.nodeArray.get(t1 - 1).getLastLocation(), this.nodeArray.get(k).getLastLocation(), "", this.placeArcListPreWeight.get(0).get(pozycja_a), Arc.TypeOfArc.NORMAL));
                                ++pozycja_a;
                            }
                        }
                        pozycja_a = 0;
                        for (k = 0; k < this.placeArcListPost.size(); ++k) {
                            for (int j = 0; j < this.placeArcListPost.get(k).length; ++j) {
                                int t2 = trans[Integer.parseInt(this.placeArcListPost.get(k)[j])][1];
                                this.arcArray.add(new Arc(this.nodeArray.get(k).getLastLocation(), this.nodeArray.get(t2 - 1).getLastLocation(), "", this.placeArcListPostWeight.get(0).get(pozycja_a), Arc.TypeOfArc.NORMAL));
                                ++pozycja_a;
                            }
                        }
                        int wid = Toolkit.getDefaultToolkit().getScreenSize().width - 20;
                        int hei = Toolkit.getDefaultToolkit().getScreenSize().height - 20;
                        int SIN = overlord.IDtoIndex(SID);
                        int tmpX = 0;
                        int tmpY = 0;
                        boolean xFound = false;
                        boolean yFound = false;
                        GraphPanel graphPanel = overlord.getWorkspace().getSheets().get(SIN).getGraphPanel();
                        for (int l = 0; l < this.elemArray.size(); ++l) {
                            if (this.elemArray.get((int)l).getPosition().x > wid) {
                                tmpX = l;
                                xFound = true;
                                wid = this.elemArray.get((int)l).getPosition().x;
                            }
                            if (this.elemArray.get((int)l).getPosition().y <= hei) continue;
                            tmpY = l;
                            yFound = true;
                            hei = this.elemArray.get((int)l).getPosition().y;
                        }
                        if (xFound && !yFound) {
                            graphPanel.setSize(new Dimension(this.elemArray.get((int)tmpX).getPosition().x + 90, graphPanel.getSize().height));
                        }
                        if (!xFound && yFound) {
                            graphPanel.setSize(new Dimension(graphPanel.getSize().width, this.elemArray.get((int)tmpY).getPosition().y + 90));
                        }
                        if (xFound && yFound) {
                            graphPanel.setSize(new Dimension(this.elemArray.get((int)tmpX).getPosition().x + 90, this.elemArray.get((int)tmpY).getPosition().y + 90));
                        }
                        graphPanel.setOriginSize(graphPanel.getSize());
                    }
                }
            }
            in.close();
            overlord.log(lang.getText("LOGentry00188"), "text", true);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00189exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public boolean writePNT(String path, ArrayList<Place> placeList, ArrayList<Transition> transitionList, ArrayList<Arc> arcList) {
        StringBuilder fileBuffer = new StringBuilder("P   M   PRE,POST  NETZ 0:");
        try {
            int i;
            PrintWriter writerObject = new PrintWriter(path);
            fileBuffer.append(this.getFileName(path));
            fileBuffer.append("\r\n");
            for (i = 0; i < placeList.size(); ++i) {
                int j;
                if (i < 9) {
                    fileBuffer.append(" ");
                }
                if (i < 99) {
                    fileBuffer.append(" ");
                }
                fileBuffer.append(i);
                fileBuffer.append(" ");
                fileBuffer.append(placeList.get(i).getTokensNumber());
                fileBuffer.append("    ");
                if (placeList.get(i).getInputArcs().isEmpty() && placeList.get(i).getOutputArcs().isEmpty()) {
                    fileBuffer.append(" ");
                }
                if (!placeList.get(i).getInputArcs().isEmpty() && placeList.get(i).getOutputArcs().isEmpty()) {
                    for (j = 0; j < placeList.get(i).getInputArcs().size(); ++j) {
                        if (!transitionList.contains((Transition)placeList.get(i).getInputArcs().get(j).getStartNode())) continue;
                        fileBuffer.append(" ");
                        fileBuffer.append(transitionList.indexOf((Transition)placeList.get(i).getInputArcs().get(j).getStartNode()));
                        if (placeList.get(i).getInputArcs().get(j).getWeight() <= 1) continue;
                        fileBuffer.append(": ").append(placeList.get(i).getInputArcs().get(j).getWeight());
                    }
                }
                if (!placeList.get(i).getInputArcs().isEmpty() && !placeList.get(i).getOutputArcs().isEmpty()) {
                    for (j = 0; j < placeList.get(i).getInputArcs().size(); ++j) {
                        if (!transitionList.contains((Transition)placeList.get(i).getInputArcs().get(j).getStartNode())) continue;
                        fileBuffer.append(" ");
                        fileBuffer.append(transitionList.indexOf((Transition)placeList.get(i).getInputArcs().get(j).getStartNode()));
                        if (placeList.get(i).getInputArcs().get(j).getWeight() <= 1) continue;
                        fileBuffer.append(": ").append(placeList.get(i).getInputArcs().get(j).getWeight());
                    }
                    fileBuffer.append(",");
                    for (j = 0; j < placeList.get(i).getOutputArcs().size(); ++j) {
                        if (!transitionList.contains((Transition)placeList.get(i).getOutputArcs().get(j).getEndNode())) continue;
                        fileBuffer.append(" ");
                        fileBuffer.append(transitionList.indexOf((Transition)placeList.get(i).getOutputArcs().get(j).getEndNode()));
                        if (placeList.get(i).getOutputArcs().get(j).getWeight() <= 1) continue;
                        fileBuffer.append(": ").append(placeList.get(i).getOutputArcs().get(j).getWeight());
                    }
                }
                if (placeList.get(i).getInputArcs().isEmpty() && !placeList.get(i).getOutputArcs().isEmpty()) {
                    fileBuffer.append(",");
                    for (j = 0; j < placeList.get(i).getOutputArcs().size(); ++j) {
                        if (!transitionList.contains((Transition)placeList.get(i).getOutputArcs().get(j).getEndNode())) continue;
                        fileBuffer.append(" ");
                        fileBuffer.append(transitionList.indexOf((Transition)placeList.get(i).getOutputArcs().get(j).getEndNode()));
                        if (placeList.get(i).getOutputArcs().get(j).getWeight() <= 1) continue;
                        fileBuffer.append(": ").append(placeList.get(i).getOutputArcs().get(j).getWeight());
                    }
                }
                fileBuffer.append("\r\n");
            }
            fileBuffer.append("@\r\n");
            fileBuffer.append("place nr.             name capacity time\r\n");
            for (i = 0; i < placeList.size(); ++i) {
                fileBuffer.append("     ");
                if (i < 9) {
                    fileBuffer.append(" ");
                }
                if (i < 99) {
                    fileBuffer.append(" ");
                }
                fileBuffer.append(i);
                fileBuffer.append(": ");
                fileBuffer.append(placeList.get(i).getName()).append("                  ");
                fileBuffer.append("65535    0");
                fileBuffer.append("\r\n");
            }
            fileBuffer.append("@\r\n");
            fileBuffer.append("trans nr.             name priority time\r\n");
            for (i = 0; i < transitionList.size(); ++i) {
                fileBuffer.append("     ");
                if (i <= 9) {
                    fileBuffer.append(" ");
                }
                if (i <= 99) {
                    fileBuffer.append(" ");
                }
                fileBuffer.append(i);
                fileBuffer.append(": ");
                fileBuffer.append(transitionList.get(i).getName()).append("                      ");
                fileBuffer.append("0    0");
                fileBuffer.append("\r\n");
            }
            fileBuffer.append("@");
            writerObject.println(fileBuffer);
            writerObject.close();
            overlord.log(lang.getText("LOGentry00190") + ": " + path, "text", true);
            return true;
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00191exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
    }

    public void writeT_invCharlie(String path, ArrayList<ArrayList<Integer>> invariants, ArrayList<Transition> transitions) {
        try {
            String extension = "";
            if (!path.contains(".inv")) {
                extension = ".inv";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            pw.print("minimal semipositive transition invariants=");
            for (int i = 0; i < invariants.size(); ++i) {
                boolean nrPlaced = false;
                for (int t = 0; t < invariants.get(i).size(); ++t) {
                    int value = invariants.get(i).get(t);
                    if (value == 0) continue;
                    if (!nrPlaced) {
                        pw.print("\r\n" + (i + 1) + "\t|\t");
                        nrPlaced = true;
                    } else {
                        pw.print(",\r\n");
                        pw.print("\t|\t");
                    }
                    String name = transitions.get(t).getName();
                    pw.print(t + "." + name + "\t\t:" + value);
                }
            }
            pw.close();
            overlord.log(lang.getText("LOGentry00192") + " " + path, "text", true);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00193exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void writeP_invCharlie(String path, ArrayList<ArrayList<Integer>> invariants, ArrayList<Place> places) {
        try {
            String extension = "";
            if (!path.contains(".inv")) {
                extension = ".inv";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            pw.print("minimal semipositive place invariants=");
            for (int i = 0; i < invariants.size(); ++i) {
                boolean nrPlaced = false;
                for (int p = 0; p < invariants.get(i).size(); ++p) {
                    int value = invariants.get(i).get(p);
                    if (value == 0) continue;
                    if (!nrPlaced) {
                        pw.print("\r\n" + (i + 1) + "\t|\t");
                        nrPlaced = true;
                    } else {
                        pw.print(",\r\n");
                        pw.print("\t|\t");
                    }
                    String name = places.get(p).getName();
                    pw.print(p + "." + name + "\t\t:" + value);
                }
            }
            pw.print("\r\n");
            pw.close();
            overlord.log(lang.getText("LOGentry00194") + " " + path, "text", true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR: writeP_invCharlie", 0);
            overlord.log(lang.getText("LOGentry00195exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void writeT_invCSV(String path, ArrayList<ArrayList<Integer>> invariants, ArrayList<Transition> transitions) {
        try {
            String extension = "";
            if (!path.contains(".csv")) {
                extension = ".csv";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            for (int i = 0; i < transitions.size(); ++i) {
                pw.print(";" + i + "." + transitions.get(i).getName());
            }
            pw.print("\r\n");
            boolean crazyMode = false;
            if (overlord.getSettingsManager().getValue("analysisBinaryCSVInvariants").equals("1")) {
                crazyMode = true;
            }
            if (crazyMode) {
                for (int i = 0; i < invariants.size(); ++i) {
                    pw.print(i + 1);
                    for (int t = 0; t < invariants.get(i).size(); ++t) {
                        int value = invariants.get(i).get(t);
                        if (value > 0) {
                            value = 1;
                        }
                        pw.print(";" + value);
                    }
                    pw.print("\r\n");
                }
            } else {
                for (int i = 0; i < invariants.size(); ++i) {
                    pw.print(i + 1);
                    for (int t = 0; t < invariants.get(i).size(); ++t) {
                        int value = invariants.get(i).get(t);
                        pw.print(";" + value);
                    }
                    pw.print("\r\n");
                }
            }
            pw.close();
            overlord.log(lang.getText("LOGentry00196") + " " + path, "text", true);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00197exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void writeP_invCSV(String path, ArrayList<ArrayList<Integer>> p_invariants, ArrayList<Place> places) {
        try {
            int i;
            String extension = "";
            if (!path.contains(".csv")) {
                extension = ".csv";
            }
            PrintWriter pw = new PrintWriter(path + extension);
            for (i = 0; i < places.size(); ++i) {
                pw.print(";" + i + "." + places.get(i).getName());
            }
            pw.print("\r\n");
            for (i = 0; i < p_invariants.size(); ++i) {
                pw.print(i + 1);
                for (int p = 0; p < p_invariants.get(i).size(); ++p) {
                    int value = p_invariants.get(i).get(p);
                    pw.print(";" + value);
                }
                pw.print("\r\n");
            }
            pw.close();
            overlord.log(lang.getText("LOGentry00198") + " " + path, "text", true);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00199exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void exportSubnet(ArrayList<ElementLocation> listOfElements) {
        ArrayList<Node> listOfParentNodes = new ArrayList<Node>();
        int min_x = Integer.MAX_VALUE;
        int min_y = Integer.MAX_VALUE;
        for (ElementLocation el : listOfElements) {
            if (!listOfParentNodes.contains(el.getParentNode())) {
                listOfParentNodes.add(el.getParentNode());
            }
            if (el.getPosition().y < min_y) {
                min_y = el.getPosition().y;
            }
            if (el.getPosition().x >= min_x) continue;
            min_x = el.getPosition().x;
        }
        SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(SubnetCalculator.SubNetType.Export, null, null, listOfParentNodes, null, null);
        try {
            FileDialog fDialog = new FileDialog((Frame)new JFrame(), "Save", 1);
            fDialog.setVisible(true);
            String path = fDialog.getDirectory() + fDialog.getFile();
            FileOutputStream out = new FileOutputStream(path);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(sn);
            oos.flush();
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00200exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void exportBranchVertices(ArrayList<HolmesBranchVerticesPrototype.BranchStructure> bsl) {
        try {
            FileDialog fDialog = new FileDialog((Frame)new JFrame(), "Save", 1);
            fDialog.setVisible(true);
            String path = fDialog.getDirectory() + fDialog.getFile();
            FileOutputStream out = new FileOutputStream(path);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(bsl);
            oos.flush();
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00201exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public ArrayList<HolmesBranchVerticesPrototype.BranchStructure> importBranchVertices(String absolutePath) {
        ArrayList sn = new ArrayList();
        try {
            FileInputStream file = new FileInputStream(absolutePath);
            ObjectInputStream in = new ObjectInputStream(file);
            sn = (ArrayList)in.readObject();
            in.close();
            file.close();
            System.out.println("Object has been deserialized ");
        }
        catch (IOException | ClassNotFoundException e) {
            overlord.log(lang.getText("LOGentry00202exception") + "\n" + e.getMessage(), "error", true);
        }
        return sn;
    }

    public void exportSubnet(ArrayList<ElementLocation> listOfElements, ArrayList<Arc> listOfProperArcs) {
        ArrayList<Node> listOfParentNodes = new ArrayList<Node>();
        int min_x = Integer.MAX_VALUE;
        int min_y = Integer.MAX_VALUE;
        for (ElementLocation el : listOfElements) {
            if (!listOfParentNodes.contains(el.getParentNode())) {
                listOfParentNodes.add(el.getParentNode());
            }
            if (el.getPosition().y < min_y) {
                min_y = el.getPosition().y;
            }
            if (el.getPosition().x >= min_x) continue;
            min_x = el.getPosition().x;
        }
        SubnetCalculator.SubNet sn = new SubnetCalculator.SubNet(SubnetCalculator.SubNetType.Export, null, null, listOfParentNodes, null, null);
        sn.setSubArcs(listOfProperArcs);
        try {
            FileDialog fDialog = new FileDialog((Frame)new JFrame(), "Save", 1);
            fDialog.setVisible(true);
            String path = fDialog.getDirectory() + fDialog.getFile();
            FileOutputStream out = new FileOutputStream(path);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(sn);
            oos.flush();
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00203exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    public void importSubnetFromFile(String absolutePath, int x, int y) {
        try {
            FileInputStream file = new FileInputStream(absolutePath);
            ObjectInputStream in = new ObjectInputStream(file);
            SubnetCalculator.SubNet sn = (SubnetCalculator.SubNet)in.readObject();
            for (Place place : sn.getSubPlaces()) {
                place.setTokensNumber(0);
            }
            for (Node node : sn.getSubNode()) {
                for (ElementLocation el : node.getElementLocations()) {
                    el.getPosition().x += x;
                    el.getPosition().y += y;
                    el.setSelected(false);
                }
                overlord.getWorkspace().getProject().getNodes().add(node);
                if (node.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                    overlord.getWorkspace().getProject().accessStatesManager().addPlace((Place)node);
                }
                for (Place p : overlord.getWorkspace().getProject().getPlaces()) {
                    p.setTokensNumber(0);
                }
            }
            for (Arc arc : sn.getSubArcs()) {
                arc.setSelected(false);
                overlord.getWorkspace().getProject().getArcs().add(arc);
            }
            in.close();
            file.close();
            System.out.println("Object has been deserialized ");
        }
        catch (IOException | ClassNotFoundException e) {
            overlord.log(lang.getText("LOGentry00204exception") + "\n" + e.getMessage(), "error", true);
        }
    }
}

