/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.io;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNetData;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;

public class AbyssReader {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private ArrayList<Node> nodeArray = new ArrayList();
    private ArrayList<Arc> arcArray = new ArrayList();
    private String pnName;

    public void read(String path) {
        File source = new File(path);
        try {
            XStream xstream = new XStream(new StaxDriver());
            xstream.alias("petriNet", PetriNetData.class);
            PetriNetData PND = (PetriNetData)xstream.fromXML(source);
            int SID = overlord.getWorkspace().getProject().returnCleanSheetID();
            int maxPlaceId = 0;
            int maxTransitionId = 0;
            int maxGlobalId = 0;
            for (Node node : PND.nodes) {
                if (node.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                    if (node.getID() > maxPlaceId) {
                        maxPlaceId = node.getID();
                    }
                    if (node.getID() > maxGlobalId) {
                        maxGlobalId = node.getID();
                    }
                } else {
                    if (node.getID() > maxTransitionId) {
                        maxTransitionId = node.getID();
                    }
                    if (node.getID() > maxGlobalId) {
                        maxGlobalId = node.getID();
                    }
                }
                for (ElementLocation el : node.getElementLocations()) {
                    el.setSheetID(SID);
                }
            }
            for (Arc arc : PND.arcs) {
                if (arc.getID() <= maxGlobalId) continue;
                maxGlobalId = arc.getID();
            }
            this.setWorkframeBoundary(PND.nodes);
            this.getNodeArray().addAll(PND.nodes);
            this.getArcArray().addAll(PND.arcs);
            this.pnName = PND.netName;
            IdGenerator.setTransitionId(maxTransitionId + 1);
            IdGenerator.setPlaceId(maxPlaceId + 1);
            IdGenerator.setStartId(maxGlobalId + 1);
            overlord.getWorkspace().getProject().accessStatesManager().createCleanStatePN();
            overlord.getWorkspace().getProject().accessSSAmanager().createCleanSSAvector();
            overlord.getWorkspace().getProject().accessFiringRatesManager().createCleanSPNdataVector();
            xstream.fromXML(source);
            overlord.log(lang.getText("LOGentry00153") + " " + path, "text", true);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00154exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    private void setWorkframeBoundary(ArrayList<Node> aln) {
        int x = 0;
        int y = 0;
        for (Node node : aln) {
            ArrayList<ElementLocation> elementLocationList = node.getElementLocations();
            for (ElementLocation elementLocation : elementLocationList) {
                if (x < elementLocation.getPosition().x) {
                    x = elementLocation.getPosition().x;
                }
                if (y >= elementLocation.getPosition().y) continue;
                y = elementLocation.getPosition().y;
            }
        }
        GraphPanel graphPanel = overlord.getWorkspace().getSheets().get(0).getGraphPanel();
        graphPanel.setSize(new Dimension(x + 90, y + 90));
        graphPanel.setOriginSize(graphPanel.getSize());
    }

    public String getPNname() {
        return this.pnName;
    }

    public ArrayList<Node> getNodeArray() {
        return this.nodeArray;
    }

    public void setNodeArray(ArrayList<Node> nodeArray) {
        this.nodeArray = nodeArray;
    }

    public ArrayList<Arc> getArcArray() {
        return this.arcArray;
    }

    public void setArcArray(ArrayList<Arc> arcArray) {
        this.arcArray = arcArray;
    }
}

