/*
 * Decompiled with CFR 0.152.
 */
package holmes.files.clusters;

import holmes.clusters.ClusteringExtended;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JOptionPane;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ClusteringExcelWriter {
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private WritableCellFormat defCellFormat;
    private WritableCellFormat defCellFormatBold;
    private WritableCellFormat defCellFormatItalic;
    private WritableCellFormat timesBoldUnderline;
    private WritableCellFormat defCellFormatBoldRed;
    private String outputFilePath;
    private ClusteringExtended dataCore;
    public boolean succeed = false;
    public String errorMsg = "";
    private boolean success = false;

    public ClusteringExcelWriter() {
    }

    public ClusteringExcelWriter(int mode, ClusteringExtended data, String path) {
        this();
        if (mode == 0) {
            this.dataCore = data;
            this.outputFilePath = path;
            this.makeClusteringFile();
            this.success = true;
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void makeClusteringFile() {
        try {
            File excelFile = new File(this.outputFilePath);
            WorkbookSettings wbSettings = new WorkbookSettings();
            wbSettings.setLocale(new Locale("en", "EN"));
            this.initiateFonts();
            WritableWorkbook workbook = Workbook.createWorkbook(excelFile, wbSettings);
            workbook.createSheet("MCT", 0);
            for (int i = 0; i < this.dataCore.metaData.clusterNumber; ++i) {
                workbook.createSheet("Cluster" + (i + 1), i + 1);
            }
            WritableSheet mctSheet = workbook.getSheet(0);
            this.setColumns(mctSheet, "mct");
            this.fillMCTdatasheet(mctSheet);
            for (int i = 0; i < this.dataCore.metaData.clusterNumber; ++i) {
                WritableSheet clusterSheet = workbook.getSheet(i + 1);
                this.setColumns(clusterSheet, "clusterStd");
                this.fillClusterDatasheet(clusterSheet, i, true);
            }
            workbook.write();
            workbook.close();
            this.succeed = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, lang.getText("CEW_entry001a") + " " + this.outputFilePath + lang.getText("CEW_entry001b"), "Error", 0);
            this.succeed = false;
        }
    }

    private void fillClusterDatasheet(WritableSheet clusterSheet, int clusterIndex, boolean extended) throws Exception {
        double value;
        int trans;
        double clusterMSS = this.dataCore.metaData.clusterMSS.get(clusterIndex).floatValue();
        int clusterSize = this.dataCore.clustersInv.get(clusterIndex).size();
        String txt = lang.getText("CEW_entry002") + (clusterIndex + 1) + " (" + this.dataCore.metaData.algorithmName + "/" + this.dataCore.metaData.metricName + lang.getText("CEW_entry002b") + " " + clusterSize;
        this.addTextCell(clusterSheet, 0, 0, txt, this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 4, 0, this.getMSSEval(clusterMSS), this.defCellFormatBold, this.setMSSEval(clusterMSS));
        this.addTextCell(clusterSheet, 3, 1, lang.getText("CEW_entry003") + " " + (clusterIndex + 1), this.defCellFormatBoldRed, null);
        this.addTextCell(clusterSheet, 1, 2, lang.getText("CEW_entry004"), this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 2, 2, lang.getText("CEW_entry005"), this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 3, 2, lang.getText("CEW_entry006"), this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 4, 2, lang.getText("CEW_entry007"), this.defCellFormatBold, null);
        ArrayList<Integer> mctInCluster = this.dataCore.getMCTFrequencyInCluster(clusterIndex);
        int rowIndex = 3;
        for (int i = 0; i < mctInCluster.size(); ++i) {
            if (mctInCluster.get(i) <= 0) continue;
            this.addTextCell(clusterSheet, 1, rowIndex, "MCT " + (i + 1), this.defCellFormat, null);
            this.addIntCell(clusterSheet, 2, rowIndex, mctInCluster.get(i), this.defCellFormat, this.setColour(mctInCluster.get(i), clusterSize));
            this.addIntCell(clusterSheet, 3, rowIndex, this.dataCore.mctSets.get(i).size(), this.defCellFormat, null);
            Formula form = new Formula(4, rowIndex, "MCT!C" + (i + 2));
            clusterSheet.addCell(form);
            ++rowIndex;
        }
        this.addTextCell(clusterSheet, 1, ++rowIndex, lang.getText("CEW_entry008"), this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 2, rowIndex, lang.getText("CEW_entry009"), this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 3, rowIndex, lang.getText("CEW_entry010"), this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 4, rowIndex, lang.getText("CEW_entry011"), this.defCellFormatBold, null);
        int transStartRow = rowIndex++;
        int[][] transInCluster = this.dataCore.getTransitionFrequencyNoMCT(clusterIndex, mctInCluster);
        for (trans = 0; trans < this.dataCore.transNames.length; ++trans) {
            if (transInCluster[0][trans] <= 0) continue;
            this.addTextCell(clusterSheet, 1, rowIndex, lang.getText("CEW_entry012") + " " + trans, this.defCellFormat, null);
            this.addIntCell(clusterSheet, 2, rowIndex, transInCluster[0][trans], this.defCellFormat, this.setColour(transInCluster[0][trans], clusterSize));
            value = (double)transInCluster[1][trans] / (double)clusterSize;
            this.addDoubleCell(clusterSheet, 3, rowIndex, value, this.defCellFormat, null);
            this.addTextCell(clusterSheet, 4, rowIndex, this.dataCore.transNames[trans], this.defCellFormat, null);
            ++rowIndex;
        }
        if (extended) {
            this.addTextCell(clusterSheet, 6, transStartRow - 1, lang.getText("CEW_entry013"), this.defCellFormatBold, null);
            this.addTextCell(clusterSheet, 6, transStartRow, lang.getText("CEW_entry014"), this.defCellFormatBold, null);
            this.addTextCell(clusterSheet, 7, transStartRow, lang.getText("CEW_entry015"), this.defCellFormatBold, null);
            this.addTextCell(clusterSheet, 8, transStartRow, lang.getText("CEW_entry016"), this.defCellFormatBold, null);
            this.addTextCell(clusterSheet, 9, transStartRow, lang.getText("CEW_entry017"), this.defCellFormatBold, null);
            this.addTextCell(clusterSheet, 10, transStartRow, lang.getText("CEW_entry018"), this.defCellFormatBold, null);
            ++transStartRow;
            for (trans = 0; trans < this.dataCore.transNames.length; ++trans) {
                if (transInCluster[2][trans] <= 0) continue;
                this.addTextCell(clusterSheet, 6, transStartRow, lang.getText("CEW_entry019") + " " + trans, this.defCellFormat, null);
                this.addTextCell(clusterSheet, 7, transStartRow, lang.getText("CEW_entry020") + " " + transInCluster[3][trans], this.defCellFormat, null);
                this.addIntCell(clusterSheet, 8, transStartRow, mctInCluster.get(transInCluster[3][trans] - 1), this.defCellFormat, this.setColour(mctInCluster.get(transInCluster[3][trans] - 1), clusterSize));
                value = (double)transInCluster[2][trans] / (double)clusterSize;
                this.addDoubleCell(clusterSheet, 9, transStartRow, value, this.defCellFormat, null);
                this.addTextCell(clusterSheet, 10, transStartRow, this.dataCore.transNames[trans], this.defCellFormat, null);
                ++transStartRow;
            }
        }
        if (transStartRow > rowIndex) {
            rowIndex = transStartRow;
        }
        this.addTextCell(clusterSheet, 1, ++rowIndex, "Inv.#:", this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 2, rowIndex, "MCT:", this.defCellFormatBold, null);
        this.addTextCell(clusterSheet, 4, rowIndex, "Transitions:", this.defCellFormatBold, null);
        ++rowIndex;
        for (int inv = 0; inv < this.dataCore.clustersInv.get(clusterIndex).size(); ++inv) {
            int invNo = this.dataCore.clustersInv.get(clusterIndex).get(inv);
            ArrayList<String> invArray = this.dataCore.getNormalizedInvariant(invNo, false);
            String nr = invArray.get(0);
            String mct = invArray.get(1);
            StringBuilder transitions = new StringBuilder();
            for (int i = 2; i < invArray.size(); ++i) {
                transitions.append(invArray.get(i)).append("  ;  ");
            }
            this.addTextCell(clusterSheet, 1, rowIndex, nr, this.defCellFormat, null);
            this.addTextCell(clusterSheet, 2, rowIndex, mct, this.defCellFormat, null);
            this.addTextCell(clusterSheet, 4, rowIndex, transitions.toString(), this.defCellFormat, null);
            ++rowIndex;
        }
    }

    private String getMSSEval(double clusterMSS) {
        DecimalFormat df = new DecimalFormat("#.###");
        Object txt = "MSS: ";
        txt = (String)txt + df.format(clusterMSS);
        if (clusterMSS > 0.8) {
            txt = (String)txt + " " + lang.getText("CEW_entry021");
        } else if (clusterMSS > 0.6) {
            txt = (String)txt + " " + lang.getText("CEW_entry022");
        } else if (clusterMSS > 0.45) {
            txt = (String)txt + " " + lang.getText("CEW_entry023");
        } else if (clusterMSS > 0.25) {
            txt = (String)txt + " " + lang.getText("CEW_entry024");
        } else if (clusterMSS == 0.0) {
            txt = (String)txt + " " + lang.getText("CEW_entry025");
        } else if (clusterMSS <= 0.25) {
            txt = (String)txt + " " + lang.getText("CEW_entry026");
        }
        return txt;
    }

    private Colour setMSSEval(double clusterMSS) {
        if (clusterMSS > 0.8) {
            return Colour.GREEN;
        }
        if (clusterMSS > 0.6) {
            return Colour.SEA_GREEN;
        }
        if (clusterMSS > 0.45) {
            return Colour.YELLOW;
        }
        if (clusterMSS > 0.25) {
            return Colour.LIGHT_ORANGE;
        }
        if (clusterMSS <= 0.25) {
            return Colour.RED;
        }
        return Colour.WHITE;
    }

    private Colour setColour(int meanValue, int maxValue) {
        double pie = (double)meanValue / (double)maxValue;
        if (pie == 1.0) {
            return Colour.DARK_GREEN;
        }
        if (pie >= 0.8) {
            return Colour.GREEN;
        }
        if (pie >= 0.6) {
            return Colour.SEA_GREEN;
        }
        if (pie >= 0.45) {
            return Colour.YELLOW;
        }
        if (pie > 0.25) {
            return Colour.LIGHT_ORANGE;
        }
        if (pie <= 0.25) {
            return Colour.RED;
        }
        return Colour.WHITE;
    }

    private void fillMCTdatasheet(WritableSheet mctSheet) throws Exception {
        int mctSize;
        int mctIndex;
        int rowIndex = 0;
        this.addTextCell(mctSheet, 0, rowIndex, lang.getText("CEW_entry027"), this.defCellFormatBold, null);
        this.addTextCell(mctSheet, 1, rowIndex, lang.getText("CEW_entry028"), this.defCellFormatBold, null);
        this.addTextCell(mctSheet, 2, rowIndex, lang.getText("CEW_entry029"), this.defCellFormatBold, null);
        ++rowIndex;
        for (mctIndex = 0; mctIndex < this.dataCore.metaData.MCTnumber; ++mctIndex) {
            mctSize = this.dataCore.mctSets.get(mctIndex).size();
            this.addIntCell(mctSheet, 0, rowIndex, mctIndex + 1, this.defCellFormat, null);
            this.addIntCell(mctSheet, 1, rowIndex, mctSize, this.defCellFormat, null);
            this.addTextCell(mctSheet, 2, rowIndex, lang.getText("CEW_entry030") + " " + (mctIndex + 1), this.defCellFormatItalic, null);
            ++rowIndex;
        }
        int n = ++rowIndex;
        ++rowIndex;
        this.addTextCell(mctSheet, 2, n, lang.getText("CEW_entry031"), this.defCellFormatBold, null);
        ++rowIndex;
        for (mctIndex = 0; mctIndex < this.dataCore.metaData.MCTnumber; ++mctIndex) {
            mctSize = this.dataCore.mctSets.get(mctIndex).size();
            this.addTextCell(mctSheet, 2, rowIndex++, "MCT#" + (mctIndex + 1) + " " + lang.getText("CEW_entry028") + " " + mctSize, this.defCellFormatBold, null);
            for (int mctElIndex = 0; mctElIndex < mctSize; ++mctElIndex) {
                int elementIndex = this.dataCore.mctSets.get(mctIndex).get(mctElIndex);
                String txt = this.dataCore.transNames[elementIndex];
                this.addTextCell(mctSheet, 2, rowIndex++, txt, this.defCellFormat, null);
            }
            this.addTextCell(mctSheet, 2, rowIndex++, "", this.defCellFormat, null);
        }
    }

    private void setColumns(WritableSheet sheet, String type) {
        if (type.equals("mct")) {
            sheet.setColumnView(0, 12);
            sheet.setColumnView(1, 12);
            sheet.setColumnView(2, 35);
        } else if (type.equals("clusterStd")) {
            sheet.setColumnView(0, 18);
            sheet.setColumnView(1, 12);
            sheet.setColumnView(2, 12);
            sheet.setColumnView(3, 10);
            sheet.setColumnView(4, 41);
            sheet.setColumnView(7, 12);
        }
    }

    private void initiateFonts() throws WriteException {
        WritableFont times10pt = new WritableFont(WritableFont.TIMES, 10);
        this.defCellFormat = new WritableCellFormat(times10pt);
        WritableFont times10ptBold = new WritableFont(WritableFont.TIMES, 10);
        times10ptBold.setBoldStyle(WritableFont.BOLD);
        this.defCellFormatBold = new WritableCellFormat(times10ptBold);
        WritableFont times10ptItalic = new WritableFont(WritableFont.TIMES, 10);
        times10ptItalic.setItalic(true);
        this.defCellFormatItalic = new WritableCellFormat(times10ptBold);
        WritableFont times10ptBoldUnderline = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD, false, UnderlineStyle.SINGLE);
        this.timesBoldUnderline = new WritableCellFormat(times10ptBoldUnderline);
        WritableFont times10ptBoldRed = new WritableFont(WritableFont.TIMES, 10);
        times10ptBoldRed.setBoldStyle(WritableFont.BOLD);
        times10ptBoldRed.setColour(Colour.RED);
        this.defCellFormatBoldRed = new WritableCellFormat(times10ptBoldRed);
        CellView cv = new CellView();
        cv.setFormat(this.defCellFormat);
        cv.setFormat(this.defCellFormatBold);
        cv.setFormat(this.defCellFormatBoldRed);
        cv.setFormat(this.defCellFormatItalic);
        cv.setFormat(this.timesBoldUnderline);
        cv.setAutosize(true);
    }

    private void addIntCell(WritableSheet sheet, int column, int row, Integer value, WritableCellFormat format, Colour col) throws WriteException, RowsExceededException {
        if (col != null) {
            WritableFont cellFont = (WritableFont)format.getFont();
            WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
            cellFormat.setBackground(col);
            Number cell = new Number(column, row, (double)value.intValue(), (CellFormat)cellFormat);
            sheet.addCell(cell);
        } else {
            Number cell = new Number(column, row, (double)value.intValue(), (CellFormat)format);
            sheet.addCell(cell);
        }
    }

    private void addDoubleCell(WritableSheet sheet, int column, int row, Double value, WritableCellFormat format, Colour col) throws WriteException, RowsExceededException {
        if (col != null) {
            WritableFont cellFont = (WritableFont)format.getFont();
            WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
            cellFormat.setBackground(col);
            Number cell = new Number(column, row, value, (CellFormat)cellFormat);
            sheet.addCell(cell);
        } else {
            Number cell = new Number(column, row, value, (CellFormat)format);
            sheet.addCell(cell);
        }
    }

    private void addTextCell(WritableSheet sheet, int column, int row, String s, WritableCellFormat format, Colour col) throws WriteException, RowsExceededException {
        if (col != null) {
            WritableFont cellFont = (WritableFont)format.getFont();
            WritableCellFormat cellFormat = new WritableCellFormat(cellFont);
            cellFormat.setBackground(col);
            Label label = new Label(column, row, s, (CellFormat)cellFormat);
            sheet.addCell(label);
        } else {
            Label label = new Label(column, row, s, (CellFormat)format);
            sheet.addCell(label);
        }
    }
}

