/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.toolbar;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ToolbarButton
extends JLabel {
    private static final long serialVersionUID = 3034370365062643549L;
    private static final Dimension DEFAULT_SIZE = new Dimension(48, 48);
    private static final int BORDER = 4;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(4, 4, 4, 4);
    private static final Border LINE_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), BorderFactory.createLineBorder(Color.gray)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    private Action action;

    public ToolbarButton(Action action) {
        this.setDimensions();
        this.setAction(action);
        this.addMouseListener(new ClickListener());
        this.setBorder(EMPTY_BORDER);
        this.setOpaque(false);
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Acion is null.");
        }
        this.action = action;
        if (action instanceof AbstractAction) {
            ImageIcon icon = (ImageIcon)action.getValue("SmallIcon");
            this.setIcon(icon);
            String description = (String)action.getValue("ShortDescription");
            this.setToolTipText(description);
        }
    }

    private void setDimensions() {
        this.setPreferredSize(DEFAULT_SIZE);
        this.setMaximumSize(DEFAULT_SIZE);
        this.setMinimumSize(DEFAULT_SIZE);
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, (String)ToolbarButton.this.action.getValue("ShortDescription"), mouseEvent.getModifiers());
            ToolbarButton.this.action.actionPerformed(actionEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ToolbarButton.this.setBorder(LINE_BORDER);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ToolbarButton.this.setBorder(EMPTY_BORDER);
        }
    }
}

