/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.toolbar;

import holmes.analyse.GraphletsCalculator;
import holmes.analyse.MDTSCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.toolbar.ToolbarButtonAction;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.Node;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.utilities.Tools;
import holmes.varia.NetworkTransformations;
import holmes.windows.HolmesNotepad;
import holmes.windows.managers.HolmesSPNmanager;
import holmes.windows.statespace.HolmesStSpRG;
import holmes.windows.statespace.HolmesStSpRGtpn;
import holmes.windows.statespace.HolmesStSpRP;
import holmes.windows.statespace.HolmesStSpUNF;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;

public class Toolbar
extends JPanel {
    private static final long serialVersionUID = 640320332920131092L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    ToolbarButtonAction reverseLoopButton;
    ToolbarButtonAction reverseStepButton;
    ToolbarButtonAction loopSimButton;
    ToolbarButtonAction singleTransitionLoopSimButton;
    ToolbarButtonAction pauseSimButton;
    ToolbarButtonAction stopSimButton;
    ToolbarButtonAction smallStepFwdSimButton;
    ToolbarButtonAction stepFwdSimButton;
    ToolbarButtonAction resetSimButton;

    public Toolbar() {
        this.setLayout(new FlowLayout(0));
        this.createIObuttons();
        JSeparator s1 = new JSeparator();
        s1.setOrientation(1);
        s1.setPreferredSize(new Dimension(15, 45));
        this.add(s1);
        this.createNetTransformBar();
        JSeparator s2 = new JSeparator();
        s2.setOrientation(1);
        s2.setPreferredSize(new Dimension(15, 45));
        this.add(s2);
        this.createAnalysisBar();
    }

    private void createIObuttons() {
        JButton addButton = new JButton("", Tools.getResIcon48("/icons/toolbar/add_panel.png"));
        addButton.setPreferredSize(new Dimension(50, 50));
        addButton.addActionListener(arg0 -> Toolbar.overlord.reset.newProjectInitiated());
        addButton.setBorderPainted(false);
        addButton.setContentAreaFilled(false);
        addButton.setFocusPainted(false);
        addButton.setOpaque(false);
        addButton.setToolTipText(lang.getText("TB_entry001t"));
        this.add(addButton);
        JButton openButton = new JButton("", Tools.getResIcon48("/icons/toolbar/open.png"));
        openButton.setPreferredSize(new Dimension(50, 50));
        openButton.addActionListener(arg0 -> Toolbar.overlord.io.selectAndOpenHolmesProject());
        openButton.setBorderPainted(false);
        openButton.setContentAreaFilled(false);
        openButton.setFocusPainted(false);
        openButton.setOpaque(false);
        openButton.setToolTipText(lang.getText("TB_entry002t"));
        this.add(openButton);
        JButton importButton = new JButton("", Tools.getResIcon48("/icons/toolbar/import_net.png"));
        importButton.setPreferredSize(new Dimension(50, 50));
        importButton.addActionListener(arg0 -> Toolbar.overlord.io.importNetwork());
        importButton.setBorderPainted(false);
        importButton.setContentAreaFilled(false);
        importButton.setFocusPainted(false);
        importButton.setOpaque(false);
        importButton.setToolTipText(lang.getText("TB_entry003t"));
        this.add(importButton);
        JButton saveProjectButton = new JButton("", Tools.getResIcon48("/icons/toolbar/holmesSave.png"));
        saveProjectButton.setPreferredSize(new Dimension(50, 50));
        saveProjectButton.addActionListener(arg0 -> Toolbar.overlord.io.saveAsAbyssFile());
        saveProjectButton.setBorderPainted(false);
        saveProjectButton.setContentAreaFilled(false);
        saveProjectButton.setFocusPainted(false);
        saveProjectButton.setOpaque(false);
        saveProjectButton.setToolTipText(lang.getText("TB_entry004t"));
        this.add(saveProjectButton);
        JButton exportButton = new JButton("", Tools.getResIcon48("/icons/toolbar/snoopyExport.png"));
        exportButton.setPreferredSize(new Dimension(50, 50));
        exportButton.addActionListener(arg0 -> Toolbar.overlord.io.saveAsGlobal());
        exportButton.setBorderPainted(false);
        exportButton.setContentAreaFilled(false);
        exportButton.setFocusPainted(false);
        exportButton.setOpaque(false);
        exportButton.setToolTipText(lang.getText("TB_entry005t"));
        this.add(exportButton);
        JButton pictureButton = new JButton("", Tools.getResIcon48("/icons/toolbar/save_picture.png"));
        pictureButton.setPreferredSize(new Dimension(50, 50));
        pictureButton.addActionListener(arg0 -> Toolbar.overlord.io.exportProjectToImage());
        pictureButton.setBorderPainted(false);
        pictureButton.setContentAreaFilled(false);
        pictureButton.setFocusPainted(false);
        pictureButton.setOpaque(false);
        pictureButton.setToolTipText(lang.getText("TB_entry006t"));
        this.add(pictureButton);
        JButton refreshButton = new JButton("", Tools.getResIcon48("/icons/toolbar/refresh.png"));
        refreshButton.setPreferredSize(new Dimension(50, 50));
        refreshButton.addActionListener(arg0 -> overlord.getWorkspace().getProject().repaintAllGraphPanels());
        refreshButton.setBorderPainted(false);
        refreshButton.setContentAreaFilled(false);
        refreshButton.setFocusPainted(false);
        refreshButton.setOpaque(false);
        refreshButton.setToolTipText(lang.getText("TB_entry007t"));
        this.add(refreshButton);
    }

    private void createAnalysisBar() {
        JButton clusterButton = new JButton("", Tools.getResIcon48("/icons/toolbar/clusters.png"));
        clusterButton.setPreferredSize(new Dimension(50, 50));
        clusterButton.addActionListener(arg0 -> overlord.showClusterWindow());
        clusterButton.setBorderPainted(false);
        clusterButton.setContentAreaFilled(false);
        clusterButton.setFocusPainted(false);
        clusterButton.setOpaque(false);
        clusterButton.setToolTipText(lang.getText("TB_entry041t"));
        this.add(clusterButton);
        JButton netTablesButton = new JButton("", Tools.getResIcon48("/icons/toolbar/netTables.png"));
        netTablesButton.setPreferredSize(new Dimension(50, 50));
        netTablesButton.addActionListener(arg0 -> overlord.showNetTablesWindow());
        netTablesButton.setBorderPainted(false);
        netTablesButton.setContentAreaFilled(false);
        netTablesButton.setFocusPainted(false);
        netTablesButton.setOpaque(false);
        netTablesButton.setToolTipText(lang.getText("TB_entry042t"));
        this.add(netTablesButton);
        JButton netSimLogButton = new JButton("", Tools.getResIcon48("/icons/toolbar/simLog.png"));
        netSimLogButton.setPreferredSize(new Dimension(50, 50));
        netSimLogButton.addActionListener(arg0 -> overlord.showSimLogWindow());
        netSimLogButton.setBorderPainted(false);
        netSimLogButton.setContentAreaFilled(false);
        netSimLogButton.setFocusPainted(false);
        netSimLogButton.setOpaque(false);
        netSimLogButton.setToolTipText(lang.getText("TB_entry043t"));
        this.add(netSimLogButton);
        JButton consoleButton = new JButton("", Tools.getResIcon48("/icons/toolbar/terminal2.png"));
        consoleButton.setPreferredSize(new Dimension(50, 50));
        consoleButton.addActionListener(arg0 -> overlord.showConsole(true));
        consoleButton.setBorderPainted(false);
        consoleButton.setContentAreaFilled(false);
        consoleButton.setFocusPainted(false);
        consoleButton.setOpaque(false);
        consoleButton.setToolTipText(lang.getText("TB_entry044t"));
        this.add(consoleButton);
        JButton cleanButton = new JButton("", Tools.getResIcon48("/icons/toolbar/cleanGraphColors.png"));
        cleanButton.setPreferredSize(new Dimension(50, 50));
        cleanButton.addActionListener(arg0 -> Toolbar.overlord.reset.clearGraphColors());
        cleanButton.setBorderPainted(false);
        cleanButton.setContentAreaFilled(false);
        cleanButton.setFocusPainted(false);
        cleanButton.setOpaque(false);
        cleanButton.setToolTipText(lang.getText("TB_entry045t"));
        this.add(cleanButton);
        JButton fireRatesButton = new JButton("", Tools.getResIcon48("/icons/toolbar/firingRates.png"));
        fireRatesButton.setPreferredSize(new Dimension(50, 50));
        fireRatesButton.addActionListener(arg0 -> new HolmesSPNmanager(overlord.getFrame()));
        fireRatesButton.setBorderPainted(false);
        fireRatesButton.setContentAreaFilled(false);
        fireRatesButton.setFocusPainted(false);
        fireRatesButton.setOpaque(false);
        fireRatesButton.setToolTipText(lang.getText("TB_entry046t"));
        this.add(fireRatesButton);
        JSeparator s = new JSeparator();
        s.setOrientation(1);
        s.setPreferredSize(new Dimension(15, 45));
        this.add(s);
        JButton ssButtonUNF = new JButton("", Tools.getResIcon48("/icons/toolbar/ssUNF.png"));
        ssButtonUNF.setPreferredSize(new Dimension(50, 50));
        ssButtonUNF.setBorderPainted(false);
        ssButtonUNF.setContentAreaFilled(false);
        ssButtonUNF.setFocusPainted(false);
        ssButtonUNF.setOpaque(false);
        ssButtonUNF.addActionListener(e -> {
            HolmesStSpUNF stateSpaceWindow = new HolmesStSpUNF();
        });
        this.add(ssButtonUNF);
        JButton ssButtonRG = new JButton("", Tools.getResIcon48("/icons/toolbar/ssRG.png"));
        ssButtonRG.setPreferredSize(new Dimension(50, 50));
        ssButtonRG.setBorderPainted(false);
        ssButtonRG.setContentAreaFilled(false);
        ssButtonRG.setFocusPainted(false);
        ssButtonRG.setOpaque(false);
        ssButtonRG.addActionListener(e -> {
            HolmesStSpRG stateSpaceWindow = new HolmesStSpRG();
        });
        this.add(ssButtonRG);
        JButton ssButtonRP = new JButton("", Tools.getResIcon48("/icons/toolbar/ssRP.png"));
        ssButtonRP.setPreferredSize(new Dimension(50, 50));
        ssButtonRP.setBorderPainted(false);
        ssButtonRP.setContentAreaFilled(false);
        ssButtonRP.setFocusPainted(false);
        ssButtonRP.setOpaque(false);
        ssButtonRP.addActionListener(e -> {
            HolmesStSpRP stateSpaceWindow = new HolmesStSpRP();
        });
        this.add(ssButtonRP);
        JButton ssButtonRGtpn = new JButton("", Tools.getResIcon48("/icons/toolbar/ssRGtpn.png"));
        ssButtonRGtpn.setPreferredSize(new Dimension(50, 50));
        ssButtonRGtpn.setBorderPainted(false);
        ssButtonRGtpn.setContentAreaFilled(false);
        ssButtonRGtpn.setFocusPainted(false);
        ssButtonRGtpn.setOpaque(false);
        ssButtonRGtpn.addActionListener(e -> {
            HolmesStSpRGtpn stateSpaceWindow = new HolmesStSpRGtpn();
        });
        this.add(ssButtonRGtpn);
        ToolbarButtonAction testButton2 = new ToolbarButtonAction(this, "DEBUG2", "Debug2", Tools.getResIcon48("/icons/toolbar/a.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTree test = overlord.getToolBox().getTree();
                overlord.getToolBox().selectPointer();
                boolean x = true;
                MDTSCalculator mdts = new MDTSCalculator();
                ArrayList<Set<Integer>> results = mdts.calculateMDTS();
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL("", "text");
                notePad.addTextLineNL("Maximal Dependend Transition sets:", "text");
                int setNo = 0;
                for (Set<Integer> set : results) {
                    StringBuilder text = new StringBuilder();
                    text.append("Set #").append(++setNo).append(": [");
                    for (int i : set) {
                        text.append("t").append(i).append(", ");
                    }
                    text.append("]");
                    text = new StringBuilder(text.toString().replace(", ]", "]"));
                    notePad.addTextLineNL(text.toString(), "text");
                }
            }
        };
        ToolbarButtonAction testGraphletButton = new ToolbarButtonAction(this, "Debug1", "Debug", Tools.getResIcon48("/icons/toolbar/aaa.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GraphletsCalculator.generateGraphlets();
                ArrayList<int[]> GDV = new ArrayList<int[]>();
                boolean test = false;
                if (test) {
                    System.out.println(overlord.getWorkspace().getProject().getNodes().get(1));
                    int[] nArray = GraphletsCalculator.vectorOrbit(overlord.getWorkspace().getProject().getNodes().get(1), test);
                } else {
                    for (Node startNode : overlord.getWorkspace().getProject().getNodes()) {
                        int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, test);
                        GDV.add(vectorOrbit);
                    }
                    for (int j = 0; j < GDV.size(); ++j) {
                        System.out.print(overlord.getWorkspace().getProject().getNodes().get(j).getName() + " - ");
                        int[] vector = (int[])GDV.get(j);
                        for (int i = 0; i < vector.length; ++i) {
                            if (vector[i] < 0) {
                                System.out.print("X, \t");
                                continue;
                            }
                            System.out.print(vector[i] + "\t ");
                        }
                        System.out.println();
                    }
                }
            }
        };
    }

    private void createNetTransformBar() {
        JButton extendNetButton = new JButton("", Tools.getResIcon48("/icons/toolbar/resizeMax.png"));
        extendNetButton.setPreferredSize(new Dimension(50, 50));
        extendNetButton.addActionListener(actionEvent -> {
            NetworkTransformations nt = new NetworkTransformations();
            nt.extendNetwork(true);
        });
        extendNetButton.setBorderPainted(false);
        extendNetButton.setContentAreaFilled(false);
        extendNetButton.setFocusPainted(false);
        extendNetButton.setOpaque(false);
        extendNetButton.setToolTipText(lang.getText("TB_entry021t"));
        this.add(extendNetButton);
        JButton shrinkNetButton = new JButton("", Tools.getResIcon48("/icons/toolbar/resizeMin.png"));
        shrinkNetButton.setPreferredSize(new Dimension(50, 50));
        shrinkNetButton.addActionListener(actionEvent -> {
            NetworkTransformations nt = new NetworkTransformations();
            nt.extendNetwork(false);
        });
        shrinkNetButton.setBorderPainted(false);
        shrinkNetButton.setContentAreaFilled(false);
        shrinkNetButton.setFocusPainted(false);
        shrinkNetButton.setOpaque(false);
        shrinkNetButton.setToolTipText(lang.getText("TB_entry022t"));
        this.add(shrinkNetButton);
        JButton gridButton = new JButton("", Tools.getResIcon48("/icons/toolbar/grid.png"));
        gridButton.setPreferredSize(new Dimension(50, 50));
        gridButton.addActionListener(actionEvent -> {
            if (overlord.getSettingsManager().getValue("editorGridLines").equals("1")) {
                overlord.getSettingsManager().setValue("editorGridLines", "0", true);
            } else {
                overlord.getSettingsManager().setValue("editorGridLines", "1", true);
            }
            overlord.getWorkspace().getProject().repaintAllGraphPanels();
        });
        gridButton.setBorderPainted(false);
        gridButton.setContentAreaFilled(false);
        gridButton.setFocusPainted(false);
        gridButton.setOpaque(false);
        gridButton.setToolTipText(lang.getText("TB_entry023t"));
        this.add(gridButton);
        JButton gridAlignButton = new JButton("", Tools.getResIcon48("/icons/toolbar/gridAlign.png"));
        gridAlignButton.setPreferredSize(new Dimension(50, 50));
        gridAlignButton.addActionListener(actionEvent -> {
            NetworkTransformations nt = new NetworkTransformations();
            nt.alignNetToGrid();
            overlord.getWorkspace().getProject().repaintAllGraphPanels();
        });
        gridAlignButton.setBorderPainted(false);
        gridAlignButton.setContentAreaFilled(false);
        gridAlignButton.setFocusPainted(false);
        gridAlignButton.setOpaque(false);
        gridAlignButton.setToolTipText(lang.getText("TB_entry024t"));
        this.add(gridAlignButton);
    }

    public void setEnabledSimulationInitiateButtons(boolean enabled) {
    }

    public void setEnabledSimulationDisruptButtons(boolean enabled) {
    }

    public void allowOnlySimulationInitiateButtons() {
        this.setEnabledSimulationInitiateButtons(true);
        this.setEnabledSimulationDisruptButtons(false);
    }

    public void allowOnlySimulationDisruptButtons() {
        this.setEnabledSimulationInitiateButtons(false);
        this.setEnabledSimulationDisruptButtons(true);
    }

    public void allowOnlyUnpauseButton() {
        this.allowOnlySimulationDisruptButtons();
    }

    private void createSimulationBar() {
        this.reverseLoopButton = new ToolbarButtonAction(this, lang.getText("lang"), lang.getText("TB_toolTip001d"), Tools.getResIcon48("/icons/toolbar/sim_back.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.LOOP_BACK);
            }
        };
        this.reverseStepButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip002"), lang.getText("TB_toolTip002d"), Tools.getResIcon48("/icons/toolbar/sim_back_step.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.ACTION_BACK);
            }
        };
        this.loopSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip003"), lang.getText("TB_toolTip003d"), Tools.getResIcon48("/icons/toolbar/sim_start.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.LOOP);
            }
        };
        this.singleTransitionLoopSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip004"), lang.getText("TB_toolTip004d"), Tools.getResIcon48("/icons/toolbar/sim_start_single.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION_LOOP);
            }
        };
        this.pauseSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip005"), lang.getText("TB_toolTip005d"), Tools.getResIcon48("/icons/toolbar/sim_pause.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().pause();
            }
        };
        this.stopSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip006"), lang.getText("TB_toolTip006d"), Tools.getResIcon48("/icons/toolbar/sim_stop.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().getProject().getSimulator().stop();
            }
        };
        this.smallStepFwdSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip007"), lang.getText("TB_toolTip007d"), Tools.getResIcon48("/icons/toolbar/sim_forward_step.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.SINGLE_TRANSITION);
            }
        };
        this.stepFwdSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip008"), lang.getText("TB_toolTip008d"), Tools.getResIcon48("/icons/toolbar/sim_forward.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                overlord.getWorkspace().getProject().getSimulator().startSimulation(GraphicalSimulator.SimulatorMode.STEP);
            }
        };
        this.resetSimButton = new ToolbarButtonAction(this, lang.getText("TB_toolTip009"), lang.getText("TB_toolTip009d"), Tools.getResIcon48("/icons/toolbar/sim_reset.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                overlord.getWorkspace().getProject().restoreMarkingZero();
            }
        };
    }

    private JPanel createSubtoolsPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setPreferredSize(new Dimension(200, 60));
        panel.setMaximumSize(new Dimension(200, 60));
        JButton button1 = new JButton(lang.getText("TB_toolTip010"));
        button1.setName("extNet");
        button1.setPreferredSize(new Dimension(60, 40));
        button1.setToolTipText(lang.getText("TB_toolTip010d"));
        button1.addActionListener(actionEvent -> {});
        panel.add(button1);
        return panel;
    }
}

