/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.dockwindows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.workspace.WorkspaceSheet;
import java.awt.event.ActionEvent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SharedActionsXTPN {
    private static final SharedActionsXTPN singleton = new SharedActionsXTPN();
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    private SharedActionsXTPN() {
    }

    public static SharedActionsXTPN access() {
        return singleton;
    }

    public void buttonAlphaSwitchMode(ActionEvent e, TransitionXTPN transition, JFrame caller, HolmesRoundedButton tauVisibilityButton, HolmesRoundedButton buttonClassicMode, JFormattedTextField alphaMaxTextField, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isAlphaModeActive()) {
            if (transition.isBetaModeActive() && transition.getBetaMinValue() < SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy() && transition.getBetaMaxValue() < SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy() && (transition.isInputTransition() || transition.isOutputTransition())) {
                JOptionPane.showMessageDialog(null, lang.getText("SAXTPN_entry001"), lang.getText("SAXTPN_entry001t"), 0);
                return;
            }
            transition.setAlphaModeStatus(false);
            button.setNewText("<html>Alpha: OFF</html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            if (!transition.isBetaModeActive()) {
                buttonClassicMode.setNewText("<html>Classical<html>");
                buttonClassicMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                tauVisibilityButton.setEnabled(false);
                transition.setTauTimersVisibility(false);
            }
        } else {
            transition.setAlphaModeStatus(true);
            button.setNewText("<html>Alpha: ON</html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            if (transition.getAlphaMinValue() < SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy() && transition.getAlphaMaxValue() < SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy()) {
                transition.setAlphaMaxValue(1.0, false);
                alphaMaxTextField.setValue(0.0);
            }
            if (!transition.isBetaModeActive()) {
                buttonClassicMode.setNewText("<html>XTPN<html>");
                buttonClassicMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                tauVisibilityButton.setEnabled(true);
                transition.setTauTimersVisibility(true);
            }
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }

    public void buttonBetaSwitchMode(ActionEvent e, TransitionXTPN transition, JFrame caller, HolmesRoundedButton tauVisibilityButton, HolmesRoundedButton buttonClassicMode, JFormattedTextField betaMaxTextField, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isBetaModeActive()) {
            accuracy = SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy();
            if (transition.isAlphaModeActive() && transition.getAlphaMinValue() < accuracy && transition.getAlphaMaxValue() < accuracy && (transition.isInputTransition() || transition.isOutputTransition())) {
                JOptionPane.showMessageDialog(null, lang.getText("SAXTPN_entry002"), lang.getText("SAXTPN_entry002t"), 0);
                return;
            }
            transition.setBetaModeStatus(false);
            button.setNewText("<html>Beta: OFF</html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            if (!transition.isAlphaModeActive()) {
                button.setNewText("<html>Classical<html>");
                buttonClassicMode.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                tauVisibilityButton.setEnabled(false);
                transition.setTauTimersVisibility(false);
            }
        } else {
            transition.setBetaModeStatus(true);
            button.setNewText("<html>Beta: ON</html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            accuracy = SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy();
            if (transition.getBetaMinValue() < accuracy && transition.getBetaMaxValue() < accuracy) {
                transition.setBetaMaxValue(1.0, false);
                betaMaxTextField.setValue(0.0);
            }
            if (!transition.isAlphaModeActive()) {
                buttonClassicMode.setNewText("<html>XTPN<html>");
                buttonClassicMode.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                tauVisibilityButton.setEnabled(true);
                transition.setTauTimersVisibility(true);
            }
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }

    public void buttonTransitionToXTPN_classicSwitchMode(ActionEvent e, TransitionXTPN transition, JFrame caller, JFormattedTextField alphaMaxTextField, JFormattedTextField betaMaxTextField, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isAlphaModeActive() || transition.isBetaModeActive()) {
            Object[] options = new Object[]{lang.getText("confirm"), lang.getText("cancel")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry003"), lang.getText("SAXTPN_entry003t"), 0, 3, null, options, options[1]);
            if (n == 1) {
                return;
            }
            transition.setAlphaModeStatus(false);
            transition.setBetaModeStatus(false);
            transition.setTauTimersVisibility(false);
            button.setNewText("<html>Classical<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
        } else {
            transition.setAlphaModeStatus(true);
            transition.setBetaModeStatus(true);
            transition.setTauTimersVisibility(true);
            button.setNewText("<html>XTPN<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            double accuracy = SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy();
            if (transition.getAlphaMinValue() < accuracy && transition.getAlphaMaxValue() < accuracy) {
                transition.setAlphaMaxValue(1.0, false);
                alphaMaxTextField.setValue(0.0);
            }
            if (transition.getBetaMinValue() < accuracy && transition.getBetaMaxValue() < accuracy) {
                transition.setBetaMaxValue(1.0, false);
                betaMaxTextField.setValue(0.0);
            }
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }

    public void buttonGammaSwitchMode(ActionEvent e, PlaceXTPN place, JFrame caller, HolmesRoundedButton gammaVisibilityButton, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        int tokensNum = place.getTokensNumber();
        if (place.isGammaModeActive()) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry004opt1"), lang.getText("SAXTPN_entry004opt2")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry004_1") + tokensNum + lang.getText("SAXTPN_entry004_2"), lang.getText("SAXTPN_entry004t"), -1, 3, null, options, options[0]);
            if (answer == 0) {
                button.setNewText("<html><center>Gamma<br>OFF</center></html>");
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                place.transformXTPNintoPNpace();
                overlord.getWorkspace().getProject().repaintAllGraphPanels();
                button.setFocusPainted(false);
                WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
                gammaVisibilityButton.setEnabled(false);
            }
        } else {
            Object[] options = new String[]{lang.getText("SAXTPN_entry005opt1"), lang.getText("SAXTPN_entry005opt2")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry005_1") + tokensNum + lang.getText("SAXTPN_entry005_2"), lang.getText("SAXTPN_entry005t"), -1, 3, null, options, options[0]);
            if (answer == 0) {
                button.setNewText("<html><center>Gamma<br>ON</center></html>");
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                place.transformIntoXTPNplace();
                overlord.getWorkspace().getProject().repaintAllGraphPanels();
                button.setFocusPainted(false);
                WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
                ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
                gammaVisibilityButton.setEnabled(true);
            }
        }
    }

    public boolean alphaVisButtonAction(ActionEvent e, TransitionXTPN transition, HolmesRoundedButton alphaLocChangeButton, boolean alphaLocChangeMode, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isAlphaRangeVisible()) {
            transition.setAlphaRangeVisibility(false);
            button.setNewText("<html>\u03b1:hidden<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            alphaLocChangeButton.setEnabled(false);
        } else {
            transition.setAlphaRangeVisibility(true);
            button.setNewText("<html>\u03b1:visible<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            alphaLocChangeMode = false;
            overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
        return alphaLocChangeMode;
    }

    public boolean betaVisButtonAction(ActionEvent e, TransitionXTPN transition, HolmesRoundedButton betaLocChangeButton, boolean betaLocChangeMode, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isBetaRangeVisible()) {
            transition.setBetaRangeVisibility(false);
            button.setNewText("<html>\u03b2:hidden<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            betaLocChangeButton.setEnabled(false);
        } else {
            transition.setBetaRangeVisibility(true);
            button.setNewText("<html>\u03b2:visible<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            betaLocChangeMode = false;
            overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
        return betaLocChangeMode;
    }

    public boolean tauVisButtonAction(ActionEvent e, TransitionXTPN transition, HolmesRoundedButton tauLocChangeButton, boolean tauLocChangeMode, ElementLocation elementLocation) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (transition.isTauTimerVisible()) {
            transition.setTauTimersVisibility(false);
            button.setNewText("<html>\u03c4:hidden<html>");
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            tauLocChangeButton.setEnabled(false);
        } else {
            transition.setTauTimersVisibility(true);
            button.setNewText("<html>\u03c4:visible<html>");
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            tauLocChangeMode = false;
            overlord.setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
        return tauLocChangeMode;
    }

    public boolean setAlfaMinTime(double newAlphaMin, TransitionXTPN transition, ElementLocation elementLocation) {
        double alfaMax = transition.getAlphaMaxValue();
        if (newAlphaMin > alfaMax) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry006opt1") + newAlphaMin, lang.getText("SAXTPN_entry006opt1b") + alfaMax + " ", lang.getText("SAXTPN_entry006opt2")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry006_1") + newAlphaMin + lang.getText("SAXTPN_entry006_2") + alfaMax + lang.getText("SAXTPN_entry006_3"), lang.getText("SAXTPN_entry006t"), -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    transition.setAlphaMaxValue(newAlphaMin, true);
                    transition.setAlphaMinValue(newAlphaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setAlphaMinValue(alfaMax, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setAlphaMinValue(newAlphaMin, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setAlfaMaxTime(double newAlphaMax, TransitionXTPN transition, ElementLocation elementLocation) {
        double accuracy;
        double alfaMin = transition.getAlphaMinValue();
        if (alfaMin < (accuracy = SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy()) && newAlphaMax < accuracy && (transition.getBetaMinValue() < accuracy && transition.getBetaMaxValue() < accuracy || !transition.isBetaModeActive()) && (transition.isInputTransition() || transition.isOutputTransition())) {
            JOptionPane.showMessageDialog(null, lang.getText("SAXTPN_entry007"), lang.getText("SAXTPN_entry007t"), 0);
            return false;
        }
        if (alfaMin < accuracy && newAlphaMax < accuracy) {
            transition.setAlphaMaxValue(0.0, false);
            transition.setAlphaModeStatus(false);
            this.repaintGraphPanel(elementLocation);
            return true;
        }
        if (newAlphaMax < alfaMin) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry007op1") + alfaMin, lang.getText("SAXTPN_entry007op2") + newAlphaMax, lang.getText("SAXTPN_entry007op3")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry007_1") + newAlphaMax + " " + lang.getText("SAXTPN_entry007_1b") + alfaMin + lang.getText("SAXTPN_entry007_1c"), lang.getText("SAXTPN_entry007t2"), -1, 3, null, options, options[1]);
            switch (answer) {
                case 0: {
                    transition.setAlphaMaxValue(alfaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setAlphaMinValue(newAlphaMax, true);
                    transition.setAlphaMaxValue(newAlphaMax, false);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setAlphaMaxValue(newAlphaMax, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setBetaMinTime(double newBetaMin, TransitionXTPN transition, ElementLocation elementLocation) {
        double betaMax = transition.getBetaMaxValue();
        if (newBetaMin > betaMax) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry008opt1") + newBetaMin, lang.getText("SAXTPN_entry008opt2") + betaMax, lang.getText("SAXTPN_entry008opt3")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry008_1") + newBetaMin + " " + lang.getText("SAXTPN_entry008_2") + betaMax + "\n" + lang.getText("SAXTPN_entry008_3"), lang.getText("SAXTPN_entry008t"), -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    transition.setBetaMaxValue(newBetaMin, true);
                    transition.setBetaMinValue(newBetaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setBetaMinValue(betaMax, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setBetaMinValue(newBetaMin, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setBetaMaxTime(double newBetaMax, TransitionXTPN transition, ElementLocation elementLocation) {
        double accuracy;
        double betaMin = transition.getBetaMinValue();
        if (betaMin < (accuracy = SharedActionsXTPN.overlord.simSettings.getCalculationsAccuracy()) && newBetaMax < accuracy && (transition.getAlphaMinValue() < accuracy && transition.getAlphaMaxValue() < accuracy || !transition.isAlphaModeActive())) {
            boolean input = transition.isInputTransition();
            boolean output = transition.isOutputTransition();
            if (input || output) {
                JOptionPane.showMessageDialog(null, lang.getText("SAXTPN_entry009"), lang.getText("SAXTPN_entry009t"), 0);
                return false;
            }
        }
        if (betaMin < accuracy && newBetaMax < accuracy) {
            transition.setBetaMaxValue(0.0, false);
            transition.setBetaModeStatus(false);
            this.repaintGraphPanel(elementLocation);
            return true;
        }
        if (newBetaMax < betaMin) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry009op1") + betaMin, lang.getText("SAXTPN_entry009op2") + newBetaMax, lang.getText("SAXTPN_entry009op3")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry009_1") + newBetaMax + " " + lang.getText("SAXTPN_entry009_1b") + betaMin + "\n" + lang.getText("SAXTPN_entry009_1c"), lang.getText("SAXTPN_entry009t"), -1, 3, null, options, options[1]);
            switch (answer) {
                case 0: {
                    transition.setBetaMaxValue(betaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    transition.setBetaMinValue(newBetaMax, true);
                    transition.setBetaMaxValue(newBetaMax, false);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        transition.setBetaMaxValue(newBetaMax, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setGammaMinTime(double newGammaMin, PlaceXTPN place, ElementLocation elementLocation) {
        double gammaMax = place.getGammaMaxValue();
        if (newGammaMin > gammaMax) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry010op1") + newGammaMin, lang.getText("SAXTPN_entry010op2") + gammaMax, lang.getText("SAXTPN_entry010op3")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry010_1") + newGammaMin + " " + lang.getText("SAXTPN_entry010_2") + gammaMax + "\n" + lang.getText("SAXTPN_entry010_3"), lang.getText("SAXTPN_entry010t"), -1, 3, null, options, options[0]);
            switch (answer) {
                case 0: {
                    place.setGammaMaxValue(newGammaMin, true);
                    place.setGammaMinValue(newGammaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    place.setGammaMinValue(gammaMax, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        place.setGammaMinValue(newGammaMin, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    public boolean setGammaMaxTime(double newGammaMax, PlaceXTPN place, ElementLocation elementLocation) {
        double gammaMin = place.getGammaMinValue();
        if (newGammaMax < gammaMin) {
            Object[] options = new String[]{lang.getText("SAXTPN_entry011op1") + gammaMin, lang.getText("SAXTPN_entry011op2") + newGammaMax, lang.getText("SAXTPN_entry011op3")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("SAXTPN_entry011_1") + newGammaMax + " " + lang.getText("SAXTPN_entry011_2") + gammaMin + "\n" + lang.getText("SAXTPN_entry011_3"), lang.getText("SAXTPN_entry011t"), -1, 3, null, options, options[1]);
            switch (answer) {
                case 0: {
                    place.setGammaMaxValue(gammaMin, true);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
                case 1: {
                    place.setGammaMinValue(newGammaMax, true);
                    place.setGammaMaxValue(newGammaMax, false);
                    this.repaintGraphPanel(elementLocation);
                    return true;
                }
            }
            return false;
        }
        place.setGammaMaxValue(newGammaMax, false);
        this.repaintGraphPanel(elementLocation);
        return true;
    }

    private void repaintGraphPanel(ElementLocation elementLocation) {
        int sheetIndex = overlord.IDtoIndex(elementLocation.getSheetID());
        GraphPanel graphPanel = overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        graphPanel.repaint();
    }
}

