/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.dockwindows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class PetriNetTools
implements TreeSelectionListener {
    private static final long serialVersionUID = 5385847227073467035L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JPanel panel = new JPanel();
    private Point position;
    private JTree toolTree;
    private DefaultMutableTreeNode pointerNode;

    public PetriNetTools() {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        JLabel label = new JLabel("Tools");
        label.setVisible(true);
        this.panel.add(label);
        DefaultMutableTreeNode miscNode = new DefaultMutableTreeNode("Misc");
        this.pointerNode = new DefaultMutableTreeNode("Pointer");
        miscNode.add(this.pointerNode);
        miscNode.add(new DefaultMutableTreeNode("Eraser"));
        DefaultMutableTreeNode basicPetriNetsNode = new DefaultMutableTreeNode("Petri net elements");
        basicPetriNetsNode.add(new DefaultMutableTreeNode("Place"));
        basicPetriNetsNode.add(new DefaultMutableTreeNode("Transition"));
        basicPetriNetsNode.add(new DefaultMutableTreeNode("Arc"));
        basicPetriNetsNode.add(new DefaultMutableTreeNode("Read Arc"));
        DefaultMutableTreeNode xTPNNode = new DefaultMutableTreeNode("extended Time PN");
        xTPNNode.add(new DefaultMutableTreeNode("xPlace"));
        xTPNNode.add(new DefaultMutableTreeNode("xTransition"));
        xTPNNode.add(new DefaultMutableTreeNode("xArc"));
        xTPNNode.add(new DefaultMutableTreeNode("xInhibitor"));
        DefaultMutableTreeNode extArcsNode = new DefaultMutableTreeNode("extended Arcs");
        extArcsNode.add(new DefaultMutableTreeNode("Inhibitor Arc"));
        extArcsNode.add(new DefaultMutableTreeNode("Reset Arc"));
        extArcsNode.add(new DefaultMutableTreeNode("Equal Arc"));
        DefaultMutableTreeNode otherTransNode = new DefaultMutableTreeNode("TPN, SPN");
        otherTransNode.add(new DefaultMutableTreeNode("(TPN) Time"));
        otherTransNode.add(new DefaultMutableTreeNode("(SPN) Stochastic"));
        DefaultMutableTreeNode colorNetsNode = new DefaultMutableTreeNode("Experimental");
        colorNetsNode.add(new DefaultMutableTreeNode("C-Place"));
        colorNetsNode.add(new DefaultMutableTreeNode("C-Transition"));
        colorNetsNode.add(new DefaultMutableTreeNode("C-Arc"));
        DefaultMutableTreeNode hierachicalNode = new DefaultMutableTreeNode("Subsets");
        hierachicalNode.add(new DefaultMutableTreeNode("Subnet"));
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Tools");
        rootNode.add(miscNode);
        rootNode.add(basicPetriNetsNode);
        rootNode.add(xTPNNode);
        rootNode.add(extArcsNode);
        rootNode.add(otherTransNode);
        rootNode.add(colorNetsNode);
        rootNode.add(hierachicalNode);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.toolTree = new JTree(treeModel);
        this.toolTree.getSelectionModel().setSelectionMode(1);
        this.toolTree.addTreeSelectionListener(this);
        for (int row = 0; row < this.toolTree.getRowCount(); ++row) {
            this.toolTree.expandRow(row);
        }
        this.toolTree.setCellRenderer(new LeafRenderer());
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)new JScrollPane(this.toolTree), "Center");
        this.position = new Point(0, 0);
    }

    public void selectPointer() {
        this.toolTree.setSelectionRow(2);
    }

    public JTree getTree() {
        return this.toolTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.toolTree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (!node.getUserObject().toString().equals("Pointer")) {
            if (PetriNetTools.overlord.reset.isSimulatorActiveWarning(lang.getText("PNNT_toolTip_entry001"), lang.getText("warning"))) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                return;
            }
            if (PetriNetTools.overlord.reset.isXTPNSimulatorActiveWarning(lang.getText("PNNT_toolTip_entry002"), lang.getText("warning"))) {
                overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                return;
            }
        }
        Object nodeInfo = node.getUserObject();
        if (node.isLeaf()) {
            String description;
            switch (description = (String)nodeInfo) {
                case "Pointer": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.POINTER);
                    break;
                }
                case "Eraser": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.ERASER);
                    break;
                }
                case "Place": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.PLACE);
                    break;
                }
                case "Transition": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.TRANSITION);
                    break;
                }
                case "(TPN) Time": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.TIMETRANSITION);
                    break;
                }
                case "(SPN) Stochastic": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.STOCHASTICTRANS);
                    break;
                }
                case "(SPN) Immediate": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.IMMEDIATETRANS);
                    break;
                }
                case "(SPN) Deterministic": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.DETERMINISTICTRANS);
                    break;
                }
                case "(SPN) Scheduled": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.SCHEDULEDTRANS);
                    break;
                }
                case "Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.ARC);
                    break;
                }
                case "Read Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.READARC);
                    break;
                }
                case "Inhibitor Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.ARC_INHIBITOR);
                    break;
                }
                case "Reset Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.ARC_RESET);
                    break;
                }
                case "Equal Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.ARC_EQUAL);
                    break;
                }
                case "Modifier Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.ARC_MODIFIER);
                    break;
                }
                case "xPlace": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.XPLACE);
                    break;
                }
                case "xArc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.XARC);
                    break;
                }
                case "xInhibitor": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.XINHIBITOR);
                    break;
                }
                case "xTransition": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.XTRANSITION);
                    break;
                }
                case "Subnet T-type": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.SUBNET_T);
                    break;
                }
                case "Subnet P-type": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.SUBNET_P);
                    break;
                }
                case "Subnet": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.SUBNET_PT);
                    break;
                }
                case "C-Place": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.CPLACE);
                    break;
                }
                case "C-Transition": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.CTRANSITION);
                    break;
                }
                case "C-Arc": {
                    overlord.getWorkspace().setGraphMode(GraphPanel.DrawModes.CARC);
                }
            }
        }
    }

    private static class LeafRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3169140404884453079L;
        private ImageIcon placeIcon = Tools.getResIcon16("/icons/place.gif");
        private ImageIcon transitionIcon = Tools.getResIcon16("/icons/transition.gif");
        private ImageIcon pointerIcon;
        private ImageIcon eraserIcon;
        private ImageIcon timeTransitionIcon = Tools.getResIcon16("/icons/timeTransition.gif");
        private ImageIcon functionalTransIcon = Tools.getResIcon16("/icons/funcTransition.gif");
        private ImageIcon stochasticTrans = Tools.getResIcon16("/icons/stochasticTransition.gif");
        private ImageIcon immediateTransIcon = Tools.getResIcon16("/icons/immediateTransition.gif");
        private ImageIcon deterministicTransIcon = Tools.getResIcon16("/icons/deterministicTransition.gif");
        private ImageIcon scheduledTransIcon = Tools.getResIcon16("/icons/scheduledTransition.gif");
        private ImageIcon arcIcon;
        private ImageIcon arcIconRead;
        private ImageIcon arcIconInh;
        private ImageIcon arcIconRst;
        private ImageIcon arcIconEql;
        private ImageIcon arcIconModifier;
        private ImageIcon xPlaceIcon;
        private ImageIcon xTransIcon;
        private ImageIcon xArcIcon;
        private ImageIcon xInhArcIcon;
        private ImageIcon subnetT;
        private ImageIcon subnetP;
        private ImageIcon subnetPT;
        private ImageIcon cplaceIcon;
        private ImageIcon ctransitionIcon;
        private ImageIcon carcIcon;

        public LeafRenderer() {
            this.pointerIcon = Tools.getResIcon16("/icons/pointer.gif");
            this.eraserIcon = Tools.getResIcon16("/icons/eraser.gif");
            this.arcIcon = Tools.getResIcon16("/icons/arc.gif");
            this.arcIconRead = Tools.getResIcon16("/icons/arcRead.gif");
            this.arcIconInh = Tools.getResIcon16("/icons/arcInh.gif");
            this.arcIconRst = Tools.getResIcon16("/icons/arcReset.gif");
            this.arcIconEql = Tools.getResIcon16("/icons/arcEqual.gif");
            this.arcIconModifier = Tools.getResIcon16("/icons/arcModifier.gif");
            this.xPlaceIcon = Tools.getResIcon16("/icons/xPlaceIcon.gif");
            this.xTransIcon = Tools.getResIcon16("/icons/xTransIcon.gif");
            this.xArcIcon = Tools.getResIcon16("/icons/xArcIcon.gif");
            this.xInhArcIcon = Tools.getResIcon16("/icons/xArcInhIcon.gif");
            this.subnetT = Tools.getResIcon16("/icons/subnetT.gif");
            this.subnetP = Tools.getResIcon16("/icons/subnetP.gif");
            this.subnetPT = Tools.getResIcon16("/icons/subnetPT.gif");
            this.cplaceIcon = Tools.getResIcon16("/icons/cplace.gif");
            this.ctransitionIcon = Tools.getResIcon16("/icons/ctransition.gif");
            this.carcIcon = Tools.getResIcon16("/icons/carc.gif");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String nodeInfo = (String)node.getUserObject();
            if (leaf) {
                switch (nodeInfo) {
                    case "Pointer": {
                        this.setIcon(this.pointerIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipPointer"));
                        break;
                    }
                    case "Eraser": {
                        this.setIcon(this.eraserIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipEraser"));
                        break;
                    }
                    case "Place": {
                        this.setIcon(this.placeIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipPlace"));
                        break;
                    }
                    case "Transition": {
                        this.setIcon(this.transitionIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipTrans"));
                        break;
                    }
                    case "(TPN) Time": {
                        this.setIcon(this.timeTransitionIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipTPNTrans"));
                        break;
                    }
                    case "(SPN) Stochastic": {
                        this.setIcon(this.stochasticTrans);
                        this.setToolTipText(lang.getText("PNTT_toolTipSPNTrans"));
                        break;
                    }
                    case "(SPN) Immediate": {
                        this.setIcon(this.immediateTransIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipSPNImmed"));
                        break;
                    }
                    case "(SPN) Deterministic": {
                        this.setIcon(this.deterministicTransIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipSPNDeter"));
                        break;
                    }
                    case "(SPN) Scheduled": {
                        this.setIcon(this.scheduledTransIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipSPNSched"));
                        break;
                    }
                    case "Arc": {
                        this.setIcon(this.arcIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipArc"));
                        break;
                    }
                    case "Read Arc": {
                        this.setIcon(this.arcIconRead);
                        this.setToolTipText(lang.getText("PNTT_toolTipReadArc"));
                        break;
                    }
                    case "Inhibitor Arc": {
                        this.setIcon(this.arcIconInh);
                        this.setToolTipText(lang.getText("PNTT_toolTipInhibArc"));
                        break;
                    }
                    case "Reset Arc": {
                        this.setIcon(this.arcIconRst);
                        this.setToolTipText(lang.getText("PNTT_toolTipResetArc"));
                        break;
                    }
                    case "Equal Arc": {
                        this.setIcon(this.arcIconEql);
                        this.setToolTipText(lang.getText("PNTT_toolTipEquArc"));
                        break;
                    }
                    case "Modifier Arc": {
                        this.setIcon(this.arcIconModifier);
                        this.setToolTipText(lang.getText("PNTT_toolTipModArc"));
                        break;
                    }
                    case "xPlace": {
                        this.setIcon(this.xPlaceIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipXTPNplace"));
                        break;
                    }
                    case "xTransition": {
                        this.setIcon(this.xTransIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipXTPNtrans"));
                        break;
                    }
                    case "xArc": {
                        this.setIcon(this.xArcIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipXTPNarc"));
                        break;
                    }
                    case "xInhibitor": {
                        this.setIcon(this.xInhArcIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipXTPNinhArc"));
                        break;
                    }
                    case "Subnet T-type": {
                        this.setIcon(this.subnetT);
                        this.setToolTipText(lang.getText("PNTT_toolTipSubnetP"));
                        break;
                    }
                    case "Subnet P-type": {
                        this.setIcon(this.subnetP);
                        this.setToolTipText(lang.getText("PNTT_toolTipSubnetT"));
                        break;
                    }
                    case "Subnet": {
                        this.setIcon(this.subnetPT);
                        this.setToolTipText(lang.getText("PNTT_toolTipSubnetPT"));
                        break;
                    }
                    case "C-Place": {
                        this.setIcon(this.cplaceIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipCplace"));
                        break;
                    }
                    case "C-Transition": {
                        this.setIcon(this.ctransitionIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipCtrans"));
                        break;
                    }
                    case "C-Arc": {
                        this.setIcon(this.carcIcon);
                        this.setToolTipText(lang.getText("PNTT_toolTipCarc"));
                    }
                }
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

