/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui.dockwindows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.clusters.ClusterDataPackage;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.darkgui.dockwindows.SelectionPanel;
import holmes.graphpanel.SelectionActionListener;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JScrollPane;

public class HolmesDockWindow {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private HolmesDockWindowsTable dockWindowPanel;
    private SelectionPanel selectionPanel;
    private JScrollPane scrollPane;
    private DockWindowType type;

    public HolmesDockWindow(DockWindowType propertiesType) {
        this.type = propertiesType;
        this.scrollPane = new JScrollPane();
        switch (this.type) {
            case SIMULATOR: {
                GraphicalSimulator netSim = overlord.getWorkspace().getProject().getSimulator();
                GraphicalSimulatorXTPN netSimXTPN = overlord.getWorkspace().getProject().getSimulatorXTPN();
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.SIMULATOR, netSim, netSimXTPN));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case EDITOR: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.EMPTY, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case SELECTOR: {
                this.setSelectionPanel(new SelectionPanel());
                this.scrollPane.getViewport().add(this.getSelectionPanel());
                break;
            }
            case FIXNET: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.FIXER, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case QuickSim: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.QUICKSIM, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case DECOMPOSITION: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.DECOMPOSITION, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case T_INVARIANTS: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.T_INVARIANTS, overlord.getWorkspace().getProject().getT_InvMatrix()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case P_INVARIANTS: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.P_INVARIANTS, overlord.getWorkspace().getProject().getP_InvMatrix()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case MctANALYZER: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.MCT, overlord.getWorkspace().getProject().getMCTMatrix()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case MCSselector: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.MCS, new Object[0]));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case ClusterSELECTOR: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CLUSTERS, new ClusterDataPackage()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
                break;
            }
            case Knockout: {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.KNOCKOUT, new ArrayList()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            }
        }
    }

    public void createSimulatorProperties(boolean XTPN) {
        if (this.type == DockWindowType.SIMULATOR) {
            GraphicalSimulator netSim = overlord.getWorkspace().getProject().getSimulator();
            GraphicalSimulatorXTPN netSimXTPN = overlord.getWorkspace().getProject().getSimulatorXTPN();
            this.dockWindowPanel.setSimulator(netSim, netSimXTPN);
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showT_invBoxWindow(ArrayList<ArrayList<Integer>> t_invariants) {
        if (this.type == DockWindowType.T_INVARIANTS) {
            if (t_invariants != null) {
                InvariantsCalculator ic = new InvariantsCalculator(true);
                InvariantsTools.analyseInvariantTypes(ic.getCMatrix(), t_invariants, true);
            }
            overlord.getT_invBox().getCurrentDockWindow().cleanTINVsubwindowFields();
            overlord.getT_invBox().getCurrentDockWindow().setT_invariants(t_invariants);
            overlord.getT_invBox().getCurrentDockWindow().refreshInvariantsComboBox();
            overlord.getT_invBox().getCurrentDockWindow().refreshSubSurCombos();
        }
    }

    public void showMCT(ArrayList<ArrayList<Transition>> mctGroups) {
        if (this.type == DockWindowType.MctANALYZER) {
            overlord.getMctBox().getCurrentDockWindow().cleanMCtsubwindowFields();
            overlord.getMctBox().getCurrentDockWindow().refreshMCTComboBox(mctGroups);
        }
    }

    public void showP_invBoxWindow(ArrayList<ArrayList<Integer>> p_invariants) {
        if (this.type == DockWindowType.P_INVARIANTS) {
            overlord.getP_invBox().getCurrentDockWindow().cleanPINVsubwindowFields();
            overlord.getP_invBox().getCurrentDockWindow().setP_invariants(p_invariants);
            overlord.getP_invBox().getCurrentDockWindow().refreshP_invComboBox();
        }
    }

    public void showDecompositionBoxWindows() {
        if (this.type == DockWindowType.DECOMPOSITION) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.DECOMPOSITION, new Object[0]));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showClusterSelector(ClusterDataPackage data) {
        if (this.type == DockWindowType.ClusterSELECTOR) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CLUSTERS, data));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void showMCS() {
        if (this.type == DockWindowType.MCSselector) {
            overlord.getMCSBox().getCurrentDockWindow().cleanMCScomboBoxes();
        }
    }

    public void showKnockout(ArrayList<ArrayList<Integer>> knockoutData) {
        if (this.type == DockWindowType.Knockout) {
            this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.KNOCKOUT, knockoutData));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
        }
    }

    public void updateSimulatorProperties() {
        if (this.type == DockWindowType.SIMULATOR) {
            // empty if block
        }
    }

    public void selectElement(SelectionActionListener.SelectionActionEvent e) {
        if (e.getActionType() == SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_ONE) {
            if (!e.getElementLocationGroup().isEmpty()) {
                Node n = e.getElementLocation().getParentNode();
                if (n.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                    if (n instanceof PlaceXTPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.XTPNPLACE, n, e.getElementLocation()));
                    } else {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.PLACE, n, e.getElementLocation()));
                    }
                } else if (n.getType() == PetriNetElement.PetriNetElementType.META) {
                    this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.META, n, e.getElementLocation()));
                } else if (n.getType().equals((Object)PetriNetElement.PetriNetElementType.TRANSITION)) {
                    if (((Transition)n).getTransType() == Transition.TransitionType.PN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.TRANSITION, n, e.getElementLocation()));
                    } else if (((Transition)n).getTransType() == Transition.TransitionType.TPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.TIMETRANSITION, n, e.getElementLocation()));
                    } else if (((Transition)n).getTransType() == Transition.TransitionType.SPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.SPNTRANSITION, n, e.getElementLocation()));
                    } else if (n instanceof TransitionXTPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.XTPNTRANSITION, n, e.getElementLocation()));
                    } else if (((Transition)n).getTransType() == Transition.TransitionType.CPN) {
                        this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CTRANSITION, n, e.getElementLocation()));
                    }
                    HolmesDockWindow.overlord.propericeTMPBox.removeAll();
                    HolmesDockWindow.overlord.propericeTMPBox.add(this.dockWindowPanel.getPanel());
                    overlord.getFrame().revalidate();
                    overlord.getFrame().repaint();
                }
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            } else if (!e.getArcGroup().isEmpty()) {
                this.setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.ARC, e.getArc()));
                this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            }
            HolmesDockWindow.overlord.propericeTMPBox.removeAll();
            HolmesDockWindow.overlord.propericeTMPBox.add(this.dockWindowPanel.getPanel());
            overlord.getFrame().revalidate();
            overlord.getFrame().repaint();
        } else if (e.getActionType() == SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_SHEET) {
            overlord.getPropertiesBox().setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.SHEET, overlord.getWorkspace().getSheets().get(overlord.getWorkspace().getIndexOfId(e.getSheetId()))));
            this.scrollPane.getViewport().add(this.getCurrentDockWindow());
            HolmesDockWindow.overlord.propericeTMPBox.removeAll();
            HolmesDockWindow.overlord.propericeTMPBox.add(this.dockWindowPanel.getPanel());
            overlord.getFrame().revalidate();
            overlord.getFrame().repaint();
            this.dockWindowPanel.setBackground(Color.BLUE);
        }
    }

    public HolmesDockWindowsTable getCurrentDockWindow() {
        return this.dockWindowPanel;
    }

    public void setCurrentDockWindow(HolmesDockWindowsTable properties) {
        this.dockWindowPanel = properties;
    }

    public SelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    private void setSelectionPanel(SelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
    }

    public static enum DockWindowType {
        EDITOR,
        SIMULATOR,
        SELECTOR,
        T_INVARIANTS,
        P_INVARIANTS,
        ClusterSELECTOR,
        MctANALYZER,
        MCSselector,
        Knockout,
        FIXNET,
        QuickSim,
        DECOMPOSITION;

    }
}

