/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LangEngDafaultDB;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class LanguageManager {
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private HashMap<String, String> defaultDictionary;
    private HashMap<String, String> availableLanguagesFromCfg;
    private HashMap<String, HashMap<String, String>> loadedLanguages;
    private HashMap<String, String> currentDictionary;
    private boolean languageCorrupted = false;
    private boolean fileCorrupted = false;
    private String selectedLanguage;
    public static String newline = System.getProperty("line.separator");

    public LanguageManager() {
        this.overlord.log("Holmes language processing started.", "text", true);
        this.defaultDictionary = LangEngDafaultDB.getDefaultEnglish();
        this.currentDictionary = this.defaultDictionary;
        this.overlord.logNoEnter("Language: ", "bold", false);
        this.overlord.logNoEnter("default english", "italic", false);
        this.overlord.logNoEnter(" Entries: ", "bold", false);
        this.overlord.log("" + this.defaultDictionary.size(), "italic", false);
        this.availableLanguagesFromCfg = new HashMap();
        this.loadedLanguages = new HashMap();
        if (this.LoadConfigFile()) {
            for (Map.Entry<String, String> entry : this.availableLanguagesFromCfg.entrySet()) {
                HashMap<String, String> loadedDict = this.LoadDictionaryFile(entry.getKey(), entry.getValue());
                if (this.fileCorrupted) continue;
                this.loadedLanguages.put(entry.getKey(), loadedDict);
            }
            if (this.loadedLanguages.isEmpty()) {
                this.selectedLanguage = "English";
                this.currentDictionary = this.defaultDictionary;
            }
        }
        this.CheckDictionaryIntegrity();
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }

    public void setLanguage(String language, boolean startup) {
        if (this.loadedLanguages.containsKey(language)) {
            this.selectedLanguage = language;
            this.currentDictionary = this.loadedLanguages.get(language);
            this.overlord.getSettingsManager().setValue("selected_language", language, !startup);
        } else {
            this.overlord.log("Language not found: " + language, "error", true);
            this.selectedLanguage = "English";
            this.currentDictionary = this.defaultDictionary;
            this.overlord.getSettingsManager().setValue("selected_language", "English", !startup);
        }
    }

    public String getText(String ID) {
        if (this.currentDictionary.containsKey(ID)) {
            String result = this.currentDictionary.get(ID);
            if (result.contains("\\n")) {
                result = result.replace("\\n", newline);
            }
            return result;
        }
        if (this.defaultDictionary.containsKey(ID)) {
            return this.defaultDictionary.get(ID);
        }
        this.overlord.log("Language Manager error, phrase ID: \"" + ID + "\" not found in internal backup dictionary.", "error", true);
        return "-----";
    }

    private boolean LoadConfigFile() {
        this.languageCorrupted = false;
        Path path = Paths.get("language.cfg", new String[0]);
        try (Scanner scanner = new Scanner(path);){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                String[] parts = currentLine.split(",");
                if (parts.length != 2) continue;
                this.availableLanguagesFromCfg.put(parts[0], parts[1].substring(6));
            }
            this.overlord.log("Language config read: " + this.availableLanguagesFromCfg.size() + " dictionaries.", "text", false);
            this.overlord.logNoEnter("Dictionary:", "bold", false);
            this.overlord.logNoEnter(" | ", "text", false);
            for (Map.Entry<String, String> entry : this.availableLanguagesFromCfg.entrySet()) {
                String key = entry.getKey();
                this.overlord.logNoEnter(key + " | ", "text", false);
            }
            this.overlord.log("", "text", false);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error reading language config file", "Config error", 0);
            this.overlord.log("Error in language config file, reverting to default english.", "error", true);
            this.languageCorrupted = true;
        }
        return !this.languageCorrupted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, String> LoadDictionaryFile(String language, String dictPath) {
        HashMap<String, String> dictionary = new HashMap<String, String>();
        Path path = Paths.get(dictPath, new String[0]);
        try (Scanner scanner = new Scanner(path);){
            while (scanner.hasNextLine()) {
                String currentLine = scanner.nextLine();
                if (currentLine.startsWith("//") || currentLine.length() < 5) continue;
                try {
                    int comma = currentLine.indexOf(",");
                    if (comma == -1) continue;
                    String[] parts = new String[]{currentLine.substring(0, comma), currentLine.substring(comma + 1)};
                    if (dictionary.containsKey(parts[0])) {
                        this.overlord.log("Duplicate entry " + parts[0] + " in language file: " + dictPath, "error", false);
                        continue;
                    }
                    dictionary.put(parts[0], parts[1].stripLeading());
                }
                catch (Exception e) {
                    this.overlord.log("Error parsing line (" + dictPath + "): " + currentLine, "text", true);
                }
            }
            this.overlord.logNoEnter("Loaded: ", "bold", false);
            this.overlord.logNoEnter(language, "italic", false);
            this.overlord.logNoEnter(" File: ", "bold", false);
            this.overlord.logNoEnter(dictPath, "italic", false);
            this.overlord.logNoEnter(" Entries: ", "bold", false);
            this.overlord.log("" + dictionary.size(), "italic", false);
            return dictionary;
        }
        catch (Exception e) {
            this.overlord.log("Error in language dictionary file " + dictPath, "error", true);
            this.fileCorrupted = true;
        }
        return dictionary;
    }

    private void CheckDictionaryIntegrity() {
        for (Map.Entry<String, HashMap<String, String>> languagesEntry : this.loadedLanguages.entrySet()) {
            HashMap<String, String> language = languagesEntry.getValue();
            String langName = languagesEntry.getKey();
            for (Map.Entry<String, String> entry : this.defaultDictionary.entrySet()) {
                String dafultKey = entry.getKey();
                if (language.containsKey(dafultKey)) continue;
                this.overlord.log(langName + " missing tag: " + dafultKey, "warning", false);
            }
        }
    }
}

