/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import holmes.analyse.MCTCalculator;
import holmes.clusters.ClusterDataPackage;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import holmes.workspace.Workspace;
import javax.swing.JOptionPane;

public class GUIReset {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private boolean t_invGenerated = false;
    private boolean p_invGenerated = false;
    private boolean mctGenerated = false;
    private boolean clustersGenerated = false;
    private boolean subNetGenerated = false;

    public void clearGraphColors() {
        overlord.getWorkspace().getProject().resetNetColors();
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        GUIReset.overlord.simSettings.quickSimToken = false;
    }

    public boolean newProjectInitiated() {
        if (this.isSimulatorActiveWarning(lang.getText("GUIR_reset001"), "Warning")) {
            return false;
        }
        if (this.isXTPNSimulatorActiveWarning(lang.getText("GUIR_reset002"), "Warning")) {
            return false;
        }
        boolean hasSomethingChanged = overlord.getNetChangeStatus();
        if (hasSomethingChanged) {
            boolean savingStatus;
            Object[] options = new Object[]{lang.getText("continue"), lang.getText("saveAndCont"), lang.getText("cancel")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("GUIR_reset003"), lang.getText("GUIR_reset004"), 0, 3, null, options, options[2]);
            if (n == 2) {
                return false;
            }
            if (n == 1 && !(savingStatus = GUIReset.overlord.io.saveAsGlobal())) {
                return false;
            }
        }
        PetriNet pNet = overlord.getWorkspace().getProject();
        overlord.log(lang.getText("LOGentry00034"), "text", true);
        for (GraphPanel gp : pNet.getGraphPanels()) {
            gp.getSelectionManager().forceDeselectAllElements();
        }
        this.clearAll();
        return true;
    }

    public void emergencyRestart() {
        overlord.log(lang.getText("LOGentry00035"), "error", true);
        this.clearAll();
    }

    private void clearAll() {
        PetriNet pNet = overlord.getWorkspace().getProject();
        overlord.log(lang.getText("GUIR_reset005"), "text", true);
        pNet.resetData();
        pNet.setProjectType(PetriNet.GlobalNetType.PN);
        pNet.setT_InvMatrix(null, false);
        pNet.setP_InvMatrix(null);
        pNet.setMCTMatrix(null, false);
        pNet.accessMCTnames().clear();
        pNet.accessStatesManager().resetPN(true);
        pNet.accessStatesManager().removeAllMultisets_M(true);
        pNet.accessSSAmanager().reset(false);
        pNet.accessFiringRatesManager().reset(false);
        pNet.setMCSdataCore(new MCSDataMatrix());
        GUIReset.overlord.simSettings.reset();
        pNet.clearSimKnockoutData();
        pNet.resetComm();
        pNet.setMCTanalyzer(new MCTCalculator(pNet));
        pNet.setSimulator(new GraphicalSimulator(SimulatorGlobals.SimNetType.BASIC, pNet));
        pNet.setSimulatorXTPN(new GraphicalSimulatorXTPN(SimulatorGlobals.SimNetType.XTPN, pNet));
        pNet.setSimulationActive(false);
        pNet.setFileName("");
        GUIReset.overlord.simSettings.currentStep = 0L;
        GUIReset.overlord.simSettings.currentTime = 0.0;
        overlord.accessStateSimulatorWindow().resetSimWindow();
        overlord.accessStateSimulatorXTPNWindow().resetSimWindow();
        overlord.accessClusterWindow().resetWindow();
        overlord.getSimulatorBox().createSimulatorProperties(false);
        overlord.resetModuls();
        pNet.repaintAllGraphPanels();
        Workspace workspace = overlord.getWorkspace();
        workspace.deleteAllSheetButFirst();
        this.reset2ndOrderData(false);
        IdGenerator.resetIDgenerator();
        overlord.getFrame().setTitle("Holmes " + overlord.getSettingsManager().getValue("holmes_version"));
        overlord.markNetSaved();
    }

    public void reset2ndOrderData(boolean clearWindows) {
        PetriNet pNet = overlord.getWorkspace().getProject();
        if (clearWindows) {
            GUIReset.overlord.simSettings.currentStep = 0L;
            GUIReset.overlord.simSettings.currentTime = 0.0;
            overlord.accessStateSimulatorWindow().resetSimWindow();
            overlord.accessStateSimulatorXTPNWindow().resetSimWindow();
            overlord.accessClusterWindow().resetWindow();
        }
        if (this.t_invGenerated) {
            overlord.accessNetTablesWindow().resetT_invData();
            this.resetCommunicationProtocol();
            pNet.setT_InvMatrix(null, false);
            pNet.getMCSdataCore().resetMSC();
            if (overlord.getT_invBox().getCurrentDockWindow() != null) {
                overlord.getT_invBox().getCurrentDockWindow().cleanTINVsubwindowFields();
            }
            this.t_invGenerated = false;
            overlord.log(lang.getText("LOGentry00036"), "text", true);
        }
        if (this.mctGenerated) {
            pNet.setMCTMatrix(null, false);
            pNet.accessMCTnames().clear();
            if (overlord.getMctBox().getCurrentDockWindow() != null) {
                overlord.getMctBox().getCurrentDockWindow().cleanMCtsubwindowFields();
            }
            this.mctGenerated = false;
            overlord.log(lang.getText("LOGentry00037"), "text", true);
        }
        if (this.p_invGenerated) {
            pNet.setP_InvMatrix(null);
            if (overlord.getP_invBox().getCurrentDockWindow() != null) {
                overlord.getP_invBox().getCurrentDockWindow().cleanPInvSubwindowData();
            }
            this.p_invGenerated = false;
            overlord.log(lang.getText("LOGentry00038"), "text", true);
        }
        if (this.clustersGenerated) {
            if (overlord.getClusterSelectionBox().getCurrentDockWindow() != null) {
                overlord.getClusterSelectionBox().getCurrentDockWindow().removeAll();
                overlord.getClusterSelectionBox().getCurrentDockWindow().cleanClustersSubwindowData();
            }
            overlord.getClusterSelectionBox().setCurrentDockWindow(new HolmesDockWindowsTable(HolmesDockWindowsTable.SubWindow.CLUSTERS, new ClusterDataPackage()));
            this.clustersGenerated = false;
            overlord.log(lang.getText("LOGentry00039"), "text", true);
        }
        if (this.subNetGenerated) {
            this.subNetGenerated = false;
            overlord.log(lang.getText("LOGentry00040"), "text", true);
        }
    }

    public void resetCommunicationProtocol() {
        overlord.getWorkspace().getProject().resetComm();
    }

    public void setT_invariantsStatus(boolean status) {
        this.t_invGenerated = status;
    }

    public void setP_invariantsStatus(boolean status) {
        this.p_invGenerated = status;
    }

    public void setMCTStatus(boolean status) {
        this.mctGenerated = status;
    }

    public void setClustersStatus(boolean status) {
        this.clustersGenerated = status;
    }

    public void setDecompositionStatus(boolean status) {
        this.subNetGenerated = status;
    }

    public boolean isSimulatorActive() {
        GraphicalSimulator ns = overlord.getSimulatorBox().getCurrentDockWindow().getSimulator();
        return ns.getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED;
    }

    public boolean isSimulatorActiveWarning(String msg, String msgTitle) {
        GraphicalSimulator obj = overlord.getWorkspace().getProject().getSimulator();
        if (obj != null) {
            if (obj.getSimulatorStatus() == GraphicalSimulator.SimulatorMode.STOPPED) {
                return false;
            }
            JOptionPane.showMessageDialog(null, msg, msgTitle, 2);
            return true;
        }
        return false;
    }

    public boolean isXTPNSimulatorActiveWarning(String msg, String msgTitle) {
        GraphicalSimulatorXTPN obj = overlord.getWorkspace().getProject().getSimulatorXTPN();
        if (obj != null) {
            if (obj.getsimulatorStatusXTPN() == GraphicalSimulatorXTPN.SimulatorModeXTPN.STOPPED) {
                return false;
            }
            JOptionPane.showMessageDialog(null, msg, msgTitle, 2);
            return true;
        }
        return false;
    }
}

