/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import holmes.adam.mct.Runner;
import holmes.analyse.InvariantsCalculator;
import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.clusters.Rprotocols;
import holmes.files.io.ProjectReader;
import holmes.files.io.ProjectWriter;
import holmes.graphpanel.EditorResources;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.HolmesFileView;
import holmes.utilities.Tools;
import holmes.varia.Check;
import holmes.workspace.ExtensionFileFilter;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GUIOperations {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public GUIOperations() {
    }

    public GUIOperations(GUIManager mastah) {
        this();
    }

    public void importNetwork() {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("All supported Snoopy files", new String[]{"SPPED", "SPEPT", "SPTPT", "PN", "XPN"}), new ExtensionFileFilter("Snoopy Petri Net file (.spped), (.pn)", new String[]{"SPPED", "PN", "XPN"}), new ExtensionFileFilter("Snoopy Extended PN file (.spept), (.xpn)", new String[]{"SPEPT", "XPN"}), new ExtensionFileFilter("Snoopy Time PN file (.sptpt)", new String[]{"SPTPT"}), new ExtensionFileFilter(".pnt - INA PNT file (.pnt)", new String[]{"PNT"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Select PN", "Select petri net file", "");
        if (selectedFile.isEmpty()) {
            return;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return;
        }
        boolean status = overlord.getWorkspace().getProject().loadFromFile(file.getPath());
        if (status) {
            overlord.setLastPath(file.getParentFile().getPath());
            overlord.getSimulatorBox().createSimulatorProperties(false);
            overlord.getFrame().setTitle("Holmes " + overlord.getSettingsManager().getValue("holmes_version") + "  " + Tools.getFileName(file));
        }
    }

    public void selectAndOpenHolmesProject() {
        String lastPath = overlord.getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter holmesProjFilter = new ExtensionFileFilter("Holmes Project file (.project)", new String[]{"PROJECT"});
        ExtensionFileFilter projFilter = new ExtensionFileFilter("Old project file (.apf)", new String[]{"APF"});
        ExtensionFileFilter abyssFilter = new ExtensionFileFilter("Abyss Petri Net (.abyss)", new String[]{"ABYSS"});
        fc.setFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(projFilter);
        fc.addChoosableFileFilter(abyssFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showOpenDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String extension = fc.getFileFilter().getDescription();
            if (fc.getSelectedFile().toString().isEmpty()) {
                return;
            }
            if (!file.exists()) {
                return;
            }
            boolean proceed = GUIOperations.overlord.reset.newProjectInitiated();
            if (!proceed) {
                return;
            }
            boolean status = false;
            if (extension.toLowerCase().contains(".apf") || extension.toLowerCase().contains(".project")) {
                ProjectReader pRdr = new ProjectReader();
                GUIController.access().setRefresh(false);
                status = pRdr.readProject(file.getPath());
                GUIController.access().setRefresh(true);
                overlord.setLastPath(file.getParentFile().getPath());
                GUIOperations.overlord.subnetsGraphics.resizePanels();
            } else if (extension.toLowerCase().contains(".abyss")) {
                status = overlord.getWorkspace().getProject().loadFromFile(file.getPath());
                overlord.setLastPath(file.getParentFile().getPath());
            }
            if (status) {
                overlord.log(lang.getText("GUIO_openProject001"), "text", true);
                overlord.getFrame().setTitle("Holmes " + overlord.getSettingsManager().getValue("holmes_version") + "  " + Tools.getFileName(file));
            }
        }
    }

    public void exportAsPNT() {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("INA PNT file (.pnt)", new String[]{"PNT"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "", overlord.getWorkspace().getProject().getFileName());
        if (selectedFile.isEmpty()) {
            return;
        }
        File file = new File(selectedFile);
        String fileExtension = ".pnt";
        if (selectedFile.toLowerCase().contains(".pnt")) {
            fileExtension = "";
        }
        overlord.getWorkspace().getProject().saveAsPNT(file.getPath() + fileExtension);
        overlord.setLastPath(file.getParentFile().getPath());
    }

    public boolean exportGeneratedInvariants(boolean t_inv) {
        String lastPath = overlord.getLastPath();
        int result = 0;
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter inaFilter = new ExtensionFileFilter("INA Invariants File (.inv)", new String[]{"INV"});
        ExtensionFileFilter charlieFilter = new ExtensionFileFilter("Charlie Invariants File (.inv)", new String[]{"INV"});
        ExtensionFileFilter csvFilter = new ExtensionFileFilter("Comma Separated Values (.csv)", new String[]{"CSV"});
        fc.setFileFilter(inaFilter);
        fc.addChoosableFileFilter(inaFilter);
        fc.addChoosableFileFilter(charlieFilter);
        fc.addChoosableFileFilter(csvFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String description = fc.getFileFilter().getDescription();
            if (description.contains("INA")) {
                String fileExtension = file.getPath().toLowerCase().contains(".inv") ? "" : ".inv";
                result = overlord.getWorkspace().getProject().saveInvariantsToInaFormat(file.getPath() + fileExtension, t_inv);
            } else if (description.contains("Comma")) {
                String fileExtension = file.getPath().toLowerCase().contains(".csv") ? "" : ".csv";
                result = overlord.getWorkspace().getProject().saveInvariantsToCSV(file.getPath() + fileExtension, false, t_inv);
            } else if (description.contains("Charlie")) {
                String fileExtension = file.getPath().toLowerCase().contains(".inv") ? "" : ".inv";
                result = overlord.getWorkspace().getProject().saveInvariantsToCharlie(file.getPath() + fileExtension, t_inv);
            }
        }
        return result == 0;
    }

    public void exportProjectToImage() {
        String lastPath = overlord.getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter pngFilter = new ExtensionFileFilter("Portable Network Graphics (.png)", new String[]{"png"});
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter("Bitmap Image File (.bmp)", new String[]{"bmp"});
        ExtensionFileFilter jpegFilter = new ExtensionFileFilter("JPEG Image File (.jpeg)", new String[]{"jpeg"});
        ExtensionFileFilter jpgFilter = new ExtensionFileFilter("JPEG Image File (jpg)", new String[]{"jpg"});
        fc.setFileFilter(pngFilter);
        fc.addChoosableFileFilter(pngFilter);
        fc.addChoosableFileFilter(bmpFilter);
        fc.addChoosableFileFilter(jpegFilter);
        fc.addChoosableFileFilter(jpgFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String ext = "";
            String extension = fc.getFileFilter().getDescription();
            if (extension.toLowerCase().contains(".png")) {
                ext = ".png";
            }
            if (extension.toLowerCase().contains(".bmp")) {
                ext = ".bmp";
            }
            if (extension.toLowerCase().contains(".jpeg") || extension.contains(".jpg")) {
                ext = ".jpeg";
            }
            Object fullPath = "";
            for (BufferedImage bi : overlord.getWorkspace().getProject().getImagesFromGraphPanels()) {
                try {
                    String ext2 = "";
                    String path = file.getPath();
                    if (ext.equals(".png") && !path.contains(".png")) {
                        ext2 = ".png";
                    }
                    if (ext.equals(".bmp") && !file.getPath().contains(".bmp")) {
                        ext2 = ".bmp";
                    }
                    if (ext.equals(".jpeg") && !file.getPath().contains(".jpeg")) {
                        ext2 = ".jpeg";
                    }
                    if (ext.equals(".jpeg") && !file.getPath().contains(".jpg")) {
                        ext2 = ".jpg";
                    }
                    String fileName = file.getName();
                    String pathOutput = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(File.separator)) + "//";
                    fullPath = pathOutput + fileName + ext2;
                    ImageIO.write((RenderedImage)bi, ext.substring(1), new File((String)fullPath));
                }
                catch (IOException ex) {
                    overlord.log(lang.getText("LOGentry00014") + (String)fullPath, "error", true);
                }
            }
            overlord.setLastPath(file.getParentFile().getPath());
        }
    }

    public boolean saveAsAbyssFile() {
        boolean status = false;
        String lastPath = overlord.getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter holmesProjFilter = new ExtensionFileFilter("Holmes Project file (.project)", new String[]{"PROJECT"});
        ExtensionFileFilter projFilter = new ExtensionFileFilter("Old Project file (.apf)", new String[]{"APF"});
        ExtensionFileFilter abyssFilter = new ExtensionFileFilter("Abyss Petri Net (.abyss)", new String[]{"ABYSS"});
        fc.setFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(holmesProjFilter);
        fc.addChoosableFileFilter(projFilter);
        fc.addChoosableFileFilter(abyssFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String extension = fc.getFileFilter().getDescription();
            if (extension.toLowerCase().contains(".project")) {
                if (!Tools.overwriteDecision(file.getPath())) {
                    return false;
                }
                String fileExtension = ".project";
                if (file.getPath().toLowerCase().contains(".project")) {
                    fileExtension = "";
                }
                ProjectWriter pWrt = new ProjectWriter();
                status = pWrt.writeProject(file.getPath() + fileExtension);
                overlord.setLastPath(file.getParentFile().getPath());
                return status;
            }
            if (extension.toLowerCase().contains(".apf")) {
                if (!Tools.overwriteDecision(file.getPath())) {
                    return false;
                }
                String fileExtension = ".apf";
                if (file.getPath().toLowerCase().contains(".apf")) {
                    fileExtension = "";
                }
                ProjectWriter pWrt = new ProjectWriter();
                status = pWrt.writeProject(file.getPath() + fileExtension);
                overlord.setLastPath(file.getParentFile().getPath());
                return status;
            }
            if (extension.toLowerCase().contains(".abyss")) {
                if (!Tools.overwriteDecision(file.getPath())) {
                    return false;
                }
                String fileExtension = ".abyss";
                if (file.getPath().toLowerCase().contains(".abyss")) {
                    fileExtension = "";
                }
                status = overlord.getWorkspace().getProject().saveAsAbyss(file.getPath() + fileExtension);
                overlord.setLastPath(file.getParentFile().getPath());
                return status;
            }
        }
        return status;
    }

    public boolean saveAsGlobal() {
        FileFilter[] filters;
        String lastPath = overlord.getLastPath();
        String selectedFile = Tools.selectNetSaveFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("All supported Snoopy files", new String[]{"SPPED", "SPEPT", "SPTPT"}), new ExtensionFileFilter("Snoopy Petri Net (.spped)", new String[]{"SPPED"}), new ExtensionFileFilter("Snoopy Extended Petri Net (.spept)", new String[]{"SPEPT"}), new ExtensionFileFilter("Snoopy Time Petri Net (.sptpt)", new String[]{"SPTPT"}), new ExtensionFileFilter("Holmes Project File (.project)", new String[]{"PROJECT"}), new ExtensionFileFilter("INA PNT format (.pnt)", new String[]{"PNT"})}, "Save", "", overlord.getWorkspace().getProject().getFileName());
        if (selectedFile.isEmpty()) {
            return false;
        }
        if (!Tools.overwriteDecision(selectedFile)) {
            return false;
        }
        String extension = Tools.lastExtension;
        if (extension == null || extension.isEmpty()) {
            JOptionPane.showMessageDialog(null, lang.getText("GUIO_messageBox001"), lang.getText("error"), 0);
            overlord.log(lang.getText("LOGentry00015") + extension, "error", true);
            return false;
        }
        if ((extension = this.checkFileFormatCorrectness(extension)).contains(".spped")) {
            File file = new File(selectedFile);
            String fileExtension = ".spped";
            if (selectedFile.toLowerCase().contains(".spped")) {
                fileExtension = "";
            }
            boolean status = overlord.getWorkspace().getProject().saveAsSPPED(file.getPath() + fileExtension);
            overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".spept")) {
            File file = new File(selectedFile);
            String fileExtension = ".spept";
            if (selectedFile.toLowerCase().contains(".spept")) {
                fileExtension = "";
            }
            boolean status = overlord.getWorkspace().getProject().saveAsSPEPT(file.getPath() + fileExtension);
            overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".sptpt")) {
            File file = new File(selectedFile);
            String fileExtension = ".sptpt";
            if (selectedFile.toLowerCase().contains(".sptpt")) {
                fileExtension = "";
            }
            boolean status = overlord.getWorkspace().getProject().saveAsSPTPT(file.getPath() + fileExtension);
            overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".project")) {
            File file = new File(selectedFile);
            if (!Tools.overwriteDecision(file.getPath())) {
                return false;
            }
            String fileExtension = ".project";
            if (file.getPath().toLowerCase().contains(".project")) {
                fileExtension = "";
            }
            ProjectWriter pWrt = new ProjectWriter();
            boolean status = pWrt.writeProject(file.getPath() + fileExtension);
            overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        if (extension.contains(".pnt")) {
            File file = new File(selectedFile);
            String fileExtension = ".pnt";
            if (selectedFile.toLowerCase().contains(".pnt")) {
                fileExtension = "";
            }
            boolean status = overlord.getWorkspace().getProject().saveAsPNT(file.getPath() + fileExtension);
            overlord.setLastPath(file.getParentFile().getPath());
            return status;
        }
        return false;
    }

    private String checkFileFormatCorrectness(String extension) {
        String netRealName;
        String fileFormat;
        if (overlord.getSettingsManager().getValue("editorExportCheckAndWarning").equals("0")) {
            return extension;
        }
        if (extension.contains(".project")) {
            return extension;
        }
        if (extension.contains("all supported")) {
            Tools.lastExtension = extension = "snoopy petri net (.spped)";
        }
        PetriNet.GlobalNetType netType = Check.getSuggestedNetType();
        String additionalWhining = "";
        if (netType != null) {
            PetriNet.GlobalFileNetType suggestion = Check.suggestesFileFormat(netType);
            fileFormat = Check.getExtension(suggestion);
            fileFormat = fileFormat.toLowerCase();
            netRealName = Check.getNetName(netType);
            if (Check.isHierarchical()) {
                additionalWhining = lang.getText("GUIO_warning001");
            }
        } else {
            netRealName = "Unknown";
            fileFormat = "Holmes Project file";
            additionalWhining = lang.getText("GUIO_warning002");
        }
        if (extension.toLowerCase().contains(fileFormat) && additionalWhining.isEmpty()) {
            return extension;
        }
        if (fileFormat.equals(".project")) {
            fileFormat = "Holmes project file (.project)";
        }
        String strB = "err.";
        try {
            strB = String.format(lang.getText("GUIO_warning003"), extension, netRealName, fileFormat, additionalWhining);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " GUIO_warning003", "error", true);
        }
        Object[] options = new Object[]{lang.getText("GUIO_entry101op1"), lang.getText("GUIO_entry101op2"), lang.getText("GUIO_entry101op3"), lang.getText("GUIO_entry101op4")};
        int n = JOptionPane.showOptionDialog(null, strB, lang.getText("GUIO_warning003title"), 0, 2, null, options, options[0]);
        if (n == 0) {
            return extension;
        }
        if (n == 1) {
            return "." + fileFormat;
        }
        if (n == 2) {
            return ".project";
        }
        return "";
    }

    public boolean loadExternalAnalysis(boolean t_inv) {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{t_inv ? new ExtensionFileFilter("T-invariants file (.inv)", new String[]{"INV"}) : new ExtensionFileFilter("P-invariants file (.inv)", new String[]{"INV"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("GUIO_button001"), lang.getText("GUIO_button001b"), "");
        if (selectedFile.isEmpty()) {
            return false;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return false;
        }
        PetriNet project = overlord.getWorkspace().getProject();
        boolean status = project.loadTPinvariantsFromFile(file.getPath(), t_inv);
        if (!status) {
            return false;
        }
        if (t_inv) {
            overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
            overlord.getSimulatorBox().createSimulatorProperties(false);
        } else {
            overlord.getP_invBox().showP_invBoxWindow(project.getP_InvMatrix());
        }
        return true;
    }

    public void generateINAinvariants(boolean t_inv) {
        String stars = "************************************************************************************************";
        String toolPath = overlord.getToolPath();
        File tmpPNTfile = new File(toolPath + "siec.pnt");
        String x = tmpPNTfile.getPath();
        overlord.getWorkspace().getProject().saveAsPNT(x);
        long size = tmpPNTfile.length();
        if (size < 154L) {
            String msg = lang.getText("GUIO_inaInv001") + x + lang.getText("GUIO_inaInv002");
            JOptionPane.showMessageDialog(null, msg, lang.getText("GUIO_inaInv003"), 0);
            overlord.log(msg, "error", true);
            overlord.accessInvariantsWindow().setGeneratorStatus(false);
            return;
        }
        File inaExe = new File(toolPath + "INAwin32.exe");
        File batFile = new File(toolPath + "ina.bat");
        File commandFile = new File(toolPath + "COMMAND.ina");
        if (!t_inv) {
            commandFile = new File(toolPath + "COMMANDp.ina");
        }
        String holmesPath = overlord.getHolmesPath();
        if (inaExe.exists() && commandFile.exists()) {
            FileFilter[] filters;
            String selectedFile;
            try {
                JOptionPane.showMessageDialog(null, lang.getText("GUIO_inaInv004"), lang.getText("GUIO_inaInv005"), 1);
                overlord.log(stars, "text", false);
                overlord.log(lang.getText("LOGentry00016"), "text", true);
                Tools.copyFileByPath(inaExe.getPath(), holmesPath + "\\INAwin32.exe");
                Tools.copyFileByPath(batFile.getPath(), holmesPath + "\\ina.bat");
                Tools.copyFileByPath(commandFile.getPath(), holmesPath + "\\COMMAND.ina");
                Tools.copyFileByPath(tmpPNTfile.getPath(), holmesPath + "\\siec.pnt");
                tmpPNTfile.delete();
                String[] command = new String[]{"ina.bat"};
                ProcessBuilder b = new ProcessBuilder(command);
                Process proc = b.start();
                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                while (in.readLine() != null) {
                }
                Thread.sleep(200L);
                proc.destroy();
                new File(holmesPath + "\\INAwin32.exe").delete();
                new File(holmesPath + "\\ina.bat").delete();
                new File(holmesPath + "\\COMMAND.ina").delete();
                new File(holmesPath + "\\siec.pnt").delete();
                File t1 = new File(holmesPath + "\\SESSION.ina");
                File t2 = new File(holmesPath + "\\OPTIONS.ina");
                File t3 = new File(holmesPath + "\\INVARI.hlp");
                if (t1.exists()) {
                    t1.delete();
                }
                if (t2.exists()) {
                    t2.delete();
                }
                if (t3.exists()) {
                    t3.delete();
                }
                overlord.log(lang.getText("LOGentry00017"), "text", true);
            }
            catch (Exception e) {
                String msg = lang.getText("GUIO_inaInv006");
                JOptionPane.showMessageDialog(null, msg, lang.getText("critError"), 0);
                overlord.log(msg, "error", true);
                overlord.log(stars, "text", false);
                overlord.accessInvariantsWindow().setGeneratorStatus(false);
                return;
            }
            File invariantsFile = new File("siec.inv");
            if (!invariantsFile.exists()) {
                String msg = lang.getText("GUIO_inaInv007");
                JOptionPane.showMessageDialog(null, msg, lang.getText("critError"), 0);
                overlord.log(msg, "error", true);
                overlord.accessInvariantsWindow().setGeneratorStatus(false);
                return;
            }
            PetriNet project = overlord.getWorkspace().getProject();
            boolean status = project.loadTPinvariantsFromFile(invariantsFile.getPath(), t_inv);
            if (!status) {
                return;
            }
            if (t_inv) {
                overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
                overlord.getSimulatorBox().createSimulatorProperties(false);
            } else {
                overlord.getP_invBox().showP_invBoxWindow(project.getP_InvMatrix());
            }
            String lastPath = overlord.getLastPath();
            Object[] options = new Object[]{lang.getText("GUIO_inaInv008"), lang.getText("GUIO_inaInv009")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("GUIO_inaInv010"), lang.getText("GUIO_inaInv011"), 0, 3, null, options, options[0]);
            if (n == 0 && !(selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("INA Invariants file (.inv)", new String[]{"INV"})}, lang.getText("save"), lang.getText("GUIO_inaInv012"), "")).equals("")) {
                File file = new File(selectedFile);
                String ext = "";
                if (!file.getPath().contains(".inv")) {
                    ext = ".inv";
                }
                File properName = new File(file.getPath() + ext);
                Tools.copyFileDirectly(invariantsFile, properName);
            }
            overlord.log(lang.getText("LOGentry00018"), "text", true);
            overlord.log(stars, "text", false);
            invariantsFile.delete();
            overlord.accessInvariantsWindow().setGeneratorStatus(false);
        } else {
            overlord.accessInvariantsWindow().setGeneratorStatus(false);
            String msg = lang.getText("GUIO_inaInv013");
            JOptionPane.showMessageDialog(null, msg, lang.getText("GUIO_inaInv014"), 0);
            overlord.log(msg, "error", true);
        }
    }

    public void fastGenerateTinvariants() {
        boolean status = GUIOperations.overlord.accessInvariantsWindow().isGeneratorWorking;
        if (status) {
            JOptionPane.showMessageDialog(null, lang.getText("GUIO_invariants001"), lang.getText("GUIO_invariants002"), 2);
        } else {
            InvariantsCalculator invGenerator = new InvariantsCalculator(true);
            Thread myThread = new Thread(invGenerator);
            myThread.start();
        }
    }

    public void generateSimpleMCTFile() {
        String filePath = overlord.getTmpPath() + "input.csv";
        int result = overlord.getWorkspace().getProject().saveInvariantsToCSV(filePath, true, true);
        if (result == -1) {
            String msg = lang.getText("GUIO_mct001");
            JOptionPane.showMessageDialog(null, msg, lang.getText("GUIO_mct002"), 0);
            overlord.log(msg, "error", true);
            return;
        }
        try {
            overlord.log(lang.getText("LOGentry00019"), "text", true);
            Runner mctRunner = new Runner();
            String[] args = new String[]{filePath};
            mctRunner.activate(args);
            String lastPath = overlord.getLastPath();
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("MCT sets file (.mct)", new String[]{"MCT"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("save"), lang.getText("GUIO_mct003"), "");
            if (selectedFile.isEmpty()) {
                File csvFile = new File(filePath);
                csvFile.delete();
                JOptionPane.showMessageDialog(null, lang.getText("GUIO_mct004"), lang.getText("GUIO_mct005"), 1);
                overlord.log(lang.getText("LOGentry00020") + overlord.getTmpPath() + "input.csv.analysed.txt", "text", true);
            } else {
                File file = new File(selectedFile);
                String ext = "";
                if (!file.getPath().contains(".mct")) {
                    ext = ".mct";
                }
                File properName = new File(file.getPath() + ext);
                File generatedMCT = new File(overlord.getTmpPath() + "input.csv.analysed.txt");
                Tools.copyFileDirectly(generatedMCT, properName);
                generatedMCT.delete();
                File csvFile = new File(filePath);
                csvFile.delete();
                JOptionPane.showMessageDialog(null, lang.getText("GUIO_mct006"), lang.getText("GUIO_mct005"), 1);
                overlord.log(lang.getText("LOGentry00020") + filePath, "text", true);
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, lang.getText("GUIO_mct007"), lang.getText("GUIO_mct008"), 0);
            overlord.log(lang.getText("LOGentry00021") + e.getMessage(), "error", true);
        }
    }

    public String generateAllCHindexes(int howMany, ArrayList<String> commandsValidate) {
        String CSVfilePath;
        if (!overlord.getRStatus()) {
            overlord.checkRlangStatus(true);
            if (!overlord.getRStatus()) {
                return null;
            }
        }
        if ((CSVfilePath = this.selectionOfSource()) == null) {
            return null;
        }
        Object dir_path = "";
        int c_number = howMany;
        try {
            String r_path;
            if (overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
                overlord.log(lang.getText("LOGentry00022") + howMany + lang.getText("LOGentry00023"), "warning", true);
            } else {
                int invNumber = overlord.getWorkspace().getProject().getT_InvMatrix().size();
                if (invNumber < howMany) {
                    howMany = invNumber;
                }
            }
            Object[] options = new Object[]{lang.getText("GUIO_clusters001"), lang.getText("GUIO_clusters002")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("GUIO_clusters003"), lang.getText("GUIO_clusters004"), 0, 1, null, options, options[0]);
            if (n == 0) {
                String choosenDir = Tools.selectDirectoryDialog(overlord.getLastPath(), lang.getText("GUIO_clusters005"), lang.getText("GUIO_clusters006"));
                if (choosenDir.isEmpty()) {
                    dir_path = overlord.getTmpPath();
                    overlord.log(lang.getText("LOGentry00024") + (String)dir_path, "text", true);
                } else {
                    File dir = new File(choosenDir);
                    dir_path = dir.getPath() + "//";
                    Tools.copyFileByPath(CSVfilePath, (String)dir_path + "cluster.csv");
                    overlord.log(lang.getText("LOGentry00025") + (String)dir_path, "text", true);
                }
            } else {
                dir_path = overlord.getTmpPath();
                overlord.log(lang.getText("LOGentry00026") + (String)dir_path, "text", true);
            }
            overlord.showConsole(true);
            dir_path = ((String)dir_path).replace("\\", "/");
            File test64 = new File(overlord.getSettingsManager().getValue("r_path64"));
            if (test64.exists()) {
                r_path = overlord.getSettingsManager().getValue("r_path64");
            } else {
                r_path = overlord.getSettingsManager().getValue("r_path");
                overlord.log(lang.getText("LOGentry00027"), "warning", true);
            }
            Rprotocols runnable = new Rprotocols(1);
            runnable.setForRunnableAllClusters(r_path, (String)dir_path, "cluster.csv", "scripts\\f_CHindex.r", "scripts\\f_clusters_run.r", "scripts\\f_CHindex_Pearson.r", "scripts\\f_clusters_Pearson_run.r", howMany, commandsValidate);
            Thread thread = new Thread(runnable);
            thread.start();
            return dir_path;
        }
        catch (IOException e) {
            String msg = lang.getText("GUIO_clusters007") + c_number + lang.getText("GUIO_clusters008") + (String)dir_path;
            JOptionPane.showMessageDialog(null, msg, lang.getText("critError"), 0);
            overlord.log(msg, "error", true);
            overlord.log(e.getMessage(), "error", true);
            return null;
        }
    }

    public String generateClustersCase56(int howMany, ArrayList<String> commandsValidate) {
        String CSVfilePath;
        if (!overlord.getRStatus()) {
            overlord.checkRlangStatus(true);
            if (!overlord.getRStatus()) {
                return null;
            }
        }
        if ((CSVfilePath = this.selectionOfSource()) == null) {
            return null;
        }
        Object dir_path = "";
        int c_number = howMany;
        try {
            if (overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
                overlord.log(lang.getText("LOGentry00028") + howMany + lang.getText("LOGentry00029"), "warning", true);
            } else {
                int invNumber = overlord.getWorkspace().getProject().getT_InvMatrix().size();
                if (invNumber < howMany) {
                    howMany = invNumber;
                }
            }
            Object[] options = new Object[]{lang.getText("GUIO_clusters009"), lang.getText("GUIO_clusters009b"), lang.getText("GUIO_clusters009c")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("GUIO_clusters010"), lang.getText("GUIO_clusters004"), 0, 1, null, options, options[0]);
            if (n == 0) {
                String choosenDir = Tools.selectDirectoryDialog(overlord.getLastPath(), lang.getText("GUIO_clusters011"), lang.getText("GUIO_clusters012"));
                if (choosenDir.isEmpty()) {
                    dir_path = overlord.getTmpPath();
                    overlord.log(lang.getText("LOGentry00030") + (String)dir_path, "text", true);
                } else {
                    File dir = new File(choosenDir);
                    dir_path = dir.getPath() + "//";
                    Tools.copyFileByPath(CSVfilePath, (String)dir_path + "cluster.csv");
                    overlord.log(lang.getText("LOGentry00030") + (String)dir_path, "text", true);
                }
            } else if (n == 1) {
                dir_path = overlord.getTmpPath();
                overlord.log(lang.getText("LOGentry00030") + (String)dir_path, "text", true);
            } else {
                return null;
            }
            overlord.showConsole(true);
            dir_path = ((String)dir_path).replace("\\", "/");
            Rprotocols runnable = new Rprotocols();
            runnable.setForRunnableAllClusters(overlord.getSettingsManager().getValue("r_path"), (String)dir_path, "cluster.csv", "scripts\\f_clusters.r", "scripts\\f_clusters_run.r", "scripts\\f_clusters_Pearson.r", "scripts\\f_clusters_Pearson_run.r", c_number, commandsValidate);
            runnable.setWorkingMode(0);
            Thread thread = new Thread(runnable);
            thread.start();
            return (String)dir_path + "/cluster.csv";
        }
        catch (Exception e) {
            String msg = lang.getText("GUIO_clusters013") + c_number + lang.getText("GUIO_clusters014") + (String)dir_path;
            JOptionPane.showMessageDialog(null, msg, lang.getText("critError"), 0);
            overlord.log(msg, "error", true);
            overlord.log(e.getMessage(), "error", true);
            return null;
        }
    }

    private String selectionOfSource() {
        String lastPath = overlord.getLastPath();
        if (overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter(lang.getText("GUIO_csv001"), new String[]{"CSV"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("GUIO_csv002"), lang.getText("GUIO_csv003"), "");
            if (selectedFile.isEmpty()) {
                return null;
            }
            return selectedFile;
        }
        Object[] options = new Object[]{lang.getText("GUIO_csv004"), lang.getText("GUIO_csv004b"), lang.getText("GUIO_clusters009c")};
        int n = JOptionPane.showOptionDialog(null, lang.getText("LOGentry00031"), lang.getText("GUIO_inv001"), 0, 1, null, options, options[0]);
        if (n == 0) {
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("CSV invariants file (.csv)", new String[]{"CSV"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("GUIO_csv002"), lang.getText("GUIO_csv003"), "");
            if (selectedFile.isEmpty()) {
                return null;
            }
            return selectedFile;
        }
        if (n == 1) {
            String CSVfilePath = overlord.getTmpPath() + "cluster.csv";
            int result = overlord.getWorkspace().getProject().saveInvariantsToCSV(CSVfilePath, true, true);
            if (result == -1) {
                String msg = lang.getText("GUIO_inv002");
                JOptionPane.showMessageDialog(null, msg, lang.getText("GUIO_inv003"), 0);
                overlord.log(msg, "error", true);
                return null;
            }
            return CSVfilePath;
        }
        return null;
    }

    public String[] generateSingleClustering(String clustersPath, String algorithm, String metric, int howMany) {
        String resultFilePath_r;
        String resultFilePath_MCT;
        Object filePath = clustersPath + "//cluster.csv";
        File csvFile = new File((String)filePath);
        if (!csvFile.exists()) {
            Object[] options = new Object[]{lang.getText("GUIO_clusters015"), lang.getText("GUIO_clusters015b")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("GUIO_clusters016") + (String)filePath + lang.getText("GUIO_clusters017"), lang.getText("GUIO_clusters018"), 0, 3, null, options, options[0]);
            if (n == 0) {
                FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter(".csv - Comma Separated Values", new String[]{"CSV"})};
                filePath = Tools.selectFileDialog(clustersPath, filters, lang.getText("select"), lang.getText("GUIO_clusters019"), "");
                if (((String)filePath).isEmpty()) {
                    return null;
                }
                csvFile = new File((String)filePath);
                if (!csvFile.exists()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        String msg = lang.getText("GUIO_clusters020") + (String)filePath + lang.getText("GUIO_clusters021");
        overlord.log(msg, "text", true);
        String resultFilePath_clusterCSV = filePath;
        try {
            overlord.log(lang.getText("GUIO_clusters022") + (String)filePath, "text", true);
            Runner mctRunner = new Runner();
            mctRunner.activate(new String[]{filePath});
            resultFilePath_MCT = (String)filePath + ".analysed.txt";
        }
        catch (Exception e) {
            msg = lang.getText("GUIO_clusters023") + (String)filePath;
            overlord.log(msg, "text", true);
            JOptionPane.showMessageDialog(null, msg, lang.getText("critError"), 0);
            return null;
        }
        Rprotocols rp = new Rprotocols();
        String rPath = overlord.getSettingsManager().getValue("r_path");
        String csvFileName = csvFile.getName();
        String absolutePath = csvFile.getAbsolutePath();
        Object pathOutput = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator)) + "//";
        pathOutput = ((String)pathOutput).replace("\\", "/");
        try {
            resultFilePath_r = metric.equals("pearson") || metric.equals("correlation") ? rp.generateSingleClustering(rPath, (String)pathOutput, csvFileName, "scripts\\f_SingleCluster_Pearson.r", metric, algorithm, howMany) : rp.generateSingleClustering(rPath, (String)pathOutput, csvFileName, "scripts\\f_SingleCluster.r", metric, algorithm, howMany);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00032"), "error", true);
            overlord.log(lang.getText("LOGentry00032b") + csvFileName, "error", true);
            overlord.log(lang.getText("LOGentry00032c") + (String)pathOutput, "error", true);
            overlord.log(lang.getText("LOGentry00032d") + algorithm, "error", true);
            overlord.log(lang.getText("LOGentry00032e") + metric, "error", true);
            overlord.log(lang.getText("LOGentry00032f") + howMany, "error", true);
            JOptionPane.showMessageDialog(null, lang.getText("GUIO_clusters024"), lang.getText("critError"), 0);
            return null;
        }
        String[] result = new String[]{resultFilePath_clusterCSV, resultFilePath_r, resultFilePath_MCT, clustersPath + "//" + algorithm + "_" + metric + "_clusters_ext_" + howMany + ".pdf", clustersPath + "//" + algorithm + "_" + metric + "_dendrogram_ext_" + howMany + ".pdf"};
        return result;
    }

    public void updateTimeStep(boolean XTPN, long stepsValue, double timeValue, double tau) {
        try {
            if (XTPN) {
                GUIOperations.overlord.getSimulatorBox().getCurrentDockWindow().stepLabelXTPN.setText("" + stepsValue);
                GUIOperations.overlord.getSimulatorBox().getCurrentDockWindow().timeLabelXTPN.setText(Tools.cutValueExt(timeValue, 2) + " (" + Tools.cutValueExt(tau, 2) + ")");
            } else {
                GUIOperations.overlord.getSimulatorBox().getCurrentDockWindow().timeStepLabelValue.setText("" + stepsValue);
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00033") + XTPN + lang.getText("LOGentry00033b") + stepsValue + lang.getText("LOGentry00033c") + stepsValue + ".", "warning", true);
        }
    }

    public void markTransitions(int mode) {
        overlord.getWorkspace().getProject().resetNetColors();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        if (mode == 0) {
            for (Transition t : transitions) {
                if (!t.timeExtension.isTPN()) continue;
                t.drawGraphBoxT.setColorWithNumber(true, Color.green, false, -1.0, true, "TPN");
            }
        } else if (mode == 1) {
            for (Transition t : transitions) {
                if (!t.timeExtension.isDPN()) continue;
                t.drawGraphBoxT.setColorWithNumber(true, Color.green, false, -1.0, true, "DPN");
            }
        } else if (mode == 2) {
            for (Transition t : transitions) {
                if (t.timeExtension.isTPN() && !t.timeExtension.isDPN()) {
                    t.drawGraphBoxT.setColorWithNumber(true, EditorResources.tpnNOTdpn, false, -1.0, true, "TPN");
                    continue;
                }
                if (!t.timeExtension.isTPN() && t.timeExtension.isDPN()) {
                    t.drawGraphBoxT.setColorWithNumber(true, EditorResources.dpnNOTtpn, false, -1.0, true, "DPN");
                    continue;
                }
                if (!t.timeExtension.isTPN() || !t.timeExtension.isDPN()) continue;
                t.drawGraphBoxT.setColorWithNumber(true, EditorResources.tpnANDdpn, false, -1.0, true, "TPN / DPN");
            }
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void fixArcsProblem() {
        ArrayList<Arc> outArcs;
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        int arcSize = arcs.size();
        int arcCounter = 0;
        int ghosts = 0;
        for (Place p : places) {
            for (ElementLocation el : p.getElementLocations()) {
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    ++arcCounter;
                    if (arcs.contains(a)) continue;
                    ++ghosts;
                    int placeId = places.indexOf(p);
                    int transId = transitions.indexOf((Transition)a.getEndNode());
                    overlord.log(lang.getText("GUIO_fix001") + placeId + " -> t" + transId + lang.getText("GUIO_fix002"), "error", true);
                    this.removeArc(a, arcs);
                }
            }
        }
        for (Transition t : transitions) {
            for (ElementLocation el : t.getElementLocations()) {
                outArcs = el.getOutArcs();
                for (Arc a : outArcs) {
                    ++arcCounter;
                    if (arcs.contains(a)) continue;
                    ++ghosts;
                    int transId = transitions.indexOf(t);
                    int placeId = places.indexOf((Place)a.getEndNode());
                    overlord.log(lang.getText("GUIO_fix003") + transId + " -> p" + placeId + lang.getText("GUIO_fix002"), "error", true);
                    this.removeArc(a, arcs);
                }
            }
        }
        overlord.log(lang.getText("GUIO_fix004") + arcSize + lang.getText("GUIO_fix005") + arcCounter + lang.getText("GUIO_fix006") + ghosts, "text", true);
    }

    private void removeArc(Arc arc, ArrayList<Arc> arcs) {
        overlord.markNetChange();
        arc.unlinkElementLocations();
        arcs.remove(arc);
        if (arc.getPairedArc() != null) {
            Arc a = arc.getPairedArc();
            a.unlinkElementLocations();
            arcs.remove(a);
        }
    }
}

