/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import holmes.analyse.MCTCalculator;
import holmes.clusters.ClusterDataPackage;
import holmes.darkgui.DarkMenu;
import holmes.darkgui.GUIOperations;
import holmes.darkgui.GUIReset;
import holmes.darkgui.KeyManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.dockwindows.HolmesDockWindow;
import holmes.darkgui.dockwindows.PetriNetTools;
import holmes.darkgui.settings.SettingsManager;
import holmes.darkgui.toolbar.Toolbar;
import holmes.files.io.TexExporter;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.subnets.SubnetsControl;
import holmes.petrinet.subnets.SubnetsGraphics;
import holmes.utilities.Tools;
import holmes.windows.HolmesAbout;
import holmes.windows.HolmesConsole;
import holmes.windows.HolmesInvariantsGenerator;
import holmes.windows.HolmesKnockout;
import holmes.windows.HolmesMCS;
import holmes.windows.HolmesNetProperties;
import holmes.windows.HolmesNetTables;
import holmes.windows.HolmesNotepad;
import holmes.windows.HolmesProgramProperties;
import holmes.windows.HolmesSearch;
import holmes.windows.clusters.HolmesClusters;
import holmes.windows.decompositions.HolmesBranchVerticesPrototype;
import holmes.windows.decompositions.HolmesComparisonModule;
import holmes.windows.decompositions.HolmesDecomposition;
import holmes.windows.decompositions.HolmesGraphlets;
import holmes.windows.decompositions.HolmesLabelComparison;
import holmes.windows.decompositions.HolmesReductionPrototype;
import holmes.windows.ssim.HolmesSim;
import holmes.windows.xtpn.HolmesSimXTPN;
import holmes.workspace.ExtensionFileFilter;
import holmes.workspace.Workspace;
import holmes.workspace.WorkspaceSheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class GUIManager
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = -817072868916096442L;
    private static GUIManager guiManager;
    private static LanguageManager lang;
    public boolean debug = false;
    public Random randGen = new Random(System.currentTimeMillis());
    public GUIOperations io;
    public TexExporter tex;
    public GUIReset reset;
    public SubnetsGraphics subnetsGraphics;
    public SubnetsControl subnetsHQ;
    public SimulatorGlobals simSettings;
    private Dimension screenSize;
    private Dimension smallScreenSize;
    private final SettingsManager settingsManager;
    private Workspace workspace;
    private JTabbedPane tabbedWorkspace = new JTabbedPane();
    private PetriNetTools toolBox;
    private HolmesDockWindow simulatorBox;
    private HolmesDockWindow selectionBox;
    private HolmesDockWindow mctBox;
    private HolmesDockWindow t_invariantsBox;
    private HolmesDockWindow p_invariantsBox;
    private HolmesDockWindow selElementBox;
    private HolmesDockWindow clustersBox;
    private HolmesDockWindow mcsBox;
    private HolmesDockWindow fixBox;
    private HolmesDockWindow knockoutBox;
    private HolmesDockWindow quickSimBox;
    private Toolbar shortcutsBar;
    private JFrame frame;
    private DarkMenu menu;
    private String lastPath;
    private String holmesPath;
    private String tmpPath;
    private String toolPath;
    private String logPath;
    private HolmesClusters windowClusters;
    private HolmesConsole windowConsole;
    private HolmesNetProperties windowNetProperties;
    private HolmesAbout windowAbout;
    private HolmesSearch windowSearch;
    private HolmesProgramProperties windowProperties;
    private HolmesSim windowStateSim;
    private HolmesSimXTPN windowStateSimXTPN;
    private HolmesNetTables windowNetTables;
    private HolmesNotepad windowSimulationLog;
    private HolmesInvariantsGenerator windowInvariants;
    private HolmesMCS windowMCS;
    private HolmesKnockout windowsKnockout;
    private HolmesDecomposition windowsDeco;
    private HolmesGraphlets windowsGraphlet;
    private HolmesLabelComparison labelComparison;
    private HolmesBranchVerticesPrototype windowsBranch;
    private HolmesComparisonModule windowsComp;
    private HolmesReductionPrototype windowReduction;
    private boolean rReady = false;
    private boolean inaReady = true;
    private static boolean isXTPNmode;
    private locationMoveType nameLocChangeMode = locationMoveType.NONE;
    private Node nameSelectedNode = null;
    private ElementLocation nameNodeEL = null;
    public JPanel propericeTMPBox;
    public JTabbedPane analysisTabs;

    public GUIManager(JFrame frejm) {
        super(new BorderLayout());
        guiManager = this;
        this.createHiddenConsole();
        lang = new LanguageManager();
        this.io = new GUIOperations();
        this.tex = new TexExporter();
        this.reset = new GUIReset();
        this.subnetsGraphics = new SubnetsGraphics();
        this.subnetsHQ = new SubnetsControl();
        this.simSettings = new SimulatorGlobals();
        this.setFrame(frejm);
        try {
            this.frame.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.frame.addComponentListener(this);
        this.getFrame().addComponentListener(this);
        this.settingsManager = new SettingsManager();
        this.settingsManager.loadSettings();
        this.setJavaUI();
        this.frame.setTitle("Holmes " + this.settingsManager.getValue("holmes_version"));
        lang.setLanguage(this.settingsManager.getValue("selected_language"), true);
        this.createClusterWindow();
        this.createNetPropertiesWindow();
        this.createSearchWindow();
        this.createNetTablesWindow();
        this.createInvariantsWindow();
        this.initializeEnvironment();
        this.getFrame().setDefaultCloseOperation(3);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.getFrame().setLocation((int)((double)this.screenSize.width * 0.1) / 2, (int)((double)this.screenSize.height * 0.1) / 2);
        this.getFrame().setSize((int)(this.screenSize.getWidth() * 0.9), (int)(this.screenSize.getHeight() * 0.9));
        this.getFrame().setVisible(true);
        boolean startMaximized = Boolean.parseBoolean(this.settingsManager.getValue("mainWindowStartMaximized"));
        startMaximized = true;
        int screenHeight = this.screenSize.height;
        int screenWidth = this.screenSize.width;
        float aspect = (float)screenWidth / (float)screenHeight;
        if ((double)aspect > 2.0) {
            this.getFrame().setSize(screenHeight * 2, screenHeight - 40);
            this.getFrame().setExtendedState(this.getFrame().getExtendedState() | 0);
            this.getFrame().setLocation(-7, -1);
        } else if (startMaximized) {
            this.getFrame().setExtendedState(this.getFrame().getExtendedState() | 6);
        } else {
            int width = Integer.parseInt(this.settingsManager.getValue("mainWindowWidth"));
            int height = Integer.parseInt(this.settingsManager.getValue("mainWindowHeight"));
            this.getFrame().setSize(width, height);
            this.getFrame().setExtendedState(this.getFrame().getExtendedState() | 0);
        }
        this.getFrame().setVisible(true);
        this.setToolBox(new PetriNetTools());
        this.createSimLogWindow();
        this.setWorkspace(new Workspace());
        this.getWorkspace().newTab(false, new Point(0, 0), 1, MetaNode.MetaType.SUBNET);
        this.getTabbedWorkspace().setPreferredSize(new Dimension(1300, 400));
        this.setPropertiesBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.EDITOR));
        this.setSimulatorBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.SIMULATOR));
        this.setSelectionBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.SELECTOR));
        this.setT_invBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.T_INVARIANTS));
        this.setP_invSim(new HolmesDockWindow(HolmesDockWindow.DockWindowType.P_INVARIANTS));
        this.setClusterSelectionBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.ClusterSELECTOR));
        this.setMctBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.MctANALYZER));
        this.setMCSBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.MCSselector));
        this.setKnockoutBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.Knockout));
        this.setQuickSimBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.QuickSim));
        this.setFixBox(new HolmesDockWindow(HolmesDockWindow.DockWindowType.FIXNET));
        this.setMenu(new DarkMenu());
        this.getFrame().setJMenuBar(this.getMenu());
        this.smallScreenSize = new Dimension((int)(this.screenSize.getWidth() * 0.9), (int)(this.screenSize.getHeight() * 0.9));
        this.setShortcutsBar(new Toolbar());
        this.getFrame().add((Component)this.shortcutsBar, "First");
        JPanel mainpanel = new JPanel();
        mainpanel.add(this.getWorkspace().getSelectedSheet());
        mainpanel.setLayout(new BorderLayout());
        mainpanel.setSize(200, 200);
        this.getFrame().add((Component)this.getWorkspace().getSelectedSheet(), "Center");
        this.propericeTMPBox = this.getPropertiesBox().getCurrentDockWindow();
        this.propericeTMPBox.setPreferredSize(new Dimension(200, 400));
        JTabbedPane leftCentralPanel = new JTabbedPane();
        leftCentralPanel.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        leftCentralPanel.add(this.getToolBox().getTree());
        leftCentralPanel.setTabComponentAt(0, new JLabel("Toolbox"));
        leftCentralPanel.add(this.getSimulatorBox().getCurrentDockWindow().getPanel());
        leftCentralPanel.setTabComponentAt(1, new JLabel("Simulator"));
        leftCentralPanel.setPreferredSize(new Dimension(200, 400));
        this.analysisTabs = new JTabbedPane();
        this.analysisTabs.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        this.analysisTabs.add(this.getQuickSimBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(0, new JLabel(lang.getText("GUIM_quicksimTabName")));
        this.analysisTabs.add(this.getT_invBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(1, new JLabel(lang.getText("GUIM_tinvTabName")));
        this.analysisTabs.add(this.getP_invBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(2, new JLabel(lang.getText("GUIM_pinvTabName")));
        this.analysisTabs.add(this.getMctBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(3, new JLabel(lang.getText("GUIM_mctTabName")));
        this.analysisTabs.add(this.getMCSBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(4, new JLabel(lang.getText("GUIM_mcsTabName")));
        this.analysisTabs.add(this.getFixBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(5, new JLabel(lang.getText("GUIM_fixTabName")));
        this.analysisTabs.add(this.getClusterSelectionBox().getCurrentDockWindow().getPanel());
        this.analysisTabs.setTabComponentAt(6, new JLabel(lang.getText("GUIM_clustersTabName")));
        this.analysisTabs.setPreferredSize(new Dimension(200, 200));
        JSplitPane simAndworkspacePanel = new JSplitPane(1, leftCentralPanel, this.getTabbedWorkspace());
        leftCentralPanel.setPreferredSize(new Dimension(200, 400));
        simAndworkspacePanel.setPreferredSize(new Dimension(1200, 200));
        simAndworkspacePanel.setDividerLocation(180);
        JSplitPane rightPanelSplit = new JSplitPane(0, this.propericeTMPBox, this.analysisTabs);
        JSplitPane uberMainPanel = new JSplitPane(1, simAndworkspacePanel, rightPanelSplit);
        if ((double)aspect > 2.0) {
            uberMainPanel.setDividerLocation(screenHeight * 2 - 330);
        } else {
            uberMainPanel.setDividerLocation(this.screenSize.width - 350);
        }
        rightPanelSplit.setDividerLocation(340);
        this.getFrame().add((Component)uberMainPanel, "Center");
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.addKeyEventDispatcher(new KeyManager(this));
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                boolean status = GUIManager.this.getNetChangeStatus();
                if (status) {
                    Object[] options = new Object[]{lang.getText("exit"), lang.getText("saveAndExit"), lang.getText("cancel")};
                    String tmp = lang.getText("GUIM_closingQuestion001");
                    int n = JOptionPane.showOptionDialog(null, tmp, lang.getText("GUIM_closeWindowTitle001"), 0, 3, null, options, options[2]);
                    if (n == 0) {
                        GUIManager.this.log(lang.getText("LOGentry00001"), "text", true);
                        GUIManager.this.windowConsole.saveLogToFile(null);
                        System.exit(0);
                    } else if (n == 1) {
                        boolean savingStatus = GUIManager.this.io.saveAsGlobal();
                        if (!savingStatus) {
                            return;
                        }
                        GUIManager.this.log(lang.getText("LOGentry00001"), "text", true);
                        GUIManager.this.windowConsole.saveLogToFile(null);
                        System.exit(0);
                    }
                } else if (JOptionPane.showConfirmDialog(GUIManager.this.frame, lang.getText("GUIM_closingQuestion002"), lang.getText("exit") + "?", 0, 3) == 0) {
                    GUIManager.this.log(lang.getText("LOGentry00001"), "text", true);
                    GUIManager.this.windowConsole.saveLogToFile(null);
                    System.exit(0);
                }
            }
        });
        this.createStateSimulatorWindow();
        this.createStateSimulatorXTPNWindow();
        this.createMCSWindow();
        String path = this.settingsManager.getValue("lastOpenedPath");
        File f = new File(path);
        if (f.exists()) {
            this.lastPath = path;
        }
        this.getFrame().repaint();
    }

    private void setJavaUI() {
        String current;
        block14 : switch (current = this.getSettingsManager().getValue("systemUI")) {
            case "1": {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break block14;
                    }
                    break;
                }
                catch (Exception e) {
                    try {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            case "2": {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"CDE/Motif".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break block14;
                    }
                    break;
                }
                catch (Exception e) {
                    try {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            case "3": {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Windows".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break block14;
                    }
                    break;
                }
                catch (Exception e) {
                    try {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
            case "4": {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Windows Classic".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break block14;
                    }
                    break;
                }
                catch (Exception e) {
                    try {
                        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void initializeEnvironment() {
        this.lastPath = null;
        this.holmesPath = System.getProperty("user.dir");
        this.tmpPath = this.holmesPath + "\\tmp\\";
        this.toolPath = this.holmesPath + "\\tools\\";
        this.logPath = this.holmesPath + "\\log\\";
        File checkFile = new File(this.tmpPath);
        if (!checkFile.exists()) {
            checkFile.mkdirs();
        }
        if (!(checkFile = new File(this.logPath)).exists()) {
            checkFile.mkdirs();
        }
        File checkFileINA0 = new File(this.toolPath);
        File checkFileINA1 = new File(this.toolPath + "//INAwin32.exe");
        File checkFileINA2 = new File(this.toolPath + "//COMMAND.ina");
        File checkFileINA2p = new File(this.toolPath + "//COMMANDp.ina");
        File checkFileINA3 = new File(this.toolPath + "//ina.bat");
        if (!(checkFileINA0.exists() && checkFileINA1.exists() && checkFileINA2.exists() && checkFileINA2.length() == 80L && checkFileINA3.exists() && checkFileINA3.length() == 30L && checkFileINA2p.exists() && checkFileINA2p.length() == 77L)) {
            PrintWriter pw;
            if (!checkFileINA0.exists()) {
                checkFileINA0.mkdirs();
                this.logNoEnter(lang.getText("LOGentry00002"), "warning", true);
                this.log(lang.getText("fixed"), "italic", false);
            }
            if (!checkFileINA2.exists() || checkFileINA2.length() != 80L) {
                try {
                    pw = new PrintWriter(checkFileINA2.getPath());
                    pw.print(this.settingsManager.getValue("ina_COMMAND1") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND2") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND3") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND4"));
                    pw.close();
                    this.logNoEnter(lang.getText("LOGentry00003"), "warning", true);
                    this.log(lang.getText("fixed"), "italic", false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, lang.getText("GUI_inaProblem001"), lang.getText("GUI_inaProblem002"), 0);
                    this.inaReady = false;
                    this.log(lang.getText("LOGentry00004"), "warning", true);
                }
            }
            if (!checkFileINA2p.exists() || checkFileINA2p.length() != 77L) {
                try {
                    pw = new PrintWriter(checkFileINA2p.getPath());
                    pw.print(this.settingsManager.getValue("ina_COMMAND1") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND2p") + "\r");
                    pw.print(this.settingsManager.getValue("ina_COMMAND4"));
                    pw.close();
                    this.logNoEnter(lang.getText("LOGentry00005"), "warning", true);
                    this.log("Fixed", "italic", false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, lang.getText("GUI_inaProblem001"), lang.getText("GUI_inaProblem003"), 0);
                    this.inaReady = false;
                    this.log(lang.getText("LOGentry00004"), "warning", true);
                }
            }
            if (!checkFileINA3.exists() || checkFileINA3.length() != 30L) {
                try {
                    pw = new PrintWriter(checkFileINA3.getPath());
                    pw.print(this.settingsManager.getValue("ina_bat"));
                    pw.close();
                    this.logNoEnter(lang.getText("LOGentry00006"), "warning", true);
                    this.log(lang.getText("fixed"), "italic", false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, lang.getText("GUI_inaProblem004"), lang.getText("GUI_inaProblem005"), 0);
                    this.inaReady = false;
                    this.log(lang.getText("LOGentry00007"), "warning", true);
                }
            }
            if (!checkFileINA1.exists()) {
                this.inaReady = false;
            }
        }
        this.checkRlangStatus(false);
        if (this.settingsManager.getValue("programDebugMode").equals("1")) {
            this.debug = true;
        }
    }

    public void checkRlangStatus(boolean forceCheck) {
        this.rReady = true;
        String Rpath = this.settingsManager.getValue("r_path");
        File rF = new File(Rpath);
        if (!rF.exists()) {
            this.rReady = false;
            this.log(lang.getText("LOGentry00008R") + Rpath + lang.getText("LOGentry00009R"), "warning", true);
            if (!forceCheck && this.getSettingsManager().getValue("programAskForRonStartup").equals("0")) {
                return;
            }
            Object[] options = new Object[]{lang.getText("GUI_RscriptProblem001"), lang.getText("GUI_RscriptProblem002")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("GUI_RscriptProblem003") + Rpath, lang.getText("GUI_RscriptProblem004"), 0, 2, null, options, options[0]);
            if (n == 0) {
                FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter(".exe - Rscript", new String[]{"EXE"})};
                String selectedFile = Tools.selectFileDialog("", filters, lang.getText("GUI_RscriptButton001"), lang.getText("GUI_RscriptButton002tip"), "");
                if (selectedFile.isEmpty()) {
                    this.log(lang.getText("LOGentry00010R"), "error", true);
                } else {
                    if (!selectedFile.contains("x64")) {
                        Object dest = selectedFile.substring(0, selectedFile.lastIndexOf(File.separator));
                        if (Tools.ifExist((String)(dest = (String)dest + "\\x64\\Rscript.exe"))) {
                            this.settingsManager.setValue("r_path64", (String)dest, true);
                        } else {
                            this.settingsManager.setValue("r_path64", "", true);
                        }
                    } else {
                        this.settingsManager.setValue("r_path64", selectedFile, true);
                    }
                    if (Tools.ifExist(selectedFile)) {
                        this.settingsManager.setValue("r_path", selectedFile, true);
                        this.settingsManager.saveSettings();
                        this.setRStatus(true);
                        this.log(lang.getText("LOGentry00011R") + selectedFile + lang.getText("LOGentry00012R"), "text", true);
                    } else {
                        this.settingsManager.setValue("r_path", "", true);
                        this.setRStatus(false);
                        this.log(lang.getText("LOGentry00013R"), "error", true);
                    }
                }
            }
        }
    }

    private void resetSplitDocks() {
        if (this.getFrame().getExtendedState() == 6) {
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        } else {
            this.smallScreenSize = this.getFrame().getSize();
        }
    }

    public String getLastPath() {
        return this.lastPath;
    }

    public void setLastPath(String path) {
        this.lastPath = path;
        this.settingsManager.setValue("lastOpenedPath", this.lastPath, true);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    public void resetModuls() {
        this.windowsComp = new HolmesComparisonModule();
        this.windowsBranch = new HolmesBranchVerticesPrototype();
        this.windowsGraphlet = new HolmesGraphlets();
        this.windowsDeco = new HolmesDecomposition();
        this.windowsKnockout = new HolmesKnockout();
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.resetSplitDocks();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    public HolmesDockWindow getMctBox() {
        return this.mctBox;
    }

    private void setMctBox(HolmesDockWindow mctBox) {
        this.mctBox = mctBox;
    }

    public HolmesDockWindow getMCSBox() {
        return this.mcsBox;
    }

    private void setMCSBox(HolmesDockWindow mcsBox) {
        this.mcsBox = mcsBox;
    }

    public HolmesDockWindow getFixBox() {
        return this.fixBox;
    }

    private void setFixBox(HolmesDockWindow fixBox) {
        this.fixBox = fixBox;
    }

    private void setKnockoutBox(HolmesDockWindow knockoutBox) {
        this.knockoutBox = knockoutBox;
    }

    public HolmesDockWindow getKnockoutBox() {
        return this.knockoutBox;
    }

    private void setQuickSimBox(HolmesDockWindow quickSimBox) {
        this.quickSimBox = quickSimBox;
    }

    private HolmesDockWindow getQuickSimBox() {
        return this.quickSimBox;
    }

    public HolmesDockWindow getT_invBox() {
        return this.t_invariantsBox;
    }

    private void setT_invBox(HolmesDockWindow invariantsBox) {
        this.t_invariantsBox = invariantsBox;
    }

    private void setP_invSim(HolmesDockWindow invSim) {
        this.p_invariantsBox = invSim;
    }

    public HolmesDockWindow getP_invBox() {
        return this.p_invariantsBox;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public PetriNetTools getToolBox() {
        return this.toolBox;
    }

    private void setToolBox(PetriNetTools toolBox) {
        this.toolBox = toolBox;
    }

    public HolmesDockWindow getPropertiesBox() {
        return this.selElementBox;
    }

    public void setPropertiesBox(HolmesDockWindow propertiesBox) {
        this.selElementBox = propertiesBox;
    }

    public DarkMenu getMenu() {
        return this.menu;
    }

    private void setMenu(DarkMenu menu) {
        this.menu = menu;
    }

    public static GUIManager getDefaultGUIManager() {
        return guiManager;
    }

    public static LanguageManager getLanguageManager() {
        return lang;
    }

    public int IDtoIndex(int id) {
        return this.workspace.getIndexOfId(id);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame frame) {
        this.frame = frame;
    }

    public HolmesDockWindow getSimulatorBox() {
        return this.simulatorBox;
    }

    private void setSimulatorBox(HolmesDockWindow simulatorBox) {
        this.simulatorBox = simulatorBox;
    }

    public HolmesDockWindow getSelectionBox() {
        return this.selectionBox;
    }

    private void setSelectionBox(HolmesDockWindow selectionBox) {
        this.selectionBox = selectionBox;
    }

    private Toolbar getShortcutsBar() {
        return this.shortcutsBar;
    }

    private void setShortcutsBar(Toolbar shortcutsBar) {
        this.shortcutsBar = shortcutsBar;
    }

    public HolmesDockWindow getClusterSelectionBox() {
        return this.clustersBox;
    }

    public void setClusterSelectionBox(HolmesDockWindow clusterBox) {
        this.clustersBox = clusterBox;
    }

    public HolmesConsole getConsoleWindow() {
        return this.windowConsole;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    public String getHolmesPath() {
        return this.holmesPath;
    }

    public String getTmpPath() {
        return this.tmpPath;
    }

    public void generateMCT() {
        MCTCalculator analyzer = this.getWorkspace().getProject().getMCTanalyzer();
        ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
        this.getWorkspace().getProject().setMCTMatrix(mct, true);
        this.getMctBox().showMCT(mct);
    }

    public void showMCS() {
        this.getMCSBox().showMCS();
    }

    public void showKnockout(ArrayList<ArrayList<Integer>> knockoutData) {
        this.getKnockoutBox().showKnockout(knockoutData);
    }

    public void showClusterSelectionBox(ClusterDataPackage data) {
        this.getClusterSelectionBox().showClusterSelector(data);
        this.reset.setClustersStatus(true);
    }

    public void startInvariantsSimulation(int type, int value) throws CloneNotSupportedException {
        this.getWorkspace().getProject().startInvSim(type, value);
    }

    private void createClusterWindow() {
        this.windowClusters = new HolmesClusters(0);
    }

    public void showClusterWindow() {
        if (this.windowClusters != null) {
            this.windowClusters.setVisible(true);
        }
    }

    public HolmesClusters accessClusterWindow() {
        return this.windowClusters;
    }

    private void createNetPropertiesWindow() {
        this.windowNetProperties = new HolmesNetProperties();
        this.windowNetProperties.setLocationRelativeTo(this.frame);
    }

    public void showNetPropertiesWindow() {
        if (this.windowNetProperties != null) {
            this.windowNetProperties.setVisible(true);
        }
    }

    public void createAboutWindow() {
        this.windowAbout = new HolmesAbout(this.frame);
    }

    private void createSearchWindow() {
        this.windowSearch = new HolmesSearch();
    }

    public void showSearchWindow() {
        if (this.windowSearch != null) {
            this.windowSearch.setVisible(true);
        }
    }

    public HolmesSearch getSearchWindow() {
        return this.windowSearch;
    }

    private void createPropertiesWindow() {
        this.windowProperties = new HolmesProgramProperties(this.frame);
    }

    public void showPropertiesWindow() {
        if (this.windowProperties != null) {
            this.windowProperties.dispatchEvent(new WindowEvent(this.frame, 201));
            this.createPropertiesWindow();
        } else {
            this.createPropertiesWindow();
        }
        this.windowProperties.setVisible(true);
    }

    private void createStateSimulatorWindow() {
        this.windowStateSim = new HolmesSim();
    }

    public HolmesSim accessStateSimulatorWindow() {
        return this.windowStateSim;
    }

    public void showStateSimulatorWindow() {
        if (this.windowStateSim != null) {
            this.windowStateSim.setVisible(true);
        }
    }

    private void createStateSimulatorXTPNWindow() {
        this.windowStateSimXTPN = new HolmesSimXTPN(this);
    }

    public HolmesSimXTPN accessStateSimulatorXTPNWindow() {
        return this.windowStateSimXTPN;
    }

    public void showStateSimulatorWindowXTPN() {
        if (this.windowStateSimXTPN != null) {
            this.windowStateSimXTPN.setVisible(true);
        }
    }

    private void createNetTablesWindow() {
        this.windowNetTables = new HolmesNetTables(this.frame);
    }

    public void showNetTablesWindow() {
        if (this.windowNetTables != null && !this.reset.isSimulatorActiveWarning(lang.getText("GUI_simulator0001warn"), lang.getText("netSimWork01")) && !this.reset.isXTPNSimulatorActiveWarning(lang.getText("GUI_simulator0002warn"), lang.getText("netSimWork01"))) {
            this.windowNetTables.setVisible(true);
        }
    }

    public HolmesNetTables accessNetTablesWindow() {
        return this.windowNetTables;
    }

    private void createSimLogWindow() {
        this.windowSimulationLog = new HolmesNotepad(900, 600);
        this.windowSimulationLog.setVisible(false);
    }

    public void showSimLogWindow() {
        if (this.windowSimulationLog != null) {
            this.windowSimulationLog.setVisible(true);
        }
    }

    public HolmesNotepad getSimLog() {
        return this.windowSimulationLog;
    }

    private void createHiddenConsole() {
        this.windowConsole = new HolmesConsole();
        this.windowConsole.setLocationRelativeTo(this);
    }

    public void showConsole(boolean value) {
        if (this.windowConsole != null) {
            this.windowConsole.setVisible(value);
        }
    }

    public void createInvariantsWindow() {
        this.windowInvariants = new HolmesInvariantsGenerator();
        this.windowInvariants.setVisible(false);
    }

    public void showInvariantsWindow() {
        if (this.windowInvariants != null) {
            this.windowInvariants.setVisible(true);
        }
    }

    public HolmesInvariantsGenerator accessInvariantsWindow() {
        if (this.windowInvariants != null) {
            return this.windowInvariants;
        }
        return null;
    }

    public HolmesComparisonModule accessComparisonWindow() {
        if (this.windowsComp != null) {
            return this.windowsComp;
        }
        return null;
    }

    public void createMCSWindow() {
        if (this.windowMCS == null) {
            this.windowMCS = new HolmesMCS();
            this.windowMCS.setVisible(false);
        }
    }

    public void showMCSWindow() {
        if (this.windowMCS != null) {
            this.windowMCS.setVisible(true);
        }
    }

    public HolmesMCS accessMCSWindow() {
        if (this.windowMCS != null) {
            return this.windowMCS;
        }
        return null;
    }

    public void createKnockoutWindow() {
        if (this.windowsKnockout == null) {
            this.windowsKnockout = new HolmesKnockout();
        }
    }

    public void createDecompositionWindow() {
        if (this.windowsDeco == null) {
            this.windowsDeco = new HolmesDecomposition();
        }
    }

    public void createGraphletsWindow() {
        if (this.windowsGraphlet == null) {
            this.windowsGraphlet = new HolmesGraphlets();
        }
    }

    public void createLabelComparisonWindow() {
        if (this.labelComparison == null) {
            this.labelComparison = new HolmesLabelComparison();
        }
    }

    public void createBranchWindow() {
        if (this.windowsBranch == null) {
            this.windowsBranch = new HolmesBranchVerticesPrototype();
        }
    }

    public void createComparisonnWindow() {
        if (this.windowsComp == null) {
            this.windowsComp = new HolmesComparisonModule();
        }
    }

    public void createReductionWindow() {
        if (this.windowReduction == null) {
            this.windowReduction = new HolmesReductionPrototype();
        }
    }

    public void showKnockoutWindow() {
        if (this.windowsKnockout != null) {
            this.windowsKnockout.setVisible(true);
        }
    }

    public void showDecoWindow() {
        if (this.windowsDeco != null) {
            this.windowsDeco.setVisible(true);
        }
    }

    public void showGraphletsWindow() {
        if (this.windowsGraphlet != null) {
            this.windowsGraphlet.setVisible(true);
        }
    }

    public void showReductionsWindow() {
        if (this.windowReduction != null) {
            this.windowReduction.setVisible(true);
        }
    }

    public void showBranchWindow() {
        if (this.windowsBranch != null) {
            this.windowsBranch.setVisible(true);
        }
    }

    public void showCompWindow() {
        if (this.windowsComp != null) {
            this.windowsComp.setVisible(true);
        }
    }

    public void showLabelCompWindow() {
        if (this.labelComparison != null) {
            this.labelComparison.setVisible(true);
        }
    }

    public void log(String text, String mode, boolean time) {
        this.windowConsole.addText(text, mode, time, true);
        if (mode.equals("error")) {
            this.windowConsole.setVisible(true);
        }
    }

    public void logNoEnter(String text, String mode, boolean time) {
        this.windowConsole.addText(text, mode, time, false);
        if (mode.equals("error")) {
            this.windowConsole.setVisible(true);
        }
    }

    public boolean getRStatus() {
        return this.rReady;
    }

    public boolean getINAStatus() {
        return this.inaReady;
    }

    public void setRStatus(boolean status) {
        this.rReady = status;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setNameLocationChangeMode(Node n, ElementLocation el, locationMoveType mode) {
        this.nameSelectedNode = n;
        this.nameNodeEL = el;
        this.nameLocChangeMode = mode;
    }

    public locationMoveType getNameLocChangeMode() {
        return this.nameLocChangeMode;
    }

    public Node getNameLocChangeNode() {
        return this.nameSelectedNode;
    }

    public ElementLocation getNameLocChangeEL() {
        return this.nameNodeEL;
    }

    public void markNetChange() {
        this.getWorkspace().getProject().anythingChanged = true;
    }

    public void markNetSaved() {
        this.getWorkspace().getProject().anythingChanged = false;
    }

    public boolean getNetChangeStatus() {
        return this.getWorkspace().getProject().anythingChanged;
    }

    public static boolean isXTPN_simMode() {
        return isXTPNmode;
    }

    public static void setXTPN_simMode(boolean simMode) {
        isXTPNmode = simMode;
    }

    public JTabbedPane getTabbedWorkspace() {
        return this.getWorkspace().getTablePane();
    }

    public void setTabbedWorkspace(JTabbedPane tabbedWorkspace) {
        this.tabbedWorkspace = tabbedWorkspace;
    }

    public void testRemovePanel(int sheetID) {
        WorkspaceSheet begone = null;
        for (WorkspaceSheet ws : this.getWorkspace().getSheets()) {
            if (ws.getId() != sheetID) continue;
            begone = ws;
            break;
        }
        if (begone != null) {
            this.getWorkspace().deleteSheetFromArrays(begone);
        }
    }

    static {
        isXTPNmode = false;
    }

    public static enum locationMoveType {
        NONE,
        NAME,
        ALPHA,
        BETA,
        GAMMA,
        TAU;

    }
}

