/*
 * Decompiled with CFR 0.152.
 */
package holmes.darkgui;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.dockable.DockableMenuItem;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.utilities.Tools;
import holmes.windows.HolmesInvariantsViewer;
import holmes.windows.HolmesSubnetsInfo;
import holmes.windows.decompositions.HolmesMergeNets;
import holmes.windows.managers.HolmesSPNmanager;
import holmes.windows.managers.HolmesSSAwindowManager;
import holmes.windows.managers.HolmesStatesManager;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class DarkMenu
extends JMenuBar {
    private static final long serialVersionUID = -1671996309149490657L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JMenu sheetsMenu;
    private ArrayList<DockableMenuItem> sheetItems = new ArrayList();

    public DarkMenu() {
        JMenu xMenu = new JMenu(" ");
        xMenu.setEnabled(false);
        this.add(xMenu);
        JMenu fileMenu = new JMenu(lang.getText("DM_menuFile"));
        fileMenu.setMnemonic(70);
        fileMenu.getAccessibleContext().setAccessibleDescription(lang.getText("DM_menuFileDesc"));
        this.add(fileMenu);
        JMenuItem projectMenuItem = new JMenuItem(lang.getText("DM_menuFileProject"), 78);
        projectMenuItem.setEnabled(true);
        projectMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_newProject.png"));
        projectMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        projectMenuItem.addActionListener(arg0 -> DarkMenu.overlord.reset.newProjectInitiated());
        fileMenu.add(projectMenuItem);
        fileMenu.addSeparator();
        JMenuItem openMenuItem = new JMenuItem(lang.getText("DM_menuFileOpenProject"), 79);
        openMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_open.png"));
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        openMenuItem.addActionListener(arg0 -> DarkMenu.overlord.io.selectAndOpenHolmesProject());
        fileMenu.add(openMenuItem);
        JMenuItem importMenuItem = new JMenuItem(lang.getText("DM_menuFileImportNet"), 73);
        importMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_importNet.png"));
        importMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 192));
        importMenuItem.addActionListener(arg0 -> DarkMenu.overlord.io.importNetwork());
        fileMenu.add(importMenuItem);
        JMenuItem mergeMenuItem = new JMenuItem(lang.getText("DM_menuFileMerge"));
        mergeMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_MergeIcon.png"));
        mergeMenuItem.addActionListener(arg0 -> new HolmesMergeNets());
        fileMenu.add(mergeMenuItem);
        fileMenu.addSeparator();
        JMenuItem saveMenuItem = new JMenuItem(lang.getText("DM_menuFileSavePr"), 83);
        saveMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_save.png"));
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        saveMenuItem.addActionListener(arg0 -> DarkMenu.overlord.io.saveAsAbyssFile());
        fileMenu.add(saveMenuItem);
        JMenuItem saveAsMenuItem = new JMenuItem(lang.getText("DM_menuFileExport"));
        saveAsMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_saveAs.png"));
        saveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        saveAsMenuItem.addActionListener(arg0 -> DarkMenu.overlord.io.saveAsGlobal());
        fileMenu.add(saveAsMenuItem);
        JMenuItem exportMenuItem = new JMenuItem(lang.getText("DM_menuFileExportPNT"));
        exportMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportNet.png"));
        exportMenuItem.addActionListener(arg0 -> DarkMenu.overlord.io.exportAsPNT());
        fileMenu.add(exportMenuItem);
        JMenuItem expImgMenuItem = new JMenuItem(lang.getText("DM_menuFileExportImg"));
        expImgMenuItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportPicture.png"));
        expImgMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 192));
        expImgMenuItem.addActionListener(arg0 -> DarkMenu.overlord.io.exportProjectToImage());
        fileMenu.add(expImgMenuItem);
        JMenu texSubMenu = new JMenu(lang.getText("DM_menuFileExportTex"));
        texSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        fileMenu.add(texSubMenu);
        JMenuItem exportTexPTItem = new JMenuItem(lang.getText("DM_menuFileExportTexPT"), 49);
        exportTexPTItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        exportTexPTItem.addActionListener(arg0 -> DarkMenu.overlord.tex.writePlacesTransitions());
        texSubMenu.add(exportTexPTItem);
        JMenuItem exportTexInvItem = new JMenuItem(lang.getText("DM_menuFileExportTexInv"), 50);
        exportTexInvItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        exportTexInvItem.addActionListener(arg0 -> DarkMenu.overlord.tex.writeInvariants());
        texSubMenu.add(exportTexInvItem);
        JMenuItem exportTexMCTItem = new JMenuItem(lang.getText("DM_menuFileExportTexMCT"), 51);
        exportTexMCTItem.setIcon(Tools.getResIcon32("/icons/menu/menu_exportTex.png"));
        exportTexMCTItem.addActionListener(arg0 -> DarkMenu.overlord.tex.writeMCT());
        texSubMenu.add(exportTexMCTItem);
        fileMenu.addSeparator();
        JMenuItem exitMenuItem = new JMenuItem(lang.getText("DM_menuFileExit"), 69);
        exitMenuItem.setPreferredSize(new Dimension(1, 38));
        exitMenuItem.addActionListener(arg0 -> {
            if (JOptionPane.showConfirmDialog(null, lang.getText("DM_menuFileExitQ1"), lang.getText("DM_menuFileExitQ2"), 0, 3) == 0) {
                overlord.getConsoleWindow().saveLogToFile(null);
                System.exit(0);
            }
        });
        fileMenu.add(exitMenuItem);
        JMenu viewMenu = new JMenu(lang.getText("DM_menuView"));
        viewMenu.setMnemonic(86);
        this.add(viewMenu);
        JMenuItem resetZoomItem = new JMenuItem(lang.getText("DM_menuViewZoom100"), 49);
        resetZoomItem.setIcon(Tools.getResIcon32("/icons/menu/menu_zoom_reset.png"));
        resetZoomItem.setAccelerator(KeyStroke.getKeyStroke(121, 128));
        resetZoomItem.addActionListener(arg0 -> {
            for (GraphPanel gp : overlord.getWorkspace().getProject().getGraphPanels()) {
                gp.setZoom(100, gp.getZoom());
            }
        });
        viewMenu.add(resetZoomItem);
        JMenuItem incZoomItem = new JMenuItem(lang.getText("DM_menuViewZoomIn"), 50);
        incZoomItem.setIcon(Tools.getResIcon32("/icons/menu/menu_zoom_inc.png"));
        incZoomItem.setAccelerator(KeyStroke.getKeyStroke(122, 128));
        incZoomItem.addActionListener(arg0 -> {
            for (GraphPanel gp : overlord.getWorkspace().getProject().getGraphPanels()) {
                gp.setZoom((int)((double)gp.getZoom() * 1.1), gp.getZoom());
            }
        });
        viewMenu.add(incZoomItem);
        JMenuItem decZoomItem = new JMenuItem(lang.getText("DM_menuViewZoomOut"), 50);
        decZoomItem.setIcon(Tools.getResIcon32("/icons/menu/menu_zoom_dec.png"));
        decZoomItem.setAccelerator(KeyStroke.getKeyStroke(123, 128));
        decZoomItem.addActionListener(arg0 -> {
            for (GraphPanel gp : overlord.getWorkspace().getProject().getGraphPanels()) {
                gp.setZoom((int)((double)gp.getZoom() * 0.9), gp.getZoom());
            }
        });
        viewMenu.add(decZoomItem);
        JMenu windowMenu = new JMenu(lang.getText("DM_menuWindows"));
        windowMenu.setMnemonic(87);
        this.add(windowMenu);
        this.sheetsMenu = new JMenu(lang.getText("DM_menuWindowsProject"));
        this.sheetsMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_Sheets.png"));
        this.sheetsMenu.setMnemonic(80);
        windowMenu.add(this.sheetsMenu);
        windowMenu.addSeparator();
        windowMenu.addSeparator();
        JMenuItem consoleItem = new JMenuItem(lang.getText("DM_menuWindowsConsole"), 49);
        consoleItem.setIcon(Tools.getResIcon32("/icons/menu/menu_console.png"));
        consoleItem.setAccelerator(KeyStroke.getKeyStroke(76, 128));
        consoleItem.addActionListener(arg0 -> overlord.showConsole(true));
        windowMenu.add(consoleItem);
        JMenuItem propertiesItem = new JMenuItem(lang.getText("DM_menuWindowsProperties"), 49);
        propertiesItem.setIcon(Tools.getResIcon32("/icons/menu/menu_properties.png"));
        propertiesItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        propertiesItem.addActionListener(arg0 -> overlord.showPropertiesWindow());
        windowMenu.add(propertiesItem);
        JMenu netMenu = new JMenu(lang.getText("DM_menuNetData"));
        netMenu.setMnemonic(78);
        this.add(netMenu);
        JMenuItem propItem = new JMenuItem(lang.getText("DM_menuNetDataProperties"), 49);
        propItem.setIcon(Tools.getResIcon32("/icons/menu/menu_NetProp.png"));
        propItem.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        propItem.addActionListener(arg0 -> overlord.showNetPropertiesWindow());
        netMenu.add(propItem);
        JMenuItem searchItem = new JMenuItem(lang.getText("DM_menuNetDataSearch"), 50);
        searchItem.setIcon(Tools.getResIcon32("/icons/menu/menu_search.png"));
        searchItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        searchItem.addActionListener(arg0 -> overlord.showSearchWindow());
        netMenu.add(searchItem);
        JMenuItem netTablesItem = new JMenuItem(lang.getText("DM_menuNetDataTable"), 52);
        netTablesItem.setIcon(Tools.getResIcon32("/icons/menu/menu_netTables.png"));
        netTablesItem.addActionListener(arg0 -> overlord.showNetTablesWindow());
        netMenu.add(netTablesItem);
        JMenuItem invViewItem = new JMenuItem(lang.getText("DM_menuNetDataInvariants"), 53);
        invViewItem.setIcon(Tools.getResIcon32("/icons/menu/menu_invViewer.png"));
        invViewItem.addActionListener(arg0 -> new HolmesInvariantsViewer());
        netMenu.add(invViewItem);
        JMenuItem netStatessItem = new JMenuItem(lang.getText("DM_menuNetDataPStateM"), 54);
        netStatessItem.setIcon(Tools.getResIcon32("/icons/menu/menu_statesViewer.png"));
        netStatessItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        netStatessItem.addActionListener(arg0 -> {
            if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, lang.getText("DM_menuNetDataPStateMQ1"), lang.getText("DM_menuNetDataPStateMQ2"), 2);
            } else {
                new HolmesStatesManager();
            }
        });
        netMenu.add(netStatessItem);
        JMenuItem netTransFreqItem = new JMenuItem(lang.getText("DM_menuNetDataSPNM"), 54);
        netTransFreqItem.setIcon(Tools.getResIcon32("/icons/menu/menu_firingRates.png"));
        netTransFreqItem.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        netTransFreqItem.addActionListener(arg0 -> {
            if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, lang.getText("DM_menuNetDataPStateMQ1"), lang.getText("DM_menuNetDataPStateMQ2"), 2);
            } else {
                new HolmesSPNmanager(overlord.getFrame());
            }
        });
        netMenu.add(netTransFreqItem);
        JMenuItem netSSAmanagerItem = new JMenuItem(lang.getText("DM_menuNetDataSSA"), 54);
        netSSAmanagerItem.setIcon(Tools.getResIcon32("/icons/menu/menu_SSAmanager.png"));
        netSSAmanagerItem.setAccelerator(KeyStroke.getKeyStroke(85, 128));
        netSSAmanagerItem.addActionListener(arg0 -> {
            if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, lang.getText("DM_menuNetDataPStateMQ1"), lang.getText("DM_menuNetDataPStateMQ2"), 2);
            } else {
                new HolmesSSAwindowManager(overlord.getFrame());
            }
        });
        netMenu.add(netSSAmanagerItem);
        JMenu hierachyMenu = new JMenu(lang.getText("DM_menuSubnets"));
        this.add(hierachyMenu);
        JMenuItem collapseNetItem = new JMenuItem(lang.getText("DM_menuSubnetsCompr"), 49);
        collapseNetItem.setIcon(Tools.getResIcon32("/icons/menu/menu_subnetCompress.png"));
        collapseNetItem.addActionListener(arg0 -> {
            DarkMenu.overlord.subnetsGraphics.collapseSubnets();
            DarkMenu.overlord.subnetsGraphics.resizePanels();
        });
        hierachyMenu.add(collapseNetItem);
        JMenuItem alignElementsItem = new JMenuItem(lang.getText("DM_menuSubnetsAlign"), 49);
        alignElementsItem.setIcon(Tools.getResIcon32("/icons/menu/menu_subnetAlignUpLeft.png"));
        alignElementsItem.addActionListener(arg0 -> DarkMenu.overlord.subnetsGraphics.realignElements());
        hierachyMenu.add(alignElementsItem);
        JMenuItem resizePanelsItem = new JMenuItem(lang.getText("DM_menuSubnetsResize"), 49);
        resizePanelsItem.setIcon(Tools.getResIcon32("/icons/menu/menu_subnetResize.png"));
        resizePanelsItem.addActionListener(arg0 -> DarkMenu.overlord.subnetsGraphics.resizePanels());
        hierachyMenu.add(resizePanelsItem);
        JMenuItem showDetailsItem = new JMenuItem(lang.getText("DM_menuSubnetsShowDet"), 49);
        showDetailsItem.setIcon(Tools.getResIcon32("/icons/menu/menu_search.png"));
        showDetailsItem.getAccessibleContext().setAccessibleDescription("Show details about current subnet");
        showDetailsItem.addActionListener(arg0 -> HolmesSubnetsInfo.open());
        hierachyMenu.add(showDetailsItem);
        JMenu analysisMenu = new JMenu(lang.getText("DM_menuAnalysis"));
        analysisMenu.setMnemonic(65);
        this.add(analysisMenu);
        JMenu invSubMenu = new JMenu(lang.getText("DM_menuAnalysisInvariants"));
        invSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_InvariantsMenu.png"));
        analysisMenu.add(invSubMenu);
        JMenuItem invWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisInvGen"), 49);
        invWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_analysis_invariants.png"));
        invWindowItem.setAccelerator(KeyStroke.getKeyStroke(73, 128));
        invWindowItem.addActionListener(arg0 -> overlord.showInvariantsWindow());
        invSubMenu.add(invWindowItem);
        JMenuItem mcsWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisMCS"), 50);
        mcsWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_analysis_MCS.png"));
        mcsWindowItem.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        mcsWindowItem.addActionListener(arg0 -> overlord.showMCSWindow());
        invSubMenu.add(mcsWindowItem);
        JMenuItem knockoutWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisKnockout"), 51);
        knockoutWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_knockout.png"));
        knockoutWindowItem.setAccelerator(KeyStroke.getKeyStroke(75, 128));
        knockoutWindowItem.addActionListener(arg0 -> {
            overlord.createKnockoutWindow();
            overlord.showKnockoutWindow();
        });
        invSubMenu.add(knockoutWindowItem);
        JMenuItem showClustersItem = new JMenuItem(lang.getText("DM_menuAnalysisClusters"), 52);
        showClustersItem.setIcon(Tools.getResIcon32("/icons/menu/menu_ClustersAnalysis.png"));
        showClustersItem.setAccelerator(KeyStroke.getKeyStroke(67, 128));
        showClustersItem.addActionListener(arg0 -> overlord.showClusterWindow());
        invSubMenu.add(showClustersItem);
        JMenu simulatorSubMenu = new JMenu(lang.getText("DM_menuAnalysisSim"));
        simulatorSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_simulators.png"));
        simulatorSubMenu.getAccessibleContext().setAccessibleDescription("Simulator");
        analysisMenu.add(simulatorSubMenu);
        JMenuItem netSimItem = new JMenuItem(lang.getText("DM_menuAnalysisStateSim"), 53);
        netSimItem.setIcon(Tools.getResIcon32("/icons/menu/menu_stateSim.png"));
        netSimItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        netSimItem.addActionListener(arg0 -> overlord.showStateSimulatorWindow());
        simulatorSubMenu.add(netSimItem);
        JMenuItem netSimXTPNItem = new JMenuItem(lang.getText("DM_menuAnalysisXTPNSim"), 53);
        netSimXTPNItem.setIcon(Tools.getResIcon32("/icons/menu/menu_XTPNsimulator.png"));
        netSimXTPNItem.setAccelerator(KeyStroke.getKeyStroke(88, 128));
        netSimXTPNItem.addActionListener(arg0 -> overlord.showStateSimulatorWindowXTPN());
        simulatorSubMenu.add(netSimXTPNItem);
        JMenu decompSubMenu = new JMenu(lang.getText("DM_menuAnalysisNetDeco"));
        decompSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_decompSubmenu.png"));
        analysisMenu.add(decompSubMenu);
        JMenuItem decoWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisNetDecoA"), 54);
        decoWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompModule.png"));
        decoWindowItem.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        decoWindowItem.addActionListener(arg0 -> {
            overlord.createDecompositionWindow();
            overlord.showDecoWindow();
        });
        decompSubMenu.add(decoWindowItem);
        JMenuItem branchWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisNetDecoB"), 55);
        branchWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompBranch.png"));
        branchWindowItem.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        branchWindowItem.addActionListener(arg0 -> {
            overlord.createBranchWindow();
            overlord.showBranchWindow();
        });
        decompSubMenu.add(branchWindowItem);
        JMenuItem compWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisNetDecoC"), 56);
        compWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompNetComp.png"));
        compWindowItem.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        compWindowItem.getAccessibleContext().setAccessibleDescription("Comparison prototype");
        compWindowItem.addActionListener(arg0 -> {
            overlord.createComparisonnWindow();
            overlord.showCompWindow();
        });
        decompSubMenu.add(compWindowItem);
        JMenuItem graphletWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisNetDecoD"), 48);
        graphletWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompGraphlets.png"));
        graphletWindowItem.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        graphletWindowItem.addActionListener(arg0 -> {
            overlord.createGraphletsWindow();
            overlord.showGraphletsWindow();
        });
        decompSubMenu.add(graphletWindowItem);
        JMenuItem reductionWindowItem = new JMenuItem(lang.getText("DM_menuAnalysisNetDecoE"), 48);
        reductionWindowItem.setIcon(Tools.getResIcon32("/icons/menu/menu_decompReduction.png"));
        reductionWindowItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        reductionWindowItem.addActionListener(arg0 -> {
            overlord.createReductionWindow();
            overlord.showReductionsWindow();
        });
        decompSubMenu.add(reductionWindowItem);
        JMenu otherMenu = new JMenu(lang.getText("DM_menuOther"));
        otherMenu.setMnemonic(79);
        this.add(otherMenu);
        JMenu mctOperationsMenu = new JMenu(lang.getText("DM_menuOtherMCT"));
        mctOperationsMenu.setMnemonic(77);
        mctOperationsMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        mctOperationsMenu.setPreferredSize(new Dimension(1, 38));
        otherMenu.add(mctOperationsMenu);
        JMenuItem genMCTGroups = new JMenuItem(lang.getText("DM_menuOtherMCTGen"), 49);
        genMCTGroups.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        genMCTGroups.addActionListener(arg0 -> overlord.generateMCT());
        mctOperationsMenu.add(genMCTGroups);
        JMenuItem createMCTFile = new JMenuItem(lang.getText("DM_menuOtherMCTCre"), 50);
        createMCTFile.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        createMCTFile.addActionListener(arg0 -> DarkMenu.overlord.io.generateSimpleMCTFile());
        mctOperationsMenu.add(createMCTFile);
        JMenu mctSubMenu = new JMenu(lang.getText("DM_menuOtherMCTFiles"));
        mctSubMenu.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        mctSubMenu.getAccessibleContext().setAccessibleDescription("MCT Generator");
        mctOperationsMenu.add(mctSubMenu);
        JMenuItem mctItem = new JMenuItem(lang.getText("DM_menuOtherMCTFilesA"), 51);
        mctItem.setIcon(Tools.getResIcon32("/icons/menu/menu_genMCT.png"));
        mctItem.addActionListener(arg0 -> {
            try {
                JOptionPane.showMessageDialog(null, lang.getText("unimplemented"), lang.getText("unimplementedTitle"), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        mctItem.setEnabled(false);
        mctSubMenu.add(mctItem);
        JMenuItem invSimul = new JMenuItem(lang.getText("DM_menuOtherInvGen"), 54);
        invSimul.setIcon(Tools.getResIcon32("/icons/menu/menu_invSim.png"));
        invSimul.addActionListener(arg0 -> {
            try {
                JOptionPane.showMessageDialog(null, lang.getText("unimplemented"), lang.getText("unimplementedTitle"), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        otherMenu.add(invSimul);
        JMenuItem fixNet = new JMenuItem(lang.getText("DM_menuOtherFixArcs"), 55);
        fixNet.setIcon(Tools.getResIcon32("/icons/menu/menu_properties.png"));
        fixNet.addActionListener(arg0 -> {
            try {
                DarkMenu.overlord.io.fixArcsProblem();
            }
            catch (Exception e) {
                overlord.log("Error: (437454427)" + e.getMessage(), "error", true);
            }
        });
        otherMenu.add(fixNet);
        JMenu aboutMenu = new JMenu(lang.getText("DM_menuHelp"));
        aboutMenu.setMnemonic(72);
        aboutMenu.getAccessibleContext().setAccessibleDescription(lang.getText("DM_menuHelp"));
        this.add(aboutMenu);
        JMenuItem aboutItem = new JMenuItem(lang.getText("DM_menuHelpAbout"));
        aboutItem.setIcon(Tools.getResIcon32("/icons/menu/menu_about.png"));
        aboutItem.getAccessibleContext().setAccessibleDescription(lang.getText("DM_menuHelpAbout"));
        aboutItem.addActionListener(arg0 -> overlord.createAboutWindow());
        aboutMenu.add(aboutItem);
    }
}

